#include "optionwindow.h"
#include "ui_optionwindow.h"
#include "QFileDialog"
#include <QFileInfo>

OptionWindow::OptionWindow(QDialog *parent) :
        QDialog(parent),
        ui(new Ui::OptionWindow)
{
    ui->setupUi(this);
    translate();

    QDir langDir( qApp->applicationDirPath() );
    if( langDir.cd("../languages") )
    {
        foreach (QString fileName, langDir.entryList(QDir::Files))
            ui->cb_language->addItem( fileName.left(fileName.lastIndexOf('.')) );

    }

    //moves the window to the center of the screen
    this->move( (QApplication::desktop()->width() / 2) - (this->width() / 2),
                (QApplication::desktop()->height() / 2) - (this->height() / 2) );

    QDir dlDir( qApp->applicationDirPath() );
    dlDir.cdUp();
    if( !dlDir.cd("downloads") )
    {
        dlDir.mkdir("downloads");
        dlDir.cd("downloads");
    }

    settings = new QSettings( tr("%1/save.ini").arg(qApp->applicationDirPath()), QSettings::IniFormat);

    if( !QFile::exists(settings->value("filesavepath").toString()) )
        settings->setValue( "filesavepath", dlDir.path() );


    // initialize the saved values
    ui->le_filepath->setText( settings->value("filesavepath", dlDir.path()).toString() );
    ui->cb_language->setCurrentIndex( ui->cb_language->findText(settings->value("language").toString()) );
    if( ui->cb_language->currentText().isEmpty() )
        ui->cb_language->setCurrentIndex(0);
}

OptionWindow::~OptionWindow()
{
    delete ui;
    delete settings;
}

void OptionWindow::translate()
{
    ui->retranslateUi(this);
}

void OptionWindow::on_pb_browse_clicked()
{
    QString tmpPath = QFileDialog::getExistingDirectory(0,"Save at",QDir::homePath());

    if( !tmpPath.isEmpty() )
    ui->le_filepath->setText( tmpPath );
}
void OptionWindow::on_pb_ok_clicked()
{
    // if the chosen filepath doesn't exist -> warning message and return
    QDir dir( ui->le_filepath->text() );
    if( !dir.exists() )
    {
        QMessageBox::warning( 0, tr("Warning"), tr("The directory doesn't exist.\nPlease choose another folder.") );
        return;
    }

    QFileInfo tmpInfo( dir.path() );
    if( !tmpInfo.isWritable() )
    {
        QMessageBox::warning( 0, tr("No permissions"), tr("You have no write permissions for this directory.\n"
                              "Please choose another one.") );
        return;
    }

    settings->setValue( "filesavepath",ui->le_filepath->text() );

    // if the language has been changed -> ask to restart
    if( settings->value("language").toString() != ui->cb_language->currentText() )
    {
        settings->setValue("language", ui->cb_language->currentText() );

        int req = QMessageBox::question(0, tr("Restart"), tr("The language has been changed!\n"
                                        "A restart is required."),
                                        QMessageBox::Yes, QMessageBox::No);

        // restarts
        if( req == QMessageBox::Yes )
        {
            emit emitRestart();
        }
    }

    // sends a signal to sets the new filepath in simplenetwork
    emit emitOptionAccept( ui->le_filepath->text() );
    this->close();
}

void OptionWindow::on_pb_cancel_clicked()
{
    this->close();
    QSettings settings(tr("%1/save.ini").arg(qApp->applicationDirPath()),QSettings::IniFormat);
    ui->le_filepath->setText(settings.value("filesavepath",qApp->applicationDirPath()).toString());
}
