#include "broadcaster.h"

Broadcaster::Broadcaster(QObject *parent) :
        QObject(parent),
        udpSocket(new QUdpSocket)
{
    connect(udpSocket, SIGNAL(readyRead()),
            this, SLOT(processPendingDatagrams()));
}

Broadcaster::~Broadcaster()
{
    delete udpSocket;
}

void Broadcaster::startBroadcast(int port)
{
    stopBroadcast();

    serverPort = port;

    datagramTimer.start(2000);
    connect( &datagramTimer, SIGNAL(timeout()),
             this, SLOT(sendBroadcast()) );
}

void Broadcaster::sendBroadcast()
{
    QString usrName( getenv("USERNAME") );
    usrName.append("@").append( getLocalAddress() );
    usrName.append('#').append( QString(tr("%1").arg(serverPort)) );

    udpSocket->writeDatagram( usrName.toLatin1(), usrName.size(),
                              QHostAddress::Broadcast, 49552 );
}

void Broadcaster::stopBroadcast()
{
    datagramTimer.stop();

    udpSocket->close();
}

void Broadcaster::searchAvailableServer(int port)
{
    stopSearch();

    searchPort = port;
    udpSocket->bind(49552, QUdpSocket::ShareAddress);
}

void Broadcaster::stopSearch()
{
    udpSocket->close();
}

void Broadcaster::processPendingDatagrams()
{
    QByteArray datagram;

    while( udpSocket->hasPendingDatagrams() )
    {
        datagram.resize( udpSocket->pendingDatagramSize() );
        udpSocket->readDatagram( datagram.data(), datagram.size() );
    }

    // takes the server port to compare
    int tmpPort =  datagram.mid( datagram.lastIndexOf('#') + 1 ).toInt();
    // removes the server port of the name string
    datagram.remove( datagram.lastIndexOf('#'), datagram.count() );

    // compares port
    if( searchPort == tmpPort )
        emitServerLocated( QString(datagram) );
}

QString Broadcaster::getLocalAddress()
{
    QList<QHostAddress> ipAddressesList = QNetworkInterface::allAddresses();
    // use the first non-localhost IPv4 address
    for (int i = 0; i < ipAddressesList.size(); ++i)
    {
        if (ipAddressesList.at(i) != QHostAddress::LocalHost &&
            ipAddressesList.at(i).toIPv4Address() )
            return ipAddressesList.at(i).toString();
    }

    return QHostAddress(QHostAddress::LocalHost).toString();
}
