/*****************************************************************************/
/*	       Copyright (c) 1994 by Jyrki Salmi <jytasa@jyu.fi>             */
/*        You may modify, recompile and distribute this file freely.         */
/*****************************************************************************/

#ifndef _TL_H_
#define _TL_H_

#include <time.h>

typedef struct _TE {

  U8 *name;
  U32 name_len;
  U8 *path;
  U32 path_len;

  struct _TE *p;
  struct _TE *n;
} TE;

typedef struct _TL {

  TE *f;
  TE *l;
  TE *c;

  U32 cnt;
  U32 size;
} TL;

extern void tl_add(TL **, U8 *, U32);
extern void tl_expanded_add(TL **, U8 *);
extern void tl_free(TL **);
extern void tl_read_from_list(TL **, U32, U8 *);
extern BOOLEAN tl_exists(TL *, U8 *);

#endif /* _TL_H_ */

