#define INCL_PM
#define INCL_GPI
#define INCL_DOS
#define INCL_DOSFILEMGR
#define INCL_DOSSESMGR
#define INCL_DOSERRORS
#define INCL_WINWORKPLACE
#include <OS2.H>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <process.h>
#include <signal.h>
#include "retriever.h"
#include "retriever_rc.h"
#include "retriever_mr.h"
#include "utils.h"

static RuntimeData           runtimeData;
static SystemRuntimeData     systemRuntimeData;
static RuntimeSettings       runtimeSettings;
static StaticExecSettings    staticExecSettings;
static StaticRuntimeSettings staticRuntimeSettings;
static RuntimeArgs           runtimeArgs;
static ExecArgs              execArgs;
static RetCode               retCode;
static PIPEDATA              pipeData;


int fetch(int refresh)
{
char buf[32];
int anz=0;
char ch;
ULONG r;
  DosRead(runtimeData.hpR  , (PVOID) buf,1, &r);

  ch=buf[0];
return ch;
}

int  fetchStr(char *str,int begin,int end,int len,int refresh)
{
int ch,i=0;


  ch=fetch(refresh);
  refresh=0;
  if (begin=='#')
    while(!isdigit(ch))
      ch=fetch(refresh);
  else
    if (begin!='*')
       while (ch!=begin)
         ch=fetch(refresh);


  while (ch!=end && i<(len-1))
  {
    str[i++]=ch;
    ch=fetch(refresh);
  }
  strcpy(&str[i],"\0");
  return 0;
}

char * getHttpUrl(char *where,char *dest)
{
char *start,*end;
int type,n;
  if (start=strstr(where,"http://"))
  {
    type=1;
  }
  else if (start=strstr(where,"HTTP://"))
  {
    type=1;
  }
  else if (start=strstr(where,"www."))
  {
    type=2;
  }
  else if (start=strstr(where,"WWW."))
  {
    type=2;

  }
  else
  {

    strcpy(dest,"\0");
    return NULL;
  }

  strcpy(dest,"\0");
  n=firstStrDelimiter(start);
  stripncpy(dest,start,n);

  return &start[n-1];


}
char * getFtpUrl(char *where,char *dest)
{
char *start,*end;
int type,n;
  if (start=strstr(where,"ftp://"))
  {
    type=1;
  }
  else if (start=strstr(where,"FTP://"))
  {
    type=1;
  }
  else if (start=strstr(where,"ftp."))
  {
    type=2;
  }
  else if (start=strstr(where,"FTP."))
  {
    type=2;

  }
  else
  {

    strcpy(dest,"\0");
    return NULL;
  }

  strcpy(dest,"\0");
  n=firstStrDelimiter(start);

  stripncpy(dest,start,n);
  return &start[n-1];


}

void toggleNbWindowPos(HWND wnd,int xDiff,int yDiff)
{
int static yPos=0,xPos=0,toggle=0;
RECTL rcl;
SWP swp;
  WinQueryWindowPos(wnd,&swp);
  if (toggle)
  {
    toggle=0;

    swp.y-=yDiff;
    swp.x-=xDiff;
  }
  else
  {
      swp.y+=yDiff;
      swp.x+=xDiff;
      toggle=1;
   }



  WinSetWindowPos(wnd,HWND_TOP,swp.x,swp.y, 0,0,SWP_MOVE/*|SWP_ACTIVATE|SWP_SHOW*/);
}

int toggleWindowSize(HWND wnd,int xDiff,int yDiff)
{
int static ySize=0,xSize=0,toggle=1;
RECTL rcl;
SWP swp;
static HWND menu=NULL;
  if (!menu)
    menu=WinWindowFromID(systemRuntimeData.hwndDlg,FID_MENU);
  WinQueryWindowPos(wnd,&swp);
  if (toggle)
  {
    toggle=0;
    toggleNbWindowPos(wnd,11,12);
    swp.cy-=yDiff;
    swp.cx-=xDiff;
    if (!WinSendDlgItemMsg(systemRuntimeData.hwndStatDlg,ID_CHANGESIZE_BTN,BM_QUERYCHECK,NULL,NULL))
      WinSendDlgItemMsg(systemRuntimeData.hwndStatDlg,ID_CHANGESIZE_BTN,BM_SETCHECK,(MPARAM)1,NULL);
    WinSetParent(menu, HWND_OBJECT, FALSE);
  }
  else
  {
    toggle=1;
    swp.cy+=yDiff;
    swp.cx+=xDiff;
    toggleNbWindowPos(wnd,12,12);
    if (WinSendDlgItemMsg(systemRuntimeData.hwndStatDlg,ID_CHANGESIZE_BTN,BM_QUERYCHECK,NULL,NULL))
      WinSendDlgItemMsg(systemRuntimeData.hwndStatDlg,ID_CHANGESIZE_BTN,BM_SETCHECK,(MPARAM)0,NULL);
    WinSetParent(menu, systemRuntimeData.hwndDlg,TRUE);

  }



  WinSetWindowPos(wnd,HWND_TOP,0,0, swp.cx,swp.cy,SWP_SIZE/*|SWP_ACTIVATE|SWP_SHOW*/);
  WinSendMsg(systemRuntimeData.hwndDlg, WM_UPDATEFRAME, (MPARAM)( FCF_MENU|FCF_ACCELTABLE/*|FCF_SYSMENU*/), 0);
  runtimeData.lastSizeToggle=1;
  return toggle;
}

void toggleWindowPos(HWND wnd,int xDiff,int yDiff)
{
int static yPos=0,xPos=0,toggle=1;
RECTL rcl;
SWP swp;

  WinQueryWindowPos(wnd,&swp);
  if (toggle)
  {
    toggle=0;

    swp.y-=yDiff;
    swp.x-=xDiff;
  }
  else
  {
      swp.y+=yDiff;
      swp.x+=xDiff;
      toggle=1;
   }



  WinSetWindowPos(wnd,HWND_TOP,swp.x,swp.y, 0,0,SWP_MOVE/*|SWP_ACTIVATE|SWP_SHOW*/);
}

LONG mrNPGetState(HPIPE pHandle)
{
   ULONG state, buffer, buffer2;
   AVAILDATA avail;

   DosPeekNPipe(pHandle, &buffer, 4, &buffer2, &avail, &state);
   return state;
}

void infoPipeThread(void)
{
HAB hAB = NULLHANDLE;
HMQ hMQ = NULLHANDLE;
LONG rc,cb;
HPIPE pHandle;
char pName[255];
  hAB = WinInitialize(0);
  if(hAB)
    hMQ = WinCreateMsgQueue(hAB, 0);
  if(hMQ)
  {
  QMSG qmsg;

    pipeData.infoPipeHMQ=hMQ;
    strcpy(pName,"\\PIPE\\");
    strcat(pName,pipeData.pName);
    strcat(pName,"_INFO");
    //Fehler(pName);
    if(! (rc = DosCreateNPipe(pName, &pHandle,NP_ACCESS_OUTBOUND,  NP_NOWAIT|NP_TYPE_MESSAGE|NP_READMODE_MESSAGE|0x016/*-1*/, 200,200,0 )) != 0)
    {
      while (DosConnectNPipe(pHandle)==ERROR_PIPE_NOT_CONNECTED)
        DosSleep(500);
      while(WinGetMsg(hAB, &qmsg,NULLHANDLE,NULL,NULL)) // The message loop
      {
        if( mrNPGetState(pHandle) == NP_STATE_CLOSING)    //client is killed?
        {
          DosDisConnectNPipe(pHandle);
          while (DosConnectNPipe(pHandle)==ERROR_PIPE_NOT_CONNECTED)
            DosSleep(500);
        }
        if( mrNPGetState(pHandle) == NP_STATE_CONNECTED)
        {
        char message[255];
          switch (qmsg.msg)
          {
            case WM_FROM:
                message[0]=MRIP_FROM;
                strcpy(&message[1],qmsg.mp1);
            break;

            case WM_LOCAL:
                message[0]=MRIP_LOCAL;
                strcpy(&message[1],qmsg.mp1);
            break;

            case WM_LENGTH:
                message[0]=MRIP_LENGTH;
                strcpy(&message[1],qmsg.mp1);
            break;

            case WM_ERROR:
                message[0]=MRIP_ERROR;
                strcpy(&message[1],qmsg.mp1);
            break;

            case WM_SIZE:
                message[0]=MRIP_SIZE;
                strcpy(&message[1],qmsg.mp1);
            break;

            case WM_RATE:
                message[0]=MRIP_RATE;
                strcpy(&message[1],qmsg.mp1);
            break;

            case WM_RATE_NOW:
                message[0]=MRIP_RATE_NOW;
                strcpy(&message[1],qmsg.mp1);
            break;
            case WM_TIME_REMAIN:
                message[0]=MRIP_TIME_REMAIN;
                strcpy(&message[1],qmsg.mp1);
            break;


            case WM_CONNECTED:
                message[0]=MRIP_CONNECTED;
                strcpy(&message[1],qmsg.mp1);
            break;

            case WM_REQUEST_OK:
                message[0]=MRIP_REQUEST_OK;
                strcpy(&message[1],qmsg.mp1);
            break;

            case WM_TIMEPAST:
                message[0]=MRIP_TIMEPAST;
                strcpy(&message[1],qmsg.mp1);
            break;

            case WM_FINISHED:
                message[0]=MRIP_FINISHED;
                strcpy(&message[1],qmsg.mp1);
            break;

            case WM_MR_DIE:
                message[0]=MRIP_MR_DIE;
                strcpy(&message[1],qmsg.mp1);
            break;

          }
          rc= DosWrite  (pHandle,message,strlen(message)+1 ,&cb);


        }

      }

    }
    DosResetBuffer(pHandle);
  }

  DosClose(pHandle);
  _endthread();


}
void commandPipeThread(void)
{
HAB hAB = NULLHANDLE;
HMQ hMQ = NULLHANDLE;
LONG rc,cb;
HPIPE pHandle;
char pName[255],buffer[255];
  hAB = WinInitialize(0);
  if(hAB)
    hMQ = WinCreateMsgQueue(hAB, 0);
  if(hMQ)
  {
  QMSG qmsg;

    pipeData.infoPipeHMQ=hMQ;
    strcpy(pName,"\\PIPE\\");
    strcat(pName,pipeData.pName);
    strcat(pName,"_CMD");

    if(! (rc = DosCreateNPipe(pName, &pHandle,NP_ACCESS_INBOUND,  NP_WAIT|NP_TYPE_MESSAGE|NP_READMODE_MESSAGE|1/*0x016-1*/, 200,200,0 )) != 0)
    {
      while (DosConnectNPipe(pHandle)==ERROR_PIPE_NOT_CONNECTED)
        DosSleep(500);
      while(WinGetMsg(hAB, &qmsg,NULLHANDLE,NULL,NULL)) // The message loop
      {
        if( mrNPGetState(pHandle) == NP_STATE_CLOSING)    //client is killed?
        {
          DosDisConnectNPipe(pHandle);         // printf("\nTrying to ReConnect");
          while (DosConnectNPipe(pHandle)==ERROR_PIPE_NOT_CONNECTED)
            DosSleep(500);
        }
        if( mrNPGetState(pHandle) == NP_STATE_CONNECTED)
        {
        char message[255];
          rc=DosRead(pHandle, message,255,&cb );

          switch (message[0])
          {
          case MRCP_CANCEL:
            message[0]=MRIP_FROM;
            strcpy(&message[1],qmsg.mp1);
          break;

          case MRCP_PAUSE:
            message[0]=MRIP_LOCAL;
            strcpy(&message[1],qmsg.mp1);
          break;

          case MRCP_RESUME:
            message[0]=MRIP_LENGTH;
            strcpy(&message[1],qmsg.mp1);
          break;

          case MRCP_RETRY:
            message[0]=MRIP_ERROR;
            strcpy(&message[1],qmsg.mp1);
          break;

          case MRCP_RETRANSFER:
            message[0]=MRIP_SIZE;
            strcpy(&message[1],qmsg.mp1);
          break;

          case MRCP_TOGGLE_SHOW:
            message[0]=MRIP_RATE;
            strcpy(&message[1],qmsg.mp1);
          break;

          case MRCP_TOGGLE_DETAILS:
            message[0]=MRIP_RATE_NOW;
            strcpy(&message[1],qmsg.mp1);
          break;
          }

        }

      }

    }
    DosResetBuffer(pHandle);
  }

  DosClose(pHandle);
  _endthread();


}



void statUpdateThread(void)
{
ULONG cbRead;
CHAR achBuf[11];
HAB hAB = NULLHANDLE;
HMQ hMQ = NULLHANDLE;
SHORT timerId;
DATETIME elapsedTime;

  hAB = WinInitialize(0);
  if(hAB)
    hMQ = WinCreateMsgQueue(hAB, 0);
  if(hMQ)
  {
  QMSG qmsg;
  char bu[32];
    timerId=WinStartTimer(hAB,NULLHANDLE,ID_TIMER1,250);
    WinSetWindowULong(systemRuntimeData.hwndDlg, QWL_USER, hMQ);
    while(WinGetMsg(hAB, &qmsg,NULLHANDLE,NULL,NULL)) // The message loop
    {
      switch (qmsg.msg)
      {
        case WM_TIMER:
        {
          if (SHORT1FROMMP(qmsg.mp1)==timerId)
          {
          static int s=1,last=0;
          int std=runtimeData.seconds/3600;
          int min=runtimeData.seconds/60;
          int sec=runtimeData.seconds%60;
          char buf[255],buf2[64];
          long rate ;
          double avgRate,remainingSec;
            if (s%4==0)
            {
              runtimeData.seconds++;
              secToTime(runtimeData.seconds,&elapsedTime);
              sprintf(buf,"Start: %i:%.2i:%.2i, Time since: %s",runtimeSettings.startTime.hours,runtimeSettings.startTime.minutes,runtimeSettings.startTime.seconds,formatTime(&elapsedTime,buf2,0));

              WinSendMsg(systemRuntimeData.noteBookWnd,BKM_SETSTATUSLINETEXT,MPFROMLONG(systemRuntimeData.idMainPage1),MPFROMP(buf));
              if (pipeData.infoPipeHMQ)
              {
              char mysec[32];
                formatTime(&elapsedTime,mysec,0);

                WinPostQueueMsg(pipeData.infoPipeHMQ,WM_TIMEPAST,mysec,NULL); //  WinQueMsg
              }
            }
            if ((runtimeData.asyncPipeMsg && (!runtimeData.endFile)) /*|| last*/)
            {
              if (s%4==0)
              {
                avgRate=(double)runtimeData.actSize/runtimeData.seconds;
                rate=runtimeData.actSize-runtimeData.prevSize;
                statSetRate((double)rate,avgRate);
                runtimeData.prevSize=runtimeData.actSize;
                remainingSec=(runtimeData.length-runtimeData.actSize);
                remainingSec/=avgRate;
                statSetRemainingTime((long)remainingSec);
                statSetFinishedAt(runtimeSettings.startTime,elapsedTime,(long)remainingSec);
              }
              statSetSize(runtimeData.actSize,0);

              if (runtimeData.length)
                statSetPercent(runtimeData.length,runtimeData.actSize);
            }
            if (runtimeData.endDownload)
            {
              DosSleep(200);
              WinSendMsg(systemRuntimeData.hwndDlg,WM_THEEND,(MPARAM) 0,(MPARAM) 0);
              WinPostQueueMsg(hMQ,WM_QUIT,NULL,NULL);
            }
            s++;
          }
        }
      }
    }
    WinStopTimer(hAB,NULLHANDLE,ID_TIMER1);
    WinDestroyMsgQueue(hMQ);
    WinTerminate(hAB);
  }
_endthread();
}
void analyzeThread(void)
{

HAB hAB = NULLHANDLE;
HMQ hMQ = NULLHANDLE;
char baba[255];
int strend=1,done=0,size=0,eof=0,ispipe=1,res=0;
int i,n=0;
ULONG msgDone=0;

char message[255],*start,*end,*test;
char buf[255];
 QMSG qmsg;
hAB = WinInitialize(0);
 if(hAB)
    hMQ = WinCreateMsgQueue(hAB, 0);
 if (hMQ)
 {
   WinSetWindowULong(systemRuntimeData.hwndConDlg, QWL_USER, hMQ);
   msgDone=0;
   while (!eof)
   {
      DosSleep(10);
      if (WinPeekMsg(hAB, &qmsg,NULLHANDLE,NULL,NULL,PM_NOREMOVE))
    {

      switch (qmsg.msg)
      {
        case WM_QUIT:
        {


          _endthread();
          break;
        }
      }


    }
      if (strend)      // if finished with analyzing string,then get next one
      {

        fetchStr(buf,'*','\n',255,0);
        start=buf;

        printf("%s\n",buf);  //simple logging of wget's output


       WinSendMsg(WinWindowFromID(systemRuntimeData.hwndConDlg,ID_CON_MLE),MLM_INSERT,MPFROMP(buf),NULL);
       fprintf(systemRuntimeData.logout,"%s",buf);
      }






       if ( !(msgDone & PROT_IT_FINI)&& (msgDone &PROT_AVG_RATE) && execArgs.iterative)
       {

         if ( (test=strstr(start,"FINI")) )
         {
           message[0]=0;

           strend=1;
           eof=1;

           runtimeData.endDownload=1;
         }
      }

      if (!(msgDone & PROT_START))

        if (strstr(start,"--"))     //The beginning or the end of a download
        {

          if ( (test=strstr(start,"http://")) || (test=strstr(start,"ftp://")) )
          {
          char buf[255];
            runtimeData.endFile=0;
            start=test;
            message[0]=1;   //Number of Protocol for Timestamp
            message[1]=strlen(start);
            strcpy(&message[2],start);
            start[strlen(start)-1]='\0';
            statSetFromFn(start);       //Url from the Server
            if (pipeData.infoPipeHMQ)
              WinPostQueueMsg(pipeData.infoPipeHMQ,WM_FROM,runtimeData.from,NULL);


            sprintf(buf,"Connecting to '%s'...",start);
            statSetInfo(buf);
            strend=1;       // There still is some information in the string
            runtimeData.prevSize=0;
            if (runtimeData.newDownload) runtimeData.actSize=0;
            msgDone=PROT_START;   //  this is not a mistake
          }



      }
      if (!(msgDone & PROT_LOCAL_FN))
      if ( (test=strstr(start,"=> `")) )
      {
        start=strstr(test,"`");
        start++;
        message[0]=2;   // PNR for local filename
        end=strstr(start,"'");
        if (end)
        {
          strcpy(end,"\0");
        }
        message[1]=end-start;  //calculate length of message

        strcpy(&message[2],start);
        statSetLocalFn(&message[2]);    //the selected local filename
         if (pipeData.infoPipeHMQ)
              WinPostQueueMsg(pipeData.infoPipeHMQ,WM_LOCAL,runtimeData.local,NULL);
        strend=1;

        msgDone|=PROT_LOCAL_FN;


      }

      if (!(msgDone & PROT_ERROR))
      if ( (test=strstr(start,"Host not found")))
      {
      char buf[128];
      start[strlen(start)-1]='\0';
        sprintf(buf,"Error->'%s' Download failed!",start);
        statSetError(buf);

        retCode.rcError=1;


        message[0]=0;
        strend=1;

        eof=1;
        msgDone|=PROT_ERROR;
        break;

      }
      if (!(msgDone & PROT_ERROR))
      if ( (test=strstr(start,"No such file")) )
      {
      char buf[128];
      start[strlen(start)-1]='\0';
        sprintf(buf,"Error->'%s' Download failed!",start);
        statSetError(buf);
        retCode.rcError=1;
        message[0]=0;
        strend=1;
        //done=1;
        eof=1;
        msgDone|=PROT_ERROR;
        break;

      }
      if (!(msgDone & PROT_ERROR))
      if ( (test=strstr(start,"refused")) )
      {
      char buf[128];
      start[strlen(start)-1]='\0';
        sprintf(buf,"Error->'%s' Download failed!",start);
        statSetError(buf);
        retCode.rcError=1;
        message[0]=0;
        strend=1;
        //done=1;
        eof=1;
        msgDone|=PROT_ERROR;
        break;

      }


      if (!(msgDone & PROT_ERROR))
        if ( (test=strstr(start,"ERROR")) )
        {
        char buf[128];
          start[strlen(start)-1]='\0';
          sprintf(buf,"Error->'%s' Download failed!",test);
          statSetError(buf);
          retCode.rcError=1;
          message[0]=0;
          strend=1;
          if (!execArgs.iterative)
          {
            msgDone|=PROT_ERROR;
            if (!execArgs.iterative)
            {
              eof=1;
              msgDone=0;
              runtimeData.endDownload=1;
            }
          }

          msgDone|=PROT_ERROR;
        }






      if (!(msgDone & PROT_CONNECT))
      if ( (test=strstr(start,"connected")) )
      {
        os2title(-1,"warum",0);   //restore Title
        start[strlen(start)-1]='\0';
        message[0]=3;   // PNR for Connected
        message[1]=0;
        strcpy(&message[2],"\0");
        strend=1;

        msgDone|=PROT_CONNECT;

        statSetInfo(test);
        if (pipeData.infoPipeHMQ)
          WinPostQueueMsg(pipeData.infoPipeHMQ,WM_CONNECTED,"OK ",NULL);
      }
      if (!(msgDone & PROT_FTP_CWD))
      if ( (test=strstr(start,"==> CWD")) )
      {
      char buf[128];
              start[strlen(start)-1]='\0';
        sprintf(buf,"%s",&test[4]);
        statSetInfo(buf);
        message[0]=0;
        strend=1;

        msgDone|=PROT_FTP_CWD;

      }
      if (!(msgDone & PROT_FTP_RETR))
      if ( (test=strstr(start,"==> RETR")) )
      {
      char buf[128];
      start[strlen(start)-1]='\0';
        sprintf(buf,"%s",&test[4]);
        statSetInfo(buf);
        if (pipeData.infoPipeHMQ)
           WinPostQueueMsg(pipeData.infoPipeHMQ,WM_REQUEST_OK,"OK",NULL);

        message[0]=0;
        strend=1;
        msgDone|=PROT_FTP_RETR;

      }


      if (!(msgDone & PROT_REQUEST))
      if ( (test=strstr(start,"request sent")) )
      {

        start[strlen(start)-1]='\0';
        message[0]=4;   // PNR fr Request ok
        message[1]=0;
        strcpy(&message[2],"\0");
        strend=1;

        msgDone|=PROT_REQUEST;

        statSetInfo(test);
        if (pipeData.infoPipeHMQ)
           WinPostQueueMsg(pipeData.infoPipeHMQ,WM_REQUEST_OK,"OK",NULL);
      }
      if (!(msgDone & PROT_LENGTH))
      if ( (test=strstr(start,"ength:")) )      //Get the Length
      {



        start=strstr(test," ");
        end=strstr(&start[1]," ");
        message[1]=end-start;
        strncpy(&message[2],start,end-start);
        strcpy(&message[end-start+2],"\0");

        message[0]=5;

        statSetLength(&message[2]);
        statSetFromFn(runtimeData.from);
        message[0]=0;
        strend=1;

        msgDone|=PROT_LENGTH;

      }
      if (!(msgDone & PROT_SIZE)&& ((msgDone &PROT_FTP_RETR) || (msgDone &PROT_LENGTH)) )
      {
      char zb[32];

      int ch;

        if (!runtimeData.prevSize)
         runtimeData.actSize=0;
        runtimeData.asyncPipeMsg=TRUE;
        do                              //Count the dots to get the actual size
        {
          ch=fetch(0);
          zb[0]=ch;
          zb[1]='\0';
          if (ch!=0xa)
          {
            WinSendMsg(WinWindowFromID(systemRuntimeData.hwndConDlg,ID_CON_MLE),MLM_INSERT,MPFROMP(zb),NULL);
            fprintf(systemRuntimeData.logout,"%c",ch);
          }

          if (ch=='.')
          {

            runtimeData.actSize+=1024;
          }
          if (!(isdigit(ch) || ch=='K'|| ch=='-' ||ch=='>'|| ch==' '|| ch=='['|| ch==']'|| ch=='%'||ch==0xd ||ch==0xa||ch=='.'||ch==':') )
          {

            fetchStr(buf,'*','\n',255,0);
            WinSendMsg(WinWindowFromID(systemRuntimeData.hwndConDlg,ID_CON_MLE),MLM_INSERT,MPFROMP(buf),NULL);
            fprintf(systemRuntimeData.logout,"%s",buf);
            if ((test=strstr(buf,"nnot write to")) || (test=strstr(buf,"isk full")))
            {
            char mybuf[255];
              sprintf(mybuf,"Ca%s Download failed!",test);
              statSetError(mybuf);
              msgDone|=PROT_ERROR;
              if (!execArgs.iterative)
              {

                eof=1;
                msgDone=0;
                runtimeData.endDownload=1;
              }


              break;
            }
          }

        } while (ch!=':');
        runtimeData.asyncPipeMsg=FALSE;

        if ( !(msgDone &PROT_ERROR))
        {
        message[0]=6;
        _ltoa(runtimeData.actSize,zb,10);
        message[1]=strlen(zb);
        strcpy(&message[2],zb);

        message[0]=0;
        }
        message[0]=0;
        strend=1;

        msgDone|=PROT_SIZE;
      }


      if (!(msgDone & PROT_AVG_RATE))
      if ( (test=strstr(start,"/s)")) )    //average transfer leistung
      {
        message[0]=9;

        start=strstr(start,"(");
        start++;
        end=strstr(start,")");
        message[1]=end-start;
        strncpy(&message[2],start,end-start);
        strcpy(&message[end-start+2],"\0");

        statSetSize(runtimeData.actSize,1);
        statSetPercent(1,1);
       retCode.rcAllOk=1;

       {
       char avg[32];char *p=strstr(start,"K");
         strncpy(avg,start,p-start-1);
         avg[p-start-1]='\0';

       statSetRate(-1,atof(avg)*1000);
      }
        strend=1;
        msgDone=PROT_AVG_RATE;   //must be operator "=",because normaly we would stop here but have to check on prot_start

        runtimeData.endFile=1;
        if (!execArgs.iterative)
        {
          if (pipeData.infoPipeHMQ)
            WinPostQueueMsg(pipeData.infoPipeHMQ,WM_FINISHED,runtimeData.avgRate,NULL);
          eof=1;
          runtimeData.endDownload=1;
          msgDone=0;
        }

      }

      if (message[0])        // SLDCDATA
      {

      int len,pnr;
      pnr=message[0];
      len=message[1];

      if (pnr!=9)
      {
        sprintf(baba,"PNR: %i, LEN: %i : ",pnr,len);

      }
      else
      {
        sprintf(baba,"\nPNR: %i, LEN: %i : ",pnr,len);
      }

        for (i=0;i<len;i++)
        {
         sprintf(baba,"%c",message[2+i]);

         }

         sprintf(baba,"\n");


       message[0]=0;
      }

}


    WinDestroyMsgQueue(hMQ);
    WinTerminate(hAB);

  _endthread();
  }
}

void statSetLength(char* length)
{
char buf[255];
unsigned long what;
stricpy(buf,',',length);
what=strtoul(buf,NULL,10);
runtimeData.length=what;

  if (pipeData.infoPipeHMQ)
    WinPostQueueMsg(pipeData.infoPipeHMQ,WM_LENGTH,length,NULL); //  WinQueMsg


}
void statSetSize(long size,int finished)
{
char size_buf[48];
char length_buf[48];
char stat_buf[255];
char togo_buf[48];

  formatByte(runtimeData.length-(double)size,togo_buf,0);
  formatByte(size,size_buf,0);
  formatByte((double)runtimeData.length,length_buf,0);
  if (!finished)
  {
    if(runtimeData.length)
      sprintf(stat_buf,"%s of %s transferred, %s left.",size_buf,length_buf,togo_buf);
     else
       sprintf(stat_buf,"%s transferred.",size_buf);
  }
  else
  {
    sprintf(stat_buf,"%s transferred, finished.",size_buf,length_buf,togo_buf);
    statSetPercent(1,1);
  }
  WinSetWindowText( WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_STATUS_EF),stat_buf);
  if (pipeData.infoPipeHMQ)
    WinPostQueueMsg(pipeData.infoPipeHMQ,WM_SIZE,size_buf,NULL); //  WinQueMsg


}
void statSetError(char *str)
{
 WinSetWindowText( WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_STATUS_EF),str);

 WinPostQueueMsg(WinQueryWindowULong(systemRuntimeData.hwndDlg  ,QWL_USER),WM_QUIT,NULL,NULL); //  WinQueMsg
 if (WinSendDlgItemMsg(systemRuntimeData.hwndStatDlg,ID_LEAVEOPEN_BTN,BM_QUERYCHECK,NULL,NULL))
   WinSendDlgItemMsg(systemRuntimeData.hwndStatDlg,ID_LEAVEOPEN_BTN,BM_SETCHECK,(MPARAM)0,NULL);

  if (pipeData.infoPipeHMQ)
    WinPostQueueMsg(pipeData.infoPipeHMQ,WM_ERROR,str,NULL); //  WinQueMsg

 WinSendMsg(systemRuntimeData.hwndDlg,WM_THEEND,(MPARAM) 0,(MPARAM) 0);


}
void statSetInfo(char *str)
{
  WinSetWindowText( WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_STATUS_EF),str);


}
void statRequestOK(void)
{
  WinSetWindowText( WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_FROM_EF),"My Request is OK, waiting for Data!");
  if (pipeData.infoPipeHMQ)
    WinPostQueueMsg(pipeData.infoPipeHMQ,WM_REQUEST_OK,"Request OK",NULL); //  WinQueMsg

}
void statSetRemainingTime(unsigned long sec)
{
char buf[64];
DATETIME dt;

  secToTime(sec,&dt);
 formatTime(&dt,buf,0);
  if (pipeData.infoPipeHMQ)
    WinPostQueueMsg(pipeData.infoPipeHMQ,WM_TIME_REMAIN,buf,NULL); //  WinQueMsg


}
void statSetFinishedAt(DATETIME elapsedTime,DATETIME startedAt,long remainingSec)
{
DATETIME dt,dt2;

char buf[64];
char buf2[64];
char statBuf[255];
long startedAtSec=startedAt.hours*3600+startedAt.minutes*60+startedAt.seconds;
long elapsedTimeSec=elapsedTime.hours*3600+elapsedTime.minutes*60+elapsedTime.seconds;

  if (runtimeData.length)
  {

    secToTime(startedAtSec+elapsedTimeSec+remainingSec,&dt);
    formatTime(&dt,buf,1);

    secToTime(remainingSec,&dt2);
    formatTime(&dt2,buf2,0);
    if (remainingSec)
      sprintf(statBuf,"%s, in %s",buf,buf2);
    else
      sprintf(statBuf,"%s",buf);
    WinSetWindowText(WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_FINISHED_AT_ST),statBuf);

  }
  else WinSetWindowText(WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_FINISHED_AT_ST)," ");


}
void statSetConnecting(void)
{
  WinSetWindowText( WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_FROM_EF),"OK! I have a connection to ...");
  if (pipeData.infoPipeHMQ)
    WinPostQueueMsg(pipeData.infoPipeHMQ,WM_CONNECTED,"Connected",NULL); //  WinQueMsg

}
void statSetFromFn(char *fn)
{
  strcpy(runtimeData.from,fn);

 WinSetWindowText( WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_FROM_EF),fn);

}

void statSetLocalFn(char *fn)
{
char buf[255];

  strcpy(runtimeData.local,fn);
  if (!(runtimeSettings.workDir[strlen(runtimeSettings.workDir)-1]=='\\'))
  {
    sprintf(buf,"%s\\%s",runtimeSettings.workDir,fn);

  }
  else
    sprintf(buf,"%s%s",runtimeSettings.workDir,fn);

  WinSetWindowText( WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_LOCAL_EF),buf);


}
void statSetRate(double rate,double avg)   //Speed
{
char avg_buf[48];
char now_buf[48];
char buf[255];


  formatByte(avg,avg_buf,0);
  formatByte(rate,now_buf,0);
  strcpy(runtimeData.avgRate,avg_buf);
  strcpy(runtimeData.rateNow,now_buf);

  if (rate!=-1.0)
    sprintf(buf,"Average: %s, Now %s",avg_buf,now_buf);
  else
    sprintf(buf,"Average: %s",avg_buf);
  WinSetWindowText( WinWindowFromID(systemRuntimeData.hwndStatDlg,  ID_AMOUNTLEFT_ST),buf);
  if (pipeData.infoPipeHMQ)
  {
    WinPostQueueMsg(pipeData.infoPipeHMQ,WM_RATE,runtimeData.avgRate,NULL); //  WinQueMsg
    if (rate!=-1)
      WinPostQueueMsg(pipeData.infoPipeHMQ,WM_RATE_NOW,runtimeData.rateNow,NULL); //  WinQueMsg
  }


}

void statSetPercent(long length,long act)
{
double per=(double)act/length;
char buf[255];
int iper;
per*=100;
iper=per;
if(per==100)
{
  iper=99;                                                                                                                                         //2SHORT
  os2title(0,runtimeData.local,100);
}
else os2title(0,runtimeData.local,iper);
WinSendDlgItemMsg(systemRuntimeData.hwndStatDlg,ID_SLIDER_SL     ,SLM_SETSLIDERINFO,MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_INCREMENTVALUE /*RANGEVALUE*/),(MPARAM)MPFROMSHORT(iper/*,60*/));
  sprintf(buf,"(%i",(int)per);
  strcat(buf,"%)");
  WinSetWindowText( WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_PERCENT_ST),buf);



}




void doArgs(int argc,char *argv[])
{
int i=0,n=0;
char *start;


  execArgs.wgetArgs=malloc(argc*sizeof(char*)+1);

  for (i=1;i<argc;i++)
  {


    if ( (strstr(argv[i],"-p")))
    {

     i++;

     if (argv[i])
     {
     strcpy(pipeData.pName,argv[i]);

     pipeData.isPipe=1;
     }

     fprintf(systemRuntimeData.logout,"in -p %s\n",pipeData.pName);
     continue;
    }
    if ( (start=strstr(argv[i],"-d")))
    {
     i++;

     fprintf(systemRuntimeData.logout,"in -d\n");


     if (argv[i])
     if (argv[i][1]==':')
     {
       _chdrive(argv[i][0]);
       _chdir(&argv[i][2]);
     }
     else _chdir(argv[i]);
     continue;
    }
    if ( (start=strstr(argv[i],"-acl")))
    {

      if (start=strstr(argv[i],"-acl-"))
        runtimeArgs.noAutoClose=1;
      else runtimeArgs.autoClose=1;

      continue;
    }
    if ( (start=strstr(argv[i],"-c")))
    {

      fprintf(systemRuntimeData.logout,"in -c\n");
      execArgs.cont=1;

     continue;
    }

    if ( strncmp(argv[i],"-i",2)==0)
    {

    fprintf(systemRuntimeData.logout,"in -i\n");
      execArgs.iterative=1;
      execArgs.urlExists=1;
    }
    if (argv[i][0]!='-')
      execArgs.urlExists=1;

   execArgs.wgetArgs[n]=malloc(strlen(argv[i])+1);
    strcpy(execArgs.wgetArgs[n],argv[i]);

    n++;


  }

  execArgs.wgetArgs[n]=NULL;

  i=0;
  while (execArgs.wgetArgs[i])
  {
    fprintf(systemRuntimeData.logout,"\narg: %s\n",execArgs.wgetArgs[i++]);

   }

}

void displayErrorBox(int value,char *info)
{
char buf[255]="Ooops, GNU wGet could not be started because: ";
  switch( value)
  {
  case EINVAL:
     strcat(buf,"There was an invalid argument");
  break;
  case ENOENT:
    strcat(buf,"The path or filename of wget.exe is invalid. This is what I got: \"");
    strcat(buf,info);
    strcat(buf,"\"");
  break;
  case ENOEXEC:
     strcat(buf,"The executable has wrong format. Please check if the wget.exe works from the commmandline!");
  break;
  case ENOMEM:
     strcat(buf,"Well it seems that there is not enough memory, which is quite unlikely!");
  break;
  }
  Fehler(buf);




}
int startJob(char *wget,char *workdir,int cont)
{
char *myArgs[32];
int i,n;
char mycwd[256];
  char buf[48];
  _getcwd(mycwd,255);
  if (workdir)
    _chdir(workdir);


  n=0;

  myArgs[n]=(char *)malloc(strlen(wget)+1);
  strcpy(myArgs[n],wget);
  n++;

  if (cont)
  {
    myArgs[n]=(char*)malloc(strlen("-c")+1);
    strcpy(myArgs[n],"-c");
    n++;
  }
  if (!runtimeArgs.noFilePath)
    if (staticRuntimeSettings.filePath || runtimeArgs.filePath)
    {
      myArgs[n]=(char*)malloc(strlen("-x")+1);
      strcpy(myArgs[n],"-x");
      n++;
    }
    if (staticExecSettings.ftpPassiveMode)
    {
      myArgs[n]=(char*)malloc(strlen("--passive-ftp")+1);
      strcpy(myArgs[n],"--passive-ftp");
      n++;
    }

  i=0;
  while (execArgs.wgetArgs[i])
  {
    myArgs[n]=(char *)malloc(strlen(execArgs.wgetArgs[i])+1);
    strcpy(myArgs[n],execArgs.wgetArgs[i]);
    n++;
    i++;
  }

  if (execArgs.usedClip)
  {
    myArgs[n]=(char *)malloc(strlen(execArgs.clipUrl)+1);

    strcpy(myArgs[n],execArgs.clipUrl);
   n++;

  }

  myArgs[n]=NULL;
  i=0;
  while (execArgs.wgetArgs[i])
    fprintf(systemRuntimeData.logout,"spawnarg %i: %s",i,execArgs.wgetArgs[i++]);

  systemRuntimeData.wgetPid= spawnvp(P_NOWAIT,staticExecSettings.wGetExePath,myArgs);
  if (systemRuntimeData.wgetPid==-1)
  {
    displayErrorBox(errno,wget);
    return errno;
  }
  else return 0;



}


MRESULT EXPENTRY mainNbPageDlgProc(HWND hwndStatDlg,ULONG msg,MPARAM mp1, MPARAM mp2)
{
HMQ statUpdateHMQ=WinQueryWindowULong(systemRuntimeData.hwndDlg  ,QWL_USER);
HMQ analyzeHMQ=WinQueryWindowULong(systemRuntimeData.hwndConDlg,QWL_USER);
static int pause=TRUE;
static long cb_cx=0,cb_cy=0;
  switch(msg)
  {
    case WM_INITDLG:
    WinShowWindow(WinWindowFromID(hwndStatDlg,ID_PLAY_BTN),FALSE);
    WinSetFocus(HWND_DESKTOP,WinWindowFromID(hwndStatDlg,ID_RETRY_BTN));



    break;

    case WM_CONTROL:
      switch(SHORT1FROMMP(mp1))
      {

        case ID_CHANGESIZE_BTN:
          WinSendMsg (systemRuntimeData.hwndStatDlg,WM_COMMAND,MPFROM2SHORT(ID_CHANGE_SIZE,0),(MPARAM)NULL);
        return FALSE;
      }
     return FALSE;



    case WM_COMMAND:
    {



    switch(SHORT1FROMMP(mp1))
    {
    int n=0;
      case ID_LAUNCH_BTN:
      {
      int what=spawnlp(P_NOWAIT,runtimeData.local,NULL);
      if (what==0)
      {
      char lb[255];
        sprintf(lb,"Could not launch %s, is it really an .exe file?",runtimeData.local);
        Fehler(lb);


      }

      }
      break;
        case ID_OPEN_BTN:
        {
          HOBJECT dir;
          dir=WinQueryObject(runtimeSettings.workDir);
          if (dir)
          {
            WinOpenObject(dir,1,TRUE);
            WinOpenObject(dir,1,TRUE);
          }

        }
        break;
        case ID_CANCEL_BTN:
        {

          WinPostMsg(systemRuntimeData.hwndDlg,WM_CLOSE,0,0);
        retCode.rcUsercancel=1;

        }
        break;
        case ID_PAUSE_BTN:
        {

        runtimeData.newDownload=0;
        retCode.rcUsercancel=1;


          kill(systemRuntimeData.wgetPid,SIGINT);


          n = DosKillProcess (DKP_PROCESS, systemRuntimeData.wgetPid);
          n = DosKillProcess (DKP_PROCESSTREE,systemRuntimeData.wgetPid);
          WinPostQueueMsg(statUpdateHMQ,WM_QUIT,NULL,NULL); //  WinQueMsg
          WinPostQueueMsg(analyzeHMQ,WM_QUIT,NULL,NULL); //  WinQueMsg
         DosSleep(250);
          DosKillThread(systemRuntimeData.analyzeTID);
          DosKillThread(systemRuntimeData.statUpdateTID);

          WinEnableWindow(WinWindowFromID(hwndStatDlg,ID_RETRY_BTN),FALSE);
          WinShowWindow(WinWindowFromID(hwndStatDlg,ID_PAUSE_BTN),FALSE);
          WinShowWindow(WinWindowFromID(hwndStatDlg,ID_PLAY_BTN),TRUE);

          break;
        }
        case ID_PLAY_BTN:

        {

                retCode.rcUsercancel=0;

          WinEnableWindow(WinWindowFromID(hwndStatDlg,ID_RETRY_BTN),TRUE);

          startJob(staticExecSettings.wGetExePath,runtimeSettings.workDir,TRUE);

          DosSleep(250);
          systemRuntimeData.statUpdateTID=_beginthread(statUpdateThread,NULL,32768,NULL);  //  EM_SETBACKCOLOR
          systemRuntimeData.analyzeTID=_beginthread(analyzeThread,NULL,32768,NULL);  //  EM_SETBACKCOLOR
          WinShowWindow(WinWindowFromID(hwndStatDlg,ID_PLAY_BTN),FALSE);
          WinShowWindow(WinWindowFromID(hwndStatDlg,ID_PAUSE_BTN),TRUE);

        }
        break;


        case ID_RETRY_BTN:
        {
           runtimeData.newDownload=0;

           kill(systemRuntimeData.wgetPid,SIGINT);
           n = DosKillProcess (DKP_PROCESS, systemRuntimeData.wgetPid);
           n = DosKillProcess (DKP_PROCESSTREE,systemRuntimeData.wgetPid);

           WinEnableWindow(WinWindowFromID(hwndStatDlg,ID_RETRY_BTN),FALSE);

           WinPostQueueMsg(statUpdateHMQ,WM_QUIT,NULL,NULL);
           WinPostQueueMsg(analyzeHMQ,WM_QUIT,NULL,NULL); //  WinQueMsg

           DosSleep(250);

           DosKillThread(systemRuntimeData.analyzeTID);
           DosKillThread(systemRuntimeData.statUpdateTID);

           startJob(staticExecSettings.wGetExePath,runtimeSettings.workDir,TRUE);

           DosSleep(250);

            systemRuntimeData.statUpdateTID=_beginthread(statUpdateThread,NULL,32768,NULL);  //  EM_SETBACKCOLOR
           systemRuntimeData.analyzeTID=_beginthread(analyzeThread,NULL,32768,NULL);  //  EM_SETBACKCOLOR
           WinEnableWindow(WinWindowFromID(hwndStatDlg,ID_RETRY_BTN),TRUE);
        }
        break;

        case ID_RETRANSFER_BTN:
        {
           runtimeData.newDownload=1;
           runtimeData.prevSize=0;
           kill(systemRuntimeData.wgetPid,SIGINT);
           DosKillProcess (DKP_PROCESS, systemRuntimeData.wgetPid);
           n = DosKillProcess (DKP_PROCESSTREE,systemRuntimeData.wgetPid);
           if (!pause)
           {
             WinSetWindowText(WinWindowFromID(hwndStatDlg,ID_PAUSE_BTN),"Pause");
             WinEnableWindow(WinWindowFromID(hwndStatDlg,ID_RETRY_BTN),TRUE);
             pause=1;

           }
           WinEnableWindow(WinWindowFromID(systemRuntimeData.hwndDlg,ID_RETRY_BTN),FALSE);
           WinPostQueueMsg(statUpdateHMQ,WM_QUIT,NULL,NULL);
           WinPostQueueMsg(analyzeHMQ,WM_QUIT,NULL,NULL); //  WinQueMsg
           DosSleep(250);
           DosKillThread(systemRuntimeData.analyzeTID);
           DosKillThread(systemRuntimeData.statUpdateTID);
           startJob(staticExecSettings.wGetExePath,runtimeSettings.workDir,FALSE);
           DosSleep(250);
           systemRuntimeData.statUpdateTID=_beginthread(statUpdateThread,NULL,32768,NULL);  //  EM_SETBACKCOLOR
           systemRuntimeData.analyzeTID=_beginthread(analyzeThread,NULL,32768,NULL);  //  EM_SETBACKCOLOR
           WinEnableWindow(WinWindowFromID(systemRuntimeData.hwndDlg,ID_RETRY_BTN),TRUE);

        }
        break;
        case ID_CHANGE_SIZE:
        {
        RECTL rclDlg,rclButton,rclFrame;
        SWP swp;
        int myToggle=1;

          swp.x=12;
          swp.y=12;
          swp.cy=12;
          swp.cx=12;
          WinShowWindow(systemRuntimeData.hwndDlg,FALSE);
          if (!cb_cx)
          {
            WinQueryWindowPos( WinWindowFromID(hwndStatDlg,ID_CANCEL_BTN),&rclButton);
            WinQueryWindowPos( systemRuntimeData.hwndDlg,&rclDlg);
            WinQueryWindowPos( WinWindowFromID(systemRuntimeData.hwndFrame,FCF_TITLEBAR),&rclFrame);
            if (!systemRuntimeData.bigFonts)
            {
              cb_cx=21;
              cb_cy=-(rclDlg.yTop-rclButton.yTop)+41;
            }
            else
            {
              cb_cx=41;
              cb_cy=-(rclDlg.yTop-rclButton.yTop)+53;

            }
          }
          runtimeData.windowDetail=toggleWindowSize(systemRuntimeData.hwndDlg,cb_cx,cb_cy);
          toggleWindowPos(systemRuntimeData.noteBookWnd,12,12);
          WinShowWindow(systemRuntimeData.hwndDlg,TRUE);

          WinSetFocus(HWND_DESKTOP,systemRuntimeData.noteBookWnd); //well this should have brought
                                                                   //the notebook into focus so that
                                                                   //the accelerator keys work, but
                                                                   //it didn't
        }



    }

    }
    return FALSE;


    default:
      return WinDefDlgProc(hwndStatDlg,msg,mp1,mp2);

 }
return (MRESULT) FALSE;
}





MRESULT EXPENTRY retrieverWndProc(HWND Window,ULONG Message,MPARAM Param1,MPARAM Param2)
{

  switch(Message)
  {
    case WM_CREATE: //INITDLG:
    {
      char buf[255];

      SWP winPos;
      RECTL rcl;

      SetSysMenu(Window);



      systemRuntimeData.noteBookWnd=WinCreateWindow(Window,WC_NOTEBOOK,"what is this",BKS_BACKPAGESBR | BKS_MAJORTABRIGHT | WS_GROUP|BKS_TABBEDDIALOG, 0, 0,384, 209,Window,HWND_TOP,ID_NOTEBOOKDLG,NULL,NULL);



      systemRuntimeData.idMainPage1=WinSendMsg(systemRuntimeData.noteBookWnd,BKM_INSERTPAGE,0L,MPFROM2SHORT(BKA_MAJOR|BKA_STATUSTEXTON|BKA_AUTOPAGESIZE,BKA_LAST));

      sprintf(buf,"Started at %i:%i:%i o'clock",runtimeSettings.startTime.hours,runtimeSettings.startTime.minutes,runtimeSettings.startTime.seconds);
      WinSendMsg(systemRuntimeData.noteBookWnd,BKM_SETSTATUSLINETEXT,MPFROMLONG(systemRuntimeData.idMainPage1),MPFROMP(buf));
      WinSendMsg(systemRuntimeData.noteBookWnd,BKM_SETTABTEXT,MPFROMLONG(systemRuntimeData.idMainPage1),MPFROMP("Status"));

      systemRuntimeData.idMainPage2=WinSendMsg(systemRuntimeData.noteBookWnd,BKM_INSERTPAGE,0L,MPFROM2SHORT(BKA_MAJOR|BKA_STATUSTEXTON|BKA_AUTOPAGESIZE,BKA_LAST));

      WinSendMsg(systemRuntimeData.noteBookWnd,BKM_SETSTATUSLINETEXT,MPFROMLONG(systemRuntimeData.idMainPage2),MPFROMP("Console"));
      WinSendMsg(systemRuntimeData.noteBookWnd,BKM_SETTABTEXT,MPFROMLONG(systemRuntimeData.idMainPage2),MPFROMP("Console"));

      systemRuntimeData.hwndStatDlg=WinLoadDlg(systemRuntimeData.noteBookWnd,Window,(PFNWP)mainNbPageDlgProc,NULLHANDLE,ID_STATDLG,NULL);
      systemRuntimeData.hwndConDlg=WinLoadDlg(systemRuntimeData.noteBookWnd,Window,(PFNWP)mainNbPageDlgProc,NULLHANDLE,ID_CONDLG,NULL);
      WinQueryWindowRect( systemRuntimeData.hwndStatDlg,&rcl);

      WinSetWindowPos(systemRuntimeData.noteBookWnd,HWND_TOP,83, 26,   (rcl.xRight)-rcl.xLeft,(rcl.yTop)-rcl.yBottom ,SWP_SIZE);

      WinSendMsg(systemRuntimeData.noteBookWnd,BKM_SETPAGEWINDOWHWND,MPFROMLONG(systemRuntimeData.idMainPage1),MPFROMHWND(systemRuntimeData.hwndStatDlg));
      WinSendMsg(systemRuntimeData.noteBookWnd,BKM_SETPAGEWINDOWHWND,MPFROMLONG(systemRuntimeData.idMainPage2),MPFROMHWND(systemRuntimeData.hwndConDlg));

      systemRuntimeData.statUpdateTID=_beginthread(statUpdateThread,NULL,32768,NULL);  //  EM_SETBACKCOLOR
      systemRuntimeData.analyzeTID=_beginthread(analyzeThread,NULL,32768,NULL);  //  EM_SETBACKCOLOR

      if (!runtimeArgs.noAutoClose)
      if (runtimeArgs.autoClose||staticRuntimeSettings.autoClose)
        WinSendDlgItemMsg(systemRuntimeData.hwndStatDlg,ID_LEAVEOPEN_BTN,BM_SETCHECK,(MPARAM)TRUE,NULL);

WinQueryWindowRect( systemRuntimeData.noteBookWnd,&rcl);


 WinSetWindowPos(Window,HWND_TOP,83, 26, rcl.xRight-rcl.xLeft,rcl.yTop-rcl.yBottom,SWP_SIZE/* |SWP_MOVE|SWP_ACTIVATE*/);

      WinShowWindow(systemRuntimeData.noteBookWnd,TRUE);
     WinShowWindow(Window,TRUE);



    }
    return (MRESULT) FALSE;
                                                     //SLDCDATA


    case WM_THEEND:
    {
      if (WinSendDlgItemMsg(systemRuntimeData.hwndStatDlg,ID_LEAVEOPEN_BTN,BM_QUERYCHECK,NULL,NULL)) //|| runtimeData.argFlags.autoClose)
      {
        if (pipeData.infoPipeHMQ)
          WinPostQueueMsg(pipeData.infoPipeHMQ,WM_MR_DIE,"Marvin's Retriever is quitting",NULL); //  WinQueMsg
        WinPostMsg(Window,WM_CLOSE,0,0);
      }
      WinShowWindow(WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_PLAY_BTN),TRUE);
      WinShowWindow(WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_PAUSE_BTN),FALSE);
    }
    break;

    case WM_PAINT:

      {
      HPS    hps;                       /* Presentation Space handle    */
      RECTL  rc;                        /* Rectangle coordinates        */

                                        /* Create a presentation space  */
      hps = WinBeginPaint( Window, 0L, &rc );
      WinFillRect( hps, &rc, CLR_PALEGRAY);

      WinEndPaint( hps );                      /* Drawing is complete   */
      break;
      }

     case WM_COMMAND:
    {
      switch(SHORT1FROMMP(Param1))
      {
        case IDM_QUIT:
          WinSendMsg(Window,WM_CLOSE,0,0);

        break;

        case IDM_PAUSE_PLAY:
          if( WinIsWindowVisible(WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_PLAY_BTN))  )
            WinSendMsg(systemRuntimeData.hwndStatDlg,WM_COMMAND,ID_PLAY_BTN,0);
          else
            WinSendMsg(systemRuntimeData.hwndStatDlg,WM_COMMAND,ID_PAUSE_BTN,0);
        break;
        case IDM_RETRY:
          WinSendMsg(systemRuntimeData.hwndStatDlg,WM_COMMAND,ID_RETRY_BTN,0);

        break;
        case IDM_DETAIL:
          WinSendMsg(systemRuntimeData.hwndStatDlg,WM_COMMAND,ID_CHANGE_SIZE,0);
        break;
        case IDM_RETRANSFER:
          WinSendMsg(systemRuntimeData.hwndStatDlg,WM_COMMAND,ID_RETRANSFER_BTN,0);

        break;
        case IDM_LAUNCH:
          WinSendMsg(systemRuntimeData.hwndStatDlg,WM_COMMAND,ID_LAUNCH_BTN,0);
        break;
        case IDM_OPEN:
          WinSendMsg(systemRuntimeData.hwndStatDlg,WM_COMMAND,ID_OPEN_BTN,0);

        break;
        case IDM_ABOUT:
        {
        HWND hwndAboutDlg=WinLoadDlg(HWND_DESKTOP,Window,aboutDialogProc,NULLHANDLE,ID_ABOUT_DLG,NULL );
          WinProcessDlg(hwndAboutDlg);


        }
        break;
        case IDM_SETTINGS:
        {
        HWND hwndSettingsDlg=WinLoadDlg(HWND_DESKTOP,Window,settingsDialogProc,NULLHANDLE,ID_SETTINGS_DLG,NULL );
          WinProcessDlg(hwndSettingsDlg);


        }
        break;


      }
    }
    break;


    case WM_CLOSE:
    {
    HMQ updateThreadHmq,analyzeThreadHmq;
      updateThreadHmq=WinQueryWindowULong(systemRuntimeData.hwndStatDlg,QWL_USER);
      analyzeThreadHmq=WinQueryWindowULong(systemRuntimeData.hwndConDlg,QWL_USER);

      WinPostQueueMsg(updateThreadHmq,WM_QUIT,NULL,NULL); //  WinQueMsg
      WinPostQueueMsg(analyzeThreadHmq,WM_QUIT,NULL,NULL); //  WinQueMsg
      WinPostQueueMsg(pipeData.infoPipeHMQ,WM_QUIT,NULL,NULL); //  WinQueMsg


     WinPostMsg(Window,WM_QUIT,0,0);
    }
    return (MRESULT) FALSE;
    default:
     return WinDefWindowProc(Window,Message,Param1,Param2);
  }
  return(MRESULT)FALSE;
}



MRESULT EXPENTRY settingsDialogProc(HWND window,ULONG Message,MPARAM Param1,MPARAM Param2)
{
char buf[255];
static int secs;

 switch(Message)
  {
    case WM_INITDLG:
    {
    HPOINTER hIcon;

      WinSendDlgItemMsg(window,ID_AUTOSTART_EF,SPBM_SETLIMITS,MPFROMLONG(60),MPFROMLONG(0));
      WinSendDlgItemMsg(window,ID_AUTOSTART_EF,SPBM_SETCURRENTVALUE,(MPARAM) staticRuntimeSettings.autoStartTime,(MPARAM)NULL);
      if (staticRuntimeSettings.autoStart)
      {
        WinSendDlgItemMsg(window,ID_AUTOSTART_BTN,BM_SETCHECK,(MPARAM)1,NULL);
        WinEnableWindow(WinWindowFromID(window,ID_AUTOSTART_EF),TRUE);
      }
      else
        WinEnableWindow(WinWindowFromID(window,ID_AUTOSTART_EF),FALSE);

      if (staticRuntimeSettings.autoClose)
        if (!WinSendDlgItemMsg(window,ID_AUTOCLOSE_BTN,BM_QUERYCHECK,NULL,NULL))
          WinSendDlgItemMsg(window,ID_AUTOCLOSE_BTN,BM_SETCHECK,(MPARAM)1,NULL);

      if (!staticRuntimeSettings.detail)
        if (!WinSendDlgItemMsg(window,ID_DETAIL_BTN,BM_QUERYCHECK,NULL,NULL))
          WinSendDlgItemMsg(window,ID_DETAIL_BTN,BM_SETCHECK,(MPARAM)1,NULL);

      if (staticRuntimeSettings.filePath)
        if (!WinSendDlgItemMsg(window,ID_FILEPATH_BTN,BM_QUERYCHECK,NULL,NULL))
          WinSendDlgItemMsg(window,ID_FILEPATH_BTN,BM_SETCHECK,(MPARAM)1,NULL);
      if (staticExecSettings.ftpPassiveMode)
        if (!WinSendDlgItemMsg(window,ID_PASSIVE_FTP_BTN,BM_QUERYCHECK,NULL,NULL))
          WinSendDlgItemMsg(window,ID_PASSIVE_FTP_BTN,BM_SETCHECK,(MPARAM)1,NULL);

      if (staticExecSettings.wGetPath)
      {
        if (!WinSendDlgItemMsg(window,ID_WGETPATH_BTN,BM_QUERYCHECK,NULL,NULL))
        {
          WinSendDlgItemMsg(window,ID_WGETPATH_BTN,BM_SETCHECK,(MPARAM)1,NULL);
          WinSetWindowText(WinWindowFromID(window,ID_WGETPATH_EF),staticExecSettings.wGetExePath);
        }
      }
      else
      {
        WinEnableWindow(WinWindowFromID(window,ID_WGETPATH_EF),FALSE);
        WinEnableWindow(WinWindowFromID(window,ID_WGETBROWSE_BTN),FALSE);
      }
       hIcon= WinLoadPointer(HWND_DESKTOP,0,ID_RETRIEVER);
           WinSendMsg(window,WM_SETICON,(MPARAM)hIcon,NULL);



      return (MRESULT) FALSE;
    }
    case WM_CONTROL:       //WM_ENABLE
    {
       switch(SHORT1FROMMP(Param1))
       {
         case ID_AUTOSTART_BTN:
           if (SHORT2FROMMP(Param1)==BN_CLICKED || SHORT2FROMMP(Param1)==BN_DBLCLICKED)
           {
             if (WinSendDlgItemMsg(window,ID_AUTOSTART_BTN,BM_QUERYCHECK,NULL,NULL))
               WinEnableWindow(WinWindowFromID(window,ID_AUTOSTART_EF),TRUE);
             else
               WinEnableWindow(WinWindowFromID(window,ID_AUTOSTART_EF),FALSE);
           }
         break;
         case ID_WGETPATH_BTN:
           if (SHORT2FROMMP(Param1)==BN_CLICKED || SHORT2FROMMP(Param1)==BN_DBLCLICKED)
           {
             if (WinSendDlgItemMsg(window,ID_WGETPATH_BTN,BM_QUERYCHECK,NULL,NULL))
             {
               WinEnableWindow(WinWindowFromID(window,ID_WGETPATH_EF),TRUE);
               WinEnableWindow(WinWindowFromID(window,ID_WGETBROWSE_BTN),TRUE);
             }
             else
             {
               WinEnableWindow(WinWindowFromID(window,ID_WGETPATH_EF),FALSE);
               WinEnableWindow(WinWindowFromID(window,ID_WGETBROWSE_BTN),FALSE);
             }
           }
         break;

       }

    }

    case WM_COMMAND:
    {
      switch(SHORT1FROMMP(Param1))
      {
        case ID_WGETBROWSE_BTN:
        {
          FILEDLG fd;

          memset(&fd,0,sizeof(FILEDLG));
          fd.cbSize=sizeof(FILEDLG);
          fd.pszTitle=(PSZ)"Specify location of wget.exe";
          fd.pszOKButton=(PSZ)"Select file";
          fd.fl=FDS_CENTER|FDS_OPEN_DIALOG;
          fd.pfnDlgProc=(PFNWP)NULL;
          strcpy(fd.szFullFile,(PSZ)"*.exe");

          WinFileDlg(HWND_DESKTOP,window,(PFILEDLG)&fd);

          if (fd.lReturn==MBID_OK)
            WinSetWindowText(WinWindowFromID(window,ID_WGETPATH_EF),fd.szFullFile);
        }
        return FALSE;
        case DID_OK:
        {
        char timeBuf[32];
          if (WinSendDlgItemMsg(window,ID_AUTOSTART_BTN,BM_QUERYCHECK,NULL,NULL))
          {
            staticRuntimeSettings.autoStart=1;
            WinQueryWindowText(WinQueryWindow(WinWindowFromID(window,ID_AUTOSTART_EF), QW_TOP),sizeof(timeBuf),timeBuf);
            staticRuntimeSettings.autoStartTime=atoi(timeBuf);
          }
          else
            staticRuntimeSettings.autoStart=0;

          if (WinSendDlgItemMsg(window,ID_AUTOCLOSE_BTN,BM_QUERYCHECK,NULL,NULL))
            staticRuntimeSettings.autoClose=1;
          else
            staticRuntimeSettings.autoClose=0;

          if ( WinSendDlgItemMsg(window,ID_DETAIL_BTN,BM_QUERYCHECK,NULL,NULL))
            staticRuntimeSettings.detail=0;
          else
            staticRuntimeSettings.detail=1;

          if ( WinSendDlgItemMsg(window,ID_FILEPATH_BTN,BM_QUERYCHECK,NULL,NULL))
          {
            staticRuntimeSettings.filePath=1;

         }
          else
            staticRuntimeSettings.filePath=0;


          if (WinSendDlgItemMsg(window,ID_WGETPATH_BTN,BM_QUERYCHECK,NULL,NULL))
          {

            staticExecSettings.wGetPath=1;
            WinQueryWindowText(WinWindowFromID(window,ID_WGETPATH_EF),CCHMAXPATH,staticExecSettings.wGetExePath);
          }
          else
            staticExecSettings.wGetPath=0;

        }
        if (WinSendDlgItemMsg(window,ID_PASSIVE_FTP_BTN,BM_QUERYCHECK,NULL,NULL))
          staticExecSettings.ftpPassiveMode=1;
        else
          staticExecSettings.ftpPassiveMode=0;


      }
    }
    default:
      return WinDefDlgProc(window,Message,Param1,Param2);
  }
}

MRESULT EXPENTRY aboutDialogProc(HWND Window,ULONG Message,MPARAM Param1,MPARAM Param2)
{
char buf[255];
static int secs;

 switch(Message)
  {
    case WM_INITDLG:
    {
    HPOINTER hIcon;
    int i;
    FILE *fGPL;
    char fGPLName[CCHMAXPATH+1], lineBuf[256];
      WinEnableWindowUpdate(WinWindowFromID(Window,ID_THANKS_LB),FALSE);
      for (i=0;aboutThanks[i];i++)
        WinSendDlgItemMsg(Window,ID_THANKS_LB,LM_INSERTITEM,MPFROMSHORT(LIT_END),aboutThanks[i]);
      WinEnableWindowUpdate(WinWindowFromID(Window,ID_THANKS_LB),TRUE);

      strcpy(fGPLName,runtimeSettings.retrieverPath);
      strcat(fGPLName,"\\");
      strcat(fGPLName,"GPL.txt");

      fGPL=fopen(fGPLName,"r");
      if (fGPL)
      {
        while (fgets(lineBuf,255,fGPL))
        {

          WinSendDlgItemMsg(Window,ID_GPL_MLE,MLM_INSERT, MPFROMP(lineBuf),(MPARAM)NULL );


        }
         WinSendDlgItemMsg(Window,ID_GPL_MLE,MLM_SETFIRSTCHAR, (MPARAM)0,(MPARAM)NULL );
         WinSendDlgItemMsg(Window,ID_GPL_MLE,MLM_SETSEL, (MPARAM)0,(MPARAM)NULL );

       fclose(fGPL);
        }


        hIcon= WinLoadPointer(HWND_DESKTOP,0,ID_RETRIEVER);
           WinSendMsg(Window/*Window*/,WM_SETICON,(MPARAM)hIcon,NULL);

      return (MRESULT) FALSE;
    }
    case WM_COMMAND:
    {
      switch(SHORT1FROMMP(Param1))
      {
        case DID_OK:
        {
        }
      }
    }
    default:
      return WinDefDlgProc(Window,Message,Param1,Param2);
  }
}

MRESULT EXPENTRY getUrlDialogProc(HWND Window,ULONG Message,MPARAM Param1,MPARAM Param2)
{
char buf[255];
static int secs;

 switch(Message)
  {
    case WM_INITDLG:
    {
    char *next,*clip=getFromClipboard();
    char buf2[32];

      WinSetFocus(HWND_DESKTOP,WinWindowFromID(Window,ID_GU_URL_CB));
      if (clip)
      {
        next=clip;
        do
        {
          next=getHttpUrl(next,buf);

          if (strlen(buf)>1)
          {
            WinSendDlgItemMsg(Window,ID_GU_URL_CB,LM_INSERTITEM,MPFROMSHORT(LIT_END),buf);

          }
          else break;
        }
        while (next);
        next=clip;
        do
        {
           next=getFtpUrl(next,buf);
           if (strlen(buf)>1)
           {
            WinSendDlgItemMsg(Window,ID_GU_URL_CB,LM_INSERTITEM,MPFROMSHORT(LIT_END),buf);
           }
           else break;
        }
        while (next);
        free(clip);

      }
      WinSendDlgItemMsg(Window,ID_GU_URL_CB,LM_SELECTITEM,MPFROMSHORT(0),MPFROMSHORT(TRUE));
      secs=staticRuntimeSettings.autoStartTime;

      sprintf(buf2,"in %i seconds!",secs--);
      WinSetWindowText(WinWindowFromID(Window,ID_GU_AS_EF),buf2);

      if (staticRuntimeSettings.autoStart)
      {
      char buf1[255];
        WinQueryWindowText(WinWindowFromID(Window,ID_GU_URL_CB),250,buf1) ;
        if (strlen(buf1))
        {
          WinStartTimer(systemRuntimeData.mainHAB,Window,ID_TIMER3,1000);
           WinSendDlgItemMsg(Window,ID_GU_AS_BTN,BM_SETCHECK,(MPARAM)TRUE,NULL);
        }
        else
        {
          WinEnableWindow(WinWindowFromID(Window,ID_GU_AS_EF),FALSE);
        }



      }
      else
        WinEnableWindow(WinWindowFromID(Window,ID_GU_AS_EF),FALSE);
      if (staticRuntimeSettings.filePath)
        WinSendDlgItemMsg(Window,ID_GU_SP_BTN,BM_SETCHECK,(MPARAM)TRUE,NULL);

    }



    return (MRESULT) FALSE;

    case WM_TIMER:
    {
     if (SHORT1FROMMP(Param1)==ID_TIMER3)
     {
       char b[32];
       sprintf(b,"in %i seconds!",secs--);
       WinSetWindowText(WinWindowFromID(Window,ID_GU_AS_EF),b);
       if (secs==-1)
         WinPostMsg (Window,WM_COMMAND,MPFROM2SHORT(DID_OK,0),(MPARAM)NULL);
     }


    }


    break;



    case WM_COMMAND:
    {
      switch(SHORT1FROMMP(Param1))
      {
        case DID_OK:
         WinQueryWindowText(WinWindowFromID(Window,ID_GU_URL_CB),250,buf);
         if (strlen(buf)>1)
         {

           execArgs.usedClip=1;
           strcpy(execArgs.clipUrl,buf);

         }
        if (WinSendDlgItemMsg(Window,ID_GU_SP_BTN,BM_QUERYCHECK,NULL,NULL))
          runtimeArgs.filePath=1;
        else runtimeArgs.noFilePath=1;

         WinSendMsg(Window,WM_CLOSE,NULL,NULL);

        break;
        case DID_CANCEL:
        WinSendMsg(Window,WM_CLOSE,NULL,NULL);

        break;
        case IDM_SETTINGS:
        {
        HWND hwndSettingsDlg=WinLoadDlg(HWND_DESKTOP,Window,settingsDialogProc,NULLHANDLE,ID_SETTINGS_DLG,NULL );
          WinStopTimer(systemRuntimeData.mainHAB,Window,ID_TIMER3);
          WinProcessDlg(hwndSettingsDlg);
                WinSetFocus(HWND_DESKTOP,WinWindowFromID(Window,ID_GU_URL_CB));

          break;
        }
        case IDM_ABOUT:
        {

        HWND hwndAboutDlg=WinLoadDlg(HWND_DESKTOP,Window,aboutDialogProc,NULLHANDLE,ID_ABOUT_DLG,NULL );
          WinStopTimer(systemRuntimeData.mainHAB,Window,ID_TIMER3);
          WinProcessDlg(hwndAboutDlg);
          WinSetFocus(HWND_DESKTOP,WinWindowFromID(Window,ID_GU_URL_CB));

          break;
        }
        case ID_GU_FN_BTN:
        {
          FILEDLG fd;
          char buf[255];
          memset(&fd,0,sizeof(FILEDLG));
          fd.cbSize=sizeof(FILEDLG);
          fd.pszTitle=(PSZ)"Select File with a list of URLs";
          fd.pszOKButton=(PSZ)"Open file";
          fd.fl=FDS_CENTER|FDS_OPEN_DIALOG;
          fd.pfnDlgProc=(PFNWP)NULL;
          strcpy(fd.szFullFile,(PSZ)"*.txt;*.lst;*.htm;*.html");
          if (staticRuntimeSettings.autoStart)
            WinStopTimer(systemRuntimeData.mainHAB,Window,ID_TIMER3);
          WinSendDlgItemMsg(Window,ID_GU_AS_BTN,BM_SETCHECK,(MPARAM)0,NULL);
          secs=10;

          WinFileDlg(HWND_DESKTOP,Window,(PFILEDLG)&fd);

          if (fd.lReturn==MBID_OK)
          {

            strcpy(buf,"-i");
            strcat(buf,fd.szFullFile);
            WinSetWindowText(WinWindowFromID(Window,ID_GU_URL_CB),buf);
            execArgs.iterative=1;
            WinPostMsg (Window,WM_COMMAND,MPFROM2SHORT(DID_OK,0),(MPARAM)NULL);
          }
          else
          {
            WinSendDlgItemMsg(Window,ID_GU_AS_BTN,BM_SETCHECK,(MPARAM)1,NULL);
            if (staticRuntimeSettings.autoStart)
              WinStartTimer(systemRuntimeData.mainHAB,Window,ID_TIMER3,1000);
          }

        }
        break;



        }
      }
      case WM_CONTROL:
      {
      switch(SHORT2FROMMP(Param1))
      {
        case BN_DBLCLICKED:
        case BN_CLICKED:
        {
          if (SHORT1FROMMP(Param1)==ID_GU_AS_BTN)
          {

            if (!WinSendDlgItemMsg(Window,ID_GU_AS_BTN,BM_QUERYCHECK,NULL,NULL))
            {

              WinStopTimer(systemRuntimeData.mainHAB,Window,ID_TIMER3);
              WinEnableWindow(WinWindowFromID(Window,ID_GU_AS_EF),FALSE);
              secs=staticRuntimeSettings.autoStartTime;
            }
            else
            {
              WinStartTimer(systemRuntimeData.mainHAB,Window,ID_TIMER3,1000);
              WinEnableWindow(WinWindowFromID(Window,ID_GU_AS_EF),TRUE);
            }

          }
        }
      }

    }
    return (MRESULT)FALSE;

    default:
      return WinDefDlgProc(Window,Message,Param1,Param2);

 }
return (MRESULT) FALSE;
}
/* ------------------------------------------------------------------------- */

int main(int argc,CHAR *argv[])
{

HMQ hmq;
QMSG qmsg;
ULONG DialogID;

RECTL rcl;
SWP mainWinPos;
CHAR Title[]=TITLE_VERSION;
PID        pid;
TID        tid;
SWCNTRL    Swctl;
HMODULE moduleHandle;
CHAR szWindowClass[]="Marvin's Retriever";
ULONG wndFlags=WS_VISIBLE| FCF_SYSMENU | FCF_TITLEBAR |FCF_MINBUTTON|FCF_DLGBORDER|FCF_MENU|FCF_ACCELTABLE;
ULONG xDelta,yDelta,frameHeight,len;
char LoadError[80];
CHAR szFailName[CCHMAXPATH];
RESULTCODES resc;
FATTRS fAttr;
HPOINTER hIcon;
int prfFirst=0;
int winListAdded=0;
HINI retrieverIni;
ULONG hfSave=-1, hfNew = XPIPE_STDERROR;

  pipeData.isPipe=0;
  systemRuntimeData.logout=fopen("retrievr.log","w");
  systemRuntimeData.mainHAB=WinInitialize(0);
  hmq=WinCreateMsgQueue(systemRuntimeData.mainHAB,0);
  systemRuntimeData.bigFonts=0;
  runtimeData.newDownload=1;
  runtimeData.endDownload=0;
  execArgs.iterative=0;
  runtimeData.windowDetail=1;
  runtimeArgs.autoClose=0;
  retCode.rcError=0;
  retCode.rcUsercancel=0;
  retCode.rcAllOk=0;
  prfFirst=0;
  execArgs.usedClip=0;
  doArgs(argc,argv);

  _getcwd2(runtimeSettings.retrieverPath,CCHMAXPATH);
  {
  char *p=runtimeSettings.retrieverPath;
    while (*p)
    {
      if (*p=='/') *p='\\';
      p++;
    }
  }
  PrfQueryProfileSize(HINI_USERPROFILE,"Marvin","Directory",&len);
  if (!len)
  {
    PrfWriteProfileString(HINI_USERPROFILE,"Marvin","Directory",runtimeSettings.retrieverPath);  // not there,ok we will create it

  }
  else
  {
    PrfQueryProfileString(HINI_USERPROFILE,"Marvin","Directory","War wohl nix",runtimeSettings.retrieverPath,CCHMAXPATH);
  }
  strcpy(runtimeSettings.retrieverIniFile,runtimeSettings.retrieverPath);
  strcat(runtimeSettings.retrieverIniFile,"\\retrievr.ini");

  if(!fileExists(runtimeSettings.retrieverIniFile))
  {
    staticRuntimeSettings.autoStart=1;
    staticRuntimeSettings.autoStartTime=10;
    staticRuntimeSettings.autoClose=1;
    staticRuntimeSettings.detail=0;
    staticExecSettings.wGetPath=0;
    staticRuntimeSettings.filePath=0;
    prfFirst=1;

  }


  retrieverIni=PrfOpenProfile(systemRuntimeData.mainHAB,runtimeSettings.retrieverIniFile);


  if (prfFirst)
  {
    PrfWriteProfileData(retrieverIni,"Retriever","runtimeSettings",&staticRuntimeSettings,sizeof(StaticRuntimeSettings));
    PrfWriteProfileData(retrieverIni,"Retriever","execSettings",&staticExecSettings,sizeof(StaticExecSettings));
  }
  else
  {
    len=sizeof(StaticRuntimeSettings);
    PrfQueryProfileData(retrieverIni,"Retriever","runtimeSettings",&staticRuntimeSettings,&len);
    len=sizeof(StaticExecSettings);
    PrfQueryProfileData(retrieverIni,"Retriever","execSettings",&staticExecSettings,&len);
  }


  if (!staticExecSettings.wGetPath)
    strcpy(staticExecSettings.wGetExePath,"wget.exe");

  if (pipeData.isPipe)
  {
   systemRuntimeData.infoPipeTID=_beginthread(infoPipeThread,NULL,32768,NULL);  //  EM_SETBACKCOLOR
  }

  hIcon= WinLoadPointer(HWND_DESKTOP,0,ID_RETRIEVER);
  if (!execArgs.urlExists)

  {
  HWND hwndGetUrlDlg=WinLoadDlg(HWND_DESKTOP,HWND_DESKTOP,getUrlDialogProc,NULLHANDLE,ID_GETURL_DLG,NULL );
  HSWITCH hSE;
  WinSendMsg(hwndGetUrlDlg/*Window*/,WM_SETICON,(MPARAM)hIcon,NULL);
  SetSysMenu(hwndGetUrlDlg);
  WinQueryWindowProcess(hwndGetUrlDlg, &pid, &tid);
  memset(&Swctl,0,sizeof(Swctl));
  Swctl.hwnd = hwndGetUrlDlg;
  Swctl.idProcess = pid;
  Swctl.uchVisibility = SWL_VISIBLE;
  Swctl.fbJump = SWL_JUMPABLE;
  strcpy(Swctl.szSwtitle,Title);
  hSE=WinAddSwitchEntry(&Swctl);
  os2title(1,"Nix",0);
  winListAdded=1;

   WinProcessDlg(hwndGetUrlDlg);
   WinStopTimer(systemRuntimeData.mainHAB,hwndGetUrlDlg,ID_TIMER3);
   WinRemoveSwitchEntry(hSE);

  }

  PrfWriteProfileData(retrieverIni,"Retriever","runtimeSettings",&staticRuntimeSettings,sizeof(StaticRuntimeSettings));
  PrfWriteProfileData(retrieverIni,"Retriever","execSettings",&staticExecSettings,sizeof(StaticExecSettings));

  if (!execArgs.urlExists && !execArgs.usedClip)
  {
    WinTerminate (systemRuntimeData.mainHAB);
    return 0;
  }
  if (!WinRegisterClass (systemRuntimeData.mainHAB, (PSZ)szWindowClass,
            (PFNWP)&retrieverWndProc, CS_SIZEREDRAW, 0L))
  {

       WinTerminate (systemRuntimeData.mainHAB);
       return       (FALSE);
  }
  DosGetDateTime(&runtimeSettings.startTime);
  systemRuntimeData.hwndDlg=WinCreateStdWindow(HWND_DESKTOP,0L,&wndFlags,szWindowClass,TITLE_VERSION,0,0L,ID_RETRIEVER,systemRuntimeData.hwndFrame);

      WinSendMsg(systemRuntimeData.hwndDlg/*Window*/,WM_SETICON,(MPARAM)hIcon,NULL);
      SetSysMenu(systemRuntimeData.hwndDlg);





WinQueryWindowRect( systemRuntimeData.noteBookWnd,&rcl);

yDelta=rcl.yTop-rcl.yBottom;
xDelta=rcl.xRight-rcl.xLeft;




  WinSetWindowPos(systemRuntimeData.hwndDlg,HWND_TOP,0, 0, xDelta,yDelta,SWP_SIZE );





WinQueryWindowRect( WinWindowFromID(systemRuntimeData.hwndDlg,FID_TITLEBAR),&rcl);
frameHeight=rcl.yTop-rcl.yBottom;

WinQueryWindowRect( WinWindowFromID(systemRuntimeData.hwndDlg,FID_MENU),&rcl);
frameHeight=frameHeight+(rcl.yTop-rcl.yBottom);

if (frameHeight>40) systemRuntimeData.bigFonts=1;
WinSetWindowPos(systemRuntimeData.hwndDlg,HWND_TOP,83, 26, xDelta+2,yDelta+frameHeight+8,SWP_SIZE );





 WinQueryTaskSizePos(systemRuntimeData.mainHAB,0,&mainWinPos);
  if (staticRuntimeSettings.detail)
    WinSendMsg (systemRuntimeData.hwndStatDlg,WM_COMMAND,MPFROM2SHORT(ID_CHANGE_SIZE,0),(MPARAM)NULL);  //we need both if not being small
  WinSendMsg (systemRuntimeData.hwndStatDlg,WM_COMMAND,MPFROM2SHORT(ID_CHANGE_SIZE,0),(MPARAM)NULL);
  WinSetWindowPos(systemRuntimeData.hwndDlg,HWND_TOP,mainWinPos.x, mainWinPos.y, 0,0,SWP_MOVE );
  WinShowWindow(systemRuntimeData.hwndDlg,TRUE);


  {
    WinQueryWindowProcess(systemRuntimeData.hwndDlg, &pid, &tid);
    memset(&Swctl,0,sizeof(Swctl));
    Swctl.hwnd = systemRuntimeData.hwndDlg;
    Swctl.idProcess = pid;
    Swctl.uchVisibility = SWL_VISIBLE;
    Swctl.fbJump = SWL_JUMPABLE;
    strcpy(Swctl.szSwtitle,Title);
    WinAddSwitchEntry(&Swctl);
    os2title(1,"Nix",0);
  }

    runtimeData.seconds=1;

  DosDupHandle(XPIPE_STDERROR, &hfSave);


  DosCreatePipe(&runtimeData.hpR, &runtimeData.hpW, 10);
  DosDupHandle(runtimeData.hpW, &hfNew);

  memset(&fAttr,0,sizeof(fAttr));
  fAttr.usRecordLength=sizeof(fAttr);
  fAttr.lMatch=1;
  strcpy(fAttr.szFacename,"Courier");
  fAttr.lMaxBaselineExt=8;
  WinSendMsg(WinWindowFromID(systemRuntimeData.hwndConDlg,ID_CON_MLE),MLM_SETFONT,MPFROMLONG(&fAttr),NULL);

  WinSendMsg(WinWindowFromID(systemRuntimeData.hwndConDlg,ID_CON_MLE),MLM_SETBACKCOLOR,MPFROMLONG(7),NULL);
  WinSendMsg(WinWindowFromID(systemRuntimeData.hwndConDlg,ID_CON_MLE),MLM_SETTEXTCOLOR,MPFROMLONG(0),NULL);

  WinSendMsg(WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_FROM_EF),EM_SETTEXTLIMIT,MPFROMSHORT(255),NULL);
  WinSendMsg(WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_STATUS_EF),EM_SETTEXTLIMIT,MPFROMSHORT(255),NULL);
  WinSendMsg(WinWindowFromID(systemRuntimeData.hwndStatDlg,ID_LOCAL_EF),EM_SETTEXTLIMIT,MPFROMSHORT(255),NULL);



  setWorkDir(runtimeSettings.workDir,NULL);


  startJob(staticExecSettings.wGetExePath,runtimeSettings.workDir,execArgs.cont);
  os2title(-1,"warum",0);

  while(WinGetMsg(systemRuntimeData.mainHAB,&qmsg,0L,0,0))
  {

    WinDispatchMsg(systemRuntimeData.mainHAB,&qmsg);
  }

  DosClose(runtimeData.hpW);  //bring the saved handde from stderror back
  DosDupHandle(hfSave,&hfNew);
  DosClose(hfSave);
  fclose(systemRuntimeData.logout);

  PrfWriteProfileData(retrieverIni,"Retriever","runtimeSettings",&staticRuntimeSettings,sizeof(staticRuntimeSettings));
  PrfWriteProfileData(retrieverIni,"Retriever","execSettings",&staticExecSettings,sizeof(staticExecSettings));


      kill(systemRuntimeData.wgetPid,SIGINT);
      DosKillProcess (DKP_PROCESS,systemRuntimeData.wgetPid);


  kill(systemRuntimeData.wgetPid,SIGINT);
  DosKillProcess (DKP_PROCESS, systemRuntimeData.wgetPid);
  DosKillProcess (DKP_PROCESSTREE, systemRuntimeData.wgetPid);
  DosKillThread(systemRuntimeData.analyzeTID);
  DosKillThread(systemRuntimeData.statUpdateTID);
  WinDestroyWindow(systemRuntimeData.hwndDlg);
  WinDestroyMsgQueue(hmq);
  WinTerminate(systemRuntimeData.mainHAB);
  if (retCode.rcError)
  {
    return 127;

    }
  else if (retCode.rcUsercancel && (!retCode.rcAllOk))
  {


    return 255;
    }
  else
  {

    return 0;
   }
}
