/*
 * REXX ReadMe for Auto WGet Daemon
 * Copyright (C) 1998-2005 Dmitry A.Steklenev
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR OR CONTRIBUTORS "AS IS"
 * AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * AUTHOR OR THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id$
 */

globals = "cfg. local. msg. sys. color. dir. jobs. job. plugins. ico."

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

country  = NlsCountryID()

if stream( "NLS\readme."country, "c", "query exists" ) == "" then
   country = "001"

"@start /F e.exe NLS\readme."country
exit 0

/*------------------------------------------------------------------
 * $Id$
 * Returns Country Identifier
 *------------------------------------------------------------------*/
NlsCountryID: procedure expose (globals)

  parse upper value VALUE( "LANG",, "OS2ENVIRONMENT" ) with lang "_" .

  select
    when lang == "RU" then country = "007" /* Use russian */
    when lang == "EN" then country = "001" /* Use english */
    when lang == "ES" then country = "034" /* Use spanish */
    when lang == "FR" then country = "033" /* Use french  */
    when lang == "SV" then country = "046" /* Use swedish */
    when lang == "DE" then country = "049" /* Use german  */
    when lang == "ZH" then country = "088" /* Use chinese */
    otherwise
       country = strip( SysIni( "BOTH", "PM_National", "iCountry" ),, '0'x )
  end

  if country == "ERROR:" then
     country =  "001"
  else
     country =  right( country, 3, "0" )


return country

