// ---------------------------------------------------------------------------
//  M88 - PC-88 Emulator
//  Copyright (C) cisc 1997, 1999.
// ---------------------------------------------------------------------------
//  $Id: winsound.cpp,v 1.18 1999/07/22 15:57:30 cisc Exp $

#include "headers.h"
#include "WinSound.h"
#include "misc.h"
#include "pc88/config.h"
#include "status.h"
#include "soundds.h"
#include "soundwo.h"

//#define LOGNAME "winsound"
#include "diag.h"

using namespace PC8801;
using namespace WinSoundDriver;
#ifdef __OS2__
inline int Limit(int v, int l, int s) { return v > l ? l : (v < s ? s : v); }
#endif

// ---------------------------------------------------------------------------
//  \z/
//
#ifdef __OS2__
WinSound::WinSound(const ID& id)
: Sound(id), driver(0)
{
    dumping = 0;
}
#else
WinSound::WinSound(const ID& id)
: Sound(id), driver(0), hmmio(0)
{
    dumping = 0;
}
#endif

WinSound::~WinSound()
{
    DumpEnd();
    Cleanup();
}

// ---------------------------------------------------------------------------
//  
//
bool WinSound::Init
(PC88* pc, HWND hwindow, uint rate, uint32 clock, uint buflen)
{
    currentrate = 100;
    currentbuflen = 0;
    hwnd = hwindow;

    if (!Sound::Init(pc, 8000, clock, 0))
        return false;
    return true;
}

// ---------------------------------------------------------------------------
//  ㏈
//
void WinSound::Cleanup()
{
    if (driver)
    {
        driver->Cleanup();
        delete driver;
        driver = 0;
    }
    Sound::Cleanup();
}

// ---------------------------------------------------------------------------
//  EĐ[gύX
//
bool WinSound::ChangeRate(uint rate, uint32 clock, uint buflen, bool waveout)
{
    if (currentrate != rate || currentbuflen != buflen || wodrv != waveout)
    {
        if (dumping)
        {
            statusdisplay.Show(70, 3000, "ݒ̕ύX͏o͒ɂ͂ł܂");
            return false;
        }

        bool resetdriver = true;
        if (currentrate + rate == 44100 + SOUND_55K && wodrv == waveout)
            resetdriver = false;

        samprate = rate;
        currentrate = rate;
        currentbuflen = buflen;
        wodrv = waveout;

        if (rate == SOUND_55K)
        {
            samprate = 44100;
        }
        else if (rate < 8000)
        {
            rate = 100; samprate = 0;
        }

        // DirectSound: TvO[g * obt@ / 2
        // waveOut:     TvO[g * obt@ * 2
        int bufsize;
        if (wodrv)
            bufsize = (samprate * buflen / 1000 * 1) & ~15;
        else
            bufsize = (samprate * buflen / 1000 / 2) & ~15;

        if (resetdriver)
        {
            if (driver)
            {
                driver->Cleanup();
                delete driver;
                driver = 0;
            }

            if (rate < 1000)
                bufsize = 0;
        }

        if (!SetRate(rate, clock, bufsize))
            return false;

        if (resetdriver && bufsize > 0)
        {
            if (wodrv)
                driver = new DriverWO;
            else
                driver = new DriverDS;

            if (!driver || !driver->Init(this, hwnd, samprate, 2, buflen))
            {
                statusdisplay.Show(70, 3000, "I[fBIfoCXgpł܂");
                delete driver; driver = 0;
                SetRate(rate, clock, 0);
            }
        }
    }
    return true;
}

// ---------------------------------------------------------------------------
//  ݒXV
//
void WinSound::ApplyConfig(const Config* config)
{
    static const uint srate[] = { 0, 11025, 22050, 44100, SOUND_55K, 48000 };

    bool wo = (config->flag2 & Config::usewaveoutdrv) != 0;
    ChangeRate(srate[Limit(config->sound, 5, 0)], config->opnclock, config->soundbuffer, wo);

    if (driver)
        driver->MixAlways(0 != (config->flags & Config::mixsoundalways));

    Sound::ApplyConfig(config);
}

// ---------------------------------------------------------------------------
//  _vJn
//
bool WinSound::DumpBegin(char* filename)
{
#ifdef __OS2__
    return false;
#else
    if (hmmio)
        return false;
    if (!driver)
    {
        statusdisplay.Show(70, 3000, "[hł PCM ̏o͍s܂");
        return false;
    }

    memset(&ckparent, 0, sizeof(MMCKINFO));
    memset(&ckdata, 0, sizeof(MMCKINFO));

    // mmioOpen
    hmmio = mmioOpen(filename, NULL, MMIO_CREATE | MMIO_WRITE | MMIO_ALLOCBUF);
    if (!hmmio)
        return false;

    // WAVE chunk
    ckparent.fccType = mmioFOURCC('W', 'A', 'V', 'E');
    if (mmioCreateChunk(hmmio, &ckparent, MMIO_CREATERIFF))
    {
        mmioClose(hmmio, 0);
        hmmio = 0;
        return false;
    }

    // fmt chunk
    MMCKINFO cksub;
    memset(&cksub, 0, sizeof(MMCKINFO));
    cksub.ckid = mmioFOURCC('f', 'm', 't', ' ');
    mmioCreateChunk(hmmio, &cksub, 0);

    WAVEFORMATEX format;
    format.wFormatTag = WAVE_FORMAT_PCM;
    format.nChannels = 2;
    format.nSamplesPerSec = samprate;
    format.wBitsPerSample = 16;
    format.nAvgBytesPerSec = format.nChannels * format.nSamplesPerSec * 2;
    format.nBlockAlign = format.nChannels * 2;
    format.cbSize = 0;

    mmioWrite(hmmio, HPSTR(&format), sizeof(format));
    mmioAscend(hmmio, &cksub, 0);

    // data chunk
    ckdata.ckid = mmioFOURCC('d', 'a', 't', 'a');
    mmioCreateChunk(hmmio, &ckdata, 0);

    FillWhenEmpty(false);
    dumping = 1;
    dumpedsample = 0;
    statusdisplay.Show(100, 0, "^ҋ@`");
    return true;
#endif
}

// ---------------------------------------------------------------------------
//  _vI
//
bool WinSound::DumpEnd()
{
#ifdef __OS2__
    return true;
#else
    if (dumping)
    {
        dumping = 0;
        CriticalSection::Lock lock(cs);

        if (ckdata.dwFlags & MMIO_DIRTY)
            mmioAscend(hmmio, &ckdata, 0);
        if (ckparent.dwFlags & MMIO_DIRTY)
            mmioAscend(hmmio, &ckparent, 0);
        if (hmmio)
            mmioClose(hmmio, 0), hmmio = 0;
        FillWhenEmpty(true);

        int curtime = dumpedsample / currentrate;
        statusdisplay.Show(100, 2500, "^` [%.2d:%.2d]", curtime/60, curtime%60);
    }
    return true;
#endif
}

// ---------------------------------------------------------------------------
//  ̏ꍇ
//
void WinSound::Mix(Sample* dest, int samples)
{
    Sound::Mix(dest, samples);
    if (dumping)
    {
        CriticalSection::Lock lock(cs);
        if (dumping)
        {
            if (dumping == 1)
            {
                int i;
                uint32* s = (uint32*) dest;
                for (i=0; i<samples && !*s; i++, s++)
                    ;
                dest += i*2;
                samples -= i;
                if (samples > 0)
                    dumping = 2;
            }

#ifdef __OS2__
#else
            if (samples)
            {
                mmioWrite(hmmio, (char*) dest, samples * sizeof(Sample) * 2);
                int prevtime = dumpedsample / currentrate;
                dumpedsample += samples;
                int curtime = dumpedsample / currentrate;
                if (prevtime != curtime)
                {
                    statusdisplay.Show(101, 0, "^` [%.2d:%.2d]", curtime/60, curtime%60);
                }
            }
#endif
        }
    }
}
