// ---------------------------------------------------------------------------
//  M88 - PC88 emulator
//  Copyright (C) cisc 1998.
// ---------------------------------------------------------------------------
//  ʊ֌W for Windows
// ---------------------------------------------------------------------------
//  $Id: windraw.cpp,v 1.14 1999/07/22 15:57:29 cisc Exp $

#include "headers.h"
#include "misc.h"
#include "CritSect.h"
#include "windraw.h"
#include "DrawGDI.h"
#include "DrawDDS.h"
#include "DrawDDW.h"
#include "messages.h"
#include "error.h"
#include "status.h"

#define LOGNAME "windraw"
#include "diag.h"

// ---------------------------------------------------------------------------
// \z/
//
#ifdef __OS2__
WinDraw::WinDraw()
{
    draw = 0;
    idthread = 0;
    hthread = -1;
    hevredraw = 0;
    drawcount = 0;
    guicount = 0;
    shouldterminate = false;
    drawall = false;
    drawing = false;
    palchanged = false;
    refresh = false;
    lock = 0;
    active = false;
}
#else
WinDraw::WinDraw()
{
    draw = 0;
    idthread = 0;
    hthread = 0;
    hevredraw = 0;
    drawcount = 0;
    guicount = 0;
    shouldterminate = false;
    drawall = false;
    drawing = false;
    palchanged = false;
    refresh = false;
    lock = 0;
    active = false;
}
#endif

WinDraw::~WinDraw()
{
    Cleanup();
}

// ---------------------------------------------------------------------------
//  
//
#ifdef __OS2__
bool WinDraw::Init0(HWND hwindow)
{
    hwnd = hwindow;
    draw = 0;
    drawtype = None;

    hthread = -1;
    DosCreateEventSem( "\\sem32\\windraw", &hevredraw, 0, FALSE );

    return true;
}
#else
bool WinDraw::Init0(HWND hwindow)
{
    hwnd = hwindow;
    draw = 0;
    drawtype = None;

    hthread = 0;
    hevredraw = CreateEvent(NULL, FALSE, FALSE, NULL);

    return true;
}
#endif

#ifdef __OS2__
bool WinDraw::Init(uint w, uint h, uint bpp)
{
    screenheight = h;
    shouldterminate = false;
    hthread = _beginthread( ThreadEntry, NULL, 4096*16, (void *)this );
    if (hthread == -1)
    {
        Error::SetError(Error::ThreadInitFailed);
        return false;
    }
    active = true;
    return true;
}
#else
bool WinDraw::Init(uint w, uint h, uint bpp)
{
#if 0
    draw = new WinDrawGDI;
    if (!draw || !draw->Init(hwnd))
    {
        Error::SetError(Error::ScreenInitFailed);
        return false;
    }
    drawtype = GDI;
    draw->Resize(width, screenheight);
#endif

    screenheight = h;
    shouldterminate = false;
    hthread = HANDLE(_beginthreadex(NULL, 0, ThreadEntry,
                           reinterpret_cast<LPVOID>(this), 0, &idthread));
    if (!hthread)
    {
        Error::SetError(Error::ThreadInitFailed);
        return false;
    }
    active = true;
    return true;
}
#endif

// ---------------------------------------------------------------------------
//  Еt
//
#ifdef __OS2__
bool WinDraw::Cleanup()
{
    if (hthread != -1) {
//        SetThreadPriority(hthread, THREAD_PRIORITY_NORMAL);

        int i = 100;
        do
        {
            shouldterminate = true;
            DosPostEventSem( hthread );
            DosSleep( 0 );
        } while (--i > 0);

        if (!i)
            DosKillThread( hthread );
        hthread = -1;
    }

    if (hevredraw)
        DosCloseEventSem(hevredraw), hevredraw = 0;

    delete draw;    draw = 0;
    return true;
}
#else
bool WinDraw::Cleanup()
{
    if (hthread)
    {
        SetThreadPriority(hthread, THREAD_PRIORITY_NORMAL);

        int i = 300;
        do
        {
            shouldterminate = true;
            SetEvent(hevredraw);
        } while (--i > 0 && WAIT_TIMEOUT == WaitForSingleObject(hthread, 10));

        if (!i)
            TerminateThread(hthread, 0);

        CloseHandle(hthread), hthread = 0;
    }
    if (hevredraw)
        CloseHandle(hevredraw), hevredraw = 0;

    delete draw;    draw = 0;
    return true;
}
#endif

// ---------------------------------------------------------------------------
//  ʕ`pXbh
//
#ifdef __OS2__
uint WinDraw::ThreadMain()
{
    ULONG ulPostCount;
    drawing = false;
    while (!shouldterminate)
    {
        PaintWindow();
        DosWaitEventSem( hevredraw, 100 );
        DosResetEventSem( hevredraw, &ulPostCount );
    }
    _endthread();
    return 0;
}
#else
uint WinDraw::ThreadMain()
{
    drawing = false;
    while (!shouldterminate)
    {
        PaintWindow();
        WaitForSingleObject(hevredraw, 100);
    }
    return 0;
}
#endif

#ifdef __OS2__
void WinDraw::ThreadEntry(void *arg)
{
    if (arg)
        ((WinDraw *)arg)->ThreadMain();
    else
        return;
}
#else
uint __stdcall WinDraw::ThreadEntry(LPVOID arg)
{
    if (arg)
        return static_cast<WinDraw*>(arg)->ThreadMain();
    else
        return 0;
}
#endif

// ---------------------------------------------------------------------------
//  Xbh̗D揇ʂ
//
#ifdef __OS2__
void WinDraw::SetPriorityLow(bool low)
{
//    if(hthread != -1) {
//        DosSetPriority( PRTYS_THREAD, low ? PRTYC_IDLETIME : PRTYC_REGULAR, 0, hthread );
//    }
}
#else
void WinDraw::SetPriorityLow(bool low)
{
    if (hthread)
    {
        SetThreadPriority(hthread,
            low ? THREAD_PRIORITY_BELOW_NORMAL : THREAD_PRIORITY_NORMAL);
    }
}
#endif

// ---------------------------------------------------------------------------
//  pbgf
//
#ifdef __OS2__
void WinDraw::QueryNewPalette(bool /*bkgnd*/)
{
//    CriticalSection::Lock lock(csdraw);
DosEnterCritSec();
    if (draw)
        draw->QueryNewPalette();
DosExitCritSec();
}
#else
void WinDraw::QueryNewPalette(bool /*bkgnd*/)
{
    CriticalSection::Lock lock(csdraw);
    if (draw)
        draw->QueryNewPalette();
}
#endif

// ---------------------------------------------------------------------------
//  yCg
//
#ifdef __OS2__
void WinDraw::RequestPaint()
{
//    CriticalSection::Lock lock(csdraw);
DosEnterCritSec();
    drawall = true;
    drawing = true;
DosExitCritSec();
    DosPostEventSem( hevredraw );
}
#else
void WinDraw::RequestPaint()
{
    CriticalSection::Lock lock(csdraw);
    drawall = true;
    drawing = true;
    SetEvent(hevredraw);
//  LOG1("Request at %d\n", GetTickCount());
}
#endif

// ---------------------------------------------------------------------------
//  XV
//
#ifdef __OS2__
void WinDraw::DrawScreen(const Region& region)
{
//   CriticalSection::Lock lock(csdraw); // add Sofiya
DosEnterCritSec();
   if (!drawing)
    {
        LOG2("Draw %d to %d\n", region.top, region.bottom);
        drawing = true;
        drawarea.xLeft = 0;
        drawarea.yTop = Max(0, region.top);
        drawarea.xRight = width-1;
        drawarea.yBottom = Min(screenheight - 1, region.bottom);
        DosPostEventSem( hevredraw );
    }
DosExitCritSec();
}
#else
void WinDraw::DrawScreen(const Region& region)
{
    if (!drawing)
    {
        LOG2("Draw %d to %d\n", region.top, region.bottom);
        drawing = true;
        drawarea.left = 0;
        drawarea.top = Max(0, region.top);
        drawarea.right = width-1;
        drawarea.bottom = Min(screenheight - 1, region.bottom);
        SetEvent(hevredraw);
    }
}
#endif

// ---------------------------------------------------------------------------
//  `悷
//
#ifdef __OS2__
void WinDraw::PaintWindow()
{
//    CriticalSection::Lock lock(csdraw);
DosEnterCritSec();
    if (drawing && draw && active)
    {
        RECTL rect;
        if (!drawall)
            rect = drawarea;
        else
        {
            drawall = false;
            rect.xLeft = 0;
            rect.yTop = 0;
            rect.xRight = width-1;
            rect.yBottom = screenheight-1;
        }
        if (palchanged)
        {
            palchanged = false;
            draw->SetPalette(palette + 0x40);
        }
        LOG4("\t\t\t(%3d,%3d)-(%3d,%3d)\n", rect.left, rect.top, rect.right, rect.bottom);
        draw->DrawScreen(rect.yTop, rect.yBottom, refresh);
        refresh = false;
        drawcount++;
        drawing = false;
    }
DosExitCritSec();
}
#else
void WinDraw::PaintWindow()
{
    CriticalSection::Lock lock(csdraw);
    if (drawing && draw && active)
    {
        RECT rect;
        if (!drawall)
            rect = drawarea;
        else
        {
            drawall = false;
            rect.left = 0;
            rect.top = 0;
            rect.right = width-1;
            rect.bottom = screenheight-1;
        }
        if (palchanged)
        {
            palchanged = false;
            draw->SetPalette(palette + 0x40);
        }
        LOG4("\t\t\t(%3d,%3d)-(%3d,%3d)\n", rect.left, rect.top, rect.right, rect.bottom);
        draw->DrawScreen(rect.top, rect.bottom, refresh);
        refresh = false;
        drawcount++;
        drawing = false;
    }
}
#endif

// ---------------------------------------------------------------------------
//  pbgZbg
//
void WinDraw::SetPalette(uint index, uint nents, const Palette* pal)
{
    memcpy(palette+index, pal, nents * sizeof(Palette));
    palchanged = true;
}

// ---------------------------------------------------------------------------
//  Lock
//
bool WinDraw::Lock(uint8** pimage, int* pbpl)
{
    if (!lock)
    {
        lock = new CriticalSection::Lock(csdraw);
        if (draw && draw->Lock(pimage, pbpl))
            return true;
        delete lock;
        lock = 0;
    }
    return false;
}

// ---------------------------------------------------------------------------
//  unlock
//
bool WinDraw::Unlock()
{
    bool result = false;
    if (lock)
    {
        if (draw)
            result = draw->Unlock();
        delete lock;
        lock = 0;
    }
    return false;
}

// ---------------------------------------------------------------------------
//  ʃTCYς
//
void WinDraw::Resize(uint width, uint height)
{
//  statusdisplay.Show(50, 2500, "Resize (%d, %d)", width, height);
    screenheight = height;
    draw->Resize(width, height);
}

// ---------------------------------------------------------------------------
//  ʕ`hCo̕ύX
//
bool WinDraw::ChangeDisplayDriver(DisplayType type, bool force480)
{
    if (type != drawtype)
    {
        // ʂ̕ۑ
        uint8* imcache = new uint8[640*400];
        if (!imcache)
            return false;
        SaveScreen(imcache);

        // ܂ł̃hCop
        if (draw)
            draw->SetGUIMode(true);
        {
            CriticalSection::Lock lock(csdraw);
            delete draw; draw = 0;
        }

        // VhCo̗p
        WinDrawSub* newdraw;
        switch (type)
        {
        case GDI: default:
            newdraw = new WinDrawGDI;
            break;
        case DDWin:
            newdraw = new WinDrawDDW;
            break;
        case DDFull:
            newdraw = new WinDrawDDS(force480);
            break;
        }

        bool result = true;

        if (!newdraw || !newdraw->Init(hwnd))
        {
            // Ɏsꍇ GDI hCoōĒ
            delete newdraw;
            newdraw = new WinDrawGDI, type = GDI;
            result = false;

            if (!newdraw || !newdraw->Init(hwnd))
                newdraw = 0, drawtype = None;
        }

        if (newdraw)
            newdraw->SetGUIMode(false);

        // VhCogp\ɂ
        {
            CriticalSection::Lock lock(csdraw);
            guicount = 0;
            draw = newdraw;
        }

        // ʂ𕜌
        drawall = true, palchanged = true, refresh = true;
        if (draw)
            draw->Resize(width, screenheight);
        LoadScreen(imcache);
        delete[] imcache;

        if (type == DDFull)     ShowCursor(false);
        if (drawtype == DDFull) ShowCursor(true);
        drawtype = type;

        return result;
    }
    return false;
}

// ---------------------------------------------------------------------------
//  ʂ̒g擾
//  dest    ۑA640x400 bytes
//
void WinDraw::SaveScreen(uint8 * dest)
{
    if (draw)
    {
        uint8* src;
        int bpl;
        if (draw->Lock(&src, &bpl))
        {
            for (int y=0; y<400; y++)
            {
                memcpy(dest, src, 640);
                dest+=640, src+=bpl;
            }
            draw->Unlock();
        }
    }
}

// ---------------------------------------------------------------------------
//  ʂ̒g
//  src     u摜  640x400 bytes
//
void WinDraw::LoadScreen(const uint8 * src)
{
    if (draw)
    {
        uint8* dest;
        int bpl;
        if (draw->Lock(&dest, &bpl))
        {
            for (int y=0; y<400; y++)
            {
                memcpy(dest, src, 640);
                src+=640, dest+=bpl;
            }
            draw->Unlock();
        }
    }
}

// ---------------------------------------------------------------------------
//  GUI gptOݒ
//
void WinDraw::SetGUIFlag(bool usegui)
{
    CriticalSection::Lock lock(csdraw);
    if (usegui)
    {
        if (!guicount++ && draw)
        {
            draw->SetGUIMode(true);
            ShowCursor(true);
        }
    }
    else
    {
        if (!--guicount && draw)
        {
            draw->SetGUIMode(false);
            ShowCursor(false);
        }
    }
}

// ---------------------------------------------------------------------------
//  ʂ 640x400x4  BMP ɕϊ
//  dest    ϊ BMP ̒uꏊAu邾̗̈悪KvB
//  ret     Iłǂ
//
bool WinDraw::CaptureScreen(uint8* dest)
{
#ifdef __OS2__
#else
    uint8* src = new uint8[640*400];
    if (!src) return false;

    SaveScreen(src);

    // \̂̏

    BITMAPFILEHEADER* filehdr = (BITMAPFILEHEADER*) dest;
    BITMAPINFO* binfo = (BITMAPINFO*) (filehdr+1);
    uint8* image = ((uint8*)(binfo+1)) + 15 * sizeof(RGBQUAD);

    // headers
    filehdr->bfType = 'MB';
    filehdr->bfSize = image + 640*400/2 - dest ;
    filehdr->bfReserved1 = 0;
    filehdr->bfReserved2 = 0;
    filehdr->bfOffBits = image - dest;
    binfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    binfo->bmiHeader.biWidth = 640;
    binfo->bmiHeader.biHeight = 400;
    binfo->bmiHeader.biPlanes = 1;
    binfo->bmiHeader.biBitCount = 4;
    binfo->bmiHeader.biCompression = BI_RGB;
    binfo->bmiHeader.biSizeImage = 0;
    binfo->bmiHeader.biXPelsPerMeter = 0;
    binfo->bmiHeader.biYPelsPerMeter = 0;
    binfo->bmiHeader.biClrImportant = 0;

    // PUFpbg̍쐬
    RGBQUAD* pal = binfo->bmiColors;
    memset(pal, 0, sizeof(RGBQUAD)*16);

    uint8 ctable[256];
    memset(ctable, 0, sizeof(ctable));

    int colors=0;
    for (int index=0; index<144; index++)
    {
        RGBQUAD rgb;
        rgb.rgbBlue  = palette[0x40+index].peBlue;
        rgb.rgbRed   = palette[0x40+index].peRed;
        rgb.rgbGreen = palette[0x40+index].peGreen;
//      LOG4("c[%.2x] = G:%.2x R:%.2x B:%.2x\n", index, rgb.rgbGreen, rgb.rgbRed, rgb.rgbBlue);
        uint32 entry = *((uint32*)&rgb);

        int k;
        for (k=0; k<colors; k++)
        {
            if (!((*((uint32*)&pal[k]) ^ entry) & 0xffffff))
                goto match;
        }
        if (colors<15)
        {
//          LOG4("pal[%.2x] = G:%.2x R:%.2x B:%.2x\n", colors, rgb.rgbGreen, rgb.rgbRed, rgb.rgbBlue);
            pal[colors++] = rgb;
        }
        else
            k=15;
match:
        ctable[64+index] = k;
    }
    binfo->bmiHeader.biClrUsed = colors;

    // Fϊ
    uint8* d = image;
    for (int y=0; y<400; y++)
    {
        uint8* s = src + 640 * (399-y);

        for (int x=0; x<320; x++, s+=2)
            *d++ = ctable[s[0]] * 16 + ctable[s[1]];
    }

    delete[] src;
#endif
    return true;
}

