// ---------------------------------------------------------------------------
//  M88 - PC-8801 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  User Interface for Win32
// ---------------------------------------------------------------------------
//  $Id: ui.cpp,v 1.28 1999/07/22 15:57:28 cisc Exp $

#include "headers.h"
#ifdef __OS2__
    #include <OS2ME.H>
    #include <mmioos2.h>
    #include <fourcc.h>
    #include <dive.h>
    #pragma library("MMPM2.LIB");
    extern HDIVE hDive;
    extern SETUP_BLITTER SetupBlitter;
    extern ULONG ulBufferNumber, ulBufferScanLineBytes, ulBufferScanLines;
    RECTL   rctls[4096];      /* ̈ɑ΂` */
#else
    #include <shellapi.h>
    #include <mbstring.h>
#endif
#include "resource.h"
#include "ui.h"
#include "about.h"
#include "misc.h"
#include "file.h"
#include "messages.h"
#include "error.h"
#include "88config.h"
#include "status.h"

#define LOGNAME "ui"
#include "diag.h"

extern char m88dir[_MAX_PATH];
extern char m88ini[_MAX_PATH];

using namespace PC8801;

#ifdef __OS2__
    static WinUI *my;

    #define WM_VRNDISABLED             0x007e
    #define WM_VRNENABLED              0x007f
    extern "C" BOOL APIENTRY WinSetVisibleRegionNotify( HWND hwnd, BOOL fEnable);
    extern "C" ULONG APIENTRY WinQueryVisibleRegion( HWND hwnd, HRGN hrgn);
#endif

#ifdef __OS2__
BOOL FileOpenDlg(HWND hwnd, CHAR *pszTitle, CHAR *szFileName)
{
    FILEDLG fild;
    HWND    hwndDlg;

    CHAR    szDrive[_MAX_DRIVE];
    CHAR    szDir[_MAX_DIR];

    /* \̂̏ */
    memset( &fild, 0, sizeof(FILEDLG) );
    fild.cbSize   = sizeof(FILEDLG);                /* \̂̃TCYݒ肷                             */
    fild.fl       =   FDS_CENTER                    /* ɕ\                                       */
                    | FDS_OPEN_DIALOG;              /* t@C̃I[v                                   */
    fild.pszTitle   = pszTitle;                     /* _CAO^Cgݒ                             */

    strcpy( fild.szFullFile, "*.D88" );

    szFileName[0] = '\0';
DosEnterCritSec();
    hwndDlg = WinFileDlg( HWND_DESKTOP, hwnd, &fild );
DosExitCritSec();
    if((hwndDlg != NULLHANDLE) && fild.lReturn == DID_OK)
    {
        strcpy( szFileName, fild.szFullFile );
        return TRUE;
    }
    return FALSE;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI
//  Ej
//
#ifdef __OS2__
WinUI::WinUI(VOID)
{
    my = this;
    timerid = 0;
    point.x = point.y = 0;
    displaychangedtime = GetTickCount();
    report = true;

    GetDLLAddress();

    diskinfo[0].hmenu = 0;
    diskinfo[0].filename[0] = 0;
    diskinfo[0].idchgdisk = IDM_CHANGEDISK_1;
    diskinfo[1].hmenu = 0;
    diskinfo[1].filename[0] = 0;
    diskinfo[1].idchgdisk = IDM_CHANGEDISK_2;
    capturemouse = true;
    resetwindowsize = 0;
}
#else
WinUI::WinUI(HINSTANCE hinstance)
: hinst(hinstance)
{
    winproc.SetDestination((void*)(WinProcGate), (void*) this);
    timerid = 0;
    point.x = point.y = 0;
//  resizewindow = 0;
    displaychangedtime = GetTickCount();
    report = true;

    GetDLLAddress();

    diskinfo[0].hmenu = 0;
    diskinfo[0].filename[0] = 0;
    diskinfo[0].idchgdisk = IDM_CHANGEDISK_1;
    diskinfo[1].hmenu = 0;
    diskinfo[1].filename[0] = 0;
    diskinfo[1].idchgdisk = IDM_CHANGEDISK_2;
    capturemouse = true;
    resetwindowsize = 0;
}
#endif

WinUI::~WinUI()
{
}

// ---------------------------------------------------------------------------
//  WinUI::InitM88
//  M88 ̏
//
#ifdef __OS2__
bool WinUI::InitM88(const char* cmdline)
{
    active = false;

    //  ݒ݂
    PC8801::LoadConfig(&config, m88ini, true);

    //  ݂ path ۑ
    char path[MAX_PATH];
    getcwd( path, MAX_PATH );

    //  foCX̏
    PC8801::LoadConfigDirectory(&config, m88ini, "BIOSPath");


    if (!keyif.Init(hwnd))
        return false;
    if (!core.Init(this, hwnd, &draw, &keyif))
        return false;
    diskmgr = core.GetPC88()->GetDiskManager();

    //  debug pNX
    opnmon.Init(core.GetPC88()->GetOPN1()->GetRegs());
    memmon.Init(core.GetPC88());
    codemon.Init(core.GetPC88());

    //  G~[VJn
    core.Wait(false);
    active = true;

    //  ݒ蔽f
//    SetCurrentDirectory(path); @@@
    ApplyCommandLine(cmdline);
    ApplyConfig();

    //  Zbg
    core.Reset();

    // ƂႲႵ
    if (!diskinfo[0].filename[0])
        PC8801::LoadConfigDirectory(&config, m88ini, "Directory");
    fullscreen = false;
    ChangeDisplayType(true);
    ResizeWindow(640, 400);

    return true;
}
#else
bool WinUI::InitM88(const char* cmdline)
{
    active = false;

    //  ݒ݂
    PC8801::LoadConfig(&config, m88ini, true);

    //  ݂ path ۑ
    char path[MAX_PATH];
    GetCurrentDirectory(MAX_PATH, path);

    //  foCX̏
    PC8801::LoadConfigDirectory(&config, m88ini, "BIOSPath");

    if (!keyif.Init(hwnd))
        return false;
    if (!core.Init(this, hwnd, &draw, &keyif))
        return false;
    diskmgr = core.GetPC88()->GetDiskManager();

    //  debug pNX
    opnmon.Init(core.GetPC88()->GetOPN1()->GetRegs());
    memmon.Init(core.GetPC88());
    codemon.Init(core.GetPC88());

    //  G~[VJn
    core.Wait(false);
    active = true;

    //  ݒ蔽f
    SetCurrentDirectory(path);
    ApplyCommandLine(cmdline);
    ApplyConfig();

    //  Zbg
    core.Reset();

    // ƂႲႵ
    if (!diskinfo[0].filename[0])
        PC8801::LoadConfigDirectory(&config, m88ini, "Directory");
    fullscreen = false;
    ChangeDisplayType(true);
    ResizeWindow(640, 400);

    return true;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::CleanupM88
//  M88 ̌Еt
//
void WinUI::CleanupM88()
{
    PC8801::Config cfg = config;
    PC8801::SaveConfig(&cfg, m88ini, true);
    core.Cleanup();
}

// ---------------------------------------------------------------------------
//  WinUI::InitWindow
//  M88 ̑쐬
//
#ifdef __OS2__
#define CLASSNAME "PC88"
bool WinUI::InitWindow()
{
    hab = WinInitialize( 0L );
    hmq = WinCreateMsgQueue( hab, 4096*1024 );
    if(hmq == 0) {
        return FALSE;
    }

    WinRegisterClass( hab, CLASSNAME, WinProcGate, CS_SIZEREDRAW, sizeof(WinUI *));

    ULONG flFrameFlags = FCF_TITLEBAR | FCF_SYSMENU | FCF_TASKLIST | FCF_MENU | FCF_ICON | FCF_MINMAX | FCF_SIZEBORDER;
    hwndFrame = WinCreateStdWindow(
                HWND_DESKTOP,
                0,
                &flFrameFlags,
                CLASSNAME,
                NULL,
                0L,
                0,
                IDR_MENU_M88,
                &hwndClient
    );

    hwnd = hwndClient;
    haspalette = true;
    WinSetWindowPtr( hwndClient, 0, this );
    WinSetWindowPos( hwndFrame, NULLHANDLE, 0, 0,
        640 + WinQuerySysValue( HWND_DESKTOP, SV_CXBORDER ) * 2 + 4 +1,
        400 + WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR) + WinQuerySysValue(HWND_DESKTOP, SV_CYMENU) + WinQuerySysValue( HWND_DESKTOP, SV_CYBORDER ) * 2  + 8, SWP_SIZE );
    if (!draw.Init0(hwnd))
        return false;

    return true;
}
#else
bool WinUI::InitWindow(int nwinmode)
{
    WNDCLASS wcl;
    const char* szwinname = "M88p2 WinUI";

    wcl.hInstance = hinst;
    wcl.lpszClassName = szwinname;
    wcl.lpfnWndProc = WNDPROC((void*)(winproc));
    wcl.style = 0;
    wcl.hIcon = LoadIcon(hinst, MAKEINTRESOURCE(IDI_ICON_M88));
    wcl.hCursor = LoadCursor(NULL, IDC_ARROW);
    wcl.cbClsExtra = 0;
    wcl.cbWndExtra = 0;
    wcl.hbrBackground = (HBRUSH) GetStockObject(BLACK_BRUSH);
//  wcl.hbrBackground = NULL;
    wcl.lpszMenuName = MAKEINTRESOURCE(IDR_MENU_M88);

    accel = LoadAccelerators(hinst, MAKEINTRESOURCE(IDR_ACC_M88UI));

    if (!RegisterClass(&wcl))
        return false;

    wstyle = WS_CAPTION | WS_OVERLAPPED | WS_SYSMENU | WS_MINIMIZEBOX;

    hwnd = CreateWindowEx(
        WS_EX_ACCEPTFILES,
        szwinname,
        "M88",
        wstyle,
        CW_USEDEFAULT,      // x
        CW_USEDEFAULT,      // y
        640,                // w
        400,                // h
        NULL,
        NULL,
        hinst,
        NULL
        );
//  ShowWindow(hwnd, nwinmode);

    HDC hdc = GetDC(hwnd);
    haspalette = !!(GetDeviceCaps(hdc, RASTERCAPS) & RC_PALETTE);
    ReleaseDC(hwnd, hdc);

    if (!draw.Init0(hwnd))
        return false;

    return true;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::Main
//  bZ[W[v
//
#ifdef __OS2__
int WinUI::Main(const char* cmdline)
{
    if (InitM88(cmdline))
    {
        statusdisplay.Init( hwnd );

        WinShowWindow( hwndFrame, TRUE );
//        UpdateWindow(hwnd);
        core.ActivateMouse(true);
        WinStartTimer(hab, hwndClient, 1, 1000);
        WinStartTimer(hab, hwndClient, 2, 100);
    }
    else
    {
        ReportError();
        WinSendMsg( hwnd, WM_CLOSE, 0, 0 );
    }

    QMSG qmsg;
    while(WinGetMsg( hab, &qmsg, NULLHANDLE, 0, 0))
    {
        WinDispatchMsg( hab, &qmsg  );
    }
    CleanupM88();
    statusdisplay.Cleanup();
//    return msg.wParam; @@@
    return 0;
}
#else
int WinUI::Main(const char* cmdline)
{
    if (InitM88(cmdline))
    {
        timerid = ::SetTimer(hwnd, 1, 1000, 0);
        ::SetTimer(hwnd, 2, 100, 0);
        statusdisplay.Init(hwnd);

        ShowWindow(hwnd, SW_SHOWDEFAULT);
        UpdateWindow(hwnd);
        core.ActivateMouse(true);
    }
    else
    {
        ReportError();
        PostQuitMessage(1);
    }

    MSG msg;
    while (GetMessage(&msg, NULL, 0, 0))
    {
        if (winconfig.ProcMsg(msg))
        {
            if (!winconfig.IsOpen())
                SetGUIFlag(false);
            continue;
        }

        if (!TranslateAccelerator(msg.hwnd, accel, &msg))
        {
            if ((msg.message == WM_SYSKEYDOWN || msg.message == WM_SYSKEYUP)
                && !(config.flags & Config::suppressmenu))
                TranslateMessage(&msg);
        }
        DispatchMessage(&msg);
    }

    CleanupM88();
    statusdisplay.Cleanup();
    return msg.wParam;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::WinProc
//  bZ[Wnh
//

#ifdef __OS2__
#define PROC_MSG(msg, func)     case (msg): ret = (MRESULT)((func)(hwnd, mp1, mp2)); break

MRESULT WinUI::WinProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    MRESULT ret;

    keyif.Disable(true);
//  LOG1("Msg: hwnd=%.8x\n", hwnd);
    switch (msg)
    {
        case WM_COMMAND:
            ret = (MRESULT)WmCommand(hwnd, msg, mp1, mp2);
            break;
        case WM_PAINT:
            WmPaint( hwnd, mp1, mp2 );
            ret = WinDefWindowProc(hwnd, msg, mp1, mp2);
            break;
    PROC_MSG(WM_CREATE,             WmCreate);
//    PROC_MSG(WM_DESTROY,            WmDestroy);
//    PROC_MSG(WM_CLOSE,              WmClose);
    PROC_MSG(WM_TIMER,              WmTimer);
    PROC_MSG(WM_ACTIVATE,           WmActivate);
//    PROC_MSG(WM_PALETTECHANGED,     WmPaletteChanged); @@@
//    PROC_MSG(WM_QUERYNEWPALETTE,    WmQueryNewPalette); @@@
//    PROC_MSG(WM_INITMENU,           WmInitMenu);

        case WM_VRNDISABLED:
DosEnterCritSec();
            if(hDive) DiveSetupBlitter( hDive, 0 );
            ret = 0;
DosExitCritSec();
            break;

        case WM_VRNENABLED:
DosEnterCritSec();
            {
                POINTL  pointl;
                SWP     swp;

                RGNRECT rgnCtl;         /* ̈搧\ */
                HRGN    hrgn;
                HPS     hps;

                hps = WinGetPS( hwnd );
                hrgn = GpiCreateRegion( hps, 0, NULL);
                WinQueryVisibleRegion( hwnd, hrgn);

                rgnCtl.ircStart = 0;    /* Jnʒu */
                rgnCtl.crc = 4096;        /* `̗ */
                rgnCtl.ulDirection = RECTDIR_LFRT_TOPBOT;

                /* ̈̂߂̋`擾܂        */
                GpiQueryRegionRects( hps, hrgn, NULL, &rgnCtl, rctls);

                WinQueryWindowPos( hwnd, &swp );

                /* fXNgbvɑ΂EChEʒũ}bvB */
                pointl.x = swp.x;
                pointl.y = swp.y;
                WinMapWindowPoints( WinQueryWindow( hwnd, QW_PARENT ),
                    HWND_DESKTOP, &pointl, 1);

                SetupBlitter.ulStructLen  = sizeof(SETUP_BLITTER);
                SetupBlitter.ulDitherType = 0;
                SetupBlitter.fInvert = FALSE;

                SetupBlitter.fccSrcColorFormat = FOURCC_LUT8;
                SetupBlitter.ulSrcWidth  = 640;
                SetupBlitter.ulSrcHeight = 400;
                SetupBlitter.ulSrcPosX   = 0;
                SetupBlitter.ulSrcPosY   = 0;

                SetupBlitter.fccDstColorFormat = FOURCC_SCRN;
                SetupBlitter.ulDstWidth  = swp.cx;
                SetupBlitter.ulDstHeight = swp.cy;
                SetupBlitter.lDstPosX   = 0;
                SetupBlitter.lDstPosY   = 0;
                SetupBlitter.lScreenPosX = pointl.x;
                SetupBlitter.lScreenPosY = pointl.y;

                SetupBlitter.ulNumDstRects = rgnCtl.crcReturned;
                SetupBlitter.pVisDstRects  = rctls;

                if(hDive) DiveSetupBlitter( hDive, &SetupBlitter );
                WinReleasePS( hps );
            }
            ret = 0;
DosExitCritSec();
            break;

    case WM_CHAR:
        if( CHARMSG(&msg)->fs & KC_KEYUP ) {
            int a = CHAR4FROMMP(mp1);
            keyif.KeyUp(0, a);
        }
        else
        {
            int a = CHAR4FROMMP(mp1);
            keyif.KeyDown(0, a);
        }
        ret = 0;
        break;

//    PROC_MSG(WM_SYSKEYDOWN,         WmSysKeyDown); @@@
    PROC_MSG(WM_SIZE,               WmSize);
//    PROC_MSG(WM_DRAWITEM,           WmDrawItem);
//    PROC_MSG(WM_ENTERMENULOOP,      WmEnterMenuLoop); @@@
//    PROC_MSG(WM_EXITMENULOOP,       WmExitMenuLoop); @@@
//    PROC_MSG(WM_DISPLAYCHANGE,      WmDisplayChange); @@@
//    PROC_MSG(WM_DROPFILES,          WmDropFiles); @@@
    PROC_MSG(WM_BUTTON1DOWN,        WmLButtonDown);
    PROC_MSG(WM_BUTTON1UP,          WmLButtonUp);
    PROC_MSG(WM_BUTTON2DOWN,        WmRButtonDown);
    PROC_MSG(WM_BUTTON2UP,          WmRButtonUp);
//    PROC_MSG(WM_ENTERSIZEMOVE,      WmEnterSizeMove); @@@
//    PROC_MSG(WM_EXITSIZEMOVE,       WmExitSizeMove); @@@
    PROC_MSG(WM_M88_SENDKEYSTATE,   M88SendKeyState);
    PROC_MSG(WM_M88_APPLYCONFIG,    M88ApplyConfig);
    PROC_MSG(WM_M88_CHANGEDISPLAY,  M88ChangeDisplay);
    PROC_MSG(WM_M88_CHANGEVOLUME,   M88ChangeVolume);

    default:
        ret = WinDefWindowProc(hwnd, msg, mp1, mp2);
    }
    keyif.Disable(false);
    return ret;
}

MRESULT EXPENTRY WinUI::WinProcGate(HWND hwnd, ULONG umsg, MPARAM wparam, MPARAM lparam)
{
//    WinUI *ui = (WinUI *)WinQueryWindowPtr( hwnd, 0 );
    return my->WinProc(hwnd, umsg, wparam, lparam);
}
#else
#define PROC_MSG(msg, func)     case (msg): ret = (func)(hwnd, wp, lp); break

LRESULT WinUI::WinProc(HWND hwnd, UINT umsg, WPARAM wp, LPARAM lp)
{
    uint ret;
    keyif.Disable(true);
//  LOG1("Msg: hwnd=%.8x\n", hwnd);
    switch (umsg)
    {
    PROC_MSG(WM_COMMAND,            WmCommand);
    PROC_MSG(WM_PAINT,              WmPaint);
    PROC_MSG(WM_CREATE,             WmCreate);
    PROC_MSG(WM_DESTROY,            WmDestroy);
    PROC_MSG(WM_CLOSE,              WmClose);
    PROC_MSG(WM_TIMER,              WmTimer);
    PROC_MSG(WM_ACTIVATE,           WmActivate);
    PROC_MSG(WM_PALETTECHANGED,     WmPaletteChanged);
    PROC_MSG(WM_QUERYNEWPALETTE,    WmQueryNewPalette);
    PROC_MSG(WM_INITMENU,           WmInitMenu);
    PROC_MSG(WM_KEYUP,              WmKeyUp);
    PROC_MSG(WM_KEYDOWN,            WmKeyDown);
    PROC_MSG(WM_SYSKEYUP,           WmSysKeyUp);
    PROC_MSG(WM_SYSKEYDOWN,         WmSysKeyDown);
    PROC_MSG(WM_SIZE,               WmSize);
    PROC_MSG(WM_DRAWITEM,           WmDrawItem);
    PROC_MSG(WM_ENTERMENULOOP,      WmEnterMenuLoop);
    PROC_MSG(WM_EXITMENULOOP,       WmExitMenuLoop);
    PROC_MSG(WM_DISPLAYCHANGE,      WmDisplayChange);
    PROC_MSG(WM_DROPFILES,          WmDropFiles);
    PROC_MSG(WM_LBUTTONDOWN,        WmLButtonDown);
    PROC_MSG(WM_LBUTTONUP,          WmLButtonUp);
    PROC_MSG(WM_RBUTTONDOWN,        WmRButtonDown);
    PROC_MSG(WM_RBUTTONUP,          WmRButtonUp);
    PROC_MSG(WM_ENTERSIZEMOVE,      WmEnterSizeMove);
    PROC_MSG(WM_EXITSIZEMOVE,       WmExitSizeMove);
    PROC_MSG(WM_M88_SENDKEYSTATE,   M88SendKeyState);
    PROC_MSG(WM_M88_APPLYCONFIG,    M88ApplyConfig);
    PROC_MSG(WM_M88_CHANGEDISPLAY,  M88ChangeDisplay);
    PROC_MSG(WM_M88_CHANGEVOLUME,   M88ChangeVolume);

    default:
        ret = DefWindowProc(hwnd, umsg, wp, lp);
    }
    keyif.Disable(false);
    return ret;
}

LRESULT _stdcall WinUI::WinProcGate(WinUI* ui, HWND hwnd, UINT umsg, WPARAM wparam, LPARAM lparam)
{
    return ui->WinProc(hwnd, umsg, wparam, lparam);
}
#endif
// ---------------------------------------------------------------------------
//  WinUI::M88SendKeyState
//
#ifdef __OS2__
inline uint WinUI::M88SendKeyState(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
//    GetKeyboardState(dest);
    WinSetKeyboardStateTable( HWND_DESKTOP, (char *)wparam, FALSE );
    return 0;
}
#else
inline uint WinUI::M88SendKeyState(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    uint8* dest = reinterpret_cast<uint8*> (wparam);
    GetKeyboardState(dest);
    SetEvent((HANDLE) lparam);
    return 0;
}
#endif

#ifdef __OS2__
#else
inline uint WinUI::WmKeyDown(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if ((uint) wparam == VK_F12 && !(config.flags & Config::disablef12reset))
        ;
    else
        keyif.KeyDown((uint) wparam, (uint32) lparam);

    return 0;
}
#endif

#ifdef __OS2__
#else
inline uint WinUI::WmKeyUp(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if ((uint) wparam == VK_F12 && !(config.flags & Config::disablef12reset))
        Reset();
    else
        keyif.KeyUp((uint) wparam, (uint32) lparam);

    return 0;
}
#endif

#ifdef __OS2__
#else
inline uint WinUI::WmSysKeyDown(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if (config.flags & Config::suppressmenu)
    {
        keyif.KeyDown((uint) wparam, (uint32) lparam);
        return 0;
    }
    return DefWindowProc(hwnd, WM_SYSKEYDOWN, wparam, lparam);
}
#endif


#ifdef __OS2__
#else
inline uint WinUI::WmSysKeyUp(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if (config.flags & Config::suppressmenu)
    {
        keyif.KeyUp((uint) wparam, (uint32) lparam);
        return 0;
    }
    return DefWindowProc(hwnd, WM_SYSKEYUP, wparam, lparam);
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::WmActive
//  WM_ACTIVATE nh
//
#ifdef __OS2__
uint WinUI::WmActivate(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    bool prevbg = background;
    background = (ULONG)wparam == FALSE;

    keyif.Activate(!background);
    draw.QueryNewPalette(background);
    if (prevbg != background)
        core.ActivateMouse(!background);
    return 0;
}
#else
uint WinUI::WmActivate(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    bool prevbg = background;
    background = LOWORD(wparam) == WA_INACTIVE;

    if (!HIWORD(wparam))
        draw.RequestPaint();

    keyif.Activate(!background);
    draw.QueryNewPalette(background);
    if (prevbg != background)
        core.ActivateMouse(!background);
    return 0;
}
#endif

// -------------------WmQueryNewPalette--------------------------------------------------------
//  WinUI::
//  WM_QUERYNEWPALETTE nh
//
uint WinUI::WmQueryNewPalette(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    draw.QueryNewPalette(background);
    return 1;
}

// ---------------------------------------------------------------------------
//  WinUI::WmPaletteChanged
//  WM_PALETTECHANGED nh
//
#ifdef __OS2__
uint WinUI::WmPaletteChanged(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    return 0;
}
#else
uint WinUI::WmPaletteChanged(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if ((HWND) wparam != hwnd)
    {
        draw.QueryNewPalette(background);
        return 1;
    }
    return 0;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::WmCommand
//  WM_COMMAND nh
//
#ifdef __OS2__
uint WinUI::WmCommand(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    ULONG a = COMMANDMSG(&msg)->cmd;
    switch(COMMANDMSG(&msg)->cmd) {
        case IDM_EXIT:
            WinPostMsg(hwnd, WM_CLOSE, 0, 0);
            break;

        case IDM_RESET:
            Reset();
            break;

        case IDM_N88V1:
            config.basicmode = Config::N88V1;
            Reset();
            break;

        case IDM_N88V1H:
            config.basicmode = Config::N88V1H;
            Reset();
            break;

        case IDM_N88V2:
            config.basicmode = Config::N88V2;
            Reset();
            break;

        case IDM_NMODE:
            config.basicmode = Config::N80;
            Reset();
            break;

        case IDM_DRIVE_1:
        case IDM_CHANGEIMAGE_1:
            ChangeDiskImage(hwnd, 0);
            break;

        case IDM_DRIVE_2:
        case IDM_CHANGEIMAGE_2:
            ChangeDiskImage(hwnd, 1);
            break;

        case IDM_BOTHDRIVE:
            diskmgr->Unmount(1);
            OpenDiskImage(1, 0, 0, 0, false);
            ChangeDiskImage(hwnd, 0);
            break;


        case IDM_ABOUTM88:
            SetGUIFlag(true);
            M88About().Show(hwnd);
            SetGUIFlag(false);
            break;

        case IDM_CONFIG:
            SetGUIFlag(true);
            winconfig.Show( hwnd, &config );
            SetGUIFlag(false);
            break;

        case IDM_TOGGLEDISPLAY:
            ToggleDisplayMode();
            break;

        case IDM_CAPTURE:
            CaptureScreen();
            break;

        case IDM_WATCHREGISTER:
            config.flags ^= PC8801::Config::watchregister;
            break;

        case IDM_STATUSBAR:
            config.flags ^= PC8801::Config::showstatusbar;
            ShowStatusWindow();
            break;

        case IDM_FDC_STATUS:
            config.flags ^= PC8801::Config::showfdcstatus;
            ApplyConfig();
            break;

        default:
            if (IDM_CHANGEDISK_1 <= a && a < IDM_CHANGEDISK_1 + 64)
            {
                SelectDisk(0, a - IDM_CHANGEDISK_1, false);
                break;
            } else if (IDM_CHANGEDISK_2 <= a && a < IDM_CHANGEDISK_2 + 64)
            {
                SelectDisk(1, a - IDM_CHANGEDISK_2, false);
                break;
            }
            break;
    }
    return 0;
}
#else
uint WinUI::WmCommand(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    uint wid = LOWORD(wparam);
    switch (wid)
    {
    case IDM_EXIT:
        PostMessage(hwnd, WM_CLOSE, 0, 0);
        break;

    case IDM_RESET:
        Reset();
        break;

    case IDM_N88V1:
        config.basicmode = Config::N88V1;
        Reset();
        break;

    case IDM_N88V1H:
        config.basicmode = Config::N88V1H;
        Reset();
        break;

    case IDM_N88V2:
        config.basicmode = Config::N88V2;
        Reset();
        break;

    case IDM_NMODE:
        config.basicmode = Config::N80;
        Reset();
        break;

    case IDM_N80MODE:
        config.basicmode = Config::N802;
        Reset();
        break;

    case IDM_DRIVE_1:
    case IDM_CHANGEIMAGE_1:
        ChangeDiskImage(hwnd, 0);
        break;

    case IDM_DRIVE_2:
    case IDM_CHANGEIMAGE_2:
        ChangeDiskImage(hwnd, 1);
        break;

    case IDM_BOTHDRIVE:
        diskmgr->Unmount(1);
        OpenDiskImage(1, 0, 0, 0, false);
        ChangeDiskImage(hwnd, 0);
        break;

    case IDM_ABOUTM88:
        SetGUIFlag(true);
        M88About().Show(hinst, hwnd);
        SetGUIFlag(false);
        break;

    case IDM_CONFIG:
//      ResizeWindow();
        SetGUIFlag(true);
        winconfig.Show(hinst, hwnd, &config);
        break;

    case IDM_TOGGLEDISPLAY:
        ToggleDisplayMode();
        break;

    case IDM_CAPTURE:
        CaptureScreen();
        break;

    case IDM_WATCHREGISTER:
//      config.flags ^= PC8801::Config::watchregister;
        config.flags ^= PC8801::Config::specialpalette;
        ApplyConfig();
        break;

    case IDM_STATUSBAR:
        config.flags ^= PC8801::Config::showstatusbar;
        ShowStatusWindow();
        break;

    case IDM_FDC_STATUS:
        config.flags ^= PC8801::Config::showfdcstatus;
        ApplyConfig();
        break;

    case IDM_SOUNDMON:
        opnmon.Show(hinst, hwnd, !opnmon.IsOpen());
        break;

    case IDM_MEMMON:
        memmon.Show(hinst, hwnd, !memmon.IsOpen());
        break;

    case IDM_CODEMON:
        codemon.Show(hinst, hwnd, !codemon.IsOpen());
        break;

    case IDM_RECORDPCM:
        if (!core.GetSound()->IsDumping())
        {
            core.GetSound()->DumpBegin("test.wav");
        }
        else
        {
            core.GetSound()->DumpEnd();
        }
        break;

    default:
        if (IDM_CHANGEDISK_1 <= wid && wid < IDM_CHANGEDISK_1 + 64)
        {
            SelectDisk(0, wid - IDM_CHANGEDISK_1, false);
            break;
        }
        if (IDM_CHANGEDISK_2 <= wid && wid < IDM_CHANGEDISK_2 + 64)
        {
            SelectDisk(1, wid - IDM_CHANGEDISK_2, false);
            break;
        }
        break;
    }
    return 0;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::WmPaint
//  WM_PAINT nh
//
#ifdef __OS2__
uint WinUI::WmPaint(HWND hwnd, WPARAM wp, LPARAM lp)
{
    draw.RequestPaint();
    return 0;
}
#else
uint WinUI::WmPaint(HWND hwnd, WPARAM wp, LPARAM lp)
{
    draw.RequestPaint();
    return DefWindowProc(hwnd, WM_PAINT, wp, lp);
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::WmCreate
//  WM_CREATE nh
//
#ifdef __OS2__
uint WinUI::WmCreate(HWND hwnd_, WPARAM wparam, LPARAM lparam)
{
//    CREATESTRUCT* cs = (CREATESTRUCT*) wparam;

    RECTL rect;
    rect.xLeft = 0;  rect.xRight =  640;
    rect.yTop  = 0;  rect.yBottom = 400;

//    AdjustWindowRect(&rect, wstyle, TRUE, 0);
//    SetWindowPos(hwndFrame, 0, 0, 0, rect.right-rect.left, rect.bottom-rect.top,
//                 SWP_NOMOVE | SWP_NOZORDER);

//    EnableIME(hwnd, false);
//    SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_ABOVE_NORMAL);

    WinQueryWindowRect(hwnd, &rect);
    point.x = rect.xLeft; point.y = rect.yTop;

//    LOG0("WmCreate\n");
    WinSetVisibleRegionNotify( hwnd_, TRUE );


    hwndMenu = WinWindowFromID( WinQueryWindow( hwnd_, QW_PARENT ), FID_MENU );

    MENUITEM mii;
    memset(&mii, 0, sizeof(mii));
    INT id = SHORT1FROMMR( WinSendMsg( hwndMenu, MM_ITEMIDFROMPOSITION, (MPARAM)1, 0 ) );
    WinSendMsg( hwndMenu, MM_QUERYITEM, MPFROM2SHORT( id, FALSE ), MPFROMP( &mii ) );
    HWND hwndSubMenu = mii.hwndSubMenu; // Disk Menu HWND

    id = SHORT1FROMMR( WinSendMsg( hwndSubMenu, MM_ITEMIDFROMPOSITION, (MPARAM)0, 0 ) );
    WinSendMsg( hwndSubMenu, MM_QUERYITEM, MPFROM2SHORT( id, FALSE ), MPFROMP( &mii ) );
    hwndDrive[0] = mii.hwndSubMenu;

    id = SHORT1FROMMR( WinSendMsg( hwndSubMenu, MM_ITEMIDFROMPOSITION, (MPARAM)1, 0 ) );
    WinSendMsg( hwndSubMenu, MM_QUERYITEM, MPFROM2SHORT( id, FALSE ), MPFROMP( &mii ) );
    hwndDrive[1] = mii.hwndSubMenu;

    return 0;
}
#else
uint WinUI::WmCreate(HWND hwnd_, WPARAM wparam, LPARAM lparam)
{
    CREATESTRUCT* cs = (CREATESTRUCT*) wparam;

    RECT rect;
    rect.left = 0;  rect.right =  640;
    rect.top  = 0;  rect.bottom = 400;

    AdjustWindowRectEx(&rect, wstyle, TRUE, 0);
    SetWindowPos(hwnd, 0, 0, 0, rect.right-rect.left, rect.bottom-rect.top,
                 SWP_NOMOVE | SWP_NOZORDER);

    EnableIME(hwnd, false);
    SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_ABOVE_NORMAL);

    GetWindowRect(hwnd, &rect);
    point.x = rect.left; point.y = rect.top;

    LOG0("WmCreate\n");

    return 0;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::WmDestroy
//  WM_DESTROY nh
//
#ifdef __OS2__
uint WinUI::WmDestroy(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    return 0;
}
#else
uint WinUI::WmDestroy(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    PostQuitMessage(0);
    return 0;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::WmClose
//  WM_CLOSE nh
//
#ifdef __OS2__
uint WinUI::WmClose(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    // mF
//    if (config.flags & Config::askbeforereset)
//    {
//        SetGUIFlag(true);
//        int res = MessageBox(hwnd, "M88 I܂", "M88", MB_ICONEXCLAMATION | MB_OKCANCEL | MB_DEFBUTTON2);
//        SetGUIFlag(false);
//        if (res != IDOK)
//            return 0;
//    }

    // 
    WinStopTimer(hab, hwndClient, 1);
    active = false;

    WinDestroyWindow( WinQueryWindow( hwnd, QW_PARENT ) );
    return 0;
}
#else
uint WinUI::WmClose(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    // mF
    if (config.flags & Config::askbeforereset)
    {
        SetGUIFlag(true);
        int res = MessageBox(hwnd, "M88 I܂", "M88", MB_ICONEXCLAMATION | MB_OKCANCEL | MB_DEFBUTTON2);
        SetGUIFlag(false);
        if (res != IDOK)
            return 0;
    }

    // 
    KillTimer(hwnd, timerid);
    timerid = 0;
    active = false;

    DestroyWindow(hwnd);
    return 0;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::WmTimer
//  WM_TIMER nh
//
#ifdef __OS2__
uint WinUI::WmTimer(HWND hwnd, WPARAM mp1, LPARAM lparam)
{
//    LOG2("WmTimer:%d(%d)\n", wparam, timerid);
    if (SHORT1FROMMP( mp1 ) == 1 )
    {
        // g,\t[擾
        int fcount = draw.GetDrawCount();
        int icount = core.GetExecCount();

        // |[gꍇ̓^Cgo[XV
        if (report)
        {
            if (active)
            {
                char buf[64];
                uint freq = icount / 10000;
                sprintf(buf, "M88 - %d fps.  %d.%.2d MHz", fcount, freq / 100, freq % 100);
                WinSetWindowText(hwndFrame, buf);
            }
            else
                WinSetWindowText(hwndFrame, "M88");
        }

        if (resetwindowsize > 0)
        {
            resetwindowsize--;
            ResizeWindow(640, 400);
        }
        return 0;
    }
    if (SHORT1FROMMP( mp1 ) == 2)
    {
//        KillTimer(hwnd, 2);
//        InvalidateRect(hwnd, 0, false);
        return 0;
    }
    if (SHORT1FROMMP( mp1 ) == 1)
    {
        statusdisplay.Update();
        return 0;
    }
    return 0;
}
#else
uint WinUI::WmTimer(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    LOG2("WmTimer:%d(%d)\n", wparam, timerid);
    if (wparam == timerid)
    {
        // g,\t[擾
        int fcount = draw.GetDrawCount();
        int icount = core.GetExecCount();

        // |[gꍇ̓^Cgo[XV
        if (report)
        {
            if (active)
            {
                char buf[64];
                uint freq = icount / 10000;
                wsprintf(buf, "M88 - %d fps.  %d.%.2d MHz",
                    fcount, freq / 100, freq % 100);
                SetWindowText(hwnd, buf);
            }
            else
                SetWindowText(hwnd, "M88");
        }

        if (resetwindowsize > 0)
        {
            resetwindowsize--;
            ResizeWindow(640, 400);
        }
        return 0;
    }
    if (wparam == 2)
    {
        KillTimer(hwnd, 2);
        InvalidateRect(hwnd, 0, false);
        return 0;
    }
    if (wparam == statusdisplay.GetTimerID())
    {
        statusdisplay.Update();
        return 0;
    }
    return 0;
}
#endif
// ---------------------------------------------------------------------------
//  WinUI::WmInitMenu
//  WM_INITMENU nh
//
#ifdef __OS2__
uint WinUI::WmInitMenu(HWND hwnd, WPARAM wp, LPARAM lp)
{
    return 0;
}
#else
uint WinUI::WmInitMenu(HWND hwnd, WPARAM wp, LPARAM lp)
{
    HMENU hmenu = (HMENU) wp;
#ifndef DEBUG_MONITOR
    EnableMenuItem(hmenu, IDM_LOGSTART, MF_GRAYED);
    EnableMenuItem(hmenu, IDM_LOGEND, MF_GRAYED);
#endif
    CheckMenuItem(hmenu, IDM_N88V1, (config.basicmode == Config::N88V1) ? MF_CHECKED : MF_UNCHECKED);
    CheckMenuItem(hmenu, IDM_N88V1H,(config.basicmode == Config::N88V1H)? MF_CHECKED : MF_UNCHECKED);
    CheckMenuItem(hmenu, IDM_N88V2, (config.basicmode == Config::N88V2) ? MF_CHECKED : MF_UNCHECKED);
    CheckMenuItem(hmenu, IDM_NMODE, (config.basicmode == Config::N80)   ? MF_CHECKED : MF_UNCHECKED);
    CheckMenuItem(hmenu, IDM_N80MODE, (config.basicmode == Config::N802)? MF_CHECKED : MF_UNCHECKED);

//  CheckMenuItem(hmenu, IDM_WATCHREGISTER, (config.flags & Config::watchregister) ? MF_CHECKED : MF_UNCHECKED);
    CheckMenuItem(hmenu, IDM_WATCHREGISTER, (config.flags & Config::specialpalette) ? MF_CHECKED : MF_UNCHECKED);
    EnableMenuItem(hmenu, IDM_WATCHREGISTER, config.dipsw != 1 ? MF_GRAYED : MF_ENABLED);
    CheckMenuItem(hmenu, IDM_STATUSBAR, (config.flags & Config::showstatusbar) ? MF_CHECKED : MF_UNCHECKED);
    EnableMenuItem(hmenu, IDM_STATUSBAR, fullscreen ? MF_GRAYED : MF_ENABLED);
    CheckMenuItem(hmenu, IDM_FDC_STATUS, (config.flags & Config::showfdcstatus) ? MF_CHECKED : MF_UNCHECKED);
    CheckMenuItem(hmenu, IDM_SOUNDMON, opnmon.IsOpen() ? MF_CHECKED : MF_UNCHECKED);
    CheckMenuItem(hmenu, IDM_MEMMON, memmon.IsOpen() ? MF_CHECKED : MF_UNCHECKED);
    CheckMenuItem(hmenu, IDM_CODEMON, codemon.IsOpen() ? MF_CHECKED : MF_UNCHECKED);
    CheckMenuItem(hmenu, IDM_RECORDPCM, core.GetSound()->IsDumping() ? MF_CHECKED : MF_UNCHECKED);

    return 0;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::WmSize
//  WM_SIZE
//
#ifdef __OS2__
uint WinUI::WmSize(HWND hwnd, WPARAM wp, LPARAM lp)
{
//    HWND hwndstatus = statusdisplay.GetHWnd();
//    if (hwndstatus)
//        PostMessage(hwndstatus, WM_SIZE, wp, lp);

//    active = wp != SIZE_MINIMIZED;
    draw.Activate( true );
    return (uint)WinDefWindowProc(hwnd, WM_SIZE, wp, lp);
}
#else
uint WinUI::WmSize(HWND hwnd, WPARAM wp, LPARAM lp)
{
    HWND hwndstatus = statusdisplay.GetHWnd();
    if (hwndstatus)
        PostMessage(hwndstatus, WM_SIZE, wp, lp);
    active = wp != SIZE_MINIMIZED;
    draw.Activate(active);
    return DefWindowProc(hwnd, WM_SIZE, wp, lp);
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::GetDLLAddress
//  IME ̂߂ API AhX擾
//
#ifdef __OS2__
void WinUI::GetDLLAddress()
{
    penableime = 0;
}
#else
void WinUI::GetDLLAddress()
{
    HMODULE hmod = ::GetModuleHandle("user32.dll");

    penableime = 0;
    if (hmod)
    {
        penableime = PENABLEIME(::GetProcAddress(hmod, "WINNLSEnableIME"));
    }
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::EnableIME
//  IME ̐
//
#ifdef __OS2__
#else
bool WinUI::EnableIME(HWND hwnd, BOOL flag)
{
    if (penableime)
    {
        return !!(*penableime)(hwnd, flag);
    }
    return false;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::ReportError
//  G[\
//
#ifdef __OS2__
void WinUI::ReportError()
{
    const char* errtext = Error::GetErrorText();
    if (errtext)
    {
        WinMessageBox( HWND_DESKTOP, hwnd, errtext, "M88", 0, MB_ERROR | MB_OK);
    }
}
#else
void WinUI::ReportError()
{
    const char* errtext = Error::GetErrorText();
    if (errtext)
    {
        ::MessageBox(hwnd, errtext, "M88", MB_ICONERROR | MB_OK);
    }
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::ReportError
//
uint WinUI::M88ApplyConfig(HWND, WPARAM newconfig, LPARAM)
{
    if (newconfig)
    {
        // \łȁB
        if (memcmp(&config, (PC8801::Config*)newconfig, sizeof(PC8801::Config)))
        {
            config = *((PC8801::Config*)newconfig);
            ApplyConfig();
        }
    }
    return 0;
}

// ---------------------------------------------------------------------------
//  WinUI::ApplyConfig
//
#ifdef __OS2__
void WinUI::ApplyConfig()
{
    config.mainsubratio =
        (config.clock >= 60 || (config.flags & Config::fullspeed)) ? 2 : 1;

    core.ApplyConfig(&config);
    keyif.ApplyConfig(&config);
    draw.SetPriorityLow((config.flags & Config::drawprioritylow) != 0);
//    ShowStatusWindow();
}
#else
void WinUI::ApplyConfig()
{
    config.mainsubratio =
        (config.clock >= 60 || (config.flags & Config::fullspeed)) ? 2 : 1;

    core.ApplyConfig(&config);
    keyif.ApplyConfig(&config);
    draw.SetPriorityLow((config.flags & Config::drawprioritylow) != 0);
//  ChangeDisplayType();

    MENUITEMINFO mii;
    memset(&mii, 0, sizeof(mii));
    mii.cbSize = sizeof(mii);
    mii.fMask = MIIM_TYPE;
    mii.fType = MFT_STRING;
    mii.dwTypeData = (config.flags & Config::disablef12reset) ? "&Reset" : "&Reset\tF12";
    SetMenuItemInfo(GetMenu(hwnd), IDM_RESET, false, &mii);
    ShowStatusWindow();
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::Reset
//
#ifdef __OS2__
void WinUI::Reset()
{
    if (config.flags & Config::askbeforereset)
    {
        SetGUIFlag(true);
//        int res = MessageBox(hwnd, "Zbg܂H", "M88", MB_ICONQUESTION | MB_OKCANCEL | MB_DEFBUTTON2);
        SetGUIFlag(false);
//        if (res != IDOK)
//            return;
    }
    keyif.ApplyConfig(&config);
    core.ApplyConfig(&config);
    core.Reset();
}
#else
void WinUI::Reset()
{
    if (config.flags & Config::askbeforereset)
    {
        SetGUIFlag(true);
        int res = MessageBox(hwnd, "Zbg܂H", "M88", MB_ICONQUESTION | MB_OKCANCEL | MB_DEFBUTTON2);
        SetGUIFlag(false);
        if (res != IDOK)
            return;
    }
    keyif.ApplyConfig(&config);
    core.ApplyConfig(&config);
    core.Reset();
}
#endif

// ---------------------------------------------------------------------------
//  ChangeDiskImage
//  fBXNւ
//
#ifdef __OS2__
void WinUI::ChangeDiskImage(HWND hwnd, int drive)
{
    SetGUIFlag(true);
    if (!diskmgr->Unmount(drive))
    {
//        MessageBox(hwnd,
//            "DiskManger::Unmount failed\nfBXN̎OɎs܂.",
//            "M88",
//            MB_ICONERROR | MB_OK);
    }

    char filename[MAX_PATH];
    filename[0] = 0;
    bool isopen = FileOpenDlg( hwnd, "Open disk image", filename );
    if (isopen)
    {
        // t@C݂?
        bool createnew = false;
        if (!diskmgr->IsImageOpen(filename) &&
            !FileIO().Open(filename, FileIO::readonly))
        {
            createnew = true;
            if (!newdisk.Show( hwnd ))
                return;
        }

        OpenDiskImage(drive, filename, 0,                        0, createnew);
//        OpenDiskImage(drive, filename, ofn.Flags & OFN_READONLY, 0, createnew); @@@

        if (createnew && diskmgr->GetNumDisks(drive) == 0)
        {
            diskmgr->AddDisk(drive, newdisk.GetTitle(), newdisk.GetType());
            OpenDiskImage(drive, filename, 0, 0, false);
            if (newdisk.DoFormat())
                diskmgr->FormatDisk(drive);
        }
        if (drive == 0 && !diskinfo[1].filename[0] && diskmgr->GetNumDisks(0) > 1)
        {
            OpenDiskImage(1, filename, 0,                        1, false);
//            OpenDiskImage(1, filename, ofn.Flags & OFN_READONLY, 1, false); @@@
        }
    }
    else
        OpenDiskImage(drive, 0, 0, 0, false);

    SetGUIFlag(false);
}
#else
void WinUI::ChangeDiskImage(HWND hwnd, int drive)
{
    HANDLE hthread = GetCurrentThread();
    int prev = GetThreadPriority(hthread);
    SetThreadPriority(hthread, THREAD_PRIORITY_ABOVE_NORMAL);

    SetGUIFlag(true);

    if (!diskmgr->Unmount(drive))
    {
        MessageBox(hwnd,
            "DiskManger::Unmount failed\nfBXN̎OɎs܂.",
            "M88",
            MB_ICONERROR | MB_OK);
    }

    OPENFILENAME ofn;
    memset(&ofn, 0, sizeof(ofn));
    char filename[MAX_PATH];
    filename[0] = 0;
    ofn.lStructSize = sizeof(ofn);
    ofn.hwndOwner = hwnd;
    ofn.lpstrFilter = "8801 disk image (*.d88)\0*.d88\0"
                      "All Files (*.*)\0*.*\0";
    ofn.lpstrFile = filename;
    ofn.nMaxFile = MAX_PATH;
    ofn.Flags = OFN_CREATEPROMPT | OFN_SHAREAWARE;
    ofn.lpstrDefExt = "d88";
    ofn.lpstrTitle = "Open disk image";

    EnableIME(hwnd, true);
    bool isopen = !!GetOpenFileName(&ofn);
    EnableIME(hwnd, false);

    if (isopen)
    {
        // t@C݂?
        bool createnew = false;
        if (!diskmgr->IsImageOpen(filename) &&
            !FileIO().Open(filename, FileIO::readonly))
        {
            createnew = true;
            if (!newdisk.Show(hinst, hwnd))
                return;
        }

        OpenDiskImage(drive, filename, ofn.Flags & OFN_READONLY, 0, createnew);

        if (createnew && diskmgr->GetNumDisks(drive) == 0)
        {
            diskmgr->AddDisk(drive, newdisk.GetTitle(), newdisk.GetType());
            OpenDiskImage(drive, filename, 0, 0, false);
            if (newdisk.DoFormat())
                diskmgr->FormatDisk(drive);
        }
        if (drive == 0 && !diskinfo[1].filename[0] && diskmgr->GetNumDisks(0) > 1)
        {
            OpenDiskImage(1, filename, ofn.Flags & OFN_READONLY, 1, false);
        }
    }
    else
        OpenDiskImage(drive, 0, 0, 0, false);

    SetGUIFlag(false);
    SetThreadPriority(hthread, prev);
}
#endif

// ---------------------------------------------------------------------------
//  KɃfBXNC[WJ
//
void WinUI::OpenDiskImage(const char* path)
{
    // fBXNC[W}Eg
    OpenDiskImage(0, path, 0, 0, false);
    if (diskmgr->GetNumDisks(0) > 1)
    {
        OpenDiskImage(1, path, 0, 1, false);
    }
    else
    {
        diskmgr->Unmount(1);
        OpenDiskImage(1, 0, 0, 0, false);
    }
}

// ---------------------------------------------------------------------------
//  OpenDiskImage
//  fBXNC[WJ
//
#ifdef __OS2__
bool WinUI::OpenDiskImage
(int drive, const char* name, bool readonly, int id, bool create)
{
    // t@Cl[̕o
    char title[MAX_PATH] = "";
    if (name)
    {
      char* ptr = strrchr(name, '\\');
      strcpy(title, ptr ? ptr+1 : name);
      ptr = strchr(title, '.');
      if (ptr)
          *ptr = 0;
    }
    char buf[MAX_PATH + 16];

    diskinfo[drive].hmenu = hwndDrive[drive];
    DiskInfo& dinfo = diskinfo[drive];

    bool result = false;
    if (name)
    {
        strcpy(dinfo.filename, name);
        result = diskmgr->Mount(drive, dinfo.filename, readonly, id, create);
        dinfo.readonly = readonly;
        dinfo.currentdisk = diskmgr->GetCurrentDisk(0);
    }
    if (!result)
        dinfo.filename[0] = 0;

    CreateDiskMenu(drive);

    MENUITEM mi;
    mi.iPosition   = 0;
    mi.afStyle     = MIS_TEXT;
    mi.afAttribute = 0;
    mi.id          = drive ? IDM_DRIVE_2 : IDM_DRIVE_1;
    mi.hwndSubMenu = 0;
    mi.hItem       = 0;

    if (!result)
    {
        sprintf(buf, "Drive ~%d...", drive+1);
        mi.hwndSubMenu = 0;
    }
    else
    {
        sprintf(buf, "Drive ~%d - %s", drive+1, title);
        mi.hwndSubMenu = dinfo.hmenu;
        SelectDisk(drive, dinfo.currentdisk, true);
    }
//    SetMenuItemInfo(GetMenu(hwnd), drive ? IDM_DRIVE_2 : IDM_DRIVE_1, false, &mii);

    WinSendMsg( hwndMenu, MM_SETITEMTEXT, MPFROM2SHORT( drive ? IDM_DRIVE_2 : IDM_DRIVE_1, 0 ), MPFROMP( buf ) );
    return true;
}
#else
bool WinUI::OpenDiskImage
(int drive, const char* name, bool readonly, int id, bool create)
{
    // t@Cl[̕o
    char title[MAX_PATH] = "";
    if (name)
    {
        uchar* ptr;
        ptr = _mbsrchr((uchar*) name, '\\');
        _mbscpy((uchar*) title,  ptr ? ptr+1 : (uchar*)(name));
        ptr = _mbschr((uchar*) title, '.');
        if (ptr)
            *ptr = 0;
//      char* ptr = strrchr(name, '\\');
//      strcpy(title, ptr ? ptr+1 : name);
//      ptr = strchr(title, '.');
//      if (ptr)
//          *ptr = 0;
    }

    char buf[MAX_PATH + 16];
    MENUITEMINFO mii;
    memset(&mii, 0, sizeof(mii));
    mii.cbSize = sizeof(mii);
    mii.fMask = MIIM_SUBMENU;
    mii.fType = MFT_STRING;
    mii.dwTypeData = buf;
    mii.hSubMenu = 0;
    SetMenuItemInfo(GetMenu(hwnd), drive ? IDM_DRIVE_2 : IDM_DRIVE_1, false, &mii);

    mii.fMask = MIIM_TYPE | MIIM_SUBMENU;

    DiskInfo& dinfo = diskinfo[drive];

    bool result = false;
    if (name)
    {
        strcpy(dinfo.filename, name);
        result = diskmgr->Mount(drive, dinfo.filename, readonly, id, create);
        dinfo.readonly = readonly;
        dinfo.currentdisk = diskmgr->GetCurrentDisk(0);
    }
    if (!result)
        dinfo.filename[0] = 0;

    CreateDiskMenu(drive);

    if (!result)
    {
        wsprintf(buf, "Drive &%d...", drive+1);
        mii.hSubMenu = 0;
    }
    else
    {
        wsprintf(buf, "Drive &%d - %s", drive+1, title);
        mii.hSubMenu = dinfo.hmenu;
        SelectDisk(drive, dinfo.currentdisk, true);
    }
    SetMenuItemInfo(GetMenu(hwnd), drive ? IDM_DRIVE_2 : IDM_DRIVE_1, false, &mii);
    return true;
}
#endif

// ---------------------------------------------------------------------------
//  SelectDisk
//  fBXNZbg
//
#ifdef __OS2__
bool WinUI::SelectDisk(uint drive, int id, bool menuonly)
{
    diskinfo[drive].hmenu = hwndDrive[drive];
    DiskInfo& dinfo = diskinfo[drive];
    if (drive >= 2 || id >= 64)
        return false;

//    CheckMenuItem(dinfo.hmenu,
//        dinfo.idchgdisk+(dinfo.currentdisk < 0 ? 63 : dinfo.currentdisk),
//        MF_BYCOMMAND | MF_UNCHECKED);
    WinSendMsg( hwndMenu, MM_SETITEMATTR,
        MPFROM2SHORT( dinfo.idchgdisk+(dinfo.currentdisk < 0 ? 63 : dinfo.currentdisk), TRUE ),
        MPFROM2SHORT( MIA_CHECKED, 0 ) );

    bool result = true;
    if (!menuonly)
        result = diskmgr->Mount(drive, dinfo.filename, dinfo.readonly, id, false);

    int current = result ? diskmgr->GetCurrentDisk(drive) : -1;

//    CheckMenuItem(dinfo.hmenu,
//                  dinfo.idchgdisk+(current < 0 ? 63 : current),
//                  MF_BYCOMMAND | MF_CHECKED);
    WinSendMsg( hwndMenu, MM_SETITEMATTR,
        MPFROM2SHORT( dinfo.idchgdisk+(current < 0 ? 63 : current), TRUE ),
        MPFROM2SHORT( MIA_CHECKED, MIA_CHECKED ) );

    dinfo.currentdisk = current;
    return true;
}
#else
bool WinUI::SelectDisk(uint drive, int id, bool menuonly)
{
    DiskInfo& dinfo = diskinfo[drive];
    if (drive >= 2 || id >= 64)
        return false;

    CheckMenuItem(dinfo.hmenu,
        dinfo.idchgdisk+(dinfo.currentdisk < 0 ? 63 : dinfo.currentdisk),
        MF_BYCOMMAND | MF_UNCHECKED);

    bool result = true;
    if (!menuonly)
        result = diskmgr->Mount(drive, dinfo.filename, dinfo.readonly, id, false);

    int current = result ? diskmgr->GetCurrentDisk(drive) : -1;

    CheckMenuItem(dinfo.hmenu,
                  dinfo.idchgdisk+(current < 0 ? 63 : current),
                  MF_BYCOMMAND | MF_CHECKED);
    dinfo.currentdisk = current;
    return true;
}
#endif

// ---------------------------------------------------------------------------
//  CreateDiskMenu
//  }`fBXNC[Wpj[̍쐬
//
#ifdef __OS2__
bool WinUI::CreateDiskMenu(uint drive)
{
    MENUITEM mi;
    diskinfo[drive].hmenu = hwndDrive[drive];
    DiskInfo& dinfo = diskinfo[drive];
    if (dinfo.hmenu)
    {
        //e


    }
    dinfo.currentdisk = -1;

    // j[쐬
//    dinfo.hmenu = CreatePopupMenu();
//    if (!dinfo.hmenu)
//        return false;

    int ndrs = diskmgr->GetNumDisks(drive);
    for (int i=0; i<63; i++)
    {
        char buf[32];
        const char* title = diskmgr->GetImageTitle(drive, i);

        if (!title) break;
        if (!title[0]) title = "(untitled)";

        if (i < 9)
            sprintf(buf, "&%d %.16s", i+1, title);
        else
            sprintf(buf, "%d %.16s", i+1, title);

//        AppendMenu( dinfo.hmenu,
//                    MF_STRING,
//                    dinfo.idchgdisk + i,
//                    buf );
        mi.iPosition   = MIT_END;
        mi.afStyle     = MIS_TEXT;
        mi.afAttribute = 0;
        mi.id          = dinfo.idchgdisk + i;
        mi.hwndSubMenu = 0;
        mi.hItem       = 0;
        WinSendMsg( dinfo.hmenu, MM_INSERTITEM, MPFROMP( &mi ), MPFROMP( buf ) );
        WinSendMsg( dinfo.hmenu, MM_SETITEMATTR, MPFROM2SHORT( dinfo.idchgdisk + i, TRUE ), MPFROM2SHORT( MIA_DISABLED, 0  ) );
    }

//    AppendMenu(dinfo.hmenu, MF_SEPARATOR, 0, 0);
    mi.iPosition   = MIT_END;
    mi.afStyle     = MIS_SEPARATOR;
    mi.afAttribute = 0;
    mi.id          = 0;
    mi.hwndSubMenu = 0;
    mi.hItem       = 0;
    WinSendMsg( dinfo.hmenu, MM_INSERTITEM, MPFROMP( &mi ), MPFROMP( "" ) );

//    AppendMenu(dinfo.hmenu, MF_STRING, dinfo.idchgdisk + 63, "&N No disk");
    mi.iPosition   = MIT_END;
    mi.afStyle     = MIS_TEXT;
    mi.afAttribute = 0;
    mi.id          = dinfo.idchgdisk + 63;
    mi.hwndSubMenu = 0;
    mi.hItem       = 0;
    WinSendMsg( dinfo.hmenu, MM_INSERTITEM, MPFROMP( &mi ), MPFROMP( "~N No disk" ) );

//    AppendMenu(dinfo.hmenu, MF_STRING, dinfo.idchgdisk + 64, "&0 Change disk");
    mi.iPosition   = MIT_END;
    mi.afStyle     = MIS_TEXT;
    mi.afAttribute = 0;
    mi.id          = dinfo.idchgdisk + 64;
    mi.hwndSubMenu = 0;
    mi.hItem       = 0;
    WinSendMsg( dinfo.hmenu, MM_INSERTITEM, MPFROMP( &mi ), MPFROMP( "~0 Change disk" ) );

//    SetMenuDefaultItem(dinfo.hmenu, dinfo.idchgdisk + 64, FALSE );
    return true;
}
#else
bool WinUI::CreateDiskMenu(uint drive)
{
    DiskInfo& dinfo = diskinfo[drive];
    if (dinfo.hmenu)
    {
        DestroyMenu(dinfo.hmenu);
        dinfo.hmenu = 0;
    }
    dinfo.currentdisk = -1;

    // j[쐬
    dinfo.hmenu = CreatePopupMenu();
    if (!dinfo.hmenu)
        return false;

    int ndrs = diskmgr->GetNumDisks(drive);
    for (int i=0; i<63; i++)
    {
        char buf[32];
        const char* title = diskmgr->GetImageTitle(drive, i);

        if (!title) break;
        if (!title[0]) title = "(untitled)";

        if (i < 9)
            wsprintf(buf, "&%d %.16s", i+1, title);
        else
            wsprintf(buf, "%d %.16s", i+1, title);

        AppendMenu( dinfo.hmenu,
                    MF_STRING,
                    dinfo.idchgdisk + i,
                    buf );
    }

    AppendMenu(dinfo.hmenu, MF_SEPARATOR, 0, 0);
    AppendMenu(dinfo.hmenu, MF_STRING, dinfo.idchgdisk + 63, "&N No disk");
    AppendMenu(dinfo.hmenu, MF_STRING, dinfo.idchgdisk + 64, "&0 Change disk");
    SetMenuDefaultItem(dinfo.hmenu, dinfo.idchgdisk + 64, FALSE );

    return true;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::ResizeWindow
//  EBhȆ傫ς
//
#ifdef __OS2__
void WinUI::ResizeWindow(uint width, uint height)
{
}
#else
void WinUI::ResizeWindow(uint width, uint height)
{
    RECT rect;
    rect.left = 0;  rect.right = width;
    rect.top  = 0;  rect.bottom = height + statusdisplay.GetHeight();

    AdjustWindowRectEx(&rect, wstyle, TRUE, 0);
    SetWindowPos(hwnd, 0, 0, 0, rect.right-rect.left, rect.bottom-rect.top,
                 SWP_NOMOVE | SWP_NOZORDER);
    PostMessage(hwnd, WM_SIZE, SIZE_RESTORED, MAKELONG(width, height));
}
#endif

// ---------------------------------------------------------------------------
//  Xe[^Xo[\؂ւ
//
#ifdef __OS2__
void WinUI::ShowStatusWindow()
{
    if (!fullscreen)
    {
        if (config.flags & PC8801::Config::showstatusbar)
            statusdisplay.Enable((config.flags & PC8801::Config::showfdcstatus) != 0);
        else
            statusdisplay.Disable();
//        ResizeWindow(640, 400);
    }
}
#else
void WinUI::ShowStatusWindow()
{
    if (!fullscreen)
    {
        if (config.flags & PC8801::Config::showstatusbar)
            statusdisplay.Enable((config.flags & PC8801::Config::showfdcstatus) != 0);
        else
            statusdisplay.Disable();
        ResizeWindow(640, 400);
    }
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::WmDrawItem
//  WM_DRAWITEM nh
//
#ifdef __OS2__
uint WinUI::WmDrawItem(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    return TRUE;
}
#else
uint WinUI::WmDrawItem(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if ((UINT) wparam == 1)
        statusdisplay.DrawItem((DRAWITEMSTRUCT*)lparam);
    return TRUE;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::ToggleDisplayMode
//  SʁEEBhE\ؑ  (ALT+ENTER)
//
#ifdef __OS2__
void WinUI::ToggleDisplayMode()
{
    uint tick = GetTickCount();
    if ((tick - displaychangedtime) < 1000)
        return;

    displaychangedtime = GetTickCount();
    fullscreen = !fullscreen;

    if (fullscreen)
        statusdisplay.Disable();
    ChangeDisplayType(fullscreen);
}
#else
void WinUI::ToggleDisplayMode()
{
    uint tick = GetTickCount();
    if ((tick - displaychangedtime) < 1000)
        return;

    displaychangedtime = GetTickCount();
    fullscreen = !fullscreen;

    if (fullscreen)
        statusdisplay.Disable();
    ChangeDisplayType(fullscreen);
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::ChangeDisplayType
//  \\bhύX
//
#ifdef __OS2__
void WinUI::ChangeDisplayType(bool savepos)
{
    if (winconfig.IsOpen())
    {
        winconfig.Close();
        SetGUIFlag(false);
    }
    if (savepos)
    {
        RECTL rect;
        WinQueryWindowRect(hwnd, &rect);
        point.x = rect.xLeft; point.y = rect.yTop;
    }
    if (!fullscreen)
    {
        if (haspalette)
            WinPostMsg(hwndClient, (ULONG)WM_M88_CHANGEDISPLAY, (MPARAM)WinDraw::DDWin, (MPARAM)0);
        else
            WinPostMsg(hwndClient, (ULONG)WM_M88_CHANGEDISPLAY, (MPARAM)WinDraw::GDI, (MPARAM)0);
    }
    else
    {
        WinPostMsg(hwndClient, (ULONG)WM_M88_CHANGEDISPLAY, (MPARAM)WinDraw::DDFull, (MPARAM)0);
    }
}
#else
void WinUI::ChangeDisplayType(bool savepos)
{
    if (winconfig.IsOpen())
    {
        winconfig.Close();
        SetGUIFlag(false);
    }
    if (savepos)
    {
        RECT rect;
        GetWindowRect(hwnd, &rect);
        point.x = rect.left; point.y = rect.top;
    }
    if (!fullscreen)
    {
        if (haspalette)
            PostMessage(hwnd, WM_M88_CHANGEDISPLAY, WinDraw::DDWin, 0);
        else
            PostMessage(hwnd, WM_M88_CHANGEDISPLAY, WinDraw::GDI, 0);
    }
    else
    {
        PostMessage(hwnd, WM_M88_CHANGEDISPLAY, WinDraw::DDFull, 0);
    }
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::M88ChangeDisplay
//  \\bh̕ύX
//
#ifdef __OS2__
uint WinUI::M88ChangeDisplay(HWND hwnd, WPARAM mode, LPARAM)
{
    bool f4 = (config.flags & PC8801::Config::force480) != 0;
    if (!draw.ChangeDisplayDriver((WinDraw::DisplayType) mode, f4))
        return 0;

    switch ((WinDraw::DisplayType) mode)
    {
    case WinDraw::GDI:
    case WinDraw::DDWin:
//        wstyle = (GetWindowLong(hwnd, GWL_STYLE) & ~WS_POPUP)
//               | (WS_CAPTION | WS_OVERLAPPED | WS_SYSMENU);
//        SetWindowLong(hwnd, GWL_STYLE, wstyle);
//        SetWindowLong(hwnd, GWL_EXSTYLE, GetWindowLong(hwnd, GWL_EXSTYLE) & ~WS_EX_TOPMOST);

        ResizeWindow(640, 400);
//        SetWindowPos(hwnd, 0, point.x, point.y, 0, 0, SWP_NOZORDER | SWP_NOSIZE);
//        ShowStatusWindow();

        report = true;
        break;

    case WinDraw::DDFull:
//        wstyle = (GetWindowLong(hwnd, GWL_STYLE) & ~(WS_CAPTION | WS_OVERLAPPED | WS_SYSMENU))
//                    | WS_POPUP;
//        SetWindowLong(hwnd, GWL_STYLE, wstyle);
//        SetWindowLong(hwnd, GWL_EXSTYLE, GetWindowLong(hwnd, GWL_EXSTYLE) | WS_EX_TOPMOST);
        report = false;
        WinSetWindowText(hwndFrame, "M88");
        break;
    }

    return 0;
}
#else
uint WinUI::M88ChangeDisplay(HWND hwnd, WPARAM mode, LPARAM)
{
    // ꎞIɉ~߂
#if 0
    PC8801::WinSound* wsnd = core.GetSound();
    int snd = config.sound;
    config.sound = 0;
    wsnd->ApplyConfig(&config);
#endif

    // ʃhCo̐ؑւ
    bool r = draw.ChangeDisplayDriver
        ((WinDraw::DisplayType) mode, (config.flags & PC8801::Config::force480) != 0);

    // ߂
#if 0
    config.sound = snd;
    wsnd->ApplyConfig(&config);
#endif

    if (r)
    {
        // EBhEX^C֌W̕ύX
        wstyle = GetWindowLong(hwnd, GWL_STYLE);
        int exstyle = GetWindowLong(hwnd, GWL_EXSTYLE);

        switch ((WinDraw::DisplayType) mode)
        {
        case WinDraw::GDI:
        case WinDraw::DDWin:
            wstyle = (wstyle & ~WS_POPUP) | (WS_CAPTION | WS_OVERLAPPED | WS_SYSMENU);
            exstyle &= ~WS_EX_TOPMOST;

            SetWindowLong(hwnd, GWL_STYLE, wstyle);
            SetWindowLong(hwnd, GWL_EXSTYLE, exstyle);
            ResizeWindow(640, 400);
            SetWindowPos(hwnd, 0, point.x, point.y, 0, 0, SWP_NOZORDER | SWP_NOSIZE);
            ShowStatusWindow();
            report = true;
            break;

        case WinDraw::DDFull:
            wstyle = (wstyle & ~(WS_CAPTION | WS_OVERLAPPED | WS_SYSMENU)) | WS_POPUP;
            exstyle |= WS_EX_TOPMOST;
            SetWindowLong(hwnd, GWL_STYLE, wstyle);
            SetWindowLong(hwnd, GWL_EXSTYLE, exstyle);
            SetWindowText(hwnd, "M88");
            report = false;
            break;
        }
    }
    return 0;
}
#endif

// ---------------------------------------------------------------------------
//  WinUI::WmEnterMenuLoop
//  WM_ENTERMENULOOP nh
//
uint WinUI::WmEnterMenuLoop(HWND, WPARAM wp, LPARAM)
{
    if (!wp)
    {
        keyif.Activate(false);
        SetGUIFlag(true);
    }
    return 0;
}

// ---------------------------------------------------------------------------
//  WinUI::WmExitMenuLoop
//  WM_EXITMENULOOP nh
//
uint WinUI::WmExitMenuLoop(HWND, WPARAM wp, LPARAM)
{
    if (!wp)
    {
        keyif.Activate(true);
        SetGUIFlag(false);
    }
    return 0;
}

// ---------------------------------------------------------------------------
//  {[ύX
//
uint WinUI::M88ChangeVolume(HWND, WPARAM c, LPARAM)
{
    if (c)
        core.GetSound()->SetVolume((PC8801::Config*) c);
    return 0;
}

// ---------------------------------------------------------------------------
//  WinUI::WmDisplayChange
//  WM_DISPLAYCHANGE nh
//
uint WinUI::WmDisplayChange(HWND hwnd, WPARAM wp, LPARAM lp)
{
    resetwindowsize = fullscreen ? 0 : 5;
    return 0;
}

// ---------------------------------------------------------------------------
//  WinUI::DropFiles
//  WM_DROPFILES nh
//  ߌs̎Ƃɍ쐬܂D(Thanks!)
//
#ifdef __OS2__
uint WinUI::WmDropFiles(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    return 0;
}
#else
uint WinUI::WmDropFiles(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    HDROP hdrop = (HDROP) wparam;

    // 󂯎t@C̐mF
    int nfiles = DragQueryFile(hdrop, ~0, 0, 0);
    if (nfiles != 1)
    {
        statusdisplay.Show(50, 3000, "hbvł̂̓t@CPł.");
        DragFinish(hdrop);
        return 0;
    }

    // t@Cl[擾
    char path[MAX_PATH];
    DragQueryFile(hdrop, 0, path, 512);
    DragFinish(hdrop);

    OpenDiskImage(path);

    // Ƀ}Egł烊Zbg
    if (diskinfo[0].filename[0])
        Reset();

    return 0;
}
#endif
// ---------------------------------------------------------------------------
//  WinUI::CaptureScreen
//
#ifdef __OS2__
void WinUI::CaptureScreen()
{
}
#else
void WinUI::CaptureScreen()
{
    const int bmpsize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFO)
                      + 15 * sizeof(RGBQUAD) + 320 * 400;
    uint8* bmp = new uint8[bmpsize];
    if (!bmp) return;

    if (!draw.CaptureScreen(bmp))
    {
        delete[] bmp;
        return;
    }

    SetGUIFlag(true);

    OPENFILENAME ofn;
    memset(&ofn, 0, sizeof(ofn));
    char filename[MAX_PATH];
    filename[0] = 0;
    ofn.lStructSize = sizeof(ofn);
    ofn.hwndOwner = hwnd;
    ofn.lpstrFilter = "bitmap image [4bpp] (*.bmp)\0*.bmp\0";
    ofn.lpstrFile = filename;
    ofn.nMaxFile = MAX_PATH;
    ofn.Flags = OFN_CREATEPROMPT;
    ofn.lpstrDefExt = "bmp";
    ofn.lpstrTitle = "Save captured image";

    EnableIME(hwnd, true);
    bool save = !!GetSaveFileName(&ofn);
    EnableIME(hwnd, false);
    SetGUIFlag(false);

    if (save)
    {
        FileIO file;
        if (file.Open(filename, FileIO::create))
            file.Write(bmp, bmpsize);
    }
    delete[] bmp;
}
#endif

// ---------------------------------------------------------------------------
//  }EXԂ̎擾
//
#ifdef __OS2__
uint WinUI::WmLButtonDown(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if (capturemouse)
    {
        mousebutton |= 1;
        return 0;
    }
    return (uint)WinDefWindowProc(hwnd, WM_BUTTON1DOWN, wparam, lparam);
}
#else
uint WinUI::WmLButtonDown(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if (capturemouse)
    {
        mousebutton |= 1;
        return 0;
    }
    return DefWindowProc(hwnd, WM_LBUTTONDOWN, wparam, lparam);
}
#endif

#ifdef __OS2__
uint WinUI::WmLButtonUp(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if (capturemouse)
    {
        mousebutton &= ~1;
        return 0;
    }
    return (uint)WinDefWindowProc(hwnd, WM_BUTTON1UP, wparam, lparam);
}
#else
uint WinUI::WmLButtonUp(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if (capturemouse)
    {
        mousebutton &= ~1;
        return 0;
    }
    return DefWindowProc(hwnd, WM_LBUTTONDOWN, wparam, lparam);
}
#endif

#ifdef __OS2__
uint WinUI::WmRButtonDown(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if (capturemouse)
    {
        mousebutton |= 2;
        return 0;
    }
    return (uint)WinDefWindowProc(hwnd, WM_BUTTON2DOWN, wparam, lparam);
}
#else
uint WinUI::WmRButtonDown(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if (capturemouse)
    {
        mousebutton |= 2;
        return 0;
    }
    return DefWindowProc(hwnd, WM_LBUTTONDOWN, wparam, lparam);
}
#endif

#ifdef __OS2__
uint WinUI::WmRButtonUp(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if (capturemouse)
    {
        mousebutton &= ~2;
        return 0;
    }
    return (uint)WinDefWindowProc(hwnd, WM_BUTTON2UP, wparam, lparam);
}
#else
uint WinUI::WmRButtonUp(HWND hwnd, WPARAM wparam, LPARAM lparam)
{
    if (capturemouse)
    {
        mousebutton &= ~2;
        return 0;
    }
    return DefWindowProc(hwnd, WM_LBUTTONDOWN, wparam, lparam);
}
#endif
// ---------------------------------------------------------------------------
//  EBhEړ[hɓEo
//
uint WinUI::WmEnterSizeMove(HWND hwnd, WPARAM, LPARAM)
{
    core.ActivateMouse(false);
    return 0;
}

uint WinUI::WmExitSizeMove(HWND hwnd, WPARAM, LPARAM)
{
    core.ActivateMouse(true);
    return 0;
}

// ---------------------------------------------------------------------------
//  GUI 샂[hɓ
//
#ifdef __OS2__
void WinUI::SetGUIFlag(bool gui)
{
    if (gui && !background)
    {
//        if (!background) @@@
//            ::DrawMenuBar(hwnd); @@@
    }
    core.SetGUIFlag(gui);
    draw.SetGUIFlag(gui);
}
#else
void WinUI::SetGUIFlag(bool gui)
{
    if (gui && !background)
    {
        if (!background)
            ::DrawMenuBar(hwnd);
    }
    core.SetGUIFlag(gui);
    draw.SetGUIFlag(gui);
}
#endif

// ---------------------------------------------------------------------------
//  R}hC
//
//  :
//  M88 [-flags] diskimagepath
//
//  -bN     basic mode (hex)
//  -fA,B   flags (16i)    (A=flags̒g, B=frbg)
//  -gA,B   flag2 (16i)    (A=flag2̒g, B=frbg)
//  -cCLK   clock (MHz) (10i)
//
//  N, A, B ̒l src/pc88/config.h QƁD
//
//  o[Wł͐ݒ_CAOł͐ݒłȂgݍ킹
//  󂯕tĂ܂̂ŗv
//  Ⴆ΃}EXgpȂL[ɂ郁j[}Ȃ񂩂̓oCD
//
//  : M88 -b31 -c8 -f10,10 popfulmail.d88
//      V2 [hC8MHzCOPNA [h popfulmail.d88 N
//
//  Â炢͕̂Smł(^^;
//  ڂ͉QƂ邩CJɂł₵ĂD
//
//  ̃p[^ύXł悤ɂꍇCꌾΑΉ܂D
//
void WinUI::ApplyCommandLine(const char* cmdline)
{
    bool change = false;
    while (*cmdline)
    {
        while (*cmdline == ' ')
            cmdline++;

        if (*cmdline == '-')
        {
            cmdline += 2;
            switch (tolower(cmdline[-1]))
            {
                char* endptr;
                int32 newflags, activate;

            // BASIC [hݒ  -b[hԍ
            case 'b':
                config.basicmode =
                    Config::BASICMode(strtoul(cmdline, &endptr, 16));
                cmdline = endptr;
                change = true;
                break;

            // clock ݒ  -cNbN
            case 'c':
                config.clock = Limit(strtoul(cmdline, &endptr, 10), 100, 1) * 10;
                cmdline = endptr;
                change = true;
                break;

            // flags ̒lݒ  -gl,Lrbg
            case 'f':
                newflags = strtoul(cmdline, &endptr, 16);
                activate = ~0;
                if (*endptr == ',')
                {
                    activate = strtoul(endptr+1, &endptr, 16);
                    cmdline = endptr;
                }
                cmdline = endptr;
                config.flags = (config.flags & ~activate) | (newflags & activate);
                change = true;
                break;

            // flag2 ̒lݒ  -gl,Lrbg
            case 'g':
                newflags = strtoul(cmdline, &endptr, 16);
                activate = ~0;
                if (*endptr == ',')
                {
                    activate = strtoul(endptr+1, &endptr, 16);
                    cmdline = endptr;
                }
                cmdline = endptr;
                config.flag2 = (config.flag2 & ~activate) | (newflags & activate);
                change = true;
                break;
            }

            while (*cmdline && *cmdline != ' ')
                cmdline++;
            continue;
        }

        // c͑t@C
        OpenDiskImage(cmdline);
        break;
    }
}
