// ---------------------------------------------------------------------------
//  M88 - PC-88 Emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  generic file io class for Win32
// ---------------------------------------------------------------------------
//  $Id: file.cpp,v 1.3 1999/03/24 23:27:20 cisc Exp $

#include "headers.h"
#include "File.h"

// ---------------------------------------------------------------------------
//  \z/
// ---------------------------------------------------------------------------

FileIO::FileIO()
{
    flags = 0;
}

FileIO::FileIO(const char* filename, uint flg)
{
    flags = 0;
    Open(filename, flg);
}

FileIO::~FileIO()
{
    Close();
}

// ---------------------------------------------------------------------------
//  t@CJ
// ---------------------------------------------------------------------------

bool FileIO::Open(const char* filename, uint flg)
{
#ifdef __OS2__
    Close();

    strncpy(path, filename, _MAX_PATH);

//    ULONG share = (flg & readonly) ? (OPEN_FLAGS_SEQUENTIAL | OPEN_SHARE_DENYWRITE | OPEN_ACCESS_READONLY) : (OPEN_FLAGS_SEQUENTIAL | OPEN_ACCESS_READWRITE);
    ULONG share = (flg & readonly) ? (OPEN_SHARE_DENYWRITE | OPEN_ACCESS_READONLY) : (OPEN_ACCESS_READWRITE);
    ULONG creation = (flg & create) ? (OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_REPLACE_IF_EXISTS) : (OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS);
    ULONG ulAction;

    DosOpen( filename, &hfile, &ulAction, 0UL, FILE_ARCHIVED | FILE_NORMAL, creation, share, NULL );
    flags = (flg & readonly) | (hfile == NULLHANDLE ? 0 : open);
    SetLogicalOrigin(0);

    return !!(flags & open);
#else
    Close();

    strncpy(path, filename, _MAX_PATH);

    DWORD access = (flg & readonly ? 0 : GENERIC_WRITE) | GENERIC_READ;
    DWORD share = (flg & readonly) ? FILE_SHARE_READ : 0;
    DWORD creation = flg & create ? CREATE_ALWAYS : OPEN_EXISTING;

    hfile = CreateFile(filename, access, share, 0, creation, 0, 0);

    flags = (flg & readonly) | (hfile == INVALID_HANDLE_VALUE ? 0 : open);
    SetLogicalOrigin(0);

    return !!(flags & open);
#endif
}

// ---------------------------------------------------------------------------
//  t@CȂꍇ͍쐬
// ---------------------------------------------------------------------------

bool FileIO::CreateNew(const char* filename)
{
#ifdef __OS2__
    Close();

    strncpy(path, filename, _MAX_PATH);

    ULONG ulAction;
    ULONG share = OPEN_FLAGS_SEQUENTIAL | OPEN_ACCESS_READWRITE;
    ULONG creation = OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_REPLACE_IF_EXISTS;
    DosOpen( filename, &hfile, &ulAction, 0UL, FILE_ARCHIVED | FILE_NORMAL, creation, share, NULL );
    flags = (hfile == NULLHANDLE ? 0 : open);

    return !!(flags & open);
#else
    Close();

    strncpy(path, filename, _MAX_PATH);

    DWORD access = GENERIC_WRITE | GENERIC_READ;
    DWORD share = 0;
    DWORD creation = CREATE_NEW;

    hfile = CreateFile(filename, access, share, 0, creation, 0, 0);

    flags = (hfile == INVALID_HANDLE_VALUE ? 0 : open);
    SetLogicalOrigin(0);

    return !!(flags & open);
#endif
}

// ---------------------------------------------------------------------------
//  t@C蒼
// ---------------------------------------------------------------------------

bool FileIO::Reopen(uint flg)
{
#ifdef __OS2__
    Close();

    ULONG ulAction;
    ULONG share = OPEN_FLAGS_SEQUENTIAL | OPEN_ACCESS_READWRITE;
    ULONG creation = OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_REPLACE_IF_EXISTS;
    DosOpen( path, &hfile, &ulAction, 0UL, FILE_ARCHIVED | FILE_NORMAL, creation, share, NULL );

    flags = (flg & readonly) | (hfile == NULLHANDLE ? 0 : open);

    return !!(flags & open);
#else
    if (!(flags & open)) return false;
    if ((flags & readonly) && (flg & create)) return false;

    if (flags & readonly) flg |= readonly;

    Close();

    DWORD access = (flg & readonly ? 0 : GENERIC_WRITE) | GENERIC_READ;
    DWORD share = flg & readonly ? FILE_SHARE_READ : 0;
    DWORD creation = flg & create ? CREATE_ALWAYS : OPEN_EXISTING;

    hfile = CreateFile(path, access, share, 0, creation, 0, 0);

    flags = (flg & readonly) | (hfile == INVALID_HANDLE_VALUE ? 0 : open);
    SetLogicalOrigin(0);

    return !!(flags & open);
#endif
}

// ---------------------------------------------------------------------------
//  t@C
// ---------------------------------------------------------------------------

void FileIO::Close()
{
    if (GetFlags() & open)
    {
#ifdef __OS2__
        DosClose( hfile );
#else
        CloseHandle(hfile);
#endif
        flags = 0;
    }
}

// ---------------------------------------------------------------------------
//  t@Ck̓ǂݏo
// ---------------------------------------------------------------------------

int32 FileIO::Read(void* dest, int32 size)
{
    if (!(GetFlags() & open))
        return -1;

#ifdef __OS2__
    ULONG readsize;
    if(DosRead( hfile, dest, size, &readsize ) != NO_ERROR) {
        return -1;
    }
    return readsize;
#else
    DWORD readsize;
    if (!ReadFile(hfile, dest, size, &readsize, 0))
        return -1;
    return readsize;
#endif
}

// ---------------------------------------------------------------------------
//  t@Cւ̏o
// ---------------------------------------------------------------------------

int32 FileIO::Write(const void* dest, int32 size)
{
    if (!(GetFlags() & open) || (GetFlags() & readonly))
        return -1;

#ifdef __OS2__
    ULONG writtensize;
    if(DosWrite( hfile, (PVOID)dest, size, &writtensize ) != NO_ERROR) {
        return -1;
    }
    return writtensize;
#else
    DWORD writtensize;
    if (!WriteFile(hfile, dest, size, &writtensize, 0))
        return -1;
    return writtensize;
#endif
}

// ---------------------------------------------------------------------------
//  t@CV[N
// ---------------------------------------------------------------------------

bool FileIO::Seek(int32 pos, SeekMethod method)
{
    if (!(GetFlags() & open))
        return false;

#ifdef __OS2__
    ULONG wmethod;
    ULONG ibActual;
    switch (method)
    {
    case begin:
        wmethod = FILE_BEGIN; pos += lorigin;
        break;
    case current:
        wmethod = FILE_CURRENT;
        break;
    case end:
        wmethod = FILE_END;
        break;
    default:
        return false;
    }
    return DosSetFilePtr( hfile, pos, wmethod, &ibActual ) == NO_ERROR;
#else
    DWORD wmethod;
    switch (method)
    {
    case begin:
        wmethod = FILE_BEGIN; pos += lorigin;
        break;
    case current:
        wmethod = FILE_CURRENT;
        break;
    case end:
        wmethod = FILE_END;
        break;
    default:
        return false;
    }

    return 0xffffffff != SetFilePointer(hfile, pos, 0, wmethod);
#endif
}

// ---------------------------------------------------------------------------
//  t@C̈ʒu𓾂
// ---------------------------------------------------------------------------

int32 FileIO::Tellp()
{
    if (!(GetFlags() & open))
        return 0;

#ifdef __OS2__
    ULONG ibActual;
    DosSetFilePtr( hfile, 0, FILE_CURRENT, &ibActual );
    return ibActual - lorigin;
#else
    return SetFilePointer(hfile, 0, 0, FILE_CURRENT) - lorigin;
#endif
}

// ---------------------------------------------------------------------------
//  ݂̈ʒut@C̏I[Ƃ
// ---------------------------------------------------------------------------

bool FileIO::SetEndOfFile()
{
    if (!(GetFlags() & open))
        return false;
#ifdef __OS2__
    return DosSetFileSize( hfile, Tellp()) == NO_ERROR;
#else
    return ::SetEndOfFile(hfile) != 0;
#endif
}
