// ---------------------------------------------------------------------------
//  M88 - PC88 emulator
//  Copyright (C) cisc 1998.
// ---------------------------------------------------------------------------
//  DirectDraw ɂEChEʕ`
//  8bpp p(T-T
// ---------------------------------------------------------------------------
//  $Id: drawddw.cpp,v 1.2 1999/07/15 12:39:27 cisc Exp $

#include "headers.h"
#include "misc.h"
#include "DrawDDW.h"

#define RELCOM(x)  if (x) x->Release(), x=0; else 0

#ifdef __OS2__
#include <OS2ME.H>
#include <mmioos2.h>
#include <fourcc.h>
#include <dive.h>
#pragma library("MMPM2.LIB");
HDIVE hDive;
SETUP_BLITTER SetupBlitter;
ULONG ulBufferNumber, ulBufferScanLineBytes, ulBufferScanLines;
BYTE  *pbImageBuffer;
RECTL rcl[1];
#endif

// ---------------------------------------------------------------------------
//  \z/
//
#ifdef __OS2__
WinDrawDDW::WinDrawDDW()
{
//    ddraw = 0;
//    ddsscrn = 0;
//    ddcscrn = 0;
//    ddpal = 0;
//    ddswork = 0;
    scrnhaspal = false;
    palchanged = false;
    image = 0;
    bpl = 0;
}
#else
WinDrawDDW::WinDrawDDW()
{
    ddraw = 0;
    ddsscrn = 0;
    ddcscrn = 0;
    ddpal = 0;
    ddswork = 0;
    scrnhaspal = false;
    palchanged = false;
    image = 0;
    bpl = 0;
}
#endif

WinDrawDDW::~WinDrawDDW()
{
    Cleanup();
}

// ---------------------------------------------------------------------------
//  
//
#ifdef __OS2__

bool WinDrawDDW::Init(HWND hwindow)
{
    hwnd = hwindow;

    image = new uint8[640*480];
    bpl = 640;
    if (!image)
        return false;
    memset(image, 0x40, 640*400);

//    if (!CreateDD2())
//        return false;

//    if (DD_OK != ddraw->SetCooperativeLevel(hwnd, DDSCL_NORMAL))
//        return false;

//    if (!CreateDDS())
//        return false;

    CreateDDPalette();



    if(DiveOpen( &hDive, FALSE, NULL )) {
        return false;
    }
    if(DiveAllocImageBuffer( hDive, &ulBufferNumber, FOURCC_LUT8, 640, 480, 0L, NULL )) {
        return false;
    }
    ulBufferScanLineBytes = 0L;
    ulBufferScanLines = 0L;
    DiveBeginImageBufferAccess( hDive, ulBufferNumber, &pbImageBuffer, &ulBufferScanLineBytes, &ulBufferScanLines );


            SetupBlitter.ulStructLen  = sizeof(SETUP_BLITTER);
            SetupBlitter.ulDitherType = 0;
            SetupBlitter.fInvert = FALSE;

            SetupBlitter.fccSrcColorFormat = FOURCC_LUT8;
            SetupBlitter.ulSrcWidth  = 640;
            SetupBlitter.ulSrcHeight = 400;
            SetupBlitter.ulSrcPosX   = 0;
            SetupBlitter.ulSrcPosY   = 0;

            SetupBlitter.fccDstColorFormat = FOURCC_SCRN;
            SetupBlitter.ulDstWidth  = 640;
            SetupBlitter.ulDstHeight = 400;
            SetupBlitter.lDstPosX   = 0;
            SetupBlitter.lDstPosY   = 0;
            SetupBlitter.lScreenPosX = 4;
            SetupBlitter.lScreenPosY = 4;

            rcl[0].xLeft   = SetupBlitter.lScreenPosX + SetupBlitter.lDstPosX;
            rcl[0].yBottom = SetupBlitter.lScreenPosY + SetupBlitter.lDstPosY;
            rcl[0].xRight  = rcl[0].xLeft + SetupBlitter.ulDstWidth;
            rcl[0].yTop    = rcl[0].yBottom + SetupBlitter.ulDstHeight;

            SetupBlitter.ulNumDstRects = 1;
            SetupBlitter.pVisDstRects  = rcl;

            if(hDive) DiveSetupBlitter( hDive, &SetupBlitter );




    return true;
}
#else
bool WinDrawDDW::Init(HWND hwindow)
{
    hwnd = hwindow;

    image = new uint8[640*400];
    bpl = 640;
    if (!image)
        return false;
    memset(image, 0x40, 640*400);

    if (!CreateDD2())
        return false;

    if (DD_OK != ddraw->SetCooperativeLevel(hwnd, DDSCL_NORMAL))
        return false;

    if (!CreateDDS())
        return false;

    CreateDDPalette();
    return true;
}
#endif
// ---------------------------------------------------------------------------
//  Cleanup
//
#ifdef __OS2__
bool WinDrawDDW::Cleanup()
{

    DiveEndImageBufferAccess( hDive, ulBufferNumber );
    DiveFreeImageBuffer( hDive, ulBufferNumber );
    DiveClose( hDive );

    delete[] image; image = 0;
    return true;
}
#else
bool WinDrawDDW::Cleanup()
{
    RELCOM(ddpal);
    RELCOM(ddcscrn);
    RELCOM(ddswork);
    RELCOM(ddsscrn);
    RELCOM(ddraw);
    delete[] image; image = 0;
    return true;
}
#endif
// ---------------------------------------------------------------------------
//  DirectDraw2 
//
#ifdef __OS2__
bool WinDrawDDW::CreateDD2()
{
    return true;
}
#else
bool WinDrawDDW::CreateDD2()
{
    LPDIRECTDRAW ddraw1;
    if (DD_OK != DirectDrawCreate(0, &ddraw1, 0))
        return false;
    if (S_OK != ddraw1->QueryInterface(IID_IDirectDraw2, (void**)&ddraw))
        return false;
    return true;
}
#endif

// ---------------------------------------------------------------------------
//  Surface 
//
#ifdef __OS2__
bool WinDrawDDW::CreateDDS()
{
    return true;
}
#else
bool WinDrawDDW::CreateDDS()
{
    // \T[tFX쐬
    DDSURFACEDESC ddsd;
    memset(&ddsd, 0, sizeof(DDSURFACEDESC));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

    if (DD_OK != ddraw->CreateSurface(&ddsd, &ddsscrn, 0))
        return false;

    // Nbp[
    if (DD_OK != ddraw->CreateClipper(0, &ddcscrn, 0))
        return false;

    ddcscrn->SetHWnd(0, hwnd);
    ddsscrn->SetClipper(ddcscrn);

    // \T[tFX̐FtH[}bg𓾂
    DDPIXELFORMAT ddpf;
    memset(&ddpf, 0, sizeof(ddpf));
    ddpf.dwSize = sizeof(DDPIXELFORMAT);
    if (DD_OK != ddsscrn->GetPixelFormat(&ddpf))
        return false;
    if (!(ddpf.dwFlags & DDPF_RGB))
        return false;
    scrnhaspal = !!(ddpf.dwFlags & DDPF_PALETTEINDEXED8);

    // ƗpT[tFX쐬
    memset(&ddsd, 0, sizeof(DDSURFACEDESC));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
    ddsd.dwWidth = 640;
    ddsd.dwHeight = 400;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;

    if (DD_OK != ddraw->CreateSurface(&ddsd, &ddswork, 0))
        return false;

    if (ddpf.dwRGBBitCount != 8)
        return false;

    return true;
}
#endif

// ---------------------------------------------------------------------------
//  pbg
//
#ifdef __OS2__
bool WinDrawDDW::CreateDDPalette()
{
    int i;
    const int nsyscol = 10;
    for (i=0; i<nsyscol; i++)
    {
        palentry[i].peRed = i;
        palentry[i].peGreen = 0;
        palentry[i].peBlue = 0;
//        palentry[i].peFlags = PC_EXPLICIT;
        palentry[255-i].peRed = 255-i;
        palentry[255-i].peGreen = 0;
        palentry[255-i].peBlue = 0;
//        palentry[255-i].peFlags = PC_EXPLICIT;
    }
    for (i=nsyscol; i<0x40; i++)
    {
        palentry[i].peRed = 0;
        palentry[i].peGreen = 0;
        palentry[i].peBlue = 0;
    }
//    for (i=0x40; i<0xd0; i++)
//    {
//        palentry[i].peFlags = PC_RESERVED | PC_NOCOLLAPSE;
//    }
    if (scrnhaspal)
    {
//        if (DD_OK == ddraw->CreatePalette(DDPCAPS_8BIT, palentry, &ddpal, 0))
//        {
//            ddsscrn->SetPalette(ddpal);
//        }
    }
    return true;
}
#else
bool WinDrawDDW::CreateDDPalette()
{
    int i;
    const int nsyscol = 10;
    for (i=0; i<nsyscol; i++)
    {
        palentry[i].peRed = i;
        palentry[i].peGreen = 0;
        palentry[i].peBlue = 0;
        palentry[i].peFlags = PC_EXPLICIT;
        palentry[255-i].peRed = 255-i;
        palentry[255-i].peGreen = 0;
        palentry[255-i].peBlue = 0;
        palentry[255-i].peFlags = PC_EXPLICIT;
    }
    for (i=nsyscol; i<0x40; i++)
    {
        palentry[i].peRed = 0;
        palentry[i].peGreen = 0;
        palentry[i].peBlue = 0;
        palentry[i].peFlags = PC_NOCOLLAPSE;
//      palentry[255-i].peRed = 0;
//      palentry[255-i].peGreen = 0;
//      palentry[255-i].peBlue = 0;
//      palentry[255-i].peFlags = PC_NOCOLLAPSE;
    }
    for (i=0x40; i<0xd0; i++)
    {
        palentry[i].peFlags = PC_RESERVED | PC_NOCOLLAPSE;
    }
    if (scrnhaspal)
    {
        if (DD_OK == ddraw->CreatePalette(DDPCAPS_8BIT, palentry, &ddpal, 0))
        {
            ddsscrn->SetPalette(ddpal);
        }
    }
    return true;
}
#endif

// ---------------------------------------------------------------------------
//  `
//
#ifdef __OS2__
void WinDrawDDW::DrawScreen(int top, int bottom, bool refresh)
{
    RECTL rect;
    rect.xLeft = 0;
    rect.yTop = top;
    rect.xRight = 640;
    rect.yBottom = bottom+1;

    if (palchanged)
    {
        RGB2 rgb[256];
        int i;
        for(i = 0; i < 256; i++)
        {
            rgb[i].bBlue  = palentry[i].peBlue;
            rgb[i].bGreen = palentry[i].peGreen;
            rgb[i].bRed   = palentry[i].peRed;
        }

        DiveSetSourcePalette( hDive, 0, 256, (PBYTE)&rgb[0]);
    }

    // Ɨ̈XV
    if (rect.yTop <= rect.yBottom)
    {
        Convert8bpp( pbImageBuffer, image, &rect, 640);
    }

    if (refresh || palchanged)
    {
        refresh = false;
        rect.yTop = 0, rect.yBottom = 400;
        palchanged = false;
    }

    if (rect.yTop <= rect.yBottom)
    {
        RECTL rectdest;
        POINTL srcpoint;
        srcpoint.x = 0, srcpoint.y = 0;
        rectdest.xLeft = srcpoint.x + rect.xLeft;
        rectdest.xRight = srcpoint.x + rect.xRight;
        rectdest.yTop = srcpoint.y + rect.yTop;
        rectdest.yBottom = srcpoint.y + rect.yBottom;

        DiveBlitImage( hDive, ulBufferNumber, DIVE_BUFFER_SCREEN );
    }
}
#else
void WinDrawDDW::DrawScreen(int top, int bottom, bool refresh)
{
    RECT rect;
    rect.left = 0;
    rect.top = top;
    rect.right = 640;
    rect.bottom = bottom;

    if (palchanged)
    {
        palchanged = false;
        ddpal->SetEntries(0, 64, 144, &palentry[64]);
    }

    if (refresh)
    {
        refresh = false;
        rect.top = 0, rect.bottom = 399;
    }

    // Ɨ̈XV
    if (rect.top <= rect.bottom)
    {
        if (DDERR_SURFACELOST == ddswork->IsLost())
        {
            if (!RestoreSurface())
                return;
            rect.top = 1, rect.bottom = 0;
        }
        else
        {
            DDSURFACEDESC ddsd;
            memset(&ddsd, 0, sizeof(ddsd));
            ddsd.dwSize = sizeof(ddsd);
            if (DD_OK != ddswork->Lock(&rect, &ddsd, 0, 0))
                return;

            Convert8bpp(ddsd.lpSurface, image, &rect, ddsd.lPitch);

            ddswork->Unlock(0);
        }
    }

    if (rect.top <= rect.bottom)
    {
        rect.bottom ++;
        RECT rectdest;
        POINT srcpoint;
        srcpoint.x = 0, srcpoint.y = 0;
        ClientToScreen(hwnd, &srcpoint);
        rectdest.left = srcpoint.x + rect.left;
        rectdest.right = srcpoint.x + rect.right;
        rectdest.top = srcpoint.y + rect.top;
        rectdest.bottom = srcpoint.y + rect.bottom;

        if (DDERR_SURFACELOST == ddsscrn->Blt(&rectdest, ddswork, &rect, 0, 0))
        {
            RestoreSurface();
        }
    }
}
#endif

// ---------------------------------------------------------------------------
//  WM_QUERYNEWPALETTE
//
#ifdef __OS2__
void WinDrawDDW::QueryNewPalette()
{
}
#else
void WinDrawDDW::QueryNewPalette()
{
    if (scrnhaspal)
    {
        ddsscrn->SetPalette(ddpal);
    }
}
#endif
// ---------------------------------------------------------------------------
//  pbgݒ
//
#ifdef __OS2__
void WinDrawDDW::SetPalette(PALETTEENTRY* pe)
{
    for (int i=0; i<0x90; i++)
    {
        palentry[i+0x40].peRed = pe[i].peRed;
        palentry[i+0x40].peBlue = pe[i].peBlue;
        palentry[i+0x40].peGreen = pe[i].peGreen;
    }
    palchanged = true;
}
#else
void WinDrawDDW::SetPalette(PALETTEENTRY* pe)
{
    for (int i=0; i<0x90; i++)
    {
        palentry[i+0x40].peRed = pe[i].peRed;
        palentry[i+0x40].peBlue = pe[i].peBlue;
        palentry[i+0x40].peGreen = pe[i].peGreen;
    }
    palchanged = true;
}
#endif

// ---------------------------------------------------------------------------
//  8bpp -> ƃobt@
//
#ifdef __OS2__
void WinDrawDDW::Convert8bpp(void* surface, const uint8* image, RECTL* rect, int pitch)
{
    const uint8* src = image + rect->yTop * 640;
    uint8* dest = (uint8*) surface + rect->yTop * 640;

    for (int y=rect->yTop; y<=rect->yBottom; y++)
    {
        memcpy(dest, src, rect->xRight - rect->xLeft);
        src += 640;
        dest += pitch;
    }
}
#else
void WinDrawDDW::Convert8bpp(void* surface, const uint8* image, RECT* rect, int pitch)
{
    const uint8* src = image + rect->top * 640;
    uint8* dest = (uint8*) surface;

    for (int y=rect->top; y<=rect->bottom; y++)
    {
        memcpy(dest, src, rect->right-rect->left);
        src += 640;
        dest += pitch;
    }
}
#endif

// ---------------------------------------------------------------------------
//  ʃC[W̎gpv
//
bool WinDrawDDW::Lock(uint8** pimage, int* pbpl)
{
DosEnterCritSec();
    *pimage = image;
    *pbpl = bpl;
DosExitCritSec();
    return true;
}

// ---------------------------------------------------------------------------
//  ʃC[W̎gpI
//
bool WinDrawDDW::Unlock()
{
    return true;
}

// ---------------------------------------------------------------------------
//  XgT[tFX߂
//
#ifdef __OS2__
bool WinDrawDDW::RestoreSurface()
{
    return true;
}
#else
bool WinDrawDDW::RestoreSurface()
{
    if (DD_OK != ddsscrn->Restore() || DD_OK != ddswork->Restore())
        return false;

    // ƃT[tFX̒g
    DDSURFACEDESC ddsd;
    memset(&ddsd, 0, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    if (DD_OK != ddswork->Lock(0, &ddsd, 0, 0))
        return false;

    RECT rect;
    rect.left = 0;      rect.top = 0;
    rect.right = 640;   rect.bottom = 400;

    Convert8bpp(ddsd.lpSurface, image, &rect, ddsd.lPitch);

    ddswork->Unlock(0);

    // Primary Surface ̒g
    RECT rectdest;
    POINT srcpoint;
    srcpoint.x = 0, srcpoint.y = 0;
    ClientToScreen(hwnd, &srcpoint);
    rectdest.left = srcpoint.x + rect.left;
    rectdest.right = srcpoint.x + rect.right;
    rectdest.top = srcpoint.y + rect.top;
    rectdest.bottom = srcpoint.y + rect.bottom;

    if (DD_OK != ddsscrn->Blt(&rectdest, ddswork, &rect, 0, 0))
        return false;
    return true;
}
#endif

void WinDrawDDW::Resize(uint, uint)
{
}