// ---------------------------------------------------------------------------
//  M88 - PC-8801 Emulator.
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  J_v(PD4990A) ̃G~[V for Win32
// ---------------------------------------------------------------------------
//  $Id: calender.cpp,v 1.2 1999/07/24 04:40:43 cisc Exp $
//  ETP, 1Hz @\

#include "headers.h"
#include <stdio.h>
#include "calender.h"

//#define LOGNAME "calender"
#include "diag.h"

using namespace PC8801;

// ---------------------------------------------------------------------------
//  Construct/Destruct
//
Calender::Calender(const ID& id)
: Device(id)
{
    diff.dwLowDateTime=0;
    diff.dwHighDateTime=0;
    Reset();
}

Calender::~Calender()
{
}

// ---------------------------------------------------------------------------
//  Eo
//
void Calender::Reset(uint, uint)
{
    datain = 0;
    dataoutmode = 0;
    strobe = 0;
    cmd = 0x80;
    scmd = 0;
    for (int i=0; i<6; i++)
        reg[i] = 0;
}

uint Calender::In40(uint)
{
    if (dataoutmode)
        return IOBus::Active((reg[0] & 1) << 4, 0x10);
    else
    {
//      SYSTEMTIME st;
//      GetLocalTime(&st);
//      return (st.wSecond & 1) << 4;
        return IOBus::Active(0, 0x10);
    }
}

void Calender::Out10(uint, uint data)
{
    pcmd = data & 7;
    datain = (data >> 3) & 1;
}

void Calender::Out40(uint, uint data)
{
    uint modified;
    modified = strobe ^ data;
    strobe = data;
    if (modified & data & 2)
        Command();
    if (modified & data & 4)
        ShiftData();
}

// ---------------------------------------------------------------------------
//  digit->BCD
//
inline uint8 Calender::BCD(uint8 n)
{
    return (n/10)*16 + (n%10);
}

// ---------------------------------------------------------------------------
//  
//
void Calender::Command()
{
    if (pcmd == 7)
        cmd = scmd | 0x80;
    else
        cmd = pcmd;

    LOG1("Command = %.2x\n", cmd);
    switch (cmd & 15)
    {
    case 0x00:          // register hold
        hold = true;
        dataoutmode = false;
        break;

    case 0x01:          // register shift
        hold = false;
        dataoutmode = true;
        break;

    case 0x02:          // time set
        SetTime();
        hold = true;
        dataoutmode = true;
        break;

    case 0x03:          // time read
        GetTime();
        hold = true;
        dataoutmode = false;
        break;
    }
}

// ---------------------------------------------------------------------------
//  f[^Vtg
//
void Calender::ShiftData()
{
    if (hold)
    {
        if (cmd & 0x80)
        {
            // shift sreg only
            LOG1("Shift HS %d\n", datain);
            scmd = (scmd >> 1) | (datain << 3);
        }
        else
        {
            LOG1("Shift HP -\n", datain);
        }
    }
    else
    {
        if (cmd & 0x80)
        {
            reg[0] = (reg[0] >> 1) | (reg[1] << 7);
            reg[1] = (reg[1] >> 1) | (reg[2] << 7);
            reg[2] = (reg[2] >> 1) | (reg[3] << 7);
            reg[3] = (reg[3] >> 1) | (reg[4] << 7);
            reg[4] = (reg[4] >> 1) | (reg[5] << 7);
            reg[5] = (reg[5] >> 1) | (scmd   << 7);
            scmd   = (scmd   >> 1) | (datain << 3);
            LOG1("Shift -S %d\n", datain);
        }
        else
        {
            reg[0] = (reg[0] >> 1) | (reg[1] << 7);
            reg[1] = (reg[1] >> 1) | (reg[2] << 7);
            reg[2] = (reg[2] >> 1) | (reg[3] << 7);
            reg[3] = (reg[3] >> 1) | (reg[4] << 7);
            reg[4] = (reg[4] >> 1) | (datain << 7);
            LOG1("Shift -P %d\n", datain);
        }
    }
}

// ---------------------------------------------------------------------------
//  ԌvZ
//
static void FTADD(FILETIME& d, const FILETIME& s)
{
    if (uint32(d.dwLowDateTime) > uint32(0xffffffff-s.dwLowDateTime))
    {
        d.dwHighDateTime++;
    }
    d.dwHighDateTime += s.dwHighDateTime;
    d.dwLowDateTime  += s.dwLowDateTime;
}

static void FTSUB(FILETIME& d, const FILETIME& s)
{
    if (uint32(d.dwLowDateTime) < uint32(s.dwLowDateTime))
    {
        d.dwHighDateTime--;
    }
    d.dwHighDateTime -= s.dwHighDateTime;
    d.dwLowDateTime  -= s.dwLowDateTime;
}

// ---------------------------------------------------------------------------
//  Ԏ擾
//
#ifdef __OS2__
void Calender::GetTime()
{
    SYSTEMTIME st;
    FILETIME ft;
    DATETIME DateTime;

    //GetLocalTime(&st);
    DosGetDateTime( &DateTime );
    st.wYear = DateTime.year;
    st.wMonth = DateTime.month;
    st.wDay   = DateTime.day;
    st.wHour = DateTime.hours;
    st.wMinute = DateTime.minutes;
    st.wSecond = DateTime.seconds;
    st.wDayOfWeek = DateTime.weekday;
//    st.wMilliseconds = 0;
//    SystemTimeToFileTime(&st, &ft);

    reg[5] = BCD(uint8(st.wYear % 100));
    reg[4] = st.wMonth * 16 + st.wDayOfWeek;
    reg[3] = BCD(uint8(st.wDay));
    reg[2] = BCD(uint8(st.wHour));
    reg[1] = BCD(uint8(st.wMinute));
    reg[0] = BCD(uint8(st.wSecond));

}
#else
void Calender::GetTime()
{
    SYSTEMTIME st;
    FILETIME ft;

    GetLocalTime(&st);
    st.wMilliseconds = 0;
    SystemTimeToFileTime(&st, &ft);

    LOG3("CT %d/%.2d/%.2d", st.wYear, st.wMonth, st.wDay);
    LOG3(" %.2d/%.2d/%.2d", st.wHour, st.wMinute, st.wSecond);
    LOG2(" %.8x %.8x\n", ft.dwHighDateTime, ft.dwLowDateTime);

    LOG2("DIFF %.8x %.8x\n", diff.dwHighDateTime, diff.dwLowDateTime);
    FTADD(ft, diff);
    FileTimeToSystemTime(&ft, &st);

    LOG3("PT %d/%.2d/%.2d", st.wYear, st.wMonth, st.wDay);
    LOG3(" %.2d/%.2d/%.2d", st.wHour, st.wMinute, st.wSecond);
    LOG2(" %.8x %.8x\n", ft.dwHighDateTime, ft.dwLowDateTime);

    reg[5] = BCD(uint8(st.wYear % 100));
    reg[4] = st.wMonth * 16 + st.wDayOfWeek;
    reg[3] = BCD(uint8(st.wDay));
    reg[2] = BCD(uint8(st.wHour));
    reg[1] = BCD(uint8(st.wMinute));
    reg[0] = BCD(uint8(st.wSecond));
}
#endif

// ---------------------------------------------------------------------------
//  Ԑݒ
//
#define BCDTOI(i)   ((i >> 4) * 10 + (i & 0x0f))

#ifdef __OS2__
void Calender::SetTime()
{
}
#else
void Calender::SetTime()
{
    GetLocalTime(&st);

    nt.wYear = (cmd & 0x80) ? 1900+BCDTOI(reg[5]) : st.wYear;
    if (nt.wYear < 1980)
        nt.wYear += 100;
    nt.wMonth  = reg[4] >> 4;
    nt.wDay    = BCDTOI(reg[3]);
    nt.wHour   = BCDTOI(reg[2]);
    nt.wMinute = BCDTOI(reg[1]);
    nt.wSecond = BCDTOI(reg[0]);

    SystemTimeToFileTime(&st, &sft);

    LOG3("CT %d/%.2d/%.2d", st.wYear, st.wMonth, st.wDay);
    LOG3(" %.2d/%.2d/%.2d", st.wHour, st.wMinute, st.wSecond);
    LOG2(" %.8x %.8x\n", sft.dwHighDateTime, sft.dwLowDateTime);

    LOG3("NT %d/%.2d/%.2d", nt.wYear, nt.wMonth, nt.wDay);
    LOG3(" %.2d/%.2d/%.2d", nt.wHour, nt.wMinute, nt.wSecond);

    SystemTimeToFileTime(&nt, &nft);
    FTSUB(nft, sft);
    diff = nft;

    LOG2(" %.8x %.8x\n", nft.dwHighDateTime, nft.dwLowDateTime);
    LOG2("DIFF = %.8x %.8x\n", diff.dwHighDateTime, diff.dwLowDateTime);
}
#endif
// ---------------------------------------------------------------------------
//  device description
//
const Device::Descriptor Calender::descriptor = { indef, outdef };

const Device::OutFuncPtr Calender::outdef[] =
{
#ifndef __OS2__
    static_cast<OutFuncPtr> (Reset),
    static_cast<OutFuncPtr> (Out10),
    static_cast<OutFuncPtr> (Out40),
#else
    (Device::OutFuncPtr) (Reset),
    (Device::OutFuncPtr) (Out10),
    (Device::OutFuncPtr) (Out40),
#endif
};

const Device::InFuncPtr Calender::indef[] =
{
#ifndef __OS2__
    static_cast<InFuncPtr> (In40),
#else
    (Device::InFuncPtr) (In40),
#endif
};

