// ---------------------------------------------------------------------------
//  M88 - PC-88 Emulator.
//  Copyright (C) cisc 1998.
// ---------------------------------------------------------------------------
//  PD8257 (uPD8257) ̃G~[V
// ---------------------------------------------------------------------------
//  $Id: pd8257.cpp,v 1.7 1999/03/21 01:41:28 cisc Exp $

#include "headers.h"
//#include <stdio.h>
#include "pc88/pd8257.h"
#include "misc.h"

//#define LOGNAME   "pd8257"
#include "diag.h"

using namespace PC8801;

#ifdef __OS2__
inline int Min(int x, int y) { return (x < y) ? x : y; }
#endif

// ---------------------------------------------------------------------------
//  \z/
// ---------------------------------------------------------------------------

PD8257::PD8257(const ID& id)
: Device(id)
{
    memory = 0;
    mbegin = 0;
    mend = 0;
    Reset();
}

PD8257::~PD8257()
{
}

// ---------------------------------------------------------------------------
//  ڑ
//  arg:    mem     ڑ郁
//          addr    ̃AhX
//          length  ̒
//
bool PD8257::Connect(uint8* mem, uint addr, uint length)
{
    if (addr+length <= 0x10000)
    {
        memory = mem;
        mbegin = addr;
        mend = addr + length;
        LOG2("Connect %.4x - %.4x bytes\n", addr, length);
        return true;
    }
    else
        memory = 0;
    return false;
}

// ---------------------------------------------------------------------------
//  Reset
//
void PD8257::Reset(uint,uint)
{
    ff = false;
    enabled = 0;
    status = 0;
    for (int i=0; i<4; i++)
    {
        addr[i] = 0;
        count[i] = 0;
        mode[i] = 0;
    }
}

// ---------------------------------------------------------------------------
//  AhXWX^Zbg
//
void PD8257::SetAddr(uint d, uint p)
{
    int bank = (d / 2) & 3;
    if (!ff)
        addr[bank] = (addr[bank] & 0xff00) | p;
    else
        addr[bank] = (addr[bank] & 0x00ff) | (p << 8);
    ff = !ff;
    LOG2("Bank %d: addr  = %.4x\n", bank, addr[bank]);
}

// ---------------------------------------------------------------------------
//  JE^WX^Zbg
//
void PD8257::SetCount(uint d, uint p)
{
    int bank = (d / 2) & 3;
    if (!ff)
        count[bank] = (count[bank] & 0xff00) | p;
    else
    {
        mode[bank] = p & 0xc0;
        count[bank] = (count[bank] & 0x00ff) | ((p & 0x3f) << 8);
    }
    ff = !ff;
    LOG3("Bank %d: count = %.4x  flag = %.4x\n", bank, count[bank] & 0x3fff, count[bank] & 0xc000);
}

// ---------------------------------------------------------------------------
//  [hWX^Zbg
//
void PD8257::SetMode(uint,uint d)
{
    autoinit = (d & 0x80) != 0;
    if (autoinit)
    {
        addr[3] = addr[2];          // ł̂...
        count[3] = count[2];
    }

    enabled = (uint8) (d & 15);

    status &= ~enabled;
    for (int i=0; i<4; i++)
    {
        if (d & (1 << i))
            ptr[i] = addr[i];
    }
    ff = false;
}

// ---------------------------------------------------------------------------
//  AhXWX^ǂݍ
//
uint PD8257::GetAddr(uint p)
{
    int bank = (p / 2) & 3;
    ff = !ff;
    if (ff)
        return addr[bank] & 0xff;
    else
        return (addr[bank] >> 8) & 0xff;
}

// ---------------------------------------------------------------------------
//  JE^WX^ǂݍ
//
uint PD8257::GetCount(uint p)
{
    int bank = (p / 2) & 3;
    ff = !ff;
    if (ff)
        return count[bank] & 0xff;
    else
        return ((count[bank] >> 8) & 0x3f) | mode[bank];
}

// ---------------------------------------------------------------------------
//  Xe[^X擾
//
inline uint PD8257::GetStatus(uint)
{
    ff = false;
    return status;
}

// ---------------------------------------------------------------------------
//  PD8257 ʂăǂݍ
//  arg:bank    DMA oN̔ԍ
//      data    ǂݍރf[^̃|C^
//      nbytes  ]TCY
//  ret:        ]łTCY
//
uint PD8257::RequestRead(uint bank, uint8* data, uint nbytes)
{
    uint n = nbytes;
    if ((enabled & (1 << bank)) && !(mode[bank] & 0x40))
    {
        while (n>0)
        {
            uint size = Min(n, count[bank]+1);
            if (!size)
                break;

            if (memory && mbegin <= ptr[bank] && ptr[bank] < mend)
            {
                // ݂郁̃ANZX
                size = Min(size, mend - ptr[bank]);
                memcpy(data, memory + ptr[bank] - mbegin, size);
//              LOG3("READ ch[%d] (%.4x - %.4x bytes)\n", bank, ptr[bank], size);
            }
            else
            {
                // ݂Ȃւ̃ANZX
                if (ptr[bank] - mbegin)
                    size = Min(size, mbegin - ptr[bank]);
                else
                    size = Min(size, 0x10000 - ptr[bank]);

                memset(data, 0xff, size);
            }

            ptr[bank] = (ptr[bank] + size) & 0xffff;
            count[bank] -= size;
            if (count[bank] < 0)
            {
                if (bank == 2 && autoinit)
                {
                    ptr[2] = addr[3];
                    count[2] = count[3];
                    LOG3("DMA READ: Bank%d auto init (%.4x:%.4x).\n", bank, addr[2], count[2]+1);
                }
                else
                {
                    status |= 1 << bank;        // TC
                    LOG1("DMA READ: Bank%d end transmittion.\n", bank);
                }
            }
            n -= size;
        }
    }
    return nbytes - n;
}

// ---------------------------------------------------------------------------
//  Device descriptor
//
const Device::Descriptor PD8257::descriptor =
{
    indef, outdef
};

const Device::OutFuncPtr PD8257::outdef[] =
{
#ifndef __OS2__
    static_cast<OutFuncPtr> (Reset),
    static_cast<OutFuncPtr> (SetAddr),
    static_cast<OutFuncPtr> (SetCount),
    static_cast<OutFuncPtr> (SetMode),
#else
    (Device::OutFuncPtr) (Reset),
    (Device::OutFuncPtr) (SetAddr),
    (Device::OutFuncPtr) (SetCount),
    (Device::OutFuncPtr) (SetMode),
#endif
};

const Device::InFuncPtr PD8257::indef[] =
{
#ifndef __OS2__
    static_cast<InFuncPtr> (GetAddr),
    static_cast<InFuncPtr> (GetCount),
    static_cast<InFuncPtr> (GetStatus),
#else
    (Device::InFuncPtr) (GetAddr),
    (Device::InFuncPtr) (GetCount),
    (Device::InFuncPtr) (GetStatus),
#endif
};

