// ---------------------------------------------------------------------------
//  M88 - PC-8801 emulator
//	Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//	$Id: config.h,v 1.12 1999/06/29 15:39:46 cisc Exp $

#ifndef pc88_config_h
#define pc88_config_h

#include "types.h"

// ---------------------------------------------------------------------------

namespace PC8801
{

class Config
{
public:
	enum BASICMode
	{
		// bit0 H/L
		// bit1 N/N80 (bit5=0)
		// bit4 V1/V2
		// bit5 N/N88
		N80 = 0x00, N802 = 0x02, 
		N88V1 = 0x20, N88V1H = 0x21, N88V2 = 0x31, 
	};
	enum KeyType
	{
		AT106=0, PC98=1
	};
	enum CPUType
	{
		ms11 = 0, ms21, msauto,
	};

	enum Flags
	{
		subcpucontrol	= 1 <<  0,	// Sub CPU ̋쓮𐧌䂷
		savedirectory	= 1 <<  1,	// NɑOĨfBNgɈړ
		fullspeed		= 1 <<  2,	// S͓
		enablepad		= 1 <<  3,	// pbhL
		enableopna		= 1 <<  4,	// OPNA [h (44h)
		watchregister	= 1 <<  5,	// WX^\
		askbeforereset	= 1 <<  6,	// IEZbgɊmF
		enablepcg		= 1 <<  7,	// PCG ñtHgL
		fv15k			= 1 <<  8,	// 15KHz j^[[h
		cpuburst        = 1 <<  9,	// m[EFCg
		suppressmenu	= 1 << 10,	// ALT  GRPH 
		cpuclockmode	= 1 << 11,	// NbNPʂŐ؂ւ
		usearrowfor10	= 1 << 12,	// L[eL[
		swappadbuttons	= 1 << 13,	// pbh̃{^ւ
		disablesing		= 1 << 14,	// CMD SING 
		digitalpalette	= 1 << 15,	// fBW^pbg[h
		useqpc			= 1 << 16,	// QueryPerformanceCounter 
		force480		= 1 << 17,	// Sʂ 640x480 
		opnona8			= 1 << 18,	// OPN (a8h)
		opnaona8		= 1 << 19,	// OPNA (a8h)
		drawprioritylow	= 1 << 20,	// `̗Dx𗎂Ƃ
		disablef12reset = 1 << 21,  // F12  RESET ƂĎgpȂ(COPY L[ɂȂ)
		fullline		= 1 << 22,  // C\
		showstatusbar	= 1 << 23,	// Xe[^Xo[\
		showfdcstatus	= 1 << 24,	// FDC ̃Xe[^X\
		enablewait		= 1 << 25,	// Wait 
		enablemouse		= 1 << 26,	// Mouse gp
		mousejoymode	= 1 << 27,	// Mouse WCXeBbN[hŎgp
		specialpalette	= 1 << 28,	// fobNpbg[h
		mixsoundalways	= 1 << 29,	// d̍𑱂
		precisemixing	= 1 << 30,	// xȍs
	};
	enum Flag2
	{
		disableopn44	= 1 <<  0,	// OPN(44h) 𖳌 (V2 [h OPN)
		usewaveoutdrv	= 1 <<	1,	// PCM ̍Đ waveOut gp
	};

	int flags;
	int flag2;
	int clock;
	int speed;
	int refreshtiming;
	int mainsubratio;
	int opnclock;
	int sound;
	int nerams;
	int keytype;
	int volfm, volssg, voladpcm, volrhythm;
	int volbd, volsd, voltop, volhh, voltom, volrim;
	int dipsw;
	uint soundbuffer;
	uint mousesensibility;
	int cpumode;

	BASICMode basicmode;

	bool IsFV15k() const { return basicmode == N802 || (flags & fv15k); }
};

}

#endif // pc88_config_h
