// ----------------------------------------------------------------------------
//  M88 - PC-8801 series emulator
//  Copyright (C) cisc 1999.
// ----------------------------------------------------------------------------
//  CD-ROM C^[tF[X̎
// ----------------------------------------------------------------------------
//  $Id: cdif.cpp,v 1.1 1999/06/20 05:27:29 cisc Exp $

#include "headers.h"
#include "cdif.h"
#include "pd8257.h"

#define LOGNAME "cdif"
#include "diag.h"

using namespace PC8801;

// ----------------------------------------------------------------------------
//  \z
//
CDIF::CDIF(const ID& id)
: Device(id)
{
}

// ----------------------------------------------------------------------------
//  j
//
CDIF::~CDIF()
{
}

// ----------------------------------------------------------------------------
//  
//
bool CDIF::Init(PD8257* _dmac)
{
    dmac = _dmac;
    return true;
}

// ----------------------------------------------------------------------------
//  Zbg
//
void CDIF::Reset()
{
    LOG0("Reset!\n");
    status = 0;
    data = 0;
    cmdphase = -1;
    playmode = 0;
}

// ----------------------------------------------------------------------------
//  f[^
//
void CDIF::IO()
{
    if ((status & 0x38) == 0x10)
    {
        if (cmdphase == 1)
        {
            cmdbuf[cmdphase-1] = data;
            cmdlen = 1 + (data < 0x80 ? 5 : 9);
        }
        if (cmdphase <= cmdlen)
        {
            cmdbuf[cmdphase - 1] = data;
            if (cmdphase < cmdlen)
            {
                cmdphase ++;
            }
            else
            {
                status &= ~0x38;
                ProcessCommand();
            }
        }
    }
}

// ----------------------------------------------------------------------------
//  R}h
//
void CDIF::ProcessCommand()
{
    LOG1("<00> ", cmdbuf[0]);

    switch (cmdbuf[0])
    {
    case 0x00:
    default:
        LOG0("unknown\n");
        break;
    }
}
// ----------------------------------------------------------------------------
//  I/O
//
void CDIF::Out90(uint, uint d)
{
    LOG1("O[90] <- %.2x\n", d);
    if (d & 1)
    {
        if (data == 0x81)
        {
            LOG0("Command\n");
            status |= 1;
            status |= 0x40 | 0x10;
            cmdphase = 0;
        }
    }
    else
    {
        status &= ~1;
        if (cmdphase == 0)
        {
            cmdphase = 1;
            status = (status & ~0x78) | 0x80 | 0x50;
        }
    }
}

uint CDIF::In90(uint)
{
    LOG1("I[90] -> %.2x\n", status);
    return status;
}

// ----------------------------------------------------------------------------
//  f[^|[g
//
void CDIF::Out91(uint, uint d)
{
    LOG1("O[91] <- %.2x (DATA)\n", d);
    data = d;
    if (status & 0x80)
        IO();
}

void CDIF::Out94(uint, uint d)
{
    LOG1("O[94] <- %.2x\n", d);
    if (d & 0x80)
    {
        Reset();
    }
}

void CDIF::Out97(uint, uint d)
{
    LOG1("O[97] <- %.2x\n", d);
}


void CDIF::Out99(uint, uint d)
{
    LOG1("O[99] <- %.2x\n", d);
}

void CDIF::Out9f(uint, uint d)
{
    LOG1("O[9f] <- %.2x", d);
    enable = d & 1;
    LOG1("  CD-ROM drive %s.\n", enable ? "enabled" : "disabled");
}

uint CDIF::In91(uint)
{
    LOG1("I[91] -> %.2x\n", data);
    return data;
}

uint CDIF::In92(uint)
{
    LOG1("I[92] -> %.2x\n", 0);
    return 0;
}

uint CDIF::In93(uint)
{
    LOG1("I[93] -> %.2x\n", 0);
    return 0;
}

uint CDIF::In96(uint)
{
    LOG1("I[96] -> %.2x\n", 0);
    return 0;
}


uint CDIF::In99(uint)
{
    LOG1("I[99] -> %.2x\n", 0);
    return 0;
}

uint CDIF::In9b(uint)
{
    return 0;
}

uint CDIF::In9d(uint)
{
    return 0;
}

// ---------------------------------------------------------------------------
//  Đ[h
//
void CDIF::Out98(uint, uint d)
{
    LOG1("O[98] <- %.2x\n", d);
    playmode = d;
}

uint CDIF::In98(uint)
{
    clk = ~clk;

    uint r = (clk & 0x80) | (playmode & 0x7f);
    LOG1("I[98] -> %.2x\n", r);
    return r;
}

// ---------------------------------------------------------------------------
//  device description
//
const Device::Descriptor CDIF::descriptor = { indef, outdef };

const Device::OutFuncPtr CDIF::outdef[] =
{
#ifndef __OS2__
    static_cast<OutFuncPtr> (Out90),
    static_cast<OutFuncPtr> (Out91),
    static_cast<OutFuncPtr> (Out94),
    static_cast<OutFuncPtr> (Out97),
    static_cast<OutFuncPtr> (Out98),
    static_cast<OutFuncPtr> (Out99),
    static_cast<OutFuncPtr> (Out9f),
#else
    (Device::OutFuncPtr) (Out90),
    (Device::OutFuncPtr) (Out91),
    (Device::OutFuncPtr) (Out94),
    (Device::OutFuncPtr) (Out97),
    (Device::OutFuncPtr) (Out98),
    (Device::OutFuncPtr) (Out99),
    (Device::OutFuncPtr) (Out9f),
#endif
};

const Device::InFuncPtr CDIF::indef[] =
{
#ifndef __OS2__
    static_cast<InFuncPtr> (In90),
    static_cast<InFuncPtr> (In91),
    static_cast<InFuncPtr> (In92),
    static_cast<InFuncPtr> (In93),
    static_cast<InFuncPtr> (In96),
    static_cast<InFuncPtr> (In98),
    static_cast<InFuncPtr> (In99),
    static_cast<InFuncPtr> (In9b),
    static_cast<InFuncPtr> (In9d),
#else
    (Device::InFuncPtr) (In90),
    (Device::InFuncPtr) (In91),
    (Device::InFuncPtr) (In92),
    (Device::InFuncPtr) (In93),
    (Device::InFuncPtr) (In96),
    (Device::InFuncPtr) (In98),
    (Device::InFuncPtr) (In99),
    (Device::InFuncPtr) (In9b),
    (Device::InFuncPtr) (In9d),
#endif
};
