// ---------------------------------------------------------------------------
//  PC-8801 emulator
//  Copyright (C) cisc 1999.
// ---------------------------------------------------------------------------
//  $Id: base.cpp,v 1.10 1999/07/05 14:39:05 cisc Exp $

#include "headers.h"
//#include <assert.h>
#include "draw.h"
#include "pc88/base.h"
#include "pc88/pc88.h"
#include "pc88/config.h"
#include "status.h"

//#define LOGNAME "88base"
#include "diag.h"

using namespace PC8801;

// ---------------------------------------------------------------------------
//  \zEj
//
Base::Base(const ID& id)
: Device(id)
{
    port40 = 0;
    autoboot = true;
}

Base::~Base()
{
}

// ---------------------------------------------------------------------------
//  
//
bool Base::Init(PC88* pc88)
{
    pc = pc88;
    RTC();
    sw30 = 0xcb;
    sw31 = 0x79;
    sw6e = 0xff;
    pc->AddEvent(167, this, static_cast<TimeFunc>(RTC), 0, true);
    return true;
}

// ---------------------------------------------------------------------------
//  XCb`XV
//
void Base::SetSwitch(const Config* cfg)
{
    bmode = cfg->basicmode;
    clock = cfg->clock;
    dipsw = cfg->dipsw;
    flags = cfg->flags;
    fv15k = cfg->IsFV15k();
}

// ---------------------------------------------------------------------------
//  肹
//
void Base::Reset(uint, uint)
{
    port40 = 0xc0 + (fv15k ? 2 : 0) + ((dipsw & (1 << 11)) || !autoboot ? 8 : 0);
    sw6e = (sw6e & 0x7f) | ((!clock || Abs(clock) >= 60) ? 0 : 0x80);
    sw30 = 0xc0 | ((dipsw << 1) & 0x3e) | (bmode & 0x22 ? 1 : 0);
    sw31 = ((dipsw >> 5) & 0x3f) | (bmode & 1 ? 0x40 : 0) | (bmode & 0x10 ? 0 : 0x80);

    const char* mode;
    switch (bmode)
    {
    case Config::N80:    mode = "N"; break;
    case Config::N802:   mode = "N80"; break;
    case Config::N88V1:  mode = "N88-V1(S)"; break;
    case Config::N88V1H: mode = "N88-V1(H)"; break;
    case Config::N88V2:  mode = "N88-V2"; break;
    default: mode = "Unknown"; break;
    };
    statusdisplay.Show(100, 2000, "%s mode", mode);
}

// ---------------------------------------------------------------------------
//  Real Time Clock Interrupt (600Hz)
//
void Base::RTC(uint)
{
    pc->bus1.Out(PC88::pint2, 1);
//  LOG0("RTC\n");
}

// ---------------------------------------------------------------------------
//  Vertical Retrace Interrupt
//
void Base::VRTC(uint, uint en)
{
    if (en)
    {
        pc->UpdateScreen();
        pc->bus1.Out(PC88::pint1, 1);
        port40 |= 0x20;
//      LOG0("CRTC: Retrace\n");
    }
    else
    {
        port40 &= ~0x20;
//      LOG0("CRTC: Display\n");
    }
}

// ---------------------------------------------------------------------------
//  In
//
uint Base::In30(uint) { return sw30; }

uint Base::In31(uint) { return sw31; }

uint Base::In40(uint) { return IOBus::Active(port40, 0xef); }

uint Base::In6e(uint) { return sw6e | 0x7f; }

// ---------------------------------------------------------------------------
//  device description
//
const Device::Descriptor Base::descriptor = { indef, outdef };

const Device::OutFuncPtr Base::outdef[] =
{
#ifndef __OS2__
    static_cast<OutFuncPtr> (Reset),
    static_cast<OutFuncPtr> (VRTC),
#else
    (Device::OutFuncPtr) (Reset),
    (Device::OutFuncPtr) (VRTC),
#endif
};

const Device::InFuncPtr Base::indef[] =
{
#ifndef __OS2__
    static_cast<InFuncPtr> (In30),
    static_cast<InFuncPtr> (In31),
    static_cast<InFuncPtr> (In40),
    static_cast<InFuncPtr> (In6e),
#else
    (Device::InFuncPtr) (In30),
    (Device::InFuncPtr) (In31),
    (Device::InFuncPtr) (In40),
    (Device::InFuncPtr) (In6e),
#endif
};
