// ---------------------------------------------------------------------------
//	Z80 emulator for x86/VC5.
//	Copyright (C) cisc 1997, 1999.
// ---------------------------------------------------------------------------
//	$Id: Z80_x86.h,v 1.8 1999/06/28 12:08:26 cisc Exp $

#ifndef z80_x86_h
#define z80_x86_h

#include "device.h"
#include "Z80.h"

// ---------------------------------------------------------------------------

class Z80_x86 : public Device
{
public:
	enum
	{
		reset = 0, irq, nmi,
	};

public:
	Z80_x86(const ID& id);
	~Z80_x86();

	bool Init(Bus* bus, int iack);
	
	int Exec(int clocks);
	int ExecOne();
	static int __stdcall ExecSingle(Z80_x86* first, Z80_x86* second, int clocks);
	static int __stdcall ExecDual(Z80_x86* first, Z80_x86* second, int clocks);
	static int __stdcall ExecDual2(Z80_x86* first, Z80_x86* second, int clocks);
	void Stop(int clocks);
	static void StopDual(int clocks);
	static int GetCCount();
	int GetCount();
	void TestIntr();
	static int GetCurrentCPUID();
	
	void Reset(uint=0, uint=0);
	void IRQ(uint, uint d);
	void NMI(uint=0, uint=0);
	void Wait(bool);

	uint GetPC() { return (uint) inst + (uint) instbase; }
	void SetPC(uint n) { inst = (uint8*)n; instbase = 0; instpage = (uint8*)-1; instlim = 0; }
	Z80Reg& GetReg() { return reg; }

	MemoryBus::Page* GetPages() { return pages; }
	const Descriptor* GetDesc() const { return &descriptor; }
	bool IsIntr() { return !!intr; }

	uint GetStatusSize() { return sizeof(CPUState); }
	bool LoadStatus(void* status);
	bool SaveStatus(void* status);

private:
	typedef MemoryBus::Page Page;
	enum
	{
		pagebits   = MemoryBus::pagebits,
		idbit      = MemoryBus::idbit,
	};
	struct CPUState
	{
		Z80Reg reg;
		uint8 intr;
		uint8 waitstate;
		uint8 flagn;
	};

private:
	Z80Reg reg;
	uint8* inst;
	uint8* instbase;
	uint8* instlim;
	uint8* instpage;
	uint   instwait;
	const IOBus::InBank* ins;
	const IOBus::OutBank* outs;
	const uint8* ioflags;
	
	uint8 intr;
	uint8 waitstate;
	uint8 flagn;
	uint8 eshift;

	uint execcount;
	int stopcount;
	int delaycount;
	int clockcount;
	int intack;
	int startcount;

	Page pages[0x10000 >> MemoryBus::pagebits];
	
	static const Descriptor descriptor;
	static const OutFuncPtr outdef[];
	static Z80_x86* currentcpu;
};

// ---------------------------------------------------------------------------

inline int Z80_x86::GetCount()
{
	return execcount + (clockcount << eshift); 
}

#endif // z80_x86_h
