.**********************************************************
.*
.* IPF for ColEm/2
.*
.**********************************************************
:userdoc.
:title.ColEm/2 Ver 1.0.0 released September 10, 2000
.*
.**********************************************************
.*
:h1.About ColEm/2

:p.
ColEm is a portable emulator of the old ColecoVision game console, written in C by Marat Fayzullin.
You can play most Coleco games with it.  The latest news, code and binaries for ColEm can be found at the ColEm Homepage&colon.
.br
:hp4.http&colon.//www.komkon.com/fms/ColEm/:ehp4.
:p.
ColEm/2 is the OS/2 version, ported by Darrell Spice Jr.
ColEm/2 can be found at the SpiceWare Homepage(along with other emulators for OS/2) at&colon.
.br
:hp4.http&colon.//home.houston.rr.com/spiceware:ehp4.
:p.
If you are having problems with ColEm/2 please visit the SpiceWare Homepage and
make sure you're running the lastest release before sending mail. OS/2 version
comments should be mailed to Darrell at :hp4.dspice@houston.rr.com:ehp4..
.*
.**********************************************************
.*
:h1.What's New
:p.
New features in version 1.0.0 of ColEm/2.
:ul.
:LI.Migrated OS/2 source to current core release
:li.Improved throttle routine for faster machines
:li.New status box, title bar no longer used for status info
:li.ColEm File Selection Dialog now starts out in the ROMS directory, if present.
:li.Joystick routines now save calibration info in :hp4.COLEM.INI:ehp4. file
:eul.
.*
.**********************************************************
.*
:h1.Installation
:p.
To install ColEm/2, just unzip the archive in your OS/2 games directory.  The directory :hp4.COLEM:ehp4. will
be created, along with the files and proper subdirectories.
:p.
You may install ColEm/2 in a directory (or path) that containes spaces, such as :hp4.D&colon.\OS2 Games\ColEm:ehp4., without any problems.
.*
.**********************************************************
.*
:h1.Running ColEm/2
:p.
Run ColEm/2 as you would any other program.
:p.
After starting ColEm/2, a title screen will show for a few seconds.  Next a file open dialog will be displayed so that a cartridge can be selected for
play.  Cartridges are located in the ROMS directory. Install any additional cartridge images you wish here.
:p.
ColEm/2 may also be started by dropping a cartridge onto it's icon.  In this case, the file open dialog will not appear.
.*
.**********************************************************
.*
:h1.ROM Images
:p.
ColEm/2 requires at least 2 ROM images to function.  The Coleco BIOS ROM and game cartridge ROM.
:h2.Coleco ROM
:p.
ColEm requires a copy of the Coleco BIOS.  It must be located
in the same directory as :hp4.colem.exe:ehp4..  I've included Kevin Horton's
modified Coleco BIOS because the startup delay can be bypassed by hitting the joystick
firebutton.  It also features a new font.
:h2.Game ROMs
:p.
Please note that ROM images have a copyright.  You should only download games
that you already own.  Do not bother to ask the authors of ColEm where
game images may be found, you will not get a reply.
:p.
The ROM images for :hp1.Star Fortress:ehp1. and :hp1.Purple Dinosaur Massacre:ehp1. are included with
 ColEm/2, courtesy of their author John Dondzila.
:p.
The file extension of the ROM images should be .ROM but this is not manditory.
:p.
After starting ColEm/2, a file open dialog will be displayed so that a
cartridge can be selected for play.  Of course, if you drop a cartridge onto
ColEm/2 to start it, the open dialog will not be displayed. There are a couple ways to obtain a ROM image:
:ol.
:li.It's possible to build a device that plugs into the printer port
of a PC and reads the data off the cartridge (See the ColEm home
page for more information)
:li.Search around the net and find some ROM images to download.  Other new, freely available games
like John Dondzila's, have been written and are available online.
:eol.
:note.Cartridges images are located in the ROMS directory, so don't mistakenly load the COLECO.ROM and expect to play a game! &colon.-)
:hp8.:warning.
It is illegal to have ROM images of games that you do not
actually own!
:ewarning.:ehp8.
.*
.**********************************************************
.*
:h1.Sound
:p.
The only requirement for sound support is MMPM/2, DART
is not required.  Sound support does impose a performance penalty.  It may be desirable to turn it
off on slower systems.  Sound can be disabled by turning off the volume in the
:link reftype=hd viewport dependent res=103.
settings dialog.
:elink.
.*
.**********************************************************
.*
:h1.DIVE
:p.
ColEm/2 requires your video card to support DIVE.
:note. If the colors are incorrect, or the game image is offset you may need to either
disable EnDIVE support, such as with a Matrox Millenium card, or update your video drivers.
.*
.**********************************************************
.*
:h1.Menu Bar
:p.
The menu bar allows you to select options for ColEm/2.
:p.
:artwork align=center name='titlescreen.bmp'.
:artlink.
:link reftype=hd viewport dependent res=203 x=131 y=220 cx=32 cy=32.
:link reftype=hd viewport dependent res=202 x=95 y=220 cx=32 cy=32.
:link reftype=hd viewport dependent res=201 x=42 y=220 cx=31 cy=32.
:link reftype=hd viewport dependent res=200 x=6 y=220 cx=32 cy=32.
:eartlink.
:p.
Select the buttons to view what they do.
:h2 res=200.New Game
:p.
:artwork name='mng.bmp'.
:p.
Brings up cartridge selection dialog.  The button represents a stack of game cartridges.
:Note. Games may also be drag and dropped onto ColEm/2
:h2 res=201.ColEm/2 Settings
:p.
:artwork name='mdb.bmp'.
:p.
Brings up the
:link reftype=hd viewport dependent res=103.
settings dialog
:elink.
for ColEm/2.
:h2 res=202.Cartridge Help
:p.
:artwork name='mch.bmp'.
:p.
Call up online help for current game cartridge.
:note.In order for this to work, you must have the game documentation stored in
the DOCS directory as specified in the
:link reftype=hd viewport dependent res=102.
Online Documentation
:elink.
section.
:h2 res=203.ColEm/2 Help
:p.
:artwork name='msh.bmp'.
:p.
Calls up the documentation which you are currently reading.
.*
.**********************************************************
.*
:h1 res=103.Settings Dialog
:p.
:artwork align=center name='settings.bmp'.
:artlink.
:link reftype=hd viewport dependent res=212 x=237 y=47 cx=215 cy=248.
:link reftype=hd viewport dependent res=211 x=5 y=47 cx=216 cy=182.
:link reftype=hd viewport dependent res=210 x=5 y=238 cx=216 cy=54.
:eartlink.
:p.
The settings dialog lets you control various aspects of ColEm.  This display
shows the default settings for the parameters.  The settings are saved when
you exit ColEm/2 in the file :hp4.COLEM.INI:ehp4..  Select any area for more information.
:p.
The :hp4.OK:ehp4. button
will save the changes, :hp4.Cancel:ehp4. will ignore the changes (except for joystick
recalibration), and :hp4.Help:ehp4. will bring you to this section of the help file.
:h2 res=210.Joystick Settings
:p.
The joystick calibration information will be reset by selecting the recalibrate button.
Once back in ColEm the joystick will need to be moved to all 4 corners to complete
the recalibration process.
:h2 res=211.Audio Settings
:p.
:hp4.Enabled:ehp4. controls weither sound is used or not.  By selecting :hp1.off:ehp1.
the sound support routines are disabled and will no longer use up any CPU time.  This may be desirable on slower systems.
:p.
:hp4.Frequency:ehp4. controls the playback frequency used by ColEm.  The higher
the frequency the better the sound and the more CPU time required by the emulator.
If you have a slower system, you may choose a lower frequency instead of turning off
sound support.
:p.
:hp4.Buffer Size:ehp4. sets the size of the audio buffer.  If it's set too small
there will be noticable distortion in the sound.  If it's too large then rapidly
changing sound effects may not be heard.
:h2 res=212.Video Settings
:p.
:hp4.System:ehp4. sets ColEm/2 for NTSC or PAL frame rates.  NTSC runs at 60fps
while PAL runs at 50fps.
:p.
:hp4.Frames Per Second:ehp4. sets the inital frame rate as well as the minimum and maximum
frame rates that ColEm will be allowed to shoot for.  It may take a few seconds for
the emulation to settle out after changing these settings.
:p.
:hp4.Initial Window Size:ehp4. allows you to select the size of ColEm's window.

.*
.**********************************************************
.*
:h1 res=102.Online Game Documentation
:p.
Support for online documention is part of the OS/2 version of ColEm.  For this
feature to function, there must be a text doc file for the game located in the DOCS
subdirectory of the COLEM directory.  If the file is not present a warning dialog
will appear.

:p.
The filename must be the same as the cartridge filename
loaded, with a .DOC extension replacing the .ROM extension.
Doc files are currently displayed using the 'E' editor in OS/2.
They are best viewed using a non-proportional font such as SYSTEM VIO, SYSTEM
MONOSPACED, or COURIER.  Proportional fonts may cause game instructions to
be difficult to read. The directory structure is as follows:
:xmp.
&dot.&dot.&dot.(path)&dot.&dot.&dot.\COLEM\DOCS\STARFORT.DOC
            |    |PDM.DOC
            |    |ZAXXON.DOC*
            |     etc.
            |
            \ROMS\STARFORT.ROM
            |    |PDM.ROM
            |    |ZAXXON.ROM*
            |     etc.
            |
            |colem.exe
            |colem.inf
            |colem.ini
            |joystick.clb
            |etc.
:exmp.

* denotes user installed files
.*
.**********************************************************
.*
:h1.Frame Rate Routines
:p.
The frame rate routines work by establishing a target frame rate, dependent
upon the performance of your hardware.  Your CPU speed, Video Hardware performance, and the use
of sound support all directly effect the performance of ColEm/2.
:p.
Instead of the traditional show 1 skip n,
the routines in the OS/2 version of ColEm are :hp1.how many frames to skip out of 16.:ehp1.
This gives a more even spread in the target frame rates.  For instance, under the traditional method
the target frame rates for NTSC are 60, 30, 20, 15, 12, 10, 9, 8, 7, and 6fps.  The
new target frame rates are for NTSC are 60, 56, 53, 49, 45, 41, 38, 34, 30, 26, 23, 19, 15,
11, 8, and 4fps.
For PAL the new target rates are 50, 47, 44, 41, 38, 34, 31, 28, 25, 22, 19, 16, 13, 9, 6, and 3.
Note the big difference in the values between 60 and 30 for each method, the better spread of rates helps performance on faster machines.
:p.
The auto-adjustment mode of the frame rate routines are on by default.
When in auto-adjust mode, ColEm/2 will analyze the performance of your system
once per second, and adjust the target frame rate accordingly.  By using the
<-/_> and <+/=> keys or the
:link reftype=hd viewport dependent res=103.
settings dialog
:elink.
, you can set the minimum target skip rate.  The maximum target skip rate can also be set in the
:link reftype=hd viewport dependent res=103.
settings dialog.
:elink.
This allows you to make ColEm/2 use less than 100% of the CPU.
:p.
By pressing <A> you can toggle the auto adjust mode on or off.  When off, use the
<-/_> and <+/=> keys to manually set your target frame rate.
:p.
Faster machines may exceed 60 (or 50) fps.  If this happens, ColEm/2 will activate throttle routines so that
the game play is not too fast.  The throttle may take a little bit of time to slow the game down.
:note.If the emulation achieves its target frame rate, even if it's not 60 (or 50) fps, then
ColEm/2 is running at 100% the speed of a real ColecoVision game system.
.*
.**********************************************************
.*
:h1 res=101.Status Box
:p.
The Status Box shows the performance information of ColEm/2
The performance information shows the current frame rate, target rate, minimum
target rate, % speed of a real Coleco system, and window resolution.
:p.
For example, if the following is shown:
:xmp.
29fps 30tA 4m 98% 256 x 192
:exmp.
Then ColEm/2 is currently achieving 29 frames per second, with a target of
30 fps, Auto adjust is turned on(the A following the 30t), a minimum target
rate of 4fps, running at 98% the speed of a real Coleco, with a window resolution
of 256 x 192.
:p.
:p.
If you have a fast enough machine, the throttle routines will become active.
The text will change slightly to denote this.
The status line will instead show current frame rate, throttle value, % speed of a real
Coleco, and window resolution.
:p.
Throttle active example:
:xmp.
60fps 2TA 100% 512 x 384
:exmp.
This shows that ColEm/2 is currently achieving 60 frames per second, with a
throttle rate of 2, Auto adjust is turned on(the A following the 2T)running at
100% the speed of a real Coleco, with a window resolution of 512 x 384.
.*
.**********************************************************
.*
:h1.Controllers
:p.
Since you cannot directly plug in Coleco style controllers to a
PC, different ways of obtaining values for the Joystick
are implemented in ColEm/2.
:p.
PC style joysticks can emulate the Coleco joysticks.
:p.
The keyboard can emulate the Joysticks as well as provide control of ColEm/2.
The keyboard always emulates the Coleco controller numeric pad.
.**********************************************************
.*
:h2.Joysticks
:p.
Joystick support requires the joystick divers to be loaded.  If your system
does not already have the drivers installed, unzip the joystick.zip archive
included with ColEm/2, and run install.cmd.  Your system will need to be rebooted
after installing the drivers for them to work.
:p.
The joysticks will calibrate themselves as the games are played.  ColEm/2
uses the SpiceWare Joystick Routines(freely available on the SpiceWare homepage at
:hp4.http&colon.//home.houston.rr.com/spiceware:ehp4.
for those OS/2 programmers
out there!), and will save the calibration information in the COLEM.INI file
so it can be reloaded.  If you ever change joysticks, or wish to recalibrate
the ones you have, use the Recalibrate option in the
:link reftype=hd viewport dependent res=103.
settings dialog.
:elink.
:note.By using the keyboard controls, ColEm/2 can be used without joysticks.
.*
.**********************************************************
.*
:h2.Keyboard
:p. The keyboard is mapped to emulate the switches and controllers of the Master System/Game Gear.
:xmp.
CNTL-1  Set Screen To 256 x 192
CNTL-2 thru CNTL-9 - multiply the base window size by the number pressed
(the window may also be scaled to any size,
 just grab &amp. move the window borders)


<ESC>   Quit ColEm/2
N       Load a new game (or drag and drop ROM images onto window)
P       Pause toggle
O       Display/Hide Oscilloscope


FRAME SKIP ADJUSTMENT:
A       Toggle Auto Frame Rate Adjustment option on/off
- _     Either 1) decrease miminum target frame rate or
               2) decrease target rate
= +     Either 1) increase minimum target frame rate or
               2) increase target rate
        option 1 happens if the auto frame rate adjustment option is on


JOYSTICKS&colon.
Cursor Pad - Player 1's Joystick
&dot. > #   Player 1's Fire Button 1
/ ?     Player 1's Fire Button 2
0-9     Player 1's keypad (on numeric keypad)
* .     Player 1's keypad key * (on numeric keypad)
- Enter Player 1's keypad key # (on numeric keypad)


T       Player 2's Joystick UP
F       Player 2's Joystick Left
G       Player 2's Joystick Down
H       Player 2's Joystick Right
Z       Player 2's Fire Button 1
X       Player 2's Fire Button 2
0-9     Player 2's keypad (on row above letters)
Q       Player 2's keypad key *
W       Player 2's keypad key #

:exmp.
.*
.**********************************************************
.*
:h1.Known Problems
:p.
:ul.
:li.Some game appear to hang when you run out of lives.  Hit
ENTER or RETURN and the game will restart.
:li.Not all games work properly - emulation is not 100%, sorry &colon.-)
:eul.
.*
.**********************************************************
.*
:h1.Acknowledgements
:p.
The following people have had a part in bringing ColEm to you:
:table cols='17 50'.
:row.
:c.John Dondzila
:c.Allowed :hp1.Star Fortress:ehp1. and :hp1.Purple Dinosaur Massacre:ehp1. to be included with ColEm/2
:row.
:c.Marat Fayzullin
:c.Maintained the core code, and the DOS and Unix versions
:row.
:c.Tim Fisken
:c.SVGALib drivers for Linux
:row.
:c.Gareth Moore
:c.Maintained the Acorn version
:row.
:c.Darrell Spice Jr.
:c.Maintained the OS/2 version
:row.
:c.Ian Spielman
:c.Improved Unix/X drivers
:row.
:c.John Stiles
:c.Maintained the MacIntosh version
:etable.
.*
.**********************************************************
.*
:h1.ColEm/2 Version History
:p.
:ul.
:li.:hp4.Version 1.0.0 released September 10, 2000:ehp4.
:ol.
:LI.Migrated OS/2 source to current core release
:li.Improved throttle routine for faster machines
:li.New status box, title bar no longer used for status info
:li.ColEm File Selection Dialog now starts out in the ROMS directory, if present.
:li.Joystick routines now save calibration info in :hp4.COLEM.INI:ehp4. file
:eol.
:li.:hp4.Version 0.4.3 released September 30, 1997:ehp4.
:ol.
:li.ColEm/2 Help is now in the OS/2 standard format.
:li.TV rate setting for PAL or NTSC frame rates.
:li.Master Volume control setting.
:li.Fixed size of display window - should have been multiples of 256 x 192 NOT
272 x 208. This increased the frame rate on my system by 20%.
:li.Added control panel and removed run-time parameters
:li.ColEm/2 Help and Game Documentation support now work correctly when the path to the file contains a space.
:eol.
:li.:hp4.Version 0.4.2 released May 11, 1997:ehp4.
:ol.
:li.Version numbering scheme changed to match MasterGear/2.
:li.Tweaked colors to look better.
:li.Added Sound Support.
:li.Added an oscilloscope for sound routines.
:li.Added the updated SpiceWare Joystick Routines which fix a few problems that
occur when 0 or 1 joysticks are plugged in.
:li.Fixed the screen-redraw of a non-active game window.  Used to leave fragments
of other windows on the game screen.
:eol.
:li.:hp4.Version 0.41 released March 15, 1997:ehp4.
:ol.
:li.Improved performance over 100%
:li.New frame rate throttle routines added.
:li.Added menu bar w/New Game, Game Help, and ColEm help options.
:li.No longer reset frame rate info between games.  Unlike Stella, ColEm frame
rates are fairly consistant between the different games cartridges.
:li.Updated keyboard interface so that the numeric keys could be read when there is
a joystick reading.
:li.Updated keyboard mapping to support both player's numeric keypads. Player 1
uses the numeric keypad, player 2 uses the numeric keys above qwerty.
:eol.
:li.:hp4.Version 0.4 released February 16, 1997:ehp4.
:ol.
:li.initial release of ColEm for OS/2
:eol.
:eul.
.*
.**********************************************************
.*
:h1.ColEm/2 To Do list
:p.
The To Do's are not listed in any order.
:ul.
:li.Add support for Full Screen Display (either Full Screen DIVE or the SciTech MGL routines).
:li.Migrate to SpiceWare EMU Core routines (will allow keyboard remapping and other things).
:eul.
:euserdoc.
