/* YEPuFOLD.CMD -- YEP URL log file to IBM Web Explorer Objects in folder.
 
 - please edit the line below to reflect the path/filename of your Log,
   or specify filename on command line. I.E. Yepufold url.log 
 
 - if the folder does not exist it is created on the desktop. After it 
   is created, you can move it to wherever you want it.
 - if you want to have multiple folders then edit the UrlFolder variable
   below-- perhaps make different copies of this script.
   
 - **WARNING** i'd be shocked to death if this works on FAT partitions.
   It shouldn't be dangerous to try... but be ready for error messages.
   
- The full entry of the URL capture is put in the COMMENTS for the object.
  To access this go to the Settings|File folder and click to page 3....
  It's messy, but all info is preserved... maybe can think of a better way.
  
*/


UrlFolder = 'Yep Urls'
UrlLog = 'c:\osu\yarn\url.log'

BetweenRecords = 1;
UrlNum = 0
URLS. = ''
Records = 0

Parse arg ln
if (ln \= '') then UrlLog = ln

Say 'Converting Yep Url Log to Web Explorer Objects in a folder...'

Call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs';
Call SysLoadFuncs;

FolderID = '<'||translate(UrlFolder,' ','_')||'>'
FolderPlace = '<WP_DESKTOP>'
FolderClass = 'WPFolder'

/* lets see if there's a log file before continuing! */
ret = stream(UrlLog,'c','open read')
if ret <> 'READY:' then do
    say 'Can not seem to be able to open "'UrlLog'" to read.'
    exit
end

/* try to make a folder in case it doesn't exist already */
ret = SysCreateObject(FolderClass, UrlFolder, FolderPlace,,
                      'OBJECTID='||FolderID, 'fail');

/* Hack to find path to desktop -- idea stolen from MakeUrl.cmd */
call SysIni 'BOTH', 'FolderWorkareaRunningObjects', 'ALL:', 'list.'
if result = 'ERROR:' then do
  say "Cannot find desktop??"
  exit
end
desktop = list.1;

/* why not give the folder a subject? Ever seen the Subject field used?! */
rc = SysPutEA(desktop||'\'||UrlFolder, '.SUBJECT',,
                   'FDFF'x||D2C(11)||'00'x||'Yep Url Log')

/* here we go... routines hacked from YEPuDUPE.cmd... reuse code! */
do while lines(UrlLog)<>0
    ln = linein(UrlLog)
    
    if (ln \= '') & (BetweenRecords = 1) then do
        BetweenRecords = 0;        
        RecordLines = 0
        Duplicate = 0
        Records = Records + 1
    end
    
    if (ln \= '') & (BetweenRecords = 0) & (duplicate = 0) then do
        RecordLines = RecordLines + 1
        Arecord.RecordLines = ln
        if SubStr(ln,1,4) == 'URL:' then do
            do x = 1 to UrlNum 
                if URLS.x = ln then Duplicate = 1
            end
            if Duplicate = 0 then do
                UrlNum = UrlNum + 1
                URLS.UrlNum = ln
            end            
        end
    end

    if (ln == '') & (BetweenRecords = 0) then do
        betweenRecords = 1;
        if Duplicate = 0 then do
            TheUrl = word(Urls.UrlNum,2)
            fnUrl = Translate(TheUrl,'!','/')
            fnUrl = Translate(fnUrl,'!',':')
            UrlFile = desktop||'\'||UrlFolder||'\'||fnUrl
            ret = SysCreateObject('WebExplorer_Url', TheUrl,,
                                   desktop||'\'||UrlFolder,,'replace');
            if ret = 1 then do
                rc = charout(UrlFile,TheUrl);
                if rc <> 0 then say 'Couldn''t write to 'fnUrl
                rc = stream(UrlFile,'c','close')
                
                /* create COMMENT and TITLE */
                ln = ''
                ea = 'DFFF'x||'00'x||'00'x||D2C(RecordLines)||'00'x
                if length(ea)<256 then do
                    do x = 1 to RecordLines
                        ea = ea||'FDFF'x||D2C(Length(Arecord.x))||'00'x||Arecord.x
                        
                        /* create title */
                        parse var Arecord.x what it_is
                        select
                            when what = 'From:' then do
                                if ln \= '' then ln = ln||d2c(13)||d2c(10)
                                ln = ln||it_is                                
                            end
                            when what = 'Newsgroups:' then do
                                if ln \= '' then ln = ln||d2c(13)||d2c(10)
                                ln = ln||it_is                                
                            end
                            when what = 'X-Newsgroups:' then do
                                if ln \= '' then ln = ln||d2c(13)||d2c(10)
                                ln = ln||it_is                                
                            end
                            when what = 'URL:' then do
                                if ln \= '' then ln = ln||d2c(13)||d2c(10)
                                ln = ln||it_is                                
                            end
                            otherwise
                        end
                    
                    end
                end
                
                
                /* fix title */
                lp = 1;
                do while lp>0 
                    lp = pos(',',ln,lp)
                    if lp>0 then do
                        insert('^',ln,lp)
                        lp = lp + 2                        
                    end
                end
                lp = 1;
                do while lp>0 
                    lp = pos(';',ln,lp)
                    if lp>0 then do
                        insert('^',ln,lp)
                        lp = lp + 2                        
                    end
                end
                
                
                /* update some EA's and stuff */
                rc = SysPutEA(UrlFile, ".SUBJECT",,
                   'FDFF'x||D2C(7)||'00'x||'Yep Url')
                rc = SysPutEA(UrlFile, ".COMMENTS", ea)                
                
                /* wish this didn't change the filename */
                /* trying to get the object title to have more data, but 
                 it's messing everything up, so have left it alone for now */
                
/*                say '=========='
                say ln
                say '----------'
                if ln \= '' then rc = SysPutEA(UrlFile, ".LONGNAME",,
 'FDFF'x||D2C(length(ln))||'00'x||ln)
                                         */
                say records||': '||TheUrl||' *ok*'
            end
            else say 'Couldn''t create to 'UrlFile
        end
        else say records||': '||theUrl||' *dupe*'
    end    
end

