/*
 * Copyright 2003, Dimitrios Bogiatzoules. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __STARTPMM_H__
#define __STARTPMM_H__

#ifdef __IBMC__
	#define bzero(a, b)	memset(a, 0, b);
#endif

#define STARTPMM_CONFIGFILE	"startpmm.conf"
#define STARTPMM_VERSION	"0.2"

#define STARTPMM_PIPESIZE	512
#define STARTPMM_MAXPATHLEN	CCHMAXPATH
#define STARTPMM_MAXLINELEN	1024
#define STARTPMM_MAXNAMELEN	512
#define STARTPMM_MAXVALUELEN	512
#define STARTPMM_MAXSTATUSARGS	12


typedef struct _handles {
	struct {
		FILE	*in, *out, *err;
	}		io;
	struct {
		HPIPE	read, write;
	}		pass;
	struct {
		HPIPE	read, write;
	}		status;
	HFILE		null;
	FILE*		log;
} handles;

typedef struct _options {
	int		verbose;
	char		logfile[STARTPMM_MAXPATHLEN + 1];
	char		pmm_path[STARTPMM_MAXPATHLEN + 1];
	char		pmm_options[STARTPMM_MAXVALUELEN + 1];
} options;

typedef struct _pmm_call {
	char		executable[STARTPMM_MAXPATHLEN + 1];
        char            path[STARTPMM_MAXPATHLEN + 1];
	char		opts[STARTPMM_MAXLINELEN + 1];
	char		uri[STARTPMM_MAXLINELEN + 1];
	int		rc;
} pmm_call;

extern handles		my_handles;
extern options		my_opts;
extern pmm_call         pmm_cmdline;

/* From OpenBSD's libc */
extern size_t strlcat(char*, const char*, size_t);
extern size_t strlcpy(char*, const char*, size_t);

#endif
