#pragma strings(writeable)

#define INCL_BASE
#define INCL_PM
#include <os2.h>
#include <lpexapi.h>
#include <stdlib.h>
#include <string.h>

#ifndef DC_PREPAREITEM
   #define DC_PREPAREITEM 0x0040
#endif

#pragma pack(1)
typedef struct
{
   ULONG    cb;
   HPOINTER hIcon;
   ULONG    cButtons;
   ULONG    flStyle;
   HWND     hwndNotify;
   MB2D     mb2d[2];
} MB2EXTINFO;
#pragma pack()


uchr pCmdString[1024]={0};
uchr pMsgString[512]={0};
uchr pParamString[256]={0};

PFNWP gOldClientProc = NULL;
HMODULE gHmod = NULLHANDLE;


#ifdef DEBUG
uchr testBuf1[1024];
uchr testBuf2[1024];
uchr testBuf3[1024];
uchr testBuf4[1024];
uchr testBuf5[1024];
#endif

#ifdef __cplusplus
extern "C" {
#endif
ULONG APIENTRY _DLL_InitTerm(ULONG modhandle,ULONG flag);
int _CRT_init(void);
void _CRT_term(void);
void __ctordtorInit(void);
void __ctordtorTerm(void);
#ifdef __cplusplus
}
#endif


ULONG APIENTRY _DLL_InitTerm(ULONG hMod,ULONG flag)
{
   if (flag == 0)
   {
      if (_CRT_init())
      {
         return 0;
      }
#ifdef __cplusplus
      __ctordtorInit();
#endif
      /*
         the "unlink" command invokes lxexit FOLLOWED BY DosFreeModule on this module
         from within the LPEX window procedure. Since it is the
         intention to have the LPEX window procedure subclassed by
         the window procedure in this module, a return from the LPEX window procedure
         into this module's window procedure would lead to a crash as at that point in
         time this module would no longer be loaded.
         Therefore we increase the DLL load count by loading it one more time.
         That will assure that after the "unlink" call this module will NOT be unloaded
      */
      if (!gHmod)
      {
         APIRET rc;

         rc = DosQueryModuleName(hMod,sizeof(pCmdString)-1,pCmdString);
         rc = DosLoadModule(NULL,0,pCmdString,&gHmod);
      }
      return 1;
   }
   else if (flag == 1)
   {
      /*
         revert the extra module load
      */
      if (gHmod)
      {
         APIRET rc;
         rc = DosFreeModule(gHmod);
         gHmod = NULLHANDLE;
      }

#ifdef __cplusplus
      __ctordtorTerm();
#endif
      _CRT_term();
      return 1;
   }
   else
   {
      return 0;
   }
}


BOOL APIENTRY myDrgDeleteDraginfoStrHandles(PDRAGINFO pDragInfo)
{
   /* a replacement for DrgDeleteDraginfoStrHandles */
   /* because that routine will fail if any one hstr is invalid */

   ULONG i,ulItems;
   PDRAGITEM pDragItem;

   ulItems = DrgQueryDragitemCount(pDragInfo);
   for (i=0;i<ulItems;i++)
   {
      pDragItem = DrgQueryDragitemPtr(pDragInfo,i);
      DrgDeleteStrHandle(pDragItem->hstrType);
      DrgDeleteStrHandle(pDragItem->hstrRMF);
      DrgDeleteStrHandle(pDragItem->hstrContainerName);
      DrgDeleteStrHandle(pDragItem->hstrSourceName);
      DrgDeleteStrHandle(pDragItem->hstrTargetName);
   }
   return TRUE;
}


MRESULT DragOverHandler(HWND hwnd,PDRAGINFO pDragInfo)
{
   PDRAGITEM pDragItem;
   ULONG i,ulItems,ulItemsDelayed;
   USHORT usIndicator=DOR_NEVERDROP,usOp=0;

   if (DrgAccessDraginfo(pDragInfo))
   {
      usIndicator = DOR_DROP;
      usOp = DO_MOVE;

      if (pDragInfo->usOperation != DO_DEFAULT)
      {
         usIndicator = DOR_NODROPOP;
         usOp = 0;
      }
      else
      {
         ulItems = DrgQueryDragitemCount(pDragInfo);
         for (i=0,ulItemsDelayed=0;i<ulItems;i++)
         {
            pDragItem = DrgQueryDragitemPtr(pDragInfo,i);
#ifdef DEBUG
            DrgQueryStrName(pDragItem->hstrType,sizeof(testBuf1),testBuf1);
            DrgQueryStrName(pDragItem->hstrRMF,sizeof(testBuf2),testBuf2);
            DrgQueryStrName(pDragItem->hstrContainerName,sizeof(testBuf3),testBuf3);
            DrgQueryStrName(pDragItem->hstrSourceName,sizeof(testBuf4),testBuf4);
            DrgQueryStrName(pDragItem->hstrTargetName,sizeof(testBuf5),testBuf5);
#endif

            if (DrgVerifyRMF(pDragItem,"DRM_OS2FILE","DRF_TEXT"))
            {
               if (!pDragItem->hstrSourceName)
               {
                  ulItemsDelayed++;
               }
               else if (!pDragItem->hstrContainerName)
               {
                  usIndicator = DOR_NEVERDROP;
                  usOp = 0;
                  break;
               }
            }
            else
            {
               usIndicator = DOR_NEVERDROP;
               usOp = 0;
               break;
            }
         }

         if (ulItemsDelayed > 1)
         {
            usIndicator = DOR_NEVERDROP;
            usOp = 0;
         }
      }
      DrgFreeDraginfo(pDragInfo);
   }

   return MRFROM2SHORT(usIndicator,usOp);
}

MRESULT DropHandler(HWND hwnd,PDRAGINFO pDragInfo)
{
   PDRAGTRANSFER pDragTransfer,pTemp;
   PDRAGITEM pDragItem;
   ULONG ulLen;
   ULONG i,ulItems,ulItemsDelayed;
   BOOL ulItemsDelayedError;
   APIRET rc;
   int ret;
#ifdef __cplusplus
   PCSZ
#else
   PSZ
#endif
pEnv;
   char drive[_MAX_DRIVE];
   char dir[_MAX_DIR];

   pEnv = NULL;
   rc = DosScanEnv("TMPDIR",&pEnv);
   if (rc != NO_ERROR)
   {
      rc = DosScanEnv("TMP",&pEnv);
   }
   if (rc != NO_ERROR)
   {
      rc = DosScanEnv("TEMP",&pEnv);
   }
   if (rc != NO_ERROR)
   {
      ulItemsDelayedError = TRUE;
   }

   if (DrgAccessDraginfo(pDragInfo))
   {
      ulItems = DrgQueryDragitemCount(pDragInfo);
      for (i=0,ulItemsDelayed=0,ulItemsDelayedError=FALSE;i<ulItems;i++)
      {
         pDragItem = DrgQueryDragitemPtr(pDragInfo,i);
#ifdef DEBUG
         DrgQueryStrName(pDragItem->hstrType,sizeof(testBuf1),testBuf1);
         DrgQueryStrName(pDragItem->hstrRMF,sizeof(testBuf2),testBuf2);
         DrgQueryStrName(pDragItem->hstrContainerName,sizeof(testBuf3),testBuf3);
         DrgQueryStrName(pDragItem->hstrSourceName,sizeof(testBuf4),testBuf4);
         DrgQueryStrName(pDragItem->hstrTargetName,sizeof(testBuf5),testBuf5);
#endif
         if (pDragItem->hstrSourceName) /* target rendering */
         {
            memset(pCmdString,0,sizeof(pCmdString));
            pCmdString[0]='"';
            ulLen = DrgQueryStrName(pDragItem->hstrContainerName,CCHMAXPATH,pCmdString+1);
            ulLen = ulLen + DrgQueryStrName(pDragItem->hstrSourceName,CCHMAXPATH-ulLen,pCmdString+ulLen+1);
            pCmdString[ulLen+1]='"';
            if (strlen(pParamString))
            {
               strcat(pCmdString," ");
               strcat(pCmdString,pParamString);
            }

            ret = lxcall("lx",pCmdString);

            DrgSendTransferMsg(pDragItem->hwndItem,
                                 DM_ENDCONVERSATION,
                                 MPFROMLONG(pDragItem->ulItemID),
                                 ret >= 0 ? MPFROMSHORT(DMFL_TARGETSUCCESSFUL):MPFROMSHORT(DMFL_TARGETFAIL));
         }
         else /* source rendering */
         {
            ulItemsDelayed++;

            if (ulItemsDelayedError)
            {
               DrgSendTransferMsg(pDragItem->hwndItem,DM_ENDCONVERSATION,MPFROMLONG(pDragItem->ulItemID),MPFROMSHORT(DMFL_TARGETFAIL));
            }

            if ((ulItemsDelayed == 1) && (!ulItemsDelayedError) && (pDragTransfer=DrgAllocDragtransfer(1)))
            {
               pDragTransfer->cb               = sizeof(DRAGTRANSFER);
               pDragTransfer->hwndClient       = hwnd;
               pDragTransfer->pditem           = pDragItem;
               pDragTransfer->hstrSelectedRMF  = DrgAddStrHandle("<DRM_OS2FILE,DRF_TEXT>");
               pDragTransfer->hstrRenderToName = 0;
               pDragTransfer->fsReply          = 0;
               pDragTransfer->ulTargetInfo     = (ULONG)pDragInfo;
               pDragTransfer->usOperation      = DO_DEFAULT;

               if (pDragItem->fsControl & DC_PREPAREITEM)
               {
                  DrgSendTransferMsg(pDragItem->hwndItem,DM_RENDERPREPARE,MPFROMP(pDragTransfer),MPVOID);
               }

               memset(pCmdString,0,sizeof(pCmdString));
               _splitpath((char *)pEnv,drive,dir,NULL,NULL);
               _makepath(pCmdString,drive,dir,NULL,NULL);
               ulLen = strlen(pCmdString);
               ulLen += DrgQueryStrName(pDragItem->hstrTargetName,CCHMAXPATH-ulLen,pCmdString+ulLen);
               pDragTransfer->hstrRenderToName = DrgAddStrHandle(pCmdString);

               if ((pDragItem->fsControl & (DC_PREPARE|DC_PREPAREITEM)) == DC_PREPARE)
               {
                  DrgSendTransferMsg(pDragItem->hwndItem,DM_RENDERPREPARE,MPFROMP(pDragTransfer),MPVOID);
               }

               if (!DrgSendTransferMsg(pDragItem->hwndItem,DM_RENDER,MPFROMP(pDragTransfer),MPVOID))
               {
                  DrgSendTransferMsg(pDragItem->hwndItem,DM_ENDCONVERSATION,MPFROMLONG(pDragItem->ulItemID),MPFROMSHORT(DMFL_TARGETFAIL));
                  DrgDeleteStrHandle(pDragTransfer->hstrSelectedRMF);
                  DrgDeleteStrHandle(pDragTransfer->hstrRenderToName);
                  DrgFreeDragtransfer(pDragTransfer);
                  ulItemsDelayedError = TRUE;
               }
            }
         }
      }
      if (!ulItemsDelayed || ulItemsDelayedError)
      {
         myDrgDeleteDraginfoStrHandles(pDragInfo);
         DrgFreeDraginfo(pDragInfo);
      }
   }
   return MRFROMLONG(0);
}

MRESULT RenderCompleteHandler(HWND hwnd,PDRAGTRANSFER pDragTransfer,USHORT usResults)
{
   PDRAGINFO pDragInfo=NULL;
   PDRAGITEM pDragItem=NULL;
   ULONG ulLen=0,ulStatus=0;
   int ret=0;

#ifdef DEBUG
   DrgQueryStrName(pDragTransfer->hstrSelectedRMF,sizeof(testBuf1),testBuf1);
   DrgQueryStrName(pDragTransfer->hstrRenderToName,sizeof(testBuf2),testBuf2);
#endif

   pDragItem   = pDragTransfer->pditem;
   pDragInfo   = (PDRAGINFO)pDragTransfer->ulTargetInfo;

   if (usResults & DMFL_RENDEROK)
   {
      memset(pCmdString,0,sizeof(pCmdString));
      pCmdString[0]='"';
      ulLen = DrgQueryStrName(pDragTransfer->hstrRenderToName,sizeof(pCmdString)-3,pCmdString+1);
      pCmdString[ulLen+1]='"';

      ret = lxcall("get",pCmdString);

      /* the pasted text fragment will not show up before the contents of the window are refreshed */
      /* by issuing the following command */
      lxcmd("sshow");
      memmove(pCmdString,pCmdString+1,ulLen);
      pCmdString[ulLen]='\0';
      DosForceDelete(pCmdString);
   }
   else
   {
      ret = -1;
   }

   DrgSendTransferMsg(pDragItem->hwndItem,
                        DM_ENDCONVERSATION,
                        MPFROMLONG(pDragItem->ulItemID),
                        ret >= 0 ? MPFROMSHORT(DMFL_TARGETSUCCESSFUL): MPFROMSHORT(DMFL_TARGETFAIL));

   DrgDeleteStrHandle(pDragTransfer->hstrSelectedRMF);
   DrgDeleteStrHandle(pDragTransfer->hstrRenderToName);
   DrgFreeDragtransfer(pDragTransfer);

   if (pDragInfo && DrgAccessDraginfo(pDragInfo))
   {
#ifdef DEBUG
      DosBeep(400,100);
#endif
      myDrgDeleteDraginfoStrHandles(pDragInfo);
      DrgFreeDraginfo(pDragInfo);
   }

   return MRFROMLONG(0);
}

MRESULT ShowHelp(HWND hwnd,PDRAGINFO pDragInfo)
{
   MB2EXTINFO mb  ={0};
   PDRAGITEM pDragItem;
   ULONG ulItems,i;

   if (DrgAccessDraginfo(pDragInfo))
   {
      ulItems = DrgQueryDragitemCount(pDragInfo);
      for (i=0;i<ulItems;i++)
      {
         pDragItem = DrgQueryDragitemPtr(pDragInfo,i);

         DrgSendTransferMsg(pDragItem->hwndItem,
                              DM_ENDCONVERSATION,
                              MPFROMP(pDragItem->ulItemID),
                              MPFROMSHORT(DMFL_TARGETSUCCESSFUL));
      }

      myDrgDeleteDraginfoStrHandles(pDragInfo);
      DrgFreeDraginfo(pDragInfo);
   }

   mb.cb          = sizeof(mb);
   mb.cButtons    = 2;
   mb.flStyle     = MB_INFORMATION | MB_NONMODAL | MB_MOVEABLE;
   mb.hwndNotify  = hwnd;
   strcpy(mb.mb2d[0].achText,"Cancel");
   mb.mb2d[0].idButton  = 10;
   mb.mb2d[0].flStyle  = BS_PUSHBUTTON;
   strcpy(mb.mb2d[1].achText,"Help");
   mb.mb2d[1].idButton  = 20;
   mb.mb2d[1].flStyle  = BS_PUSHBUTTON;

   WinMessageBox2(HWND_DESKTOP,
            NULLHANDLE,
            "DRGDRP can take the following parameters when invoked through the LPEX command execution line:\n"\
            "/settings\n"\
            "\tto query the current settings\n"\
            "/nopro,/np\n"\
            "/nosys,/ns\n"\
            "/asis,/as\n"\
            "/doctype DocType,/dt DocType\n"\
            "\tsame meaning as parameters to \"lx\" command\n"\
            "\tpress \"Help\" to see Editor Reference\n\n"\
            "Note: DRGDRP will only correctly handle parameters\n"\
            "if it is initially loaded through the \"profinit.lx\" profile !",
            "Info",
            0UL,
            (PMB2INFO)&mb);

   return MRFROMLONG(0);
}

VOID InvokeHelp(VOID)
{
   PROGDETAILS d={0};

   d.Length = sizeof(d);
   d.pszExecutable = "VIEW.EXE";
   WinStartApp(NULLHANDLE,&d,"LPXCREF.INF \"lx command\"",NULL,0UL);
   return;
}


MRESULT EXPENTRY ClientProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{

   switch(msg)
   {
      case DM_DRAGOVER:
         return DragOverHandler(hwnd,(PDRAGINFO)MPFROMP(mp1));

      case DM_DROP:
         return DropHandler(hwnd,(PDRAGINFO)MPFROMP(mp1));

      case DM_DROPHELP:
         return ShowHelp(hwnd,(PDRAGINFO)MPFROMP(mp1));

      case DM_RENDERCOMPLETE:
         return RenderCompleteHandler(hwnd,(PDRAGTRANSFER)MPFROMP(mp1),SHORT1FROMMP(mp2));

      case WM_MSGBOXDISMISS:
      {
         BOOL rc = FALSE;
         HWND hwndMsgBox=HWNDFROMMP(mp1);
         ULONG ulRes=LONGFROMMP(mp2);
         rc = WinDestroyWindow(hwndMsgBox);
         if (ulRes == 20)
         {
            InvokeHelp();
         }
         return MRFROMLONG(0);
      }

      default:
         break;
   }
   return gOldClientProc(hwnd,msg,mp1,mp2);
}

int lxmain(uchr *parm)
{
   CHAR szClassName[128];
   CLASSINFO ci;
   uchr *p=NULL;
   HENUM hEnum=NULLHANDLE;
   HWND hwndFrame=NULLHANDLE,hwndClient=NULLHANDLE;
   BOOL fRC=FALSE;

   if (parm)
   {
      if (stricmp(parm,"/settings")==0)
      {
         strcpy(pMsgString,"Current DRGDRP settings: ");
         strcat(pMsgString,pParamString);
         lxmsg(pMsgString);
      }
      else
      {
         memset(pParamString,0,sizeof(pParamString));
         strncpy(pParamString,parm,sizeof(pParamString)-1);
      }
   }

   if (!gOldClientProc)
   {
      /*
         subclass the window procedure for all editor windows that are to come
         into existence
      */
      HAB hab = WinQueryAnchorBlock(HWND_DESKTOP);
      memset(&ci,0,sizeof(ci));
      fRC = WinQueryClassInfo(hab,"LpexView",&ci);
      fRC = WinRegisterClass(hab,"LpexView",ClientProc,ci.flClassStyle,ci.cbWindowData);
      gOldClientProc = ci.pfnWindowProc;

      /*
         subclass the window procedure for all editor windows that are already
         in existence at the point in time lxmain is called
      */
      hEnum = WinBeginEnumWindows(HWND_DESKTOP);
      while ((hwndFrame = WinGetNextWindow(hEnum)) != NULLHANDLE)
      {
         hwndClient = WinWindowFromID(hwndFrame,FID_CLIENT);
         if (WinQueryClassName(hwndClient,sizeof(szClassName),szClassName) && strcmp("LpexView",szClassName) == 0)
         {
            WinSubclassWindow(hwndClient,ClientProc);
         }
      }
      WinEndEnumWindows(hEnum);
   }
   return 0;
}

int lxexit(uchr *parm)
{
   CHAR szClassName[128];
   CLASSINFO ci;
   HENUM hEnum=NULLHANDLE;
   HWND hwndFrame=NULLHANDLE,hwndClient=NULLHANDLE;
   BOOL fRC=FALSE;

   if (gOldClientProc)
   {
      /*
         undo the window class subclassing performed in lxmain
      */
      HAB hab = WinQueryAnchorBlock(HWND_DESKTOP);
      memset(&ci,0,sizeof(ci));
      fRC = WinQueryClassInfo(hab,"LpexView",&ci);
      fRC = WinRegisterClass(hab,"LpexView",gOldClientProc,ci.flClassStyle,ci.cbWindowData);

      hEnum = WinBeginEnumWindows(HWND_DESKTOP);
      while ((hwndFrame = WinGetNextWindow(hEnum)) != NULLHANDLE)
      {
         hwndClient = WinWindowFromID(hwndFrame,FID_CLIENT);
         if (WinQueryClassName(hwndClient,sizeof(szClassName),szClassName) && strcmp("LpexView",szClassName) == 0)
         {
            WinSubclassWindow(hwndClient,gOldClientProc);
         }
      }
      WinEndEnumWindows(hEnum);

      /*
         on next lxmain entry, make sure that once again the
         window class subclassing takes place
      */
      gOldClientProc=NULL;
   }
   /*
      at this point, no LPEX window procedure of any editor window is any longer subclassed
      and no future window will be subclassed until the next call into lxmain
      (invoking drgdrp from the command window in LPEX)
   */
   return 0;
}
