/* 
 *	HT Editor
 *	syskeyb.cc - keyboard access functions for OS/2 (VIO)
 */

#include "io/keyb.h"

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_VIO
#define INCL_KBD
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

HKBD hkbd = 0;
KBDKEYINFO key;
KBDINFO kstat;


//#define KEY_DEBUG

#ifdef KEY_DEBUG
static FILE *kd;
#endif


struct ht_key_keycode {
	ht_key key;
	int keycode;
};

#define HT_VK                  0x300
#define HT_VK_ALT              (0x1000)
#define HT_VK_SHIFT            (0x2000)
#define HT_VK_CTRL             (0x3000)

#define VK_BACK			(0x00e)
#define VK_TAB			(0x00f)
#define VK_RETURN		(0x01c)
#define VK_ESCAPE		(0x001)
#define VK_F1			(0x03b)
#define VK_F2			(0x03c)
#define VK_F3			(0x03d)
#define VK_F4			(0x03e)
#define VK_F5			(0x03f)
#define VK_F6			(0x040)
#define VK_F7			(0x041)
#define VK_F8			(0x042)
#define VK_F9			(0x043)
#define VK_F10			(0x044)
#define VK_F11			(0x085)
#define VK_F12			(0x086)
#define VK_HOME			(0x047)
#define VK_END			(0x04f)
#define VK_INSERT		(0x052)
#define VK_DELETE		(0x053)
#define VK_UP			(0x048)
#define VK_DOWN			(0x050)
#define VK_LEFT			(0x04b)
#define VK_RIGHT		(0x04d)
#define VK_PRIOR		(0x049)
#define VK_NEXT			(0x051)

#define VK_CTRL_UP			(0x08d)
#define VK_CTRL_DOWN		(0x091)
#define VK_CTRL_LEFT		(0x073)
#define VK_CTRL_RIGHT		(0x074)
#define VK_CTRL_HOME		(0x077)
#define VK_CTRL_END			(0x075)
#define VK_CTRL_INSERT		(0x092)
#define VK_CTRL_DELETE		(0x093)
#define VK_CTRL_PRIOR		(0x084)
#define VK_CTRL_NEXT		(0x076)

#define VK_SHIFT_F1		(0x054)
#define VK_SHIFT_F2		(0x055)
#define VK_SHIFT_F3		(0x056)
#define VK_SHIFT_F4		(0x057)
#define VK_SHIFT_F5		(0x058)
#define VK_SHIFT_F6		(0x059)
#define VK_SHIFT_F7		(0x05a)
#define VK_SHIFT_F8		(0x05b)
#define VK_SHIFT_F9		(0x05c)
#define VK_SHIFT_F10		(0x05d)
#define VK_SHIFT_F11		(0x087)
#define VK_SHIFT_F12		(0x088)

#define VK_CTRL_F1		(0x05e)
#define VK_CTRL_F2		(0x05f)
#define VK_CTRL_F3		(0x060)
#define VK_CTRL_F4		(0x061)
#define VK_CTRL_F5		(0x062)
#define VK_CTRL_F6		(0x063)
#define VK_CTRL_F7		(0x064)
#define VK_CTRL_F8		(0x065)
#define VK_CTRL_F9		(0x066)
#define VK_CTRL_F10		(0x067)
#define VK_CTRL_F11		(0x089)
#define VK_CTRL_F12		(0x08a)

#define VK_ALT_F1		(0x068)
#define VK_ALT_F2		(0x069)
#define VK_ALT_F3		(0x06a)
#define VK_ALT_F4		(0x06b)
#define VK_ALT_F5		(0x06c)
#define VK_ALT_F6		(0x06d)
#define VK_ALT_F7		(0x06e)
#define VK_ALT_F8		(0x06f)
#define VK_ALT_F9		(0x070)
#define VK_ALT_F10		(0x071)
#define VK_ALT_F11		(0x08b)
#define VK_ALT_F12		(0x08c)

#define VK_CTRL_TAB		(0x094)
#define VK_ALT_TAB		(0x0a5)

static ht_key_keycode ht_os2kbd_key_defs[] = {
	{K_Control_A,			(0x001+HT_VK_CTRL)},
	{K_Control_B,			(0x002+HT_VK_CTRL)},
	{K_Control_C,			(0x003+HT_VK_CTRL)},
	{K_Control_D,			(0x004+HT_VK_CTRL)},
	{K_Control_E,			(0x005+HT_VK_CTRL)},
	{K_Control_F,			(0x006+HT_VK_CTRL)},
	{K_Control_G,			(0x007+HT_VK_CTRL)},
	{K_Backspace,			(VK_BACK+HT_VK)},
	{K_Control_H,			(0x008+HT_VK_CTRL)},
	{K_Tab,				(VK_TAB+HT_VK)},
	{K_Control_I,			(0x009+HT_VK_CTRL)},
	{K_Control_J,			(0x00a+HT_VK_CTRL)},
	{K_Control_K,			(0x00b+HT_VK_CTRL)},
	{K_Control_L,			(0x00c+HT_VK_CTRL)},
	{K_Return,			(VK_RETURN+HT_VK)},
	{K_Control_M,			(0x00d+HT_VK_CTRL)},
	{K_Control_N,			(0x00e + HT_VK_CTRL)},	// preprocessor problem :-)
	{K_Control_O,			(0x00f+HT_VK_CTRL)},
	{K_Control_P,			(0x010+HT_VK_CTRL)},
	{K_Control_Q,			(0x011+HT_VK_CTRL)},
	{K_Control_R,			(0x012+HT_VK_CTRL)},
	{K_Control_S,			(0x013+HT_VK_CTRL)},
	{K_Control_T,			(0x014+HT_VK_CTRL)},
	{K_Control_U,			(0x015+HT_VK_CTRL)},
	{K_Control_V,			(0x016+HT_VK_CTRL)},
	{K_Control_W,			(0x017+HT_VK_CTRL)},
	{K_Control_X,			(0x018+HT_VK_CTRL)},
	{K_Control_Y,			(0x019+HT_VK_CTRL)},
	{K_Control_Z,			(0x01a+HT_VK_CTRL)},
	{K_Escape,			(VK_ESCAPE+HT_VK)},
//	{K_Control_LBracket,		0x01b},
//	{K_Control_BackSlash,		0x01c},
//	{K_Control_RBracket,		0x01d},
//	{K_Control_Caret,		0x01e},
//	{K_Control_Underscore,		0x01f},
//	{K_Control_Backspace,		(VK_BACK+HT_VK+HT_VK_CTRL)},

	{K_Meta_Escape,			(VK_ESCAPE+HT_VK+HT_VK_ALT)},
//	{K_Control_At,			0x103},
	{K_Meta_Backspace,		(VK_BACK+HT_VK+HT_VK_ALT)},
	{K_Shift_Tab,			(VK_TAB+HT_VK+HT_VK_SHIFT)},
	{K_Control_Tab,			(VK_CTRL_TAB+HT_VK+HT_VK_CTRL)},
	{K_Meta_Q,			('q'+HT_VK_ALT)},
	{K_Meta_W,			('w'+HT_VK_ALT)},
	{K_Meta_E,			('e'+HT_VK_ALT)},
	{K_Meta_R,			('r'+HT_VK_ALT)},
	{K_Meta_T,			('t'+HT_VK_ALT)},
	{K_Meta_Y,			('y'+HT_VK_ALT)},
	{K_Meta_U,			('u'+HT_VK_ALT)},
	{K_Meta_I,			('i'+HT_VK_ALT)},
	{K_Meta_O,			('o'+HT_VK_ALT)},
	{K_Meta_P,			('p'+HT_VK_ALT)},
//	{K_Meta_LBracket,		0x11a},
//	{K_Meta_RBracket,		0x11b},
//	{K_Meta_Return,			0x11c},
	{K_Meta_A,			('a'+HT_VK_ALT)},
	{K_Meta_S,			('s'+HT_VK_ALT)},
	{K_Meta_D,			('d'+HT_VK_ALT)},
	{K_Meta_F,			('f'+HT_VK_ALT)},
	{K_Meta_G,			('g'+HT_VK_ALT)},
	{K_Meta_H,			('h'+HT_VK_ALT)},
	{K_Meta_J,			('j'+HT_VK_ALT)},
	{K_Meta_K,			('k'+HT_VK_ALT)},
	{K_Meta_L,			('l'+HT_VK_ALT)},
//	{K_Meta_Semicolon,		0x127},
//	{K_Meta_Quote,			0x128},
//	{K_Meta_Backquote,		0x129},
//	{K_Meta_Backslash,		0x12b},
	{K_Meta_Z,			('z'+HT_VK_ALT)},
	{K_Meta_X,			('x'+HT_VK_ALT)},
	{K_Meta_C,			('c'+HT_VK_ALT)},
	{K_Meta_V,			('v'+HT_VK_ALT)},
	{K_Meta_B,			('b'+HT_VK_ALT)},
	{K_Meta_N,			('n'+HT_VK_ALT)},
	{K_Meta_M,			('m'+HT_VK_ALT)},
//	{K_Meta_Comma,			0x133},
//	{K_Meta_Period,			0x134},
//	{K_Meta_Slash,			0x135},
//	{K_Meta_KPStar,			0x137},
	{K_F1,				(VK_F1+HT_VK)},
	{K_F2,				(VK_F2+HT_VK)},
	{K_F3,				(VK_F3+HT_VK)},
	{K_F4,				(VK_F4+HT_VK)},
	{K_F5,				(VK_F5+HT_VK)},
	{K_F6,				(VK_F6+HT_VK)},
	{K_F7,				(VK_F7+HT_VK)},
	{K_F8,				(VK_F8+HT_VK)},
	{K_F9,				(VK_F9+HT_VK)},
	{K_F10,				(VK_F10+HT_VK)},
	{K_Home,			(VK_HOME+HT_VK)},
	{K_Up,				(VK_UP+HT_VK)},
	{K_PageUp,			(VK_PRIOR+HT_VK)},
//	{K_Meta_KPMinus,			0x14a},
	{K_Left,			(VK_LEFT+HT_VK)},
//	{K_Center,			0x14c},
	{K_Right,			(VK_RIGHT+HT_VK)},
//	{K_Meta_KPPlus,			0x14e},
	{K_End,				(VK_END+HT_VK)},
	{K_Down,			(VK_DOWN+HT_VK)},
	{K_PageDown,			(VK_NEXT+HT_VK)},
	{K_Insert,			(VK_INSERT+HT_VK)},
	{K_Delete,			(VK_DELETE+HT_VK)},
	{K_Shift_F1,			(VK_SHIFT_F1+HT_VK+HT_VK_SHIFT)},
	{K_Shift_F2,			(VK_SHIFT_F2+HT_VK+HT_VK_SHIFT)},
	{K_Shift_F3,			(VK_SHIFT_F3+HT_VK+HT_VK_SHIFT)},
	{K_Shift_F4,			(VK_SHIFT_F4+HT_VK+HT_VK_SHIFT)},
	{K_Shift_F5,			(VK_SHIFT_F5+HT_VK+HT_VK_SHIFT)},
	{K_Shift_F6,			(VK_SHIFT_F6+HT_VK+HT_VK_SHIFT)},
	{K_Shift_F7,			(VK_SHIFT_F7+HT_VK+HT_VK_SHIFT)},
	{K_Shift_F8,			(VK_SHIFT_F8+HT_VK+HT_VK_SHIFT)},
	{K_Shift_F9,			(VK_SHIFT_F9+HT_VK+HT_VK_SHIFT)},
	{K_Shift_F10,			(VK_SHIFT_F10+HT_VK+HT_VK_SHIFT)},
	{K_Control_F1,			(VK_CTRL_F1+HT_VK+HT_VK_CTRL)},
	{K_Control_F2,			(VK_CTRL_F2+HT_VK+HT_VK_CTRL)},
	{K_Control_F3,			(VK_CTRL_F3+HT_VK+HT_VK_CTRL)},
	{K_Control_F4,			(VK_CTRL_F4+HT_VK+HT_VK_CTRL)},
	{K_Control_F5,			(VK_CTRL_F5+HT_VK+HT_VK_CTRL)},
	{K_Control_F6,			(VK_CTRL_F6+HT_VK+HT_VK_CTRL)},
	{K_Control_F7,			(VK_CTRL_F7+HT_VK+HT_VK_CTRL)},
	{K_Control_F8,			(VK_CTRL_F8+HT_VK+HT_VK_CTRL)},
	{K_Control_F9,			(VK_CTRL_F9+HT_VK+HT_VK_CTRL)},
	{K_Control_F10,			(VK_CTRL_F10+HT_VK+HT_VK_CTRL)},
	{K_Meta_F1,			(VK_ALT_F1+HT_VK+HT_VK_ALT)},
	{K_Meta_F2,			(VK_ALT_F2+HT_VK+HT_VK_ALT)},
	{K_Meta_F3,			(VK_ALT_F3+HT_VK+HT_VK_ALT)},
	{K_Meta_F4,			(VK_ALT_F4+HT_VK+HT_VK_ALT)},
	{K_Meta_F5,			(VK_ALT_F5+HT_VK+HT_VK_ALT)},
	{K_Meta_F6,			(VK_ALT_F6+HT_VK+HT_VK_ALT)},
	{K_Meta_F7,			(VK_ALT_F7+HT_VK+HT_VK_ALT)},
	{K_Meta_F8,			(VK_ALT_F8+HT_VK+HT_VK_ALT)},
	{K_Meta_F9,			(VK_ALT_F9+HT_VK+HT_VK_ALT)},
	{K_Meta_F10,			(VK_ALT_F10+HT_VK+HT_VK_ALT)},
//	{K_Control_Print		0x172},
	{K_Control_Left,		(VK_CTRL_LEFT+HT_VK_CTRL+HT_VK)},
	{K_Control_Right,		(VK_CTRL_RIGHT+HT_VK_CTRL+HT_VK)},
	{K_Control_End,			(VK_CTRL_END+HT_VK_CTRL+HT_VK)},
	{K_Control_PageDown,		(VK_CTRL_NEXT+HT_VK_CTRL+HT_VK)},
	{K_Control_Home,		(VK_CTRL_HOME+HT_VK_CTRL+HT_VK)},
	{K_Meta_1,			('1'+HT_VK_ALT)},
	{K_Meta_2,			('2'+HT_VK_ALT)},
	{K_Meta_3,			('3'+HT_VK_ALT)},
	{K_Meta_4,			('4'+HT_VK_ALT)},
	{K_Meta_5,			('5'+HT_VK_ALT)},
	{K_Meta_6,			('6'+HT_VK_ALT)},
	{K_Meta_7,			('7'+HT_VK_ALT)},
	{K_Meta_8,			('8'+HT_VK_ALT)},
	{K_Meta_9,			('9'+HT_VK_ALT)},
	{K_Meta_0,			('0'+HT_VK_ALT)},
//	{K_Meta_Dash,			0x182},
//	{K_Meta_Equals,			0x183},
	{K_Control_PageUp,		(VK_CTRL_PRIOR+HT_VK_CTRL+HT_VK)},
	{K_F11,				(VK_F11+HT_VK+HT_VK)},
	{K_F12,				(VK_F12+HT_VK+HT_VK)},
	{K_Shift_F11,			(VK_SHIFT_F11+HT_VK+HT_VK_SHIFT)},
	{K_Shift_F12,			(VK_SHIFT_F12+HT_VK+HT_VK_SHIFT)},
	{K_Control_F11,			(VK_CTRL_F11+HT_VK+HT_VK_CTRL)},
	{K_Control_F12,			(VK_CTRL_F12+HT_VK+HT_VK_CTRL)},
	{K_Meta_F11,			(VK_ALT_F11+HT_VK+HT_VK_ALT)},
	{K_Meta_F12,			(VK_ALT_F12+HT_VK+HT_VK_ALT)},
	{K_Control_Up,			(VK_CTRL_UP+HT_VK_CTRL+HT_VK)},
//	{K_Control_KPDash,		0x18e},
//	{K_Control_Center,		0x18f},
//	{K_Control_KPPlus,		0x190},
	{K_Control_Down,		(VK_CTRL_DOWN+HT_VK_CTRL+HT_VK)},
	{K_Control_Insert,		(VK_CTRL_INSERT+HT_VK_CTRL+HT_VK)},
	{K_Control_Delete,		(VK_CTRL_DELETE+HT_VK_CTRL+HT_VK)},
//	{K_Control_KPSlash,		0x195},
//	{K_Control_KPStar,		0x196},
	{K_Meta_Tab,			(VK_ALT_TAB+HT_VK_ALT+HT_VK)},
	{K_Meta_Enter,			(VK_RETURN+HT_VK+HT_VK_ALT)},

	{K_Shift_Up,			(HT_VK_SHIFT+VK_UP+HT_VK)},
	{K_Shift_Down,			(HT_VK_SHIFT+VK_DOWN+HT_VK)},
	{K_Shift_Left,			(HT_VK_SHIFT+VK_LEFT+HT_VK)},
	{K_Shift_Right,			(HT_VK_SHIFT+VK_RIGHT+HT_VK)},
	{K_Shift_PageUp,		(HT_VK_SHIFT+VK_PRIOR+HT_VK)},
	{K_Shift_PageDown,		(HT_VK_SHIFT+VK_NEXT+HT_VK)},

	{K_Shift_Home,			(HT_VK_SHIFT+VK_HOME+HT_VK)},
	{K_Shift_End,			(HT_VK_SHIFT+VK_END+HT_VK)},
	{K_Shift_Delete,		(HT_VK_SHIFT+VK_DELETE+HT_VK)},
	{K_Shift_Insert,		(HT_VK_SHIFT+VK_INSERT+HT_VK)},

	{K_INVALID,			-1}
};


bool keyb_keypressed()
{
#if 0
	KBDKEYINFO key;
#endif
	key.chChar = key.chScan = 0;
	KbdPeek(&key, hkbd);
	return (key.chChar || key.chScan);
}

int ht_key_meta(bool shift, bool control, bool alt)
{
#if 0
	KBDINFO kstat;
#endif
	kstat.fsState = 0;
	kstat.cb = sizeof(kstat);
	KbdGetStatus(&kstat, hkbd);
	return \
		  ( ((kstat.fsState & 3) && shift) ? HT_VK_SHIFT : 0 )
		| ( ((kstat.fsState & 4) && control) ? HT_VK_CTRL : 0 )
		| ( ((kstat.fsState & 8) && alt) ? HT_VK_ALT : 0 );
}

UCHAR keyb_scan_to_char(PKBDKEYINFO k)
{
	APIRET rc;
	KBDTRANS kx;
	
	if ((kstat.fsState & (8 | 4)) == 4 && k->chChar)
		return k->chChar; /* thru Ctrl-? */
	memset(&kx, 0, sizeof(KBDTRANS));
	kx.chScan = k->chScan;
	kx.fsState = kstat.fsState & (0x20 | 4 | 3); /* use numlck,shift,ctrl */
	rc = KbdXlate(&kx, hkbd);
	
	return rc == NO_ERROR ? kx.chChar : 0;
}


ht_key keyb_getkey()
{
	int i;
	ht_key k;
	int vk = 0;
	UCHAR kx = 0;
	
	key.chChar = key.chScan = 0;
	KbdCharIn(&key, IO_WAIT, hkbd);
	kstat.cb = sizeof(KBDINFO);
	kstat.fsState = 0;
	KbdGetStatus(&kstat, hkbd);
	
	if (key.chChar == 0 && key.chScan == 0) return K_INVALID;
	if ((key.chChar >= 0x20 && key.chChar != 0xe0) || (key.chChar == 0xe0 && key.chScan == 0)) {
		k = (ht_key)(unsigned)key.chChar;
	}
	else {
		kx = keyb_scan_to_char(&key);
		for(i=0;;i++) {
			vk = ht_os2kbd_key_defs[i].keycode;
			if (vk == -1) {
				k = key.chChar ? (ht_key)(unsigned)key.chChar : K_INVALID;
				break;
			}
			if (vk & HT_VK) {
				if (vk == ((int)(unsigned)key.chScan | ht_key_meta(true, true, true) | HT_VK)) {
					k = ht_os2kbd_key_defs[i].key;
					break;
				}
			}
			else {
				if (vk == ((int)(unsigned)kx | ht_key_meta(true, true, true))) {
					k = ht_os2kbd_key_defs[i].key;
					break;
				}
			}
		}
	}
#ifdef KEY_DEBUG
	fprintf(kd, "char %02x kx-char %02x Scan %02x Stat %04x meta %04x k %08x \n", key.chChar, kx, key.chScan, kstat.fsState, ht_key_meta(true, true, true), k);
#endif
	return k;
}

bool init_keyb()
{
#ifdef KEY_DEBUG
	kd = fopen("_kd.kd", "wt");
#endif
	return true;
}

void done_keyb()
{
#ifdef KEY_DEBUG
	fclose(kd);
#endif
}
