/*
 * wafmail.cr
 * CRISP macro file dealing with Waffle BBS style mailboxes
 * Copyright (c) 1994  David L. Nugent & Unique Computing Pty Ltd
 * Adapted from mail routines originally developed by Paul Fox
 */

# include	"crisp.h"
# define	MAILPROG	"rmail"

int 			wmr_index = 1;			/* Response buffer index */
int				wmr_number = 1;

int 			wmail_mtime;			/* Last modification time on mailbox */
string			wmailsep,				/* Mail separator string */
				signfile,
				wmailfile,				/* Current mailbox file */
				timezone,
				username,
				realname,
				hostname,
				unknown;


void
main()
{
	int 			m, i, s, z;
	string			temp, w;

	unknown = "(none)";
	hostname = getenv("HOSTNAME");
	if (hostname != "")
		hostname = "@" + hostname;
	username = getenv("LOGNAME");
	if (username == "")
	{
		username = getenv("USER");
		if (username == "")
			username = "root";
	}
	realname = getenv("REALNAME");
	if (realname != "")
		realname = " (" + realname + ")";
	wmailfile = getenv("MAIL");
	if (wmailfile == "")
	{
		temp = getenv("HOME");
		wmailfile = temp + "/mailbox.f";            /* Waffle format */
	}
#if defined( OS2 ) || defined( MSDOS )
	sprintf(signfile, "%s/mailsig", getenv("HOME"));
#else
	sprintf(signfile, "%s/.signature", getenv("HOME"));
#endif
	wmail_mtime = -1;
	register_macro(REG_IDLE, "mail_watch");
	mail_watch();
	wmailsep = "\x01\x01\x01\x01From ";
	temp = getenv("TZ");
	if (temp == "")
		temp = "GMT0";
	s = z = 0;
	for (i = 1; i <= strlen(temp); ++i)
	{
		w = substr(temp,i, 1);
		if (w == "-")
			++s;
		else
			if (w >= "0" && w <= "9")
				break;
	}
	i = atoi(substr(temp,i));
	if (i > 100)
	{
		m = m % 100;
		i = i / 100;
	}
	else
	{
		if (i > 24)
		{
			m = i;
			i = 0;
		}
		else
		{
			m = 0;
		}
	}
	sprintf(timezone,"%s%02d%02d", (s==0)?"-":"+", i, m);
}

	/*
	 *	Function returning TRUE of mail file has been modified
	 */

int
mail_changed()
{
	int 			mtime;
	int 			fsize;

	file_pattern(wmailfile);
	if (find_file(NULL, fsize, mtime) == 0)
	{
		wmail_mtime = -1;
		return FALSE;
	}
	if (mtime != wmail_mtime && fsize != 0)
	{
		wmail_mtime = mtime;
		return TRUE;
	}
	return FALSE;
}

	/*
	 * This is the macro registered and run by the key idle handler
	 */

void
mail_watch()
{
	if (mail_changed())
		message("There is new mail.");
}


	/*
	 *	Shorthand to make it easier for user to type name of function
	 */

void
mail()
{
	string			whom;

		/*
		 *	If no 'to' parameter given, then fall back into
		 *	read mode on default mailbox
		 */

	if (get_parm(0, whom) == 0)
	{
		mail_read();
		return;
	}

		/*
		 * If  first  character  is  '='  then read the specified mail folder
		 */

	if (substr(whom, 1, 1) == "=")
	{
		whom = getenv("HOME") + "/Mail/" + substr(whom, 2);
		read_mail_folder(whom);
		return;
	}

		/*
		 *	If first character is '%', then use absolute path
		 */

	if (substr(whom, 1, 1) == "%")
	{
		read_mail_folder(substr(whom,2));
		return;
	}

		/*
		 * Otherwise, assume we want to send mail
		 */

	mail_send(whom);
}


void
read_mail_folder (string whom)
{
	string			old_wmailfile;
	int 			old_mtime;

	old_wmailfile = wmailfile;				/* Save existing mail file name */
	old_mtime = wmail_mtime;				/* .. and time */
	wmailfile = whom;
	file_pattern(wmailfile);
	find_file(NULL, NULL, wmail_mtime);
	message("Reading file: %s", wmailfile);
	mail_read();							/* read that as a mailbox */
	wmailfile = old_wmailfile;				/* Restore default mailbox */
	wmail_mtime = old_mtime;
}

void
mail_read()
{
	string			from_line,
					subject_line,
					line;
	list			who_list;
	int 			who_len,
					space,
					line_no,
					last_line_no,		// Used to calculate message size
					curbuf,
					hdrbuf, 			// Buffer containing header summary
					mailbuf,			// Buffer containing mail file
					hdrwin, 			// Window for pop-up
					quit_flag = FALSE;	// Set if user aborts mail reading

	curbuf = inq_buffer();

	/*
	 * See if there is any mail
	 */

	if (!exist(wmailfile))
	{
		error("There is no mail.");
		return;
	}

	/*
	 * Build up a list of who the mail is from
	 */

	edit_file(wmailfile);
	top_of_buffer();
	mailbuf = inq_buffer();
	hdrbuf = create_buffer("Mail Messages", NULL, 1);
	last_line_no = 0;

		/* Waffle pseudo mmdf style */
	while (re_search(NULL, wmailsep) > 0)
	{

		inq_position(line_no);
		from_line = trim(read());
		from_line = substr(from_line,index(from_line, " ")+1);
		space = index(from_line, " ");
		from_line = substr(from_line, 1, space - 1);

		/*
		 * Get subject line
		 */

		subject_line = "";
		if (re_search(NULL, "^{Subject: }|{From }") > 0)
		{
			if (read(1) == "S")
				subject_line = ltrim(trim(substr(read(), 10)));
		}

		if (strlen(subject_line) < 30)
			subject_line += "                                       ";
		subject_line = substr(subject_line, 1, 30);

		if (re_search(NULL, wmailsep) <= 0)
			end_of_buffer();
		last_line_no = line_no;
		inq_position(line_no);

		set_buffer(hdrbuf);
		if (who_len != 0)
			insert("\n");

		sprintf(line, "%d. %s [%4d] %s", who_len + 1,
				subject_line, line_no - last_line_no, from_line);
		insert(line);
		set_buffer(mailbuf);
		who_list[2 * who_len] = last_line_no;
		who_list[2 * who_len + 1] = line_no;
		++who_len;
	}

	if (who_len != 0)
	{
		message("Use <Esc> to exit and save changes; Q to exit.");
		hdrwin = sized_window(who_len + 1, 76,
							  "<Alt-K> key bindings. <Alt-H> for help.");
		set_buffer(curbuf);
		attach_buffer(curbuf);
		select_buffer(hdrbuf, hdrwin, 0, mail_keys(),
					  NULL,
					  "help_display \"features/mail.hlp\" \"Mail\"");
		/*
		 *	 Save the unread mail back in the mailbox.
		 */

		if (quit_flag)
			message("Quit - %s not updated.", wmailfile);
		/*
		else
			mail_save_unread();
		 */
	}
	else
		message("There is no mail.");

	/*
	 * Take user back to original buffer
	 */

	set_buffer(curbuf);
	delete_buffer(mailbuf);
	attach_buffer(curbuf);
}

list
mail_keys()
{
	assign_to_key("d", "mail_delete");
	assign_to_key("D", "mail_delete");
	assign_to_key("s", "mail_save");
	assign_to_key("S", "mail_save");
	assign_to_key("w", "mail_write");
	assign_to_key("W", "mail_write");
	assign_to_key("q", "mail_quit");
	assign_to_key("Q", "mail_quit");
	assign_to_key("<Enter>", "mail_select");

	return quote_list("d           Delete message",
					  "s           Save message (without headers)",
					  "w           Save message (with headers)",
					  "q           Abort mail reading.",
					  "<Enter>     Read mail message.");
}

void
mail_save_unread()
{
	string			line;
	int 			n,
					pos,
					start_line,
					end_line,
					num_saved,
					msg_no;
	extern list 	who_list;
	extern int		who_len,
					mailbuf,
					hdrbuf;

	message("Updating %s...", wmailfile);
	/*
	 *	Delete read articles backwards.
	 *	This is necessary otherwise we have to cater for the fact that
	 *	the line indexes in the who_list become incorrect as we delete
	 *	each read article
	 */

	for (n = who_len - 1; n >= 0; --n)
	{
		set_buffer(hdrbuf);
		goto_line(n + 1);
		line = read();
		pos = re_search(NULL, "[.*]", line);
		if (pos > 0 && substr(line, pos, 1) == "*")
		{
			msg_no = atoi(line) - 1;
			start_line = who_list[msg_no * 2];
			end_line = who_list[msg_no * 2 + 1] - 1;
			set_buffer(mailbuf);
			goto_line(start_line);
			drop_anchor(MK_LINE);
			goto_line(end_line);
			delete_block();
		}
		else
			++num_saved;
	}
	set_buffer(mailbuf);
	if (mail_changed())
	{
		error("Sorry - new mail arrived");
		return;
	}
	if (num_saved == 0)
		clear_buffer();
	write_buffer();

	/*
	 * Force internal mod time to be updated
	 */

	mail_changed();
	message("%d message%s saved in %s",
			num_saved,
			num_saved == 1 ? "" : "s",
			wmailfile);
}

void
mail_quit()
{
	extern int		quit_flag;
	quit_flag = TRUE;
	exit();
}

void
mail_delete()
{
	re_translate(NULL, "[*.]*$", "* <Message Deleted>");
	beginning_of_line();
	push_back(key_to_int("<Down>"));
}

void
mail_write()
{
	mail_write_msg(TRUE);
}

void
mail_save()
{
	mail_write_msg(FALSE);
}

void
mail_write_msg(int save_headers)
{
	string			filename,
					msg;
	int 			curbuf,
					line_no,
					start_line,
					end_line;
	extern list 	who_list;
	extern int		mailbuf;
	curbuf = inq_buffer();
	filename = getenv("HOME") + "/mbox";
	if (save_headers)
		msg = "Write to file: ";
	else
		msg = "Save to file: ";
	get_parm(NULL, filename, msg, NULL, filename);

	/*
	 * Check for a folder name
	 */

	if (substr(filename, 1, 1) == "=")
		filename = getenv("HOME") + "/Mail/" + substr(filename, 2);

	line_no = atoi(read()) - 1;

	set_buffer(mailbuf);
	start_line = who_list[line_no * 2];
	end_line = who_list[line_no * 2 + 1] - 1;
	goto_line(start_line);
	if (!save_headers)
	{
		re_search(NULL, "^$");
		down();
	}
	drop_anchor(MK_LINE);
	goto_line(end_line);
	if (write_block(filename, 1) <= 0)
		message("Error whilst trying to write %s", filename);
	else
		message("Message saved in %s", filename);

	set_buffer(curbuf);
	mail_delete();
}


void
mail_dispatch(string whom, string filename, int old_win, int curbuf, int mail_buf)
{
 	string			mail_cmd,
#if !defined( OS2 ) && !defined( MSDOS )
					f,
#endif
					answer;

	/*
	 * Now	ask  user  if  he wants to send the mail response
	 */

	answer = "";
	while (answer != "y" && answer != "n")
	{
		get_parm(NULL, answer, "Really send [y/n]? ", 1);
		answer = lower(answer);
	}

	message("");
	write_buffer();
	delete_window();

	if (answer == "y")
	{
		/*
		 * Escape characters which may cause the
		 * shell to blow up on the from name
		 */

#if !defined( OS2 ) && !defined( MSDOS )
		f = "";
		while ((i = index(from, "!")) > 0)
		{
			f += substr(from, 1, i - 1) + "\\!";
			from = substr(from, i + 1);
		}
		f += from;
		from = f;
# endif
		sprintf(mail_cmd, "%s %s <%s >%s/cr-mail.err", MAILPROG,
					whom, filename, tmpdir());
		message(mail_cmd);
		shell(mail_cmd, 1);
	}

	set_window(old_win);
	set_buffer(curbuf);
	attach_buffer(curbuf);
	delete_buffer(mail_buf);
	remove(filename);
	message("");
}

	/*
	 * Macro used to send mail to someone
	 */

void
mail_send()
{
	string			subject,
					filename,
					whom;
	int				lines,
					cols;
	int 			mail_buf,
					mail_win;
	int 			old_win,
					curbuf;

	curbuf = inq_buffer();
	old_win = inq_window();

	get_parm(0, whom, "Send mail to: ");
	get_parm(1, subject, "Subject: ");
	message("");

	sprintf(filename, "%s/cr%d.mai", tmpdir(), getpid());
	mail_buf = create_buffer("Mail-Buffer", filename, 0);
	inq_screen_size(lines, cols);
	mail_win = sized_window(lines-1, cols-2, "Type <Esc> to terminate entry.");
	set_window(mail_win);
	attach_buffer(mail_buf);

	put_headers(mail_buf, whom, subject);
 	select_editable();
 	mail_dispatch(whom, filename, old_win, curbuf, mail_buf);

}


	/*
	 *	 Macro to send a mail reply
	 */

void
mail_reply()
{
	int 			mail_rep_buf;
	string			filename,
					tmpfile,
					title;
	string			from,
					subject;
	int 			curbuf,
					buf,
					rep_win,
					old_win,
					line_no,
					start_line,
					end_line;
	int				lines,
					cols;
	extern int		top_line,
					mailbuf,
					hdrbuf;
	extern list 	who_list;


	curbuf = inq_buffer();
	old_win = inq_window();

	set_buffer(hdrbuf);
	line_no = atoi(read(4));
	title = ltrim(trim(substr(read(), 4, 30)));
	set_buffer(curbuf);
	if (title == "<Message Deleted>")
		return;

	--line_no;
	start_line = who_list[2 * line_no];
	end_line = who_list[2 * line_no + 1] - 1;

	set_buffer(mailbuf);
	goto_line(start_line);
	drop_anchor(MK_LINE);
	goto_line(end_line);
	sprintf(tmpfile, "%s/cr%d.mai", tmpdir(), getpid());
	write_block(tmpfile);

	buf = create_buffer(title, tmpfile, 1);
	set_buffer(buf);

	sprintf(filename, "%s/cr%d.mrp", tmpdir(), getpid());
	save_position();

	top_of_buffer();
	drop_anchor(MK_LINE);
	end_of_buffer();
	copy();
	restore_position();

	mail_rep_buf = create_buffer("Reply-Buffer-" + wmr_index++,
								 filename, 0);
	top_line++;
	inq_screen_size(lines, cols);
	rep_win = sized_window(lines-1, cols-2, "Type <ESC> to terminate reply");
	set_window(rep_win);
	attach_buffer(mail_rep_buf);

	set_buffer(mail_rep_buf);
	top_of_buffer();
	paste();

	from = get_header("Reply-To:");
	if (from == unknown)
	{
		from = get_header("From:");
		if (from == unknown)
			from = get_header("Sender:");
	}
	subject = get_header("Subject:");

	top_of_buffer();
	drop_anchor(MK_LINE);
	if (re_search(NULL, "^$") > 0)
	{
		delete_block();
		re_translate(SF_GLOBAL, "^", " >");
	}
	raise_anchor();
	insert("\n");

	if (substr(upper(subject), 1, 3) != "RE:")
		subject = "Re: " + subject;

	put_headers(mail_rep_buf, from, subject);

	unregister_macro(REG_TYPED, "sel_alpha");
	select_editable();

	register_macro(REG_TYPED, "sel_alpha", TRUE);
	top_line--;

	mail_dispatch(from, filename, old_win, curbuf, mail_rep_buf);

}

void
put_headers (int bufnum, string toname, string subject)
{
	int 			hours,
					mins,
					secs,
					year,
					mon,
					day,
					maj,
					min,
					edit;
	int				save_line;
	string			month_name,
					day_name,
					date_string,
					from_string,
					xmailer,
					msgid;

	set_buffer(bufnum);
	top_of_buffer();
	date(year, mon, day, month_name, day_name);
	time(hours, mins, secs);
	day_name = substr(day_name, 1, 3);
	month_name = substr(month_name, 1, 3);

	sprintf(from_string, "From %s%s  %s, %d %s %d %02d:%02d:%02d",
			username,
			hostname,
			day_name,
			day,
			month_name,
			year,
			hours,
			mins,
			secs);
	insert(from_string + " " + timezone + "\n");
	sprintf(date_string, "Date: %s, %d %s %d %02d:%02d:%02d",
			day_name,
			day,
			month_name,
			year,
			hours,
			mins,
			secs);
	insert(date_string + " " + timezone + "\n");
	insert("To: " + toname + "\n");
	insert("From: " + username + hostname + realname + "\n");
	sprintf(msgid, "Message-ID: <%d_%d%d.%d%s>\n",
		wmr_number++,
		(year*365)+(mon*31)+day,
		(hours*3600)+(mins*60)+secs,
		getpid(),
		hostname);
	insert(msgid);
	insert("Subject: " + subject + "\n");
	version(maj, min, edit);
	sprintf(xmailer,"X-Mailer: Crisp v%d.%d%c Mail\n", maj, min, edit);
	insert(xmailer);
	insert("\n");
	end_of_buffer();
	inq_position(save_line, NULL);
	end_of_buffer();
	insert("\n\n-- \n");

	/*
	 * Insert users .signature if he's got one
	 */

	read_file(signfile);
	move_abs(save_line, 0);
}

	/*
	 *	 This macro grabs an RFC header line. The name of the line is
	 *	 given by the argument passed to this macro. The RFC label is
	 *	 stripped off and a compressed version of the string after the
	 *	 colon is returned
	 */

string
get_header(string name)
{
	string			value;

	top_of_buffer();
	if (re_search(NULL, "^" + name) > 0)
	{
		value = read();
		value = substr(value, index(value, ":") + 1);
		value = trim(ltrim(compress(value)));

		/*
		 *	If its the From: field then we need to strip off any comments
		 */

		if (name == "From:" || name == "Reply-To:" || name == "Sender:")
		{
			if (index(value, "("))
				value = substr(value, 1, index(value, "(") - 1);
			if (index(value, "<"))
			{
				value = substr(value, index(value, "<") + 1);
				value = substr(value, 1, index(value, ">") - 1);
			}
		}
		if (value != "")
			return value;
	}
	return unknown;
}

void
mail_select()
{
	int 			line_no,
					start_line,
					end_line,
					buf,
					win,
					curbuf,
					curwin;
	string			tmpfile,
					title;
	extern list 	who_list;
	extern int		mailbuf,
					top_line;

	curbuf = inq_buffer();
	curwin = inq_window();
	line_no = atoi(read(4));
	title = ltrim(trim(substr(read(), 4, 30)));
	if (title == "<Message Deleted>")
		return;
	save_position();
	--line_no;
	start_line = who_list[line_no * 2];
	end_line = who_list[line_no * 2 + 1] - 1;

	set_buffer(mailbuf);
	goto_line(start_line);
	right(8);					/* Skip over mmdf signature */
	drop_anchor(MK_NORMAL);
	goto_line(end_line+1);
	left(1);
	sprintf(tmpfile, "%s/cr%d.mai", tmpdir(), getpid());
	write_block(tmpfile);
	raise_anchor();
	buf = create_buffer(title, tmpfile, 1);
	set_buffer(buf);

	/*
	 * Make sure window appears below the
	 * top-level mail popup so its visible
	 */

	top_line++;
	win = sized_window(inq_lines() + 1, inq_line_length(),
					   "<Esc> to return to main menu.");
	select_buffer(buf, win, 0, mail_select_keys());

	/*
	 * Restore the top_line variable for the sized_window() macro
	 * otherwise all subsequent windows will appear one
	 * line further down the screen
	 */

	top_line--;
	remove(tmpfile);
	set_window(curwin);
	set_buffer(curbuf);
	attach_buffer(curbuf);
	top_of_buffer();
	restore_position();
	re_translate(NULL, "[*.]", "*");
	beginning_of_line();
	push_back(key_to_int("<Down>"));
}


	/*
	 *	Function called to set up private key bindings when user opts
	 *	to read a mail message
	 */

list
mail_select_keys()
{
	assign_to_key("<Ctrl-G>", "mail_routines");
	assign_to_key("r", "mail_reply");
	assign_to_key("R", "mail_reply");

	return quote_list(
					  "r        Reply to mail.",
					  "<Ctrl-G> List mail headers.");
}

	/*
	 *	Macro called when user hits <Ctrl-G> for use with
	 *	things like mailing lists, where we have lots of small
	 *	subjects in one file.
	 */

void
mail_routines()
{
	select_routine("<Subject: ",
				   "Mail Topics", "mail_routines_trim");
}

string
mail_routines_trim(string routine_name)
{
	int 			spos;

	raise_anchor();
	spos = re_search(NULL, ":", routine_name);
	if (spos > 0)
	{
		routine_name = substr(routine_name, spos + 1);
		drop_anchor(MK_LINE);
	}
	return ltrim(trim(routine_name));
}

