//
// $Id$
// Various utility macros for Crisp
//
// wc_erase     13-Oct-93 DLN
// dir			16-Oct-93 DLN

# include "crisp.h"

int
	dir_buf;


void
main()
{
	dir_buf = create_buffer("DIR-Buffer", NULL, 0);
}


	// Erase files by wildcard


void
wc_erase()
{
	int i, c, llen;
	string arg, buf;
	list files_to_erase;

	if (get_parm(0, arg, "Erase spec: ", NULL, "") < 0)
		return;
	message("Gathering files...");
	files_to_erase = file_glob(arg);
	llen = length_of_list(files_to_erase);
	if (!llen)
		message("No matching files.");
	else
	{
		for (c = i = 0; i < llen; )
		{
			arg = files_to_erase[i++];
			sprintf(buf, "Erasing %s", arg);
			message(buf);
			if (remove(arg) >= 0)
				++c;
		}
		if (c == llen)
			sprintf (buf, "%d files successfully erased.", llen);
		else
			sprintf (buf, "%d of %d files NOT erased.",  llen - c, llen);
		message(buf);
	}
}

void
dir ()
{
	string fname;

	if (get_parm (0, fname, "DIR: ") <= 0)
		message("Command Aborted.");
	else
	{
		dir_buf = perform_unix_command ("cmd /cdir " + fname, "DIR-Buffer", dir_buf);
		attach_buffer(dir_buf);
		set_buffer(dir_buf);
		set_buffer_flags(~BF_CHANGED);
	}
}

