
(macro chg_properties
    (= properties_changed 1)
)

(macro crisp
    (
        (int len i)
        (string term kbd)
        (list suf_list)
        (= top_keyboard
            (inq_keyboard))
        (assign_to_key "^A" "extra")
        (assign_to_key "^B" "set_bottom_of_window")
        (assign_to_key "^C" "set_center_of_window")
        (assign_to_key "^E" "nlang")
        (assign_to_key "^F" "objects format_block")
        (assign_to_key "^G" "objects routines")
        (assign_to_key "^H" "backspace")
        (assign_to_key "^I" "insert_tab")
        (assign_to_key "^K" "objects delete_word_left")
        (assign_to_key "^L" "objects delete_word_right")
        (assign_to_key "^N" "edit_next_buffer")
        (assign_to_key "^O" "options")
        (assign_to_key "^P" "edit_previous_buffer")
        (assign_to_key "^R" "repeat")
        (assign_to_key "^T" "set_top_of_window")
        (assign_to_key "^U" "redo")
        (assign_to_key "^W" "set_backup")
        (assign_to_key "^Z" "zoom")
        (assign_to_key "^]" "tag_function")
        (assign_to_key "^_" "edit_previous_buffer")
        (assign_to_key "^^" "find_matching_brace")
        (assign_to_key "#127" "delete_character")
        (assign_to_key "<Alt-B>" "buffer_list 1")
        (assign_to_key "<Alt-E>" "edit__file")
        (assign_to_key "<Alt-G>" "goto__line")
        (assign_to_key "<Alt-H>" "help")
        (assign_to_key "<Alt-N>" "edit_next_buffer")
        (assign_to_key "<Alt-P>" "previous_alpha_buffer")
        (assign_to_key "<Alt-Q>" "key")
        (assign_to_key "<Alt-S>" "search__fwd")
        (assign_to_key "<Alt-T>" "translate__fwd")
        (assign_to_key "<Alt-Y>" "search__back")
        (assign_to_key "<F5>" "search__fwd")
        (assign_to_key "<F6>" "translate__fwd")
        (assign_to_key "<Alt-F5>" "search__back")
        (assign_to_key "<Alt-F6>" "translate__back")
        (assign_to_key "<Alt-F7>" "keylib")
        (assign_to_key "<Alt-F10>" "load")
        (assign_to_key "<Alt-End>" "goto_right_edge")
        (assign_to_key "<Alt-Home>" "goto_left_edge")
        (assign_to_key "<Alt-minus>" "previous_alpha_buffer")
        (assign_to_key "<Ctrl-F5>" "toggle_re_case")
        (assign_to_key "<Ctrl-F6>" "toggle_re")
        (assign_to_key "<Ctrl-Left-Arrow>" "objects word_left")
        (assign_to_key "<Ctrl-Right-Arrow>" "objects word_right")
        (assign_to_key "<Ctrl-minus>" "delete_curr_buffer")
        (assign_to_key "^_" "delete_curr_buffer")
        (assign_to_key "<Del>" "delete_character")
        (assign_to_key "<End>" "end")
        (assign_to_key "<Home>" "home")
        (assign_to_key "<Keypad-5>" "search_next")
        (assign_to_key "<Shift-F5>" "search_next")
        (assign_to_key "<Shift-F6>" "translate_again")
        (assign_to_key "<Shift-F10>" "load")
        (assign_to_key "<Shift-Tab>" "insert_backtab")
        (assign_to_key "<PrtSc>" "print")
        (assign_to_key "<Keypad-Scroll>" "scroll")
        (assign_to_key "<Alt-0>" "drop_bookmark 0")
        (assign_to_key "<Alt-1>" "drop_bookmark 1")
        (assign_to_key "<Alt-2>" "drop_bookmark 2")
        (assign_to_key "<Alt-3>" "drop_bookmark 3")
        (assign_to_key "<Alt-4>" "drop_bookmark 4")
        (assign_to_key "<Alt-5>" "drop_bookmark 5")
        (assign_to_key "<Alt-6>" "drop_bookmark 6")
        (assign_to_key "<Alt-7>" "drop_bookmark 7")
        (assign_to_key "<Alt-8>" "drop_bookmark 8")
        (assign_to_key "<Alt-9>" "drop_bookmark 9")
        (assign_to_key "<Ctrl-F1>" "borders")
        (assign_to_key "<Shift-Keypad-plus>" "copy 1")
        (assign_to_key "<Shift-Keypad-minus>" "cut 1")
        (assign_to_key "<Ctrl-Keypad-plus>" "copy_named_scrap")
        (assign_to_key "<Ctrl-Keypad-minus>" "cut_named_scrap")
        (assign_to_key "<Ctrl-Ins>" "paste_named_scrap")
        (register_macro 2 "prompt_help")
        (autoload "abbrev" "load_abbrev_file")
        (autoload "autosave" "autosave_disable" "get_autosave")
        (autoload "box" "dobox")
        (autoload "brace" "find_matching_brace")
        (autoload "brief" "del" "dos" "inq_brief_level")
        (autoload "c" "hier")
        (autoload "compile" "set_load" "get_load" "load" "errors" "make"
            "lint" "default_next_error" "default_previous_error")
        (autoload "copyr" "ccopyr" "fn")
        (autoload "core" "_fatal_error")
        (autoload "debug" "eval" "vars")
        (autoload "extra" "edit_again" "make_writeable")
        (autoload "feature" "select_feature")
        (autoload "objects" "objects" "shift_left" "shift_right" "lshift"
            "shiftl" "rshift" "shiftr" "c_routines" "h_routines" "m_routines"
            "mm_routines" "select_routine")
        (autoload "help" "help" "help_display" "explain" "help_command_summary"
            "cshelp")
        (autoload "history" "_prompt_begin" "_prompt_end" "prompt_help"
        )
        (autoload "man" "apropos")
        (autoload "misc" "delete_curr_buffer" "goto__line" "redo" "_indent"
            "ansi" "display_file_name" "end" "home" "noundo" "insert_tab"
            "insert_backtab" "force_input" "previous_tab" "quote" "repeat"
            "join_line" "edit_next_buffer" "edit__file" "previous_edited_buffer"
            "previous_alpha_buffer" "set_fs" "delete_character" "delete_blank_lines"
            "print" "get_print")
        (autoload "options" "options" "echo_line_options")
        (autoload "region" "copy" "cut" "paste" "block_delete" "block_lower_case"
            "block_upper_case" "sum")
        (autoload "remember" "remember" "keylib" "km_load" "km_path" "compl_keylib"
        )
        (autoload "restore" "_startup_complete" "save_state")
        (autoload "scrap" "copy_named_scrap" "cut_named_scrap" "paste_named_scrap"
        )
        (autoload "search" "i_search" "toggle_re" "toggle_re_case" "translate_again"
            "get_case_sensitive" "set_case_sensitive" "translate__back"
            "translate__fwd" "search__fwd" "search__back" "search_next"
            "search_prev" "search_options" "search_hilite")
        (autoload "select" "field_list" "sized_window" "select_list" "select_slim_list"
            "select_file" "select_buffer" "buffer_list")
        (autoload "shell" "cmd" "os2" "sh" "tcsh" "ksh" "bash" "create_shell"
        )
        (autoload "tags" "mtags" "tag" "tags" "tag_function")
        (autoload "telnet" "rlogin")
        (autoload "text" "grep" "fgrep" "egrep" "spell" "wc")
        (autoload "unix" "fixslash" "tmpdir" "getshell" "perform_unix_command"
        )
        (autoload "window" "goto_left_edge" "goto_right_edge" "set_top_of_window"
            "set_bottom_of_window" "set_center_of_window")
        (autoload "wp" "autowrap" "center" "get_autowrap" "get_justification"
            "set_justification" "wp_options" "h_format_block" "cr_format_block"
            "y_format_block" "c_format_block" "default_format_block"
            "margin" "get_margin")
        (autoload "view" "literal")
        (autoload "utils" "wc_erase" "dir" "toggle_borders")
        (autoload "rcs" "co")
        (autoload "tabs" "entab" "detab" "detab_buffer" "entab_buffer"
        )
        (if
            (&
                (display_mode)1)
            ((int edit min maj)
                (string buf1 buf)
                (version maj min edit)
                (sprintf buf "Crisp v%d.%d%c" maj min edit)
                (sprintf buf1 "v%d.%d%c" maj min edit)
                (set_wm_name buf buf1)
                (= len 0)
                (set_term_features  NULL  NULL  NULL  NULL  NULL  NULL  NULL
                     NULL  NULL 1)
                (load_macro "mouse")
                (define_mouse_buttons))
            ((= term
                    (getenv "BTERM"))
                (if
                    (== term "")
                    (= term
                        (lower
                            (getenv "TERM"))))
                (if
                    (== term "")
                    (load_macro "tty/tty")
                    ((= suf_list
                            (split term "-"))
                        (if
                            (!
                                (load_macro
                                    (+ "tty/"
                                        (nth 0 suf_list))))
                            (load_macro "tty/tty"))))
                (= len
                    (length_of_list suf_list))))
        (for
            (= i 0)
            (<
                (++ i)len) NULL
            (execute_macro
                (nth i suf_list)))
        (echo_line 63)
        (display_windows 1)
        (init_load)
        (refresh)
        (= kbd
            (lower
                (getenv "BKBD")))
        (if
            (!= kbd "")
            (load_macro
                (+ "kbd/" kbd))))
)

(macro shell_pop
    (
        ((string command)
            (get_parm 0 command)
            (int col line buf curbuf curwin)
            ((= curwin
                    (inq_window))
                (= curbuf
                    (inq_buffer))
                (= buf
                    (create_buffer "Shell Pop-Up"  NULL 1)))
            (create_window 55 8 77 2)
            (attach_buffer buf)
            (connect)
            (insert
                (+ command "\n"))
            (inq_position line col)
            (set_process_position line col)
            (insert_process
                (+ command "\n"))
            (refresh)
            (wait)
            (delete_buffer buf)
            (delete_window)
            (set_buffer curbuf)
            (set_window curwin)))
)

(macro clear_buffer
    (
        (top_of_buffer)
        (drop_anchor)
        (end_of_buffer)
        (delete_block))
)

(macro ansi_arrows
    (set_term_keyboard 514 "[B" 520 "[A" 518 "[C" 516 "[D")
)

(macro _extension
    (
        (int i)
        (string ext)
        (inq_names  NULL ext)
        (= ext
            (+
                (+ "^"
                    (quote_regexp ext))"$"))
        (= i
            (re_search  NULL ext tab_settings))
        (if
            (< i 0)
            (= i
                (re_search  NULL "default" tab_settings)))
        (if
            (>= i 0)
            (tabs
                (nth
                    (+ i 1)tab_settings))
            (tabs 5)))
)

(macro get_tabs
    (return saved_tabs)
)

(macro set_tabs
    (
        ((string arg)
            (get_parm 0 arg)
            (= saved_tabs arg)
            (= tab_settings
                (split arg " =." 1))))
)

(macro init_load
    (
        (int i curbuf buf)
        (string home fn line file)
        (if
            (!
                (first_time))
            (return))
        (register_macro 5 "init_exit")
        (= home
            (getenv "HOME"))
        (if
            (== home "")
            (= file
                (+ "~/" ".crinit"))
            (= file
                (+
                    (+ home "/")".crinit")))
        (if
            (!
                (exist file))
            ((sprintf fn "%s does not exist" file)
                (message fn)
                (= properties_changed 1)
                (return)))
        (= curbuf
            (inq_buffer))
        (= buf
            (create_buffer "-props-" file 1))
        (set_buffer buf)
        (= properties  NULL)
        (while
            (!=
                (= line
                    (compress
                        (read)1))"")
            ((down)
                (= i
                    (index line ":"))
                (if
                    (<= i 0)
                    (continue))
                (= fn
                    (substr line 1
                        (- i 1)))
                (+= properties fn)
                (if
                    (inq_macro
                        (+ "set_" fn))
                    (= fn
                        (+ "set_" fn)))
                (sprintf fn "%s \"%s\"" fn
                    (ltrim
                        (substr line
                            (+ i 1))))
                (execute_macro fn)))
        (set_buffer curbuf)
        (attach_buffer curbuf)
        (delete_buffer buf))
)

(macro init_exit
    (
        (int curbuf buf len i)
        (string home file s)
        (= home
            (getenv "HOME"))
        (if
            (== home "")
            (= file
                (+ "~/" ".crinit"))
            (= file
                (+
                    (+ home "/")".crinit")))
        (if
            (>
                (inq_buffer file)0)
            (return))
        (= curbuf
            (inq_buffer))
        (= buf
            (create_buffer "-props-"  NULL 1))
        (set_buffer buf)
        (for
            ((= i 0)
                (= len
                    (length_of_list properties)))
            (< i len) NULL
            ((= s
                    (nth
                        (post++ i)properties))
                (if
                    (inq_macro
                        (+ "get_" s))
                    (insert
                        (+
                            (+
                                (+ s ": ")
                                (execute_macro
                                    (+ "get_" s)))"\n"))
                    (insert
                        (+ s ":\n")))))
        (output_file file)
        (write_buffer)
        (set_buffer curbuf)
        (attach_buffer curbuf)
        (delete_buffer buf))
)

(macro get_color_index
    (return my_color_index)
)

(macro set_color_index
    (
        ((string arg)
            (get_parm 0 arg)
            (= my_color_index
                (atoi arg))
            (color_index my_color_index)))
)

(macro get_borders
    (return
        (if
            (borders -1)"yes" "no"))
)

(macro set_borders
    (
        ((string arg)
            (get_parm 0 arg)
            (if
                (== arg "yes")
                (borders 1)
                (borders 0))))
)

(macro get_hard_tabs
    (return
        (if
            (use_tab_char 0)"yes" "no"))
)

(macro set_hard_tabs
    (
        ((string arg)
            (get_parm 0 arg)
            (use_tab_char arg)))
)

(macro get_syntax
    (return
        (if
            (re_syntax)"unix" "crisp"))
)

(macro set_syntax
    (
        ((string arg)
            (get_parm 0 arg)
            (if
                (== arg "unix")
                (re_syntax 1)
                (re_syntax 0))))
)

(macro get_colors
    (
        (int hi_fg hi_bg errors messages selected normal background)
        (string buf)
        (get_color background normal selected messages errors hi_bg hi_fg
        )
        (sprintf buf "%s %s %s %s %s %s %s"
            (nth background color_names)
            (nth normal color_names)
            (nth selected color_names)
            (nth messages color_names)
            (nth errors color_names)
            (nth hi_bg color_names)
            (nth hi_fg color_names))
        (return buf))
)

(macro set_colors
    (
        ((string arg)
            (get_parm 0 arg)
            (execute_macro
                (+ "color " arg))))
)

(macro autoindent
    (
        (string arg)
        (get_parm 0 arg "Turn autoindent on (y/n) ? ")
        (if
            (==
                (upper
                    (substr arg 1 1))"Y")
            ((= autoindent_flag 1)
                (assign_to_key "<Enter>" "_indent")
                (message "Auto-indent enabled"))
            ((assign_to_key "<Enter>" "self_insert")
                (= autoindent_flag 0)
                (message "Auto-indent disabled"))))
)

(macro get_window_color
    (return my_window_color)
)

(macro set_window_color
    (
        ((string arg)
            (get_parm 0 arg)
            (int attrib)
            (= attrib
                (atoi arg))
            (if attrib
                ((= my_window_color attrib)
                    (window_color attrib)))))
)

(macro set_autoindent
    (
        ((string arg)
            (get_parm 0 arg)
            (if
                (==
                    (upper
                        (substr arg 1 1))"Y")
                ((= autoindent_flag 1)
                    (assign_to_key "<Enter>" "_indent"))
                ((assign_to_key "<Enter>" "self_insert")
                    (= autoindent_flag 0)))))
)

(macro get_autoindent
    (return
        (if autoindent_flag "yes" "no"))
)

(macro sub
    (
        ((string r s t)
            (get_parm 0 r)
            (get_parm 1 s)
            (get_parm 2 t)
            (return
                (re_translate 8 r s t))))
)

(macro gsub
    (
        ((string r s t)
            (get_parm 0 r)
            (get_parm 1 s)
            (get_parm 2 t)
            (return
                (re_translate 72 r s t))))
)

(macro cd
    (
        (string __dir)
        (if
            (!=
                (inq_called)"")
            (return
                (cd)))
        (if
            (>
                (get_parm 0 __dir)0)
            ((cd __dir)
                (getwd  NULL __dir)
                (set_wm_name __dir))
            (cd)))
)

(macro write_buffer
    (
        (int old_msg_level ret)
        (if
            (!=
                (inq_called)"")
            (return
                (write_buffer)))
        (= old_msg_level
            (inq_msg_level))
        (if
            (inq_marked)
            ((set_msg_level 1)
                (= ret
                    (write_block)))
            ((set_msg_level 0)
                (= ret
                    (write_buffer))))
        (set_msg_level old_msg_level)
        (return ret))
)

(macro _init
    (
        (int my_color_index my_window_color popup_level top_keyboard properties_changed
            autoindent_flag)
        (string saved_tabs last_file_edited CRISP_SLASH CRISP_DELIM CRISP_OPSYS
            translate__replacement translate__pattern search__pattern
        )
        (list color_names tab_settings kbd_labels properties)
        (global color_names saved_tabs tab_settings my_color_index my_window_color
            popup_level last_file_edited kbd_labels CRISP_SLASH CRISP_DELIM
            CRISP_OPSYS top_keyboard properties properties_changed autoindent_flag
            translate__replacement translate__pattern search__pattern
        )
        (= color_names
            (quote_list "black" "blue" "green" "cyan" "red" "magenta" "brown"
                "white" "dark-grey" "light-blue" "light-green" "light-cyan"
                "light-red" "light-magenta" "light-yellow" "light-white"
            ))
        (= saved_tabs ".m=4 .cr=5 .c=5 .cc=5 .cpp=5 .h=5 .s=5 .i=5 default=9"
        )
        (= tab_settings
            (quote_list "m" 4 "cr" 5 "c" 5 "cc" 5 "cpp" 5 "h" 5 "s" 5 "i" 5 "default"
                9))
        (= my_color_index 0)
        (= my_window_color 0)
        (= last_file_edited "")
        (= CRISP_SLASH "/")
        (= CRISP_DELIM "/")
        (= CRISP_OPSYS "OS/2")
        (= properties
            (quote_list "autoindent" "autosave" "colors" "hard_tabs" "syntax"
                "tabs" "borders" "case_sensitive" "autowrap" "justification"
                "margin" "color_index" "window_color"))
        (= properties_changed 0)
        (= autoindent_flag 1))
)
