/*************************************************************************/
/*    																	 */
/*    comment.cr														 */
/*    																	 */
/*    C/C++ block comment/uncomment										 */
/*    																	 */
/*************************************************************************/

# include "crisp.h"

/*************************************************************************/
/*    																	 */
/*    _comment_block:													 */
/*    																	 */
/*    This macro comments out a block of code. It tries to be			 */
/*    intelligent about things like comments inside the block -- if		 */
/*    it finds one, it escapes it and moves on.							 */
/*    																	 */
/*    Two different types of blocks are created, depending on the		 */
/*    cursor start and end positions. If both are in column one,		 */
/*    comment_block assumes a "block" type comment is desired. Block	 */
/*    comments have "**" inserted in rows other than the first and		 */
/*    last.																 */
/*    																	 */
/*    If the start and end columns are not both in column one, the		 */
/*    area is simply bracketed by C comment delimiters  				 */
/*    																	 */
/*************************************************************************/

void
_comment_block()
{
	int		start_line,
			start_col,
			end_line,
			end_col,
			curr_col;

	if (inq_marked(start_line, start_col, end_line, end_col) != MK_NONE)
	{
		string	pattern;

		raise_anchor();
		save_position();
		move_abs(end_line, end_col);
		insert("\xff");
		move_abs(start_line, start_col);

		if (start_col == 1)
			insert("/* ");
		else
			insert(" /* ");
		if ((start_col == 1) && (end_col == 1))
			pattern = "{/\\*}|{\\*/}|{\\*\\*}|<|\xff";
		else
			pattern = "{/\\*}|{\\*/}|{\\*\\*}|\xff";
		while (search_fwd(pattern) && (read(1) != "\xff"))
		{
			inq_position(NULL, curr_col);
			if (curr_col == 1 && start_col == 1 && end_col == 1)
				insert(" *\t");
			else
			{
				insert("\\");
				right();
			}
		}
		delete_char();

		if (end_col == 1)
			insert("*/ ");
		else
			insert(" */ ");
		restore_position();
	}
	else
		error("No marked block.");
}	


/*************************************************************************/
/*    																	 */
/*    _uncomment_block:													 */
/*    																	 */
/*    This routine uncomments a block of code that was commented out	 */
/*    by comment_block. It removed the comment and leading "**"			 */
/*    characters (if appropriate), and restores the internal			 */
/*    comments to their original, un-escaped state.						 */
/*    																	 */
/*************************************************************************/


void
_uncomment_block()
{
	int		start_line,
			start_col,
			end_line,
			end_col;

	if (inq_marked(start_line, start_col, end_line, end_col))
	{
		raise_anchor();
		save_position();
		move_abs(end_line, end_col);
		insert("\xff");
		move_abs(start_line, start_col);

		while (read(1) != "\xff")
		{
			search_fwd("{</\\* }|{<\\*/ }|{ /\\* }|{<\\*\\*\t}|{ \\*/ }|{\\\\\\*}|{\\\\/\\*}|\xff");
			
			if (read(1) != "\xff")
			{
				if (read(1) == "\\")
				{
					delete_char();
					right();
				}
				else
				{
					string tmpstr;
					drop_anchor();
					if (read(1) != " " || (tmpstr = read(2)) == "**" || tmpstr == " *")
						move_rel(0, 2);
					else
						move_rel(0, 3);
					delete_block();
				}
			}
		}
		delete_char();
		restore_position();
	}
	else
		error("No marked block.");
}

