'
' ae-play.vbs - Attempt to handle common file extensions
'
' This script is intended to be called by Andys Editor, via ae-play.cmd.
'

Option Explicit

'...sutils:0:
' Misc

Dim sXopts, iExitCode
sXopts = ""
iExitCode = 0

'...sErrDesc:0:
Function ErrDesc()

	Dim sText

	sText = Err.Description
	If sText <> "" Then
		sText="='" & sText & "'"
	End If 
	ErrDesc = "Err=&H" & Hex(Err.Number) & "=" & Err.Number & sText

End Function
'...e
'...sGetEnv:0:
' Return an environment variable.
' Not interested in system or user values, return the value in force now.
' Returns "" if not defined.

Function GetEnv(sEnvVar)

	Dim oShell
	Set oShell = WScript.CreateObject("WScript.Shell")
	Dim oEnvSys
	Set oEnvSys = oShell.Environment("PROCESS")
	GetEnv = oEnvSys(sEnvVar)
	Set oEnvSys = Nothing
	Set oShell  = Nothing

End Function
'...e
'...sContains:0:
Function Contains(a, s)

	Dim i
	For i = LBound(a) To UBound(a)
		If a(i) = s Then
			Contains = i
			Exit Function
		End If
	Next
	Contains = -1

End Function
'...e
'...sEndsWith:0:
Function EndsWith(s, sEnding)

	EndsWith = ( Right(s, Len(sEnding)) = sEnding )

End Function
'...e

' File related

'...sDirname:0:
' Remove the path, and strip the suffix if present

Function Dirname(sDirname)

	Dim i
	i = InStrRev(sDirname, "\")
	If i <> 0 Then
		Dirname = Left(sDirname, i-1)
	Else
		Dirname = sDirname
	End If

End Function
'...e
'...sBasename:0:
' Remove the path, and strip the suffix if present

Function Basename(sFilename, sSuffix)

	Dim i, s

	i = InStrRev(sFilename, "\")
	If i <> 0 Then
		s = Mid(sFilename, i+1)
	Else
		s = sFilename
	End If

	If Right(sFilename, Len(sSuffix)) = sSuffix Then
		s = Left(s, Len(s)-Len(sSuffix))
	End If

	Basename = s

End Function
'...e
'...sForwardSlash:0:
' Very often we need paths with directory seperators as /'s so we can
' put them into properties files.

Function ForwardSlash(sPath)

	Dim oRE

	Set oRE = New RegExp
	oRE.IgnoreCase = True
	oRE.Global     = True
	oRE.Pattern    = "\\"
	ForwardSlash = oRE.Replace(sPath, "/")
	Set oRE = Nothing

End Function
'...e
'...sBackwardSlash:0:
Function BackwardSlash(sPath)

	Dim oRE

	Set oRE = New RegExp
	oRE.IgnoreCase = True
	oRE.Global     = True
	oRE.Pattern    = "/"
	BackwardSlash = oRE.Replace(sPath, "\")
	Set oRE = Nothing

End Function
'...e
'...sIsDirectory:0:
Function IsDirectory(sDir)

	On Error Resume Next
	Err.clear

	Dim oFSO, oFile
	Set oFSO = CreateObject("Scripting.FileSystemObject")
	Set oFile = oFSO.GetFolder(sDir)
	If Err.Number = 0 Then
		IsDirectory = True
	Else
		IsDirectory = False
		Err.clear
	End If
	Set oFile = Nothing
	Set oFSO  = Nothing

End Function
'...e
'...sIsAbsolutePath:0:
Function IsAbsolutePath(sPath)

	If Len(sPath) >= 3 And _
	   UCase(Left(sPath,1)) >= "A" And _
	   UCase(Left(sPath,1)) <= "Z" And _
	   Mid(sPath,2,1) = ":" And _
	   ( Mid(sPath,3,1) = "\" Or Mid(sPath,3,1) = "/" ) Then
		IsAbsolutePath = True
	Else
		IsAbsolutePath = False
	End If

End Function 
'...e
'...sAbsoluteFilename:0:
Function AbsoluteFilename(sFilename)

        On Error Resume Next
        Err.clear

        Dim oFSO
        Set oFSO = CreateObject("Scripting.FileSystemObject")
        AbsoluteFilename = oFSO.GetAbsolutePathName(sFilename)
        Set oFSO = Nothing

End Function
'...e

' Running subcommands

'...sShell:0:
' WSH gives no select/poll for multiple textstreams, so we assume that stderr
' comes at the end of the output.
' Assumes WSH 5.6 or later
'
' The command is run in a subshell, but it appears that even though the parent
' has access to the console, the child does not. So running an text mode editor
' such as AE doesn't work (it can't initialise the screen). In this case a
' command line "%comspec% /c c:\ae\ae.exe" will work. 

Function Shell(sCommand, bEcho)

	On Error Resume Next
	Err.clear

	If InStr(","&sXopts&",", ",shell,") <> 0 Then
		WScript.echo("DEBUG: Shell " & sCommand)
	End If

	Dim bShellEcho
	bShellEcho = ( InStr(","&sXopts&",", ",shellecho,") <> 0 )

	iExitCode = 0

	Dim oShell, oExec, s

	Set oShell = WScript.CreateObject("WScript.shell")
	Set oExec = oShell.Exec(sCommand)

	If Err.Number <> 0 Then
		Set oExec   = Nothing
		Set oShell = Nothing
		Shell = "can't execute '" & sCommand & "': " & ErrDesc()
		Exit Function
	End If

	Do While Not oExec.StdOut.AtEndOfStream
		s = oExec.StdOut.ReadLine
		If bEcho Or bShellEcho Then
			WScript.echo(s)
		End If
	Loop
	Do While Not oExec.StdErr.AtEndOfStream
		s = oExec.StdErr.ReadLine
		If bEcho Or bShellEcho Then
			WScript.echo(s)
		End If
	Loop
	Do While oExec.Status = 0
		WScript.Sleep(100)
	Loop

	iExitCode = oExec.ExitCode
	If oExec.ExitCode <> 0 Then
		Shell = "error executing '" & sCommand & "', rc=" & oExec.ExitCode
		Set oExec  = Nothing
		Set oShell = Nothing
		Exit Function
	End If

	Set oExec  = Nothing
	Set oShell = Nothing

	Shell = "ok"

End Function
'...e
'...sShellFullScreen:0:
Function ShellFullScreen(sCommand, bEcho)

	Dim oShell
	Set oShell = WScript.CreateObject("WScript.Shell")
	Const WshNormalFocus = 1
	oShell.Run "%comspec% /c " & sCommand, WshNormalFocus, True
	Set oShell = Nothing

	ShellFullScreen = "ok"

End Function
'...e
'...e
'...smain:0:
On Error Resume Next
Err.clear

Dim e, i

Dim sOpenSSL
sOpenSSL = "c:\openssl"
Dim sJava
sJava = "c:\jdk1.6.0_17"
Dim sGskit
sGskit7 = "c:\Progra~1\IBM\gsk7"

Dim aBin, aJar, aShow
aBin = Array("obj", "lib", "com", "exe", "dll", "nlm", "class", "sth")
aJar = Array("jar", "war", "ear")
aShow = Array("bmp", "gif", "tif", "pcx", "jpg")

If WScript.Arguments.Count = 0 Then
	Usage()
End If

For i = 0 To WScript.Arguments.Count-1
	Dim sArg
	sArg = WScript.Arguments(i)
	If IsDirectory(sArg) Then
		e = sArg & " is a directory"
	Else
		Dim iDot
		iDot = InStrRev(sArg, ".")
		If iDot = 0 Then
			e = sArg & " has no file extension"
		Else
			Dim sExt
			sExt = LCase(Mid(sArg, iDot+1))
			If Contains(aBin, sExt) <> -1 Then
				e = ShellFullScreen("be " & sArg, True)
			ElseIf Contains(aJar, sExt) <> -1 Then
				e = Shell(sJava & "\bin\jar -tvf " & sArg, True)
			ElseIf Contains(aShow, sExt) <> -1 Then
				e = Shell("show " & sArg, True)
			' Office document related
			ElseIf EndsWith(sArg, ".pdf") Then
				e = Shell("foxitreader """ & sArg & """", True)
			' Archive related
			ElseIf EndsWith(sArg, ".tar") Then
				e = Shell("tar -tvf """ & sArg & """", True)
			ElseIf EndsWith(sArg, ".zip") Then
				e = Shell("unzip -v """ & sArg & """", True)
			' Crypto related
			ElseIf EndsWith(sArg, ".rawkey.pem") Then
				e = Shell(sOpenSSL & "\bin\openssl pkcs8 -in """ & sArg & """ -inform PEM", True)
			ElseIf EndsWith(sArg, ".key.pem") Then
				e = Shell(sOpenSSL & "\bin\openssl pkcs8 -in """ & sArg & """ -inform PEM -nocrypt", True)
			ElseIf EndsWith(sArg, ".csr.pem") Or _
			       EndsWith(sArg, ".csr") Then
				e = Shell(sOpenSSL & "\bin\openssl req -in """ & sArg & """ -inform PEM -text", True)
			ElseIf EndsWith(sArg, ".cert.pem") Or _
			       EndsWith(sArg, ".cer") Or _
			       EndsWith(sArg, ".arm") Then
				e = Shell(sOpenSSL & "\bin\openssl x509 -in """ & sArg & """ -inform PEM -text", True)
'				e = Shell(sJava & "\bin\keytool -printcert -file """ & sArg & """", True)
			ElseIf EndsWith(sArg, ".p12") Then
				e = Shell(sOpenSSL & "\bin\openssl pkcs12 -in """ & sArg & """", True)
			ElseIf EndsWith(sArg, ".jks") Then
				e = Shell(sJava & "\bin\keytool -list -v -keystore """ & sArg & """ -storepass password", True)
			ElseIf EndsWith(sArg, ".jceks") Then
				e = Shell(sJava & "\bin\keytool -list -v -keystore """ & sArg & """ -storetype JCEKS -storepass password", True)
'			ElseIf EndsWith(sArg, ".kdb") Then
'				e = Shell(sGskit7 & "\bin\gsk7cmd ...", True)
			ElseIf EndsWith(sArg, ".mtx") Then
				e = Shell("memu -vid-win-big -snd-portaudio " & sArg, True)
			ElseIf EndsWith(sArg, ".run") Then
				e = Shell("memu -vid-win-big -snd-portaudio " & sArg, True)
			ElseIf EndsWith(sArg, ".com") Then
				e = Shell("memu -vid-win-big -snd-portaudio " & sArg, True)
			' Give up
			Else
				e = sArg & " does not have a recognised file extension"
			End If
		End If
	End If
	If e <> "ok" Then
		WScript.echo(e)
		WScript.quit(10)
	End If
Next

WScript.quit(0)
'...e
