/* PrtRaw.c program for Printer Driver
 * FxPrint Copyright (c) 1993-1999 Keller Group Inc.  All rights reserved.
 *
 * Rather than writing to LPT3, this program uses DevEscape calls to send
 * RAW data to printer driver bypassing the spooler.  This way, the program
 * knows when the conversion is finished.
 *
 * The -q argument sends commands to tell the printer driver to queue
 * the fax for sending.  Without the arguemt, the program tells the
 * driver to write the fax into the file 'Test.fax'.
 */

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_PM
#define INCL_GPI
#define INCL_SPL
#define INCL_SPLDOSPRINT
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

int
main(
    int argc,
    char *argv[] )
{
    HAB prn_hab;
    HMQ prn_hmq;
    HDC prn_hdc = DEV_ERROR;
    ULONG rc, ul, index;
    LONG n;
    BYTE prqbuf[ 1024 ], prdbuf[ 1024 ], buf[ 1024 ];
    PCHAR cp;
    PPRQINFO3 prq3;
    PPRDINFO3 prd3;
    DEVOPENSTRUC dop;
    PCHAR queue = "FxPrint";
    PCHAR title = "PrnRaw";
    FILESTATUS3 fsts3;
    BOOL faxqueue = FALSE;

    if ( argc > 1 && stricmp( argv[1], "-q" ) == 0 )
	faxqueue = TRUE;

    prn_hab = WinInitialize( 0 );
    prn_hmq = WinCreateMsgQueue( prn_hab, 0 );
    /*
     * As this is not a full PM program with msg loop, we must ingore
     * shutdown msgs so our queue doesn't clog things up.
     */
    WinCancelShutdown( prn_hmq, TRUE );

    rc = SplQueryQueue( NULL, queue, 3, prqbuf, sizeof( prqbuf ), &ul );
    if ( rc != NO_ERROR ) {
	printf( "Can't find '%s' printer queue. (%u)\n", queue, rc );
	goto out;
    }
    prq3 = (PVOID)prqbuf;

    if ( SplQueryDevice( NULL, prq3->pszPrinters, 3,
	    prdbuf, sizeof( prdbuf ), &ul ) != NO_ERROR ) {
	printf( "Can't find '%s' printer. (%u)", prq3->pszPrinters, rc );
	goto out;
    }
    prd3 = (PVOID)prdbuf;

    memset( &dop, 0, sizeof( DEVOPENSTRUC ) );
    dop.pszDriverName = prq3->pszDriverName;
    cp = strchr( dop.pszDriverName, '.' );
    if ( cp != NULL )
	*cp = '\0';
    dop.pdriv = prq3->pDriverData;
    dop.pszDataType = "PM_Q_RAW";
    dop.pszComment = title;
    if ( faxqueue )
	dop.pszLogAddress = prd3->pszLogAddr;
    else
	dop.pszLogAddress = "Test.fax";

    prn_hdc = DevOpenDC( prn_hab, OD_DIRECT, "*",
	    sizeof( dop ) / sizeof( PVOID ), (PVOID)&dop, 0 );
    if ( prn_hdc == DEV_ERROR ) {
	printf( "Open DC failed. (%04X)\n",
		ERRORIDERROR( WinGetLastError( prn_hab ) ) );
	goto out;
    }

    if ( DevEscape( prn_hdc, DEVESC_STARTDOC, (LONG)strlen( title ), title,
	    NULL, NULL ) != DEV_OK ) {
	printf( "StartDoc failed. (%04X)\n",
		ERRORIDERROR( WinGetLastError( prn_hab ) ) );
	goto out;
    }

    if ( faxqueue ) {
	strcpy( buf, ">>FROM=Joe,Joe's Inc,555-555-6666,555-555-7777\r" );
	DevEscape( prn_hdc, DEVESC_RAWDATA, (LONG)strlen( buf ),buf,NULL,NULL);

	strcpy( buf, ">>TO=Tech Support,Keller Group Inc.,1 651 653-1987\r" );
	DevEscape( prn_hdc, DEVESC_RAWDATA, (LONG)strlen( buf ),buf,NULL,NULL);

	strcpy( buf, ">>INFO=Please read this fax,Joe's Inc.,*\r" );
	DevEscape( prn_hdc, DEVESC_RAWDATA, (LONG)strlen( buf ),buf,NULL,NULL);

	strcpy( buf, ">>AT=1p,1/1/99\r" );
	DevEscape( prn_hdc, DEVESC_RAWDATA, (LONG)strlen( buf ),buf,NULL,NULL);
    }

    /* send enhanced printer driver commands */
    strcpy( buf, ">>BOX=0,0,812,1028\r\n" );
    DevEscape( prn_hdc, DEVESC_RAWDATA, (LONG)strlen( buf ), buf, NULL, NULL );

    strcpy( buf, ">>POSITION=250,500\r\n" );
    DevEscape( prn_hdc, DEVESC_RAWDATA, (LONG)strlen( buf ), buf, NULL, NULL );

    /* send some text */
    strcpy( buf, ">>FONT=Helvetica,25\r\n" );
    DevEscape( prn_hdc, DEVESC_RAWDATA, (LONG)strlen( buf ), buf, NULL, NULL );

    strcpy( buf, "Max box on 8.5 x 11\r\n" );
    DevEscape( prn_hdc, DEVESC_RAWDATA, (LONG)strlen( buf ), buf, NULL, NULL );

    index = 0;
    n = sizeof( index );
    if ( DevEscape( prn_hdc, DEVESC_ENDDOC, 0, NULL, &n, (PBYTE)&index )
	    == DEVESC_ERROR ) {
	printf( "EndDoc failed. (%04X)\n",
		ERRORIDERROR( WinGetLastError( prn_hab ) ) );
	goto out;
    }
    DevCloseDC( prn_hdc );
    prn_hdc = DEV_ERROR;

    if ( faxqueue ) {
	printf( "Fax should now be spooled fax log with index %u\n", index );
    } else {
	if ( DosQueryPathInfo( dop.pszLogAddress, FIL_STANDARD, &fsts3,
		sizeof( fsts3 ) ) == NO_ERROR && fsts3.cbFile > 0 )
	    printf( "'%s' created (%u bytes)\n",
		    dop.pszLogAddress, fsts3.cbFile );
	else
	    printf( "Problem with '%s'\n", dop.pszLogAddress );
    }
out:
    if ( prn_hdc != DEV_ERROR )
	DevCloseDC( prn_hdc );
    WinDestroyMsgQueue( prn_hmq );
    WinTerminate( prn_hab );
    return( 0 );
}
