/*
** 240298 cawim - ptr to function typen korrigiert
*/

#include <windows.h>
#include <stdio.h>

//#include "..\..\common\source\global.h"

#define DLLNAME "CAPI2032"

typedef DWORD ( APIENTRY *tREGISTER          )( DWORD, DWORD, DWORD,
                                                DWORD, DWORD * );
typedef DWORD ( APIENTRY *tRELEASE           )( DWORD );
typedef DWORD ( APIENTRY *tPUT_MESSAGE       )( DWORD, PVOID );
typedef DWORD ( APIENTRY *tGET_MESSAGE       )( DWORD, PVOID * );
typedef DWORD ( APIENTRY *tWAIT_FOR_SIGNAL   )( DWORD );
typedef VOID  ( APIENTRY *tGET_MANUFACTURER  )( char * );
typedef DWORD ( APIENTRY *tGET_VERSION       )( DWORD *, DWORD *,
                                                DWORD *, DWORD * );
typedef DWORD ( APIENTRY *tGET_SERIAL_NUMBER )( char * );
typedef DWORD ( APIENTRY *tGET_PROFILE       )( PVOID, DWORD );
typedef DWORD ( APIENTRY *tINSTALLED         )( VOID );

tREGISTER          API_REGISTER_20;
tRELEASE           API_RELEASE_20;
tPUT_MESSAGE       API_PUT_MESSAGE_20;
tGET_MESSAGE       API_GET_MESSAGE_20;
tWAIT_FOR_SIGNAL   API_WAIT_FOR_SIGNAL_20;
tGET_MANUFACTURER  API_GET_MANUFACTURER_20;
tGET_VERSION       API_GET_VERSION_20;
tGET_SERIAL_NUMBER API_GET_SERIAL_NUMBER_20;
tGET_PROFILE       API_GET_PROFILE_20;
tINSTALLED         API_INSTALLED_20;

static HINSTANCE dllInstance;

short Capi20_LoadCapi( char *error_msg )
{
  char help [200];
#ifdef DIR_CHANGE
  char cWrkDir[MAX_PATH];
  char cSysDir[MAX_PATH];

  GetCurrentDirectory(sizeof(cWrkDir), cWrkDir); /* get current working directory */
  GetSystemDirectory (cSysDir, sizeof(cSysDir)); /* get windows\system directory  */
  SetCurrentDirectory(cSysDir);                  /* go to system directory        */
    dllInstance = LoadLibrary( DLLNAME );        /* load capi dll                 */
  SetCurrentDirectory(cWrkDir);                  /* go back to working directory  */
#else
  dllInstance = LoadLibrary( DLLNAME );          /* load capi dll                 */
#endif

  strcpy (error_msg,"ISDNAPI: Unable to load CAPI2032.DLL!\nShutting down.");
  if( !dllInstance ) return 0;

  strcpy (error_msg,"\r\nISDNAPI: CAPI2032.DLL loaded!\r\n");

//***********************************************************

  API_REGISTER_20          = (tREGISTER)          GetProcAddress( dllInstance,"CAPI_REGISTER" );
  sprintf (help,"API_REGISTER_20          gets address: %d\r\n",API_REGISTER_20);
  strcat (error_msg, help);

  API_RELEASE_20           = (tRELEASE)           GetProcAddress( dllInstance,"CAPI_RELEASE" );
  sprintf (help,"API_RELEASE_20           gets address: %d\r\n",API_RELEASE_20);
  strcat (error_msg, help);

  API_PUT_MESSAGE_20       = (tPUT_MESSAGE)       GetProcAddress( dllInstance,"CAPI_PUT_MESSAGE" );
  sprintf (help,"API_PUT_MESSAGE_20       gets address: %d\r\n",API_PUT_MESSAGE_20);
  strcat (error_msg, help);

  API_GET_MESSAGE_20       = (tGET_MESSAGE)       GetProcAddress( dllInstance,"CAPI_GET_MESSAGE" );
  sprintf (help,"API_GET_MESSAGE_20       gets address: %d\r\n",API_GET_MESSAGE_20);
  strcat (error_msg, help);

  API_WAIT_FOR_SIGNAL_20   = (tWAIT_FOR_SIGNAL)   GetProcAddress( dllInstance,"CAPI_WAIT_FOR_SIGNAL" );
  sprintf (help,"API_WAIT_FOR_SIGNAL_20   gets address: %d\r\n",API_WAIT_FOR_SIGNAL_20);
  strcat (error_msg, help);

  API_GET_MANUFACTURER_20  = (tGET_MANUFACTURER)  GetProcAddress( dllInstance,"CAPI_GET_MANUFACTURER" );
  sprintf (help,"API_GET_MANUFACTURER_20  gets address: %d\r\n",API_GET_MANUFACTURER_20);
  strcat (error_msg, help);

  API_GET_VERSION_20       = (tGET_VERSION)       GetProcAddress( dllInstance,"CAPI_GET_VERSION" );
  sprintf (help,"API_GET_VERSION_20       gets address: %d\r\n",API_GET_VERSION_20);
  strcat (error_msg, help);

  API_GET_SERIAL_NUMBER_20 = (tGET_SERIAL_NUMBER) GetProcAddress( dllInstance,"CAPI_GET_SERIAL_NUMBER" );
  sprintf (help,"API_GET_SERIAL_NUMBER_20 gets address: %d\r\n",API_GET_SERIAL_NUMBER_20);
  strcat (error_msg, help);

  API_GET_PROFILE_20       = (tGET_PROFILE)       GetProcAddress( dllInstance,"CAPI_GET_PROFILE" );
  sprintf (help,"API_GET_PROFILE_20       gets address: %d\r\n",API_GET_PROFILE_20);
  strcat (error_msg, help);

  API_INSTALLED_20         = (tINSTALLED)         GetProcAddress( dllInstance,"CAPI_INSTALLED" );
  sprintf (help,"API_INSTALLED_20         gets address: %d\r\n",API_INSTALLED_20);
  strcat (error_msg, help);

//***********************************************************

  if (API_INSTALLED_20())
  {
    strcat (error_msg,"ISDNAPI: API_INSTALLED() returns 'CAPI NOT INSTALLED'\r\n");
    return(0);
  }
    else
  {
    strcat (error_msg,"ISDNAPI: API_INSTALLED() returns 'CAPI INSTALLED'\r\n");
  }

  return 1;
}

short Capi20_UnLoadCapi( void )
{
  FreeLibrary( dllInstance );

  return 1;
}

short Capi20_GetDevName   (char* name)
{
  strcpy (name, DLLNAME);
  return 1;
}

