// win version of comv24.c

#include "..\common.src\bastypes.h"
#include "..\common.src\com.h"
#include "..\common.src\comv24.h"
#include "w32uart.h"

tU32 xComV24Init               ()
{
  return(0);
}

tU32 xComV24Exit               ()
{
  return(0);
}

tU32 xComV24OpenDev            (tComDevHandle *pDevHandle, tComEnumDev* pComDev)
{
  return (xW32UartOpen (pComDev[0].cDevNam,/* "COM1:" oder "COM2:"...      */
                        W32UART_BIT_PER_SEC_115200,
                        W32UART_BYTE_SIZE_8,
                        W32UART_NO_PARITY,
                        W32UART_ONE_STOPBIT,
                        pDevHandle));      /*                              */
}

tU32 xComV24CloseDev           (tComDevHandle   DevHandle)
{
  return (xW32UartClose (DevHandle));
}

tU32 xComV24Connect            (tComDevHandle   DevHandle, tU8* pDial)
{
  tU32 StartTick = GetTickCount();
  tU8  DialCmd[200];

  strcpy (DialCmd, "ATD");
  strcat (DialCmd, pDial);
  strcat (DialCmd, "\r");

  xComWriteBlock (DevHandle, DialCmd, strlen(DialCmd), 0);

  while ((!xW32UartDcd(DevHandle)) && (GetTickCount() < StartTick + (COM_DIAL_TIMEOUT * 1000)))
  {
    Sleep (50);
  }

  xComV24ClearRxBuff(DevHandle);
  xComV24ClearTxBuff(DevHandle);

  return (xW32UartDcd(DevHandle)?0:1);
}

tU32 xComV24Disconnect         (tComDevHandle   DevHandle)
{
  return (0);
}

tU32 xComV24CanWrite           (tComDevHandle   DevHandle)
{
  return (xW32UartCts(DevHandle));
}

tU32 xComV24WriteBlock         (tComDevHandle   DevHandle, tU8* pData, tU32 iLen, tU32 iWait)
{
  return (xW32UartWriteBlock (pData, iLen, 0, DevHandle));
}

tU32 xComV24ReadDataAvailable  (tComDevHandle   DevHandle)
{
  return (xW32UartDataAvailable(DevHandle));
}

tU32 xComV24ReadBlock          (tComDevHandle   DevHandle, tU8* pData, tU32 iLen, tU32 iWait)
{
  return (xW32UartReadBlock (pData, iLen, 0, DevHandle));
}

tU32 xComV24ClearRxBuff        (tComDevHandle   DevHandle)
{
  return (xW32UartPurgeRxBuff(DevHandle));
}

tU32 xComV24ClearTxBuff        (tComDevHandle   DevHandle)
{
  return (xW32UartPurgeTxBuff(DevHandle));
}

tU32 xComV24SetDiscIndCallback (tComDevHandle DevHandle, void (*ProcAddrParm)(void))
{
  return (xW32UartSetEventProc(W32UART_EVENT_DCD_OFF, ProcAddrParm, DevHandle));
}

tU32 xComV24SetConnIndCallback (tComDevHandle DevHandle, void (*ProcAddrParm)(void))
{
  return (xW32UartSetEventProc(W32UART_EVENT_RING, ProcAddrParm, DevHandle));
}


