#include <stdio.h>
#include <stdlib.h>
#include <capi20.h>
#include <memory.h>
#include <linux/capi.h>

#define DWORD unsigned long
#define DLLNAME "/dev/capi20"


static int controller = 0;

DWORD API_REGISTER_20( DWORD MsgBufSize, DWORD maxCons, DWORD maxBlocks,
                    DWORD maxBlockLen, DWORD* pApplId)
{
  return CAPI20_REGISTER((unsigned)maxCons, (unsigned)maxBlocks,
                         (unsigned)maxBlockLen, (unsigned*)pApplId);
}

DWORD API_RELEASE_20( DWORD ApplID )
{
  return CAPI20_RELEASE(ApplID);
}

DWORD API_PUT_MESSAGE_20( DWORD ApplID, void* pMsg )
{
  return capi20_put_message(ApplID,pMsg);
}

DWORD API_GET_MESSAGE_20( DWORD ApplID, void** ppMsg)
{
  return capi20_get_message(ApplID,(unsigned char**)ppMsg);
}

DWORD API_WAIT_FOR_SIGNAL_20( DWORD ApplID )
{
  struct timeval timeout;

  timeout.tv_sec  = 2;
  timeout.tv_usec = 0;

  return capi20_waitformessage(ApplID, &timeout);
}

void API_GET_MANUFACTURER_20( char* pMsg )
{
  if (!controller) return;
  
  *pMsg = 0;
  
  CAPI20_GET_MANUFACTURER (controller, pMsg);
}

DWORD API_GET_VERSION_20( DWORD *CapiMajor, DWORD *CapiMinor, DWORD *Major, DWORD *Minor )
{
  capi_version version;
 
  if (!controller) return 0;
  
  CAPI20_GET_VERSION(controller, (CAPI_MESSAGE)memset(&version,0,sizeof(capi_version)));

  *CapiMajor = version.majorversion;
  *CapiMinor = version.minorversion;
  *Major = version.majormanuversion;
  *Minor = version.minormanuversion;
  
  return 1;
}

DWORD API_GET_SERIAL_NUMBER_20( char* pSerNr )
{
  return !capi20_get_serial_number(1, memset(pSerNr,0,9));
}

DWORD API_GET_PROFILE( void* param1, DWORD param2 )
{
  capi_profile cprofile;
   
  capi20_get_profile(0, (CAPI_MESSAGE)&cprofile);
  controller = cprofile.ncontroller > 0 ? 1 : 0;

  return 0;
}

DWORD API_INSTALLED_20( void )
{
  API_GET_PROFILE(0,0);
  return capi20_isinstalled();
}

short Capi20_LoadCapi( char *error_msg )
{
  strcpy (error_msg,"");
  return(1);
}

short Capi20_UnLoadCapi( void )
{
  return 1;
}

short Capi20_GetDevName   (char* name)
{
  strcpy (name, DLLNAME);
  return 1;
}







