void sigFunc( short num, void *msg );

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <sys/stat.h>

#ifndef UNIX
#include <process.h>
#include <io.h>
#endif

#include "bastypes.h"

short util_file_exist (char *filename)
{
  short ret;
  struct stat buffer;

  ret = stat (filename,&buffer);
  if (ret == 0) return (1); else return (0);
}

long util_file_age (char *filename)
{
  short ret;
  struct stat buffer;

  ret = stat (filename,&buffer);
  if (ret == 0) return (buffer.st_mtime); else return (0);
// problem  if (ret == 0) return ((long)buffer.st_mtime); else return (0);
}

long util_file_size (char *filename)
{
  FILE* f=NULL;
  long size;

  f = fopen(filename, "rb");
  if(!f) return 0;

  fseek(f, 0, SEEK_END);
  size = ftell(f);
  fclose(f);
  return size;
#ifdef xxxelse
  FILE* f;
  long size;

  f = fopen(filename,"rb");
  if(!f) return 0;

  size = _filelength(fileno(f));
  fclose(f);
  return size;
#endif
}

void util_copy_file(char *from, char *to)
{
  char *dat;
  FILE *fh_from=NULL, *fh_to=NULL;
  long size=util_file_size(from);

  if( (fh_from = fopen( from, "rb" )) != NULL )
  {
    if( (fh_to   = fopen( to, "wb" )) != NULL )
    {
//      size = _filelength( fileno( fh_from ) );

      dat = (char *) malloc( size );

      fread( dat, size, 1, fh_from );
      fwrite( dat, size, 1, fh_to );

      free( dat );

      fclose( fh_to );
    }

    fclose( fh_from );
  }
}

void util_append_file( char *from, char *to )
{
  char *dat;
  FILE *fh_from = NULL, *fh_to = NULL;
  long size=util_file_size(from);

  if( (fh_from = fopen( from, "rb" )) != NULL )
  {
    if( (fh_to   = fopen( to, "ab" )) != NULL )
    {
//      size = _filelength( fileno( fh_from ) );

      dat = (char *) malloc( size );

      fread( dat, size, 1, fh_from );
      fwrite( dat, size, 1, fh_to );

      free( dat );

      fclose( fh_to );
    }

    fclose( fh_from );
  }
}


short util_pos (char was, char *str)
{
   if (!strchr(str,was)) return (0);
   return (strchr (str,was)-str+1);
}

char *util_strip_path (char *filename)
{
   while (strchr (filename,'\\')) {
      filename = strchr (filename,'\\');
      filename++;
   }
   return (filename);
}

/* remove trailing CR (if there is one) from a string */
void util_delete_cr(char *str)
{
  char *p;

  p = str + strlen(str) - 1;

  if (p >= str)
  {
    /* Strip off the trailing blanks */
    while( (p >= str) && ( isspace(*p) ) )
    {
      *p = '\0';
      --p;
    }

    /* Get rid of backslash if there is one */
    if( (p >=str) && (*p == '\n') )
    {
      *p = '\0';
    }
  }
}


/*
 *
 * strip()
 *
 * <str> = zu bearbeitender string
 * <strip> = string mit einem oder mehreren zeichen, die am
 *           anfang und am ende von str entfernt werden sollen
 *
 * liefert den ursprnglichen zeiger <str> zurck
 *
 */

char* util_strip(char* str, char* strip)
{

    if(!str || !*str)
        return str;
    while(strchr(strip, *str) && *str)
        memmove(str, str + 1, strlen(str));
    while(strchr(strip, str[strlen(str)-1]) && *str)
        str[strlen(str)-1] = 0;
    return str;

}

void util_char_add(char add,char *str)
{
  int len = strlen(str);

  str[len  ] = add;
  str[len+1] = 0;
}


#ifdef UNIX
char *strupr(char *s)
{
  char *p=s;

  if(p){
    while(*p){
      *p = toupper(*p);
      p++;
    }
  }
  return s;
}
char *ltoa (long value, char *string, int radix)
    {
        char *dst;
            char digits[32];
                unsigned long x;
                    int i, n;

                          dst = string;
                              if (radix < 2 || radix > 36)
                                      {
                                              *dst = 0;
                                                      return (string);
                                                              }
                                                                  if (radix == 10 && value < 0)
                                                                          {
                                                                                  *dst++ = '-';
                                                                                          x = -value;
                                                                                                  }
                                                                                                      else
                                                                                                              x = value;
                                                                                                                  i = 0;
                                                                                                                      do
                                                                                                                              {
                                                                                                                                      n = x % (unsigned long)radix;
                                                                                                                                              digits[i++] = (n < 10 ? (char)n+'0' : (char)n-10+'a');
                                                                                                                                                      x /= (unsigned long)radix;
                                                                                                                                                              } while (x != 0);
                                                                                                                                                                  while (i > 0)
                                                                                                                                                                          *dst++ = digits[--i];
                                                                                                                                                                              *dst = 0;
                                                                                                                                                                                  return (string);
                                                                                                                                                                                      }



#endif

