/*
  Picture Clock /2 Module  Default Digital clock
*/

extern "C"{

#include "Module.h"
#include "stdio.h"

struct _Digital{
  int hour;
  int minute;
};

typedef struct _Digital Digital;

#define CX_SPACE 8
#define CY_SPACE 8

static PSZ APPNAME = "Digital clock 1.0";
static PSZ WINPOS = "Window Position";


MRESULT APIENTRY PC2ModuleProcedure
    (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch( msg ){
  case MDL_ID:
    return MPFROMP(MDLID_V100);

  case MDL_INIT:
    {
      HINI hini = (HINI)LONGFROMMP(mp1);
      ModuleInfo* minfo = ((ModuleInfo*)PVOIDFROMMP(mp2));
      Digital* info = (Digital*)minfo->buffer;
      char string[128];

      PrfQueryProfileString
	( hini, APPNAME, WINPOS, "10 10 80 35", string, 1024 );
      int x, y, cx, cy;
      sscanf( string, "%d %d %d %d", &x, &y, &cx, &cy );
      WinSetWindowPos
	(minfo->hwndFrame, HWND_TOP, x, y, cx, cy, 
	 SWP_NOADJUST | SWP_SIZE | SWP_MOVE | SWP_SHOW | SWP_ZORDER );
      info->minute = 0;
      info->hour = 0;
      return 0;
    }

  case MDL_TERMINATE:
    return 0;

  case MDL_SAVESETTINGS:
    {
      HINI hini = LONGFROMMP(mp1);
      ModuleInfo* minfo = (ModuleInfo*)PVOIDFROMMP(mp2);
      SWP swp;
      WinQueryWindowPos( minfo->hwndFrame, &swp );
      char string[128];
      sprintf( string, "%d %d %d %d", swp.x, swp.y, swp.cx, swp.cy );
      PrfWriteProfileString( hini, APPNAME, WINPOS, string );

      return 0;
    }

  case MDL_DRAW:
    {
      ModuleInfo* minfo = (ModuleInfo*)PVOIDFROMMP(mp2);
      PDATETIME pdt = &(minfo->datetime);
      char string[6];
      sprintf( string, "%2d:%02d", pdt->hours, pdt->minutes );

      HPS hps = LONGFROMMP(mp1);
      GpiSetColor( hps, CLR_BLACK );
      POINTL ptl;
      ptl.x = minfo->width;
      ptl.y = minfo->height;
      GpiMove( hps, &ptl );
      ptl.x = ptl.y = 0;
      GpiBox( hps, DRO_FILL, &ptl, 0, 0 );

      FATTRS attr;
      attr.usRecordLength = sizeof(FATTRS);
      attr.fsSelection = FATTR_SEL_BOLD;
      attr.lMatch = 0;
      strcpy( attr.szFacename, "Times New Roman" );
      attr.idRegistry = 0;
      attr.usCodePage = 0;
      attr.lMaxBaselineExt = 0;
      attr.lAveCharWidth = 0;
      attr.fsType = FATTR_TYPE_MBCS;
      attr.fsFontUse = FATTR_FONTUSE_OUTLINE;
      GpiCreateLogFont( hps, NULL, 1, &attr );
      GpiSetCharSet( hps, 1 );

      ptl.x = (minfo->width - CX_SPACE<<1) * 72 / 45 / 10;
      ptl.y = (minfo->height - CY_SPACE<<1) * 72 / 100;
      GpiConvert( hps, CVTC_DEVICE, CVTC_WORLD, 1, &ptl );

      SIZEF size;
      size.cx = MAKEFIXED( ptl.x, 0 );
      size.cy = MAKEFIXED( ptl.y, 0 );
      GpiSetCharBox( hps, &size );

      ptl.x = CX_SPACE * 72 / 100;
      ptl.y = CY_SPACE * 72 / 100;
      GpiConvert( hps, CVTC_DEVICE, CVTC_WORLD, 1, &ptl );
      GpiSetColor( hps, CLR_GREEN );
      GpiCharStringAt( hps, &ptl, 5, string );
      GpiSetCharSet( hps, 0 );
      GpiDeleteSetId( hps, 1 );

      return 0;
    }
	
  case MDL_TRIGGER:
    {
      ModuleInfo* minfo = (ModuleInfo*)PVOIDFROMMP(mp1);
      Digital* inf = (Digital*)(minfo->buffer);
      int min = minfo->datetime.minutes;
      int hour = minfo->datetime.hours;
      if( inf->minute != min || inf->hour != hour ){
	inf->minute = min;
	inf->hour = hour;
	return MRFROMLONG( TRG_CALLDRAW | TRG_NODRAWBACK | TRG_DRAWFRAME );
      }
      return MRFROMLONG( TRG_DRAWFRAME | TRG_NODRAWBACK );
    }
    
  case MDL_TITLE:
    return MRFROMP( "WfBW^v" );

  default:
    return 0;
  }
}

// end of extern "C"
}
