#include "MdlMgr.h"
#include "DLModule.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "PC2.h"


ModuleManager :: ModuleManager( ClockManager* cmgr, HAB hab, HINI hini ) :
     Window( hab, HWND_DESKTOP, WS_ANIMATE, FCF_TITLEBAR|FCF_DLGBORDER )
{
  this->mgr = cmgr;
  this->hini = hini;
  this->makeModuleList();
  this->makeDialog();
  this->listHead = 0;
  this->displayList();
}


void ModuleManager :: displayList()
{
  for( int i=0; i<CHECKS; i++ ){
    if( item[this->listHead+i] == NULL ){
      WinSetWindowText( hwndCheck[i], "---" );
      WinSendMsg( hwndCheck[i], BM_SETCHECK, 0, 0 );
      WinEnableWindow( hwndCheck[i], FALSE );
    }else{
      WinSetWindowText( hwndCheck[i], item[this->listHead+i]->Title() );
      WinSendMsg( hwndCheck[i], BM_SETCHECK,
        MPFROMSHORT( item[this->listHead+i]->enable == TRUE ? 1 : 0 ), 0 );
      WinEnableWindow( hwndCheck[i], TRUE );
    }
  }
}


void ModuleManager :: makeModuleList()
{
  ULONG dataLen;
  if( PrfQueryProfileSize(this->hini, PRF_APPNAME, PRF_MODULELIST, &dataLen )
     == FALSE ) dataLen = strlen( DEFAULT_MODULENAME );
  PSZ enableList = new char[dataLen+2];
  PrfQueryProfileString(
    this->hini, 
    PRF_APPNAME, PRF_MODULELIST, DEFAULT_MODULENAME,
    enableList, dataLen+1 );

  this->modules = 0;
  for( int i=0; i<MAX_MODULES; i++ ) item[i] = NULL;

  char cwd[4096];
  char string[4096];
  getcwd( cwd, 4090 );
  sprintf( string, "%s\\*.dll", cwd );

  HDIR hdir = (HDIR)HDIR_CREATE;
  FILEFINDBUF3 findBuffer;
  ULONG findCount = 1;

  APIRET findRet = DosFindFirst( (const PSZ)string,
				&hdir,
				FILE_READONLY,
				(PVOID)&findBuffer,
				sizeof(findBuffer),
				&findCount,
				FIL_STANDARD );

  while( findRet == 0 ){
printf( "Name : %s :", findBuffer.achName );
    sprintf( string, "%s\\%s", cwd, findBuffer.achName );

    HLIB hlib = WinLoadLibrary( hab, (PSZ)string );
    if( hlib == NULLHANDLE ){
printf( "Disable\n" );
      goto next;
    }

    MRESULT APIENTRY (*pPC2ModuleProcedure)( HWND, ULONG, MPARAM, MPARAM );
    pPC2ModuleProcedure = 
      WinLoadProcedure( hab, hlib, (PSZ)"PC2ModuleProcedure" );
    if( pPC2ModuleProcedure == NULL ){
printf( "Disable\n" );
      goto next;
    }

    if( strcmp(
      (char*)((*pPC2ModuleProcedure)( NULLHANDLE, MDL_ID, 0, 0 )),
      MDLID_V100 ) ){
printf( "Disable\n" );
      goto next;
    }

  item[this->modules] =
    new ModuleItem( findBuffer.achName,
		   (PSZ)((*pPC2ModuleProcedure)( NULLHANDLE,MDL_TITLE,0,0 )),
		   strstr( enableList, findBuffer.achName ) ? TRUE : FALSE );
printf( "Enable[%s]%d\n",enableList, item[this->modules]->enable );
  this->modules++;

  next:
    WinDeleteProcedure( hab, pPC2ModuleProcedure );
    WinDeleteLibrary( hab, hlib );
    findRet = DosFindNext( hdir, 
			  (PVOID)&findBuffer,
			  sizeof(findBuffer),
			  &findCount );
  }

  DosFindClose( hdir );
  delete enableList;
}


void ModuleManager :: updateList()
{
  for( int i=0; i<CHECKS; i++ ){
    ModuleItem* itm;
    itm = item[this->listHead+i];
    if( itm != NULL ){
      itm->enable =
	LONGFROMMR( WinSendMsg( hwndCheck[i], BM_QUERYCHECK, 0, 0 ) )== 1 ?
	TRUE : FALSE;
    }
  }
}


void ModuleManager :: makeDialog()
{
  WinSetWindowText( this->hwndFrame, "Module selecter" );

  // Calculate size
  FONTMETRICS fm;
  HPS localHps = WinGetPS( this->hwndFrame );
  GpiQueryFontMetrics( localHps, sizeof(FONTMETRICS), &fm );
  WinReleasePS( localHps );

  SWP swp;
  WinQueryWindowPos( this->hwndClient, &swp );

  ULONG CHECK_WIDTH = fm.lAveCharWidth * CHARS + CX_CHECK;
  ULONG DLG_WIDTH =
    CHECK_WIDTH + SPACE_X1 * 2
  + WinQuerySysValue( HWND_DESKTOP, SV_CXDLGFRAME ) * 2;

  ULONG CHECK_HEIGHT = fm.lMaxBaselineExt + SPACE_Y2;
  ULONG DLG_HEIGHT =
    SPACE_Y1 * 2 + CHECK_HEIGHT*CHECKS + SPACE_Y3 + BUTTON_HEIGHT
  + WinQuerySysValue( HWND_DESKTOP, SV_CYDLGFRAME ) * 2
  + WinQuerySysValue( HWND_DESKTOP, SV_CYTITLEBAR );

  WinSetWindowPos(
    this->hwndFrame,
    HWND_TOP,
    DLG_X, DLG_Y,
    DLG_WIDTH, DLG_HEIGHT,
    SWP_NOADJUST | SWP_SIZE | SWP_MOVE | SWP_SHOW | SWP_ZORDER );

  // Making check button
  for( int i=0; i<CHECKS; i++ ){
    hwndCheck[i] =
      WinCreateWindow
	( this->hwndClient,
	 WC_BUTTON,
	 "Not use",
	 BS_AUTOCHECKBOX | WS_VISIBLE,
	 SPACE_X1 + WinQuerySysValue( HWND_DESKTOP, SV_CXDLGFRAME ) , 
	 DLG_HEIGHT - SPACE_Y1 - CHECK_HEIGHT
	 - WinQuerySysValue( HWND_DESKTOP, SV_CYTITLEBAR )
	 - WinQuerySysValue( HWND_DESKTOP, SV_CYDLGFRAME )*2 
	 - i*CHECK_HEIGHT, 
	 CHECK_WIDTH, CHECK_HEIGHT,
	 this->hwndClient,
	 HWND_TOP,
	 1, NULL, NULL );
  }

  // Previous, next, ok, cancel button
    hwndPrev = 
      WinCreateWindow
	( this->hwndClient,
	 WC_BUTTON,
	 "Previous",
	 BS_PUSHBUTTON | WS_VISIBLE,
	 SPACE_X1 + WinQuerySysValue( HWND_DESKTOP, SV_CXDLGFRAME ), 
	 SPACE_Y3 - WinQuerySysValue( HWND_DESKTOP, SV_CYDLGFRAME ),
	 BUTTON_WIDTH, BUTTON_HEIGHT,
	 this->hwndClient,
	 HWND_TOP,
	 IDC_Prev,
	 NULL, NULL );

    hwndNext = 
      WinCreateWindow
	( this->hwndClient,
	 WC_BUTTON,
	 "Next",
	 BS_PUSHBUTTON | WS_VISIBLE,
	 SPACE_X1 + WinQuerySysValue( HWND_DESKTOP, SV_CXDLGFRAME ) +
	 BUTTON_WIDTH + SPACE_X2,
	 SPACE_Y3 - WinQuerySysValue( HWND_DESKTOP, SV_CYDLGFRAME ),
	 BUTTON_WIDTH, BUTTON_HEIGHT,
	 this->hwndClient,
	 HWND_TOP,
	 IDC_Next,
	 NULL, NULL );
  
    hwndOk = 
      WinCreateWindow
	( this->hwndClient,
	 WC_BUTTON,
	 "Ok",
	 BS_PUSHBUTTON | WS_VISIBLE,
	 SPACE_X1 + WinQuerySysValue( HWND_DESKTOP, SV_CXDLGFRAME ) +
	 SPACE_X2 + BUTTON_WIDTH*2 + SPACE_X3,
	 SPACE_Y3 - WinQuerySysValue( HWND_DESKTOP, SV_CYDLGFRAME ),
	 BUTTON_WIDTH, BUTTON_HEIGHT,
	 this->hwndClient,
	 HWND_TOP,
	 IDC_Ok,
	 NULL, NULL );

    hwndNext = 
      WinCreateWindow
	( this->hwndClient,
	 WC_BUTTON,
	 "Close",
	 BS_PUSHBUTTON | WS_VISIBLE,
	 WinQuerySysValue( HWND_DESKTOP, SV_CXDLGFRAME ) + SPACE_X1 +
	 BUTTON_WIDTH*3 + SPACE_X2*2 + SPACE_X3,
	 SPACE_Y3 - WinQuerySysValue( HWND_DESKTOP, SV_CYDLGFRAME ),
	 BUTTON_WIDTH, BUTTON_HEIGHT,
	 this->hwndClient,
	 HWND_TOP,
	 IDC_Cancel,
	 NULL, NULL );
}


ModuleManager :: ~ModuleManager()
{
};


MRESULT EXPENTRY ModuleManager :: clientProc(
    HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch( msg ){
  case WM_PAINT:
    {
    HPS localHps = WinBeginPaint( hwnd, NULLHANDLE, NULL );
    GpiErase( localHps );
    WinEndPaint( localHps );
    return 0;
    }

  case WM_COMMAND:
    switch( COMMANDMSG(&msg)->cmd ){
    case IDC_Prev:
      this->updateList();
      if( this->listHead < CHECKS ) break;
      this->listHead -= CHECKS;
      this->displayList();
      break;
    case IDC_Next:
      this->updateList();
      if( this->modules <= this->listHead+CHECKS ) break;
      this->listHead += CHECKS;
      this->displayList();
      break;
    case IDC_Ok:
      this->updateList();
      WinMessageBox( HWND_DESKTOP,
		    this->hwndFrame,
		    "ݒ͎̋NɗLɂȂ܂",
		    "Picture Clock /2",
		    1,
		    MB_OK );
      this->writeIni();
      mgr->closeModuleSelecter();
      return 0;
    case IDC_Cancel:
      mgr->closeModuleSelecter();
      return 0;
    }
    return 0;
  }
  return this->Window::clientProc( hwnd, msg, mp1, mp2 );
}


void ModuleManager :: writeIni()
{
  // Calculate data size
  ULONG dataSize = 0;
  for( int i=0; i<MAX_MODULES; i++ ){
    if(   this->item[i] == NULL
       || this->item[i]->enable == FALSE ) continue;
//printf( "DLL name [%s]\n", this->item[i]->FileName() ); fflush( stdout );
    dataSize += strlen( this->item[i]->FileName() ) + 1;
  };
//printf( "Data Size %d\n", dataSize ); fflush( stdout );

  PSZ list = new char[dataSize+1];
  *list = '\0';

//printf( "Malloc pointer %p\n", list ); fflush( stdout );

  for( int i=0; i<MAX_MODULES; i++ ){
    char string[1024];
    if(   this->item[i] == NULL
       || this->item[i]->enable == FALSE ) continue;
    sprintf( string, "%s ", this->item[i]->FileName() );
    strcat( list, string );
  }

// printf( "List %s\n", list ); fflush( stdout );

  PrfWriteProfileString( this->hini, PRF_APPNAME, PRF_MODULELIST, list );

//printf( "Write ini completed.\n" ); fflush( stdout );

  delete list;
  return;
}
