/* ITALIANO.CMD: Install CLOCK in Italiano. */

'@Echo Off'
'CHCP 850'

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installo CLOCK...'
Say ''


/* Verify the existence of the various component files. */

Language = 'ITALIANO'

Result = SysFileTree( 'CLOCK.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: CLOCK.EXE non trovato!'
  Signal DONE
  End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: 'Language'.DLL trovato!'
  Signal DONE
  End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: 'Language'.HLP non trovato!'
  Signal DONE
  End

/* Ask for the target directory name. */

Say 'Per favore scrivi il nome completo del percorso in cui'
Say '  desideri installare il CLOCK (default C:\OS2\APPS): '
Parse Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'


/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Non riesco a crare la directory di destinazione.'
    Signal DONE
    End
  End
Say ''


/* Ask for the target folder. */

Say 'Desideri inserirlo nel folder di startup? (S/N)'
Pull YesNo
If YesNo = "S" Then
  Do
  Folder = '<WP_START>'
  Say 'Oggetto posto nella dir di startup.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'Oggetto posto sul desktop.'
  End
Say ''


/* Perform the installation. */

Say 'Copio CLOCK in ' Directory '...'
Copy CLOCK.EXE Directory                  '1>NUL'
Copy Language".DLL" Directory"\CLOCK.DLL" '1>NUL'
Copy Language".HLP" Directory"\CLOCK.HLP" '1>NUL'
Copy Language".DOC" Directory"\CLOCK.DOC" '1>NUL'

Result = SysFileTree( Language".INF", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy Language".INF" Directory"\CLOCK.INF"  '1>NUL'
   End

Say 'Creo oggetto del programma...'
Type = 'WPProgram'
Title = 'Clock'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CLOCK.EXE;STARTUPDIR='Directory';OBJECTID=<CLOCK>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Oggetto creato!  Fine.'
Else
  Say 'ERROR: Oggetto non creato.'

Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX fermato.'
Signal DONE

SYNTAX:
Say 'REXX errore di sintassi.'
Signal DONE

DONE:
Exit
