
/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 2.24
 */


/***************************************************************************\
 *
 * PROGRAM NAME: WPDCF77
 * -------------
 *
 * VERSION: 6.0
 * --------
 *
 * MODULE NAME: WPDCF77
 * ------------
 *
 * DESCRIPTION:
 * ------------
 *   SOM methods
 *
 * NOTES:
 * ------
 *
 * FUNCTIONS:
 * -----------
 *   setPageinfo ()
 *   wpDCF77_wpAddClockAlarmPage ()
 *   wpDCF77_wpAddClockAlarm2Page ()
 *   wpDCF77_wpAddClockAlarm3Page ()
 *   wpDCF77_wpAddClockDateTimePage ()
 *   wpDCF77_wpAddClockView1Page ()
 *   wpDCF77_wpAddClockView2Page ()
 *   wpDCF77_wpAddClockView3Page ()
 *   wpDCF77_wpAddDCFSettingPage1 ()
 *   wpDCF77_wpAddDCFSettingPage2 ()
 *   wpDCF77_wpAddDCFSettingPage3 ()
 *   wpDCF77_wpAddTmOffsSettingPage ()
 *   wpDCF77_wpAddTZSettingPage ()
 *   wpDCF77_wpAddServerIntervalPage ()
 *   wpDCF77_wpAddAudioSetupPage ()
 *   wpDCF77_wpAddSettingsPages ()
 *   wpDCF77_wpInitData ()
 *   wpDCF77_wpUnInitData ()
 *   wpDCF77_wpAdd1sTimer ()
 *   wpDCF77_wpRemove1sTimer ()
 *   wpDCF77_wpMenuItemSelected ()
 *   wpDCF77_wpModifyPopupMenu ()
 *   wpDCF77_wpFilterPopupMenu ()
 *   wpDCF77_wpOpen ()
 *   wpDCF77_wpRefreshClockView ()
 *   wpDCF77_wpRestoreState ()
 *   wpDCF77_wpSaveState ()
 *   wpDCF77_wpQueryDefaultView ()
 *   wpDCF77_wpCloseADView ()
 *   wpDCF77M_clsQueryModuleHandle ()
 *   wpDCF77M_wpclsInitData ()
 *   wpDCF77M_wpclsQueryIconData ()
 *   wpDCF77M_wpclsQueryTitle ()
 *   wpDCF77M_clsSaveSetData ()
 *   wpDCF77M_wpclsQueryDefaultHelp ()
 *
 *  Ver.    Date      Comment
 *  ----    --------  -------
 *  1.00    10-23-94  First release
 *  2.00    06-16-95  Extensions
 *  3.00    10-30-95  Client/Server support; SOM2
 *  4.00    03-15-96  Support for hopf
 *  4.20    10-15-96  Support for hopf GPS
 *  4.30    17-05-97  Support for HR-Timer
 *  4.40    01-31-00  Multimedia support, bug fixing
 *  5.10    02-10-01  Bug fixing position of icon view
 *  5.20    06-09-01  Bug fixing audio data
 *  5.30    01-16-02  Implementation of reminder function
 *  5.40    11-22-03  Bug fixing reminder function
 *  6.00    02-15-04  USB support
 *
 *  Copyright (C) noller & breining software 1995...2007
 *
\******************************************************************************/
#define INCL_DOSMODULEMGR
#define INCL_DOSDATETIME
#define INCL_DOSDEVICES
#define INCL_DOSMEMMGR
#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES
#define INCL_WINMENUS
#define INCL_WINDIALOGS
#define INCL_WINSHELLDATA
#define INCL_WINSTDBOOK
#define INCL_WINSYS
#define INCL_GPITRANSFORMS

#ifndef SOM_Module_wpdcf77_Source
#define SOM_Module_wpdcf77_Source
#endif
#define WPDCF77_Class_Source
#define M_WPDCF77_Class_Source

#include <os2.h>
#include <stdlib.h>
#include <string.h>

#include "dcfioctl.h"

#pragma info(noeff)         // suppress SOM compiler informationals

#include "WPDCF77.ih"
#include "wppalet.h"
#include "WPDCF.h"

#include "res.h"
#include "clock.h"
#include "clockpan.h"
#include "clkdata.h"
#include "clkmem.h"
#include "tloc.h"
#include "dcf77.h"
#include "alarmthd.h"
#include "dialogs.h"
#include "server.h"
#include "wndproc.h"
#include "graph.h"
#include "locale.h"
#include "udtime.h"
#include "debug.h"

#ifndef DEBUG
  #undef  WPDCF77MethodDebug
  #define WPDCF77MethodDebug(c,m) SOM_NoTrace(c,m)

  #undef  M_WPDCF77MethodDebug
  #define M_WPDCF77MethodDebug(c,m) SOM_NoTrace(c,m)
#endif /* DEBUG */

/*--------------------------------------------------------------*\
 *  Global definitions and variables for this module            *
\*--------------------------------------------------------------*/
const PSZ szDefaultTitle = DEFAULT_TITLE;

ULONG setPageinfo (WPDCF77 *somSelf, HWND hwndNotebook, PFNWP pfnwp, USHORT dlgId,
                  USHORT usPageStyleFlags, USHORT stringId, USHORT panelId)
    {
    PAGEINFO  pageinfo;
    CHAR      szPageName[CCHMAXPGNAME];

    WinLoadString (hab, hmod, stringId, CCHMAXPGNAME, szPageName);
    memset ((PCH)&pageinfo, 0, sizeof (PAGEINFO));

    pageinfo.cb                 = sizeof (PAGEINFO);
    pageinfo.hwndPage           = NULLHANDLE;
    pageinfo.pfnwp              = pfnwp;
    pageinfo.resid              = hmod;
    pageinfo.pCreateParams      = somSelf;
    pageinfo.dlgid              = dlgId;
    pageinfo.usPageStyleFlags   = usPageStyleFlags;
    pageinfo.usPageInsertFlags  = BKA_FIRST;
    pageinfo.usSettingsFlags    = SETTINGS_PAGE_NUMBERS;
    pageinfo.pszName            = szPageName;
    pageinfo.idDefaultHelpPanel = panelId;
    pageinfo.pszHelpLibraryName = HELPFILENAME;

    return _wpInsertSettingsPage (somSelf, hwndNotebook, &pageinfo);
    }

/*******************************************************************\
    _wpAddClockAlarmPage: Settings page "Alarm 1"
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddClockAlarmPage (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAddClockAlarmPage");

    _wpAddClockAlarm3Page (somSelf, hwndNotebook);
    _wpAddClockAlarm2Page (somSelf, hwndNotebook);

    return setPageinfo (somSelf,
                        hwndNotebook,
                        AlarmDlgProc,
                        IDD_ALARM,
                        BKA_MAJOR | BKA_STATUSTEXTON,
                        IDS_PAGENAME_ALARM,
                        PANEL_ALARM);
    }

/*******************************************************************\
    _wpAddClockAlarm2Page: Settings page "Alarm 2"
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddClockAlarm2Page (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAddClockAlarm2Page");

    return setPageinfo (somSelf,
                        hwndNotebook,
                        Alarm2DlgProc,
                        IDD_ALARM2,
                        BKA_STATUSTEXTON,
                        IDS_PAGENAME_ALARM,
                        PANEL_ALARM2);
    }

/*******************************************************************\
    _wpAddClockAlarm3Page: Settings page "Alarm 3"
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddClockAlarm3Page (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAddClockAlarm3Page");

    return setPageinfo (somSelf,
                        hwndNotebook,
                        Alarm3DlgProc,
                        IDD_ALARM3,
                        BKA_STATUSTEXTON,
                        IDS_PAGENAME_ALARM,
                        PANEL_ALARM3);
    }

/*******************************************************************\
    _wpAddClockDateTimePage: Settings page "Date/Time"
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddClockDateTimePage (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAddClockDateTimePage");

    /* no driver available => display standard OS/2 settings pages */
    if (!isAnySource ())
        return setPageinfo (somSelf,
                            hwndNotebook,
                            TimeDlgProc,
                            IDD_DATETIME,
                            BKA_MAJOR | BKA_STATUSTEXTON,
                            IDS_PAGENAME_DATETIME,
                            PANEL_DATETIME);

    return SETTINGS_PAGE_REMOVED;
    }

/*******************************************************************\
    _wpAddClockView1Page: Settings page "Presentation 1"
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddClockView1Page (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAddClockView1Page");

    return setPageinfo (somSelf,
                        hwndNotebook,
                        ClkTicksDlgProc,
                        IDD_SETTING1,
                        BKA_MAJOR | BKA_STATUSTEXTON,
                        IDS_PAGENAME_VIEW,
                        PANEL_SETTING1);
    }

/*******************************************************************\
    _wpAddClockView2Page: Settings page "Presentation 2"
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddClockView2Page (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAddClockView2Page");

    _wpAddClockView3Page  (somSelf, hwndNotebook);

    return setPageinfo (somSelf,
                        hwndNotebook,
                        ClkColorsDlgProc,
                        IDD_SETTING2,
                        BKA_STATUSTEXTON,
                        IDS_PAGENAME_VIEW,
                        PANEL_SETTING2);
    }

/*******************************************************************\
    _wpAddClockView3Page: Settings page "Presentation 3"
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddClockView3Page (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAddClockView3Page");

    return setPageinfo (somSelf,
                        hwndNotebook,
                        ClkBmpsDlgProc,
                        IDD_SETTING3,
                        BKA_STATUSTEXTON,
                        IDS_PAGENAME_VIEW,
                        PANEL_SETTING3);
    }

/*******************************************************************\
    _wpAddDCFSettingPage1: Settings page "DCF driver 1"
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddDCFSettingPage1 (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAddDCFSettingPage1");

    return setPageinfo (somSelf,
                        hwndNotebook,
                        DCF77DlgProc1,
                        IDD_DCF77_1,
                        BKA_MAJOR | BKA_STATUSTEXTON,
                        isHopf6038 () ? IDS_PAGENAME_GPS : IDS_PAGENAME_DCF,
                        PANEL_DCF77_1);
    }

/*******************************************************************\
    _wpAddDCFSettingPage2: Settings page "DCF driver 2"
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddDCFSettingPage2 (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAddDCFSettingPage2");

    return setPageinfo (somSelf,
                        hwndNotebook,
                        DCF77DlgProc2,
                        IDD_DCF77_2,
                        BKA_STATUSTEXTON,
                        isHopf6038 () ? IDS_PAGENAME_GPS : IDS_PAGENAME_DCF,
                        PANEL_DCF77_2);
    }

/*******************************************************************\
    _wpAddDCFSettingPage3: Settings page "DCF driver 3"
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddDCFSettingPage3 (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAddDCFSettingPage3");

    return setPageinfo (somSelf,
                        hwndNotebook,
                        DCF77DlgProc3,
                        IDD_DCF77_3,
                        BKA_STATUSTEXTON,
                        isHopf6038 () ? IDS_PAGENAME_GPS : IDS_PAGENAME_DCF,
                        PANEL_DCF77_3);
    }

/*******************************************************************\
    _wpAddTmOffsSettingPage: Settings page "Time Offset"
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddTmOffsSettingPage (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAddTmOffsSettingPage");

    return setPageinfo (somSelf,
                        hwndNotebook,
                        TmOffsDlgProc,
                        IDD_TMOFFS,
                        BKA_MAJOR | BKA_STATUSTEXTON,
                        IDS_PAGENAME_OFFSET,
                        PANEL_TMOFFS);
    }

/*******************************************************************\
    _wpAddTZSettingPage : Settings page "Set Time Zone"
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddTZSettingPage (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData(somSelf); */
    WPDCF77MethodDebug("WPDCF77","wpDCF77_wpAddTZSettingPage");

    return setPageinfo (somSelf,
                        hwndNotebook,
                        TimezoneDlgProc,
                        IDD_TIMEZONE,
                        BKA_MAJOR | BKA_STATUSTEXTON,
                        IDS_PAGENAME_TIMEZONE,
                        PANEL_TIMEZONE);
    }

/*******************************************************************\
    _wpAddServerIntervalPage: Interval for LAN::Time
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddServerIntervalPage (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAddServerIntervalPage");

    return setPageinfo (somSelf,
                        hwndNotebook,
                        SrvrIntervalDlgProc,
                        IDD_SERVER,
                        BKA_MAJOR | BKA_STATUSTEXTON,
                        IDS_PAGENAME_INTERVAL,
                        PANEL_SERVER);
    }

/*******************************************************************\
    _wpAddAudioSetupPage: Settings for Hourly Sound of the Gong
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpAddAudioSetupPage (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData(somSelf); */
    WPDCF77MethodDebug("WPDCF77","wpDCF77_wpAddAudioSetupPage");

    return setPageinfo (somSelf,
                        hwndNotebook,
                        ClkAudioDlgProc,
                        IDD_AUDIO,
                        BKA_MAJOR | BKA_STATUSTEXTON,
                        IDS_PAGENAME_AUDIO,
                        PANEL_AUDIO);
    }

/*******************************************************************\
    _wpAddSettingsPages: Insert Settings Pages into Settings Folder
\*******************************************************************/
SOM_Scope BOOL SOMLINK wpDCF77_wpAddSettingsPages (WPDCF77 *somSelf, HWND hwndNotebook)
    {
    BOOL  bRet;

    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAddSettingsPages");

    GetDCFStatus ();
    GetDCFDateTime ();

    bRet  = _wpAddTmOffsSettingPage (somSelf, hwndNotebook) ? TRUE : FALSE;
    bRet &= _wpAddAudioSetupPage  (somSelf, hwndNotebook)   ? TRUE : FALSE;
    bRet &= WPDCF77_parent_WPClock_wpAddSettingsPages (somSelf, hwndNotebook);

    /* driver available -> DCF77 settings pages */
    if (hDrvr != -1 || pShMem && pShMem->flProgs & PROG_DRIVER)
        {
        if (pShMem && pShMem->flProgs & PROG_SERVER)
            bRet &= _wpAddServerIntervalPage (somSelf, hwndNotebook) ? TRUE : FALSE;

        bRet &= _wpAddDCFSettingPage3 (somSelf, hwndNotebook) ? TRUE : FALSE;
        bRet &= _wpAddDCFSettingPage2 (somSelf, hwndNotebook) ? TRUE : FALSE;
        bRet &= _wpAddDCFSettingPage1 (somSelf, hwndNotebook) ? TRUE : FALSE;
        }

    if (isHopf6038 ())
        bRet &= _wpAddTZSettingPage   (somSelf, hwndNotebook) ? TRUE : FALSE;

    return bRet;
    }

/*******************************************************************\
    _wpInitData: initialize instance data, allocate memory
\*******************************************************************/
SOM_Scope void SOMLINK wpDCF77_wpInitData (WPDCF77 *somSelf)
    {
    LONG cxScreen, cyScreen;

    WPDCF77Data *somThis = WPDCF77GetData (somSelf);
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpInitData");

    WPDCF77_parent_WPClock_wpInitData (somSelf);

    /* determine size of screen */
    cxScreen = WinQuerySysValue (HWND_DESKTOP, SV_CXSCREEN);
    cyScreen = WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN);

    _ulPresence          = PRESENCE_DEFAULT;
    _clrBackgnd          = CLR_DEFAULT_BACKGND;
    _clrFace             = CLR_DEFAULT_FACE;
    _clrTick             = CLR_DEFAULT_TICK;
    _clrHHand            = CLR_DEFAULT_HHAND;
    _clrMHand            = CLR_DEFAULT_MHAND;
    _clrDateOnAnalog     = CLR_DEFAULT_DATEONANALG;
    _clrTransparent      = CLR_DEFAULT_TRANSPARENT;
    _clrDateText         = CLR_BLACK;
    _clrTimeText         = CLR_BLACK;
    _lcxClock            = cxScreen /3;
    _lcyClock            = cyScreen /2;
    _lxPos               = 0;
    _lyPos               = 0;
    _lxIconPos           = 0;
    _lyIconPos           = 0;
    _lcxGraph            = cxScreen /3;
    _lcyGraph            = cyScreen /4;
    _lxGraphPos          = 0;
    _lyGraphPos          = 0;
    _lLOffset            = 0;
    _szAlarmMsg[0]       = '\0';
    _szAlarmSoundFile[0] = '\0';
    _szAlarmProg[0]      = '\0';
    _szAlarmParm[0]      = '\0';
    _szAlarmDir[0]       = '\0';
    _szTimezone[0]       = '\0';
    _szPathHHandBmp[0]   = '\0';
    _szPathMHandBmp[0]   = '\0';
    _szPathFaceBmp[0]    = '\0';

    memset (&_dtAlarm, 0, sizeof (ALARMTIME));
    _dtAlarm.usReminderTime = 1;
    memset (&_fAttrD,  0, sizeof (FATTRS));
    memset (&_fAttrT,  0, sizeof (FATTRS));
    _fAttrD.usRecordLength = _fAttrT.usRecordLength = sizeof (FATTRS);
    _fAttrD.fsFontUse      = _fAttrT.fsFontUse      = FONT_DEFAULT_USE;
    _fAttrD.fsType         = _fAttrT.fsType         = FONT_DEFAULT_TYPE;
    strcpy (_fAttrD.szFacename, FONT_DEFAULT_FACE);
    strcpy (_fAttrT.szFacename, FONT_DEFAULT_FACE);
    strcpy (_szFontFamilyD, FONT_DEFAULT_FAMILY);
    strcpy (_szFontFamilyT, FONT_DEFAULT_FAMILY);

    /* allocate and initialize data area for this instance */
    _pIData = allocZeroMem (sizeof (INSTANCEDATA));
    DebugULd (D_INI, "_wpInitData", "sizeof INSTANCEDATA", sizeof (INSTANCEDATA));

    return;
    }

/*******************************************************************\
    _wpUnInitData: deallocate memory
\*******************************************************************/
SOM_Scope void SOMLINK wpDCF77_wpUnInitData (WPDCF77 *somSelf)
    {
    ULONG       ulcTime;
    WPDCF77Data *somThis = WPDCF77GetData (somSelf);
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpUnInitData");

    AlarmStart (somThis, stop);

    /* wait until alarm thread has ended */
    for (ulcTime = 0; ulcTime < 50; ulcTime++)
        {
        if (_timerResources.hSemTimer == 0)
            break;
        DosSleep (100L);
        }

    freeMem ((PPVOID)&_pIData);

    WPDCF77_parent_WPClock_wpUnInitData (somSelf);
    }

/*******************************************************************\
    _wpAdd1sTimer: insert window handle to 1s timer list
\*******************************************************************/
SOM_Scope BOOL SOMLINK wpDCF77_wpAdd1sTimer (WPDCF77 *somSelf, HWND hwndReceiver)
    {
    LONG  i, ulPos;
    BOOL  bOK;

    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpAdd1sTimer");

    /* search for free position in timer list */
    for (i = MAXTIMERS-1, bOK = FALSE; i >= 0; i--)
        {
        if (hwndTimers[i] == NULLHANDLE)
            ulPos = i;
        else if (hwndTimers[i] == hwndReceiver)
            bOK = TRUE;
        }

    if (!bOK)
        {
        /* too much timers */
        if (ulcTimers >= MAXTIMERS)
            {
            DebugE (D_TIMER, "wpAdd1sTimer", "All timers occupied");
            return FALSE;
            }
        else
            {
            hwndTimers[ulPos] = hwndReceiver;
            DebugULx (D_TIMER, "_wpAdd1sTimer", "Handle", hwndReceiver);
            ulcTimers++;
            }
        }

    return TRUE;
    }

/*******************************************************************\
    _wpRemove1sTimer: remove window handle from 1s timer list
\*******************************************************************/
SOM_Scope BOOL SOMLINK wpDCF77_wpRemove1sTimer (WPDCF77 *somSelf, HWND hwndReceiver)
    {
    LONG  i;
    ULONG ulcTmOld;

    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpRemove1sTimer");

    /* remove receiver from list */
    for (i = 0, ulcTmOld = ulcTimers; i < MAXTIMERS; i++)
        if (hwndTimers[i] == hwndReceiver)
            {
            hwndTimers[i] = NULLHANDLE;
            ulcTimers--;
            }

    DebugE (D_TIMER, "Timer removed", "");
    return (ulcTimers == ulcTmOld) ? FALSE : TRUE;
    }

/*******************************************************************\
    _wpMenuItemSelected: initiate menu action
\*******************************************************************/
SOM_Scope BOOL SOMLINK wpDCF77_wpMenuItemSelected (WPDCF77 *somSelf,
                                                   HWND hwndFrame,
                                                   ULONG ulMenuId)
    {
    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpMenuItemSelected");

    /* which menu action has been selected? */
    switch (ulMenuId)
        {
        case IDM_OPENANALOG:
            return (_wpViewObject (somSelf, NULLHANDLE, OPEN_ANALOG, 0)  != NULLHANDLE);

        case IDM_OPENDIGITAL:
            return (_wpViewObject (somSelf, NULLHANDLE, OPEN_DIGITAL, 0) != NULLHANDLE);

        case IDM_OPENSTATUS:
            return (_wpViewObject (somSelf, NULLHANDLE, OPEN_STATUS, 0)  != NULLHANDLE);

        case IDM_OPENGRAPH:
            return (_wpViewObject (somSelf, NULLHANDLE, OPEN_GRAPH, 0)   != NULLHANDLE);

        case IDM_OPENANTENNA:
            return (_wpViewObject (somSelf, NULLHANDLE, OPEN_ANTADJ, 0)  != NULLHANDLE);

        case IDM_ABOUT:
            return (_wpViewObject (somSelf, NULLHANDLE, OPEN_ABOUT, 0)   != NULLHANDLE);

        case IDM_REMIND:
            return (_wpViewObject (somSelf, NULLHANDLE, OPEN_REMIND, 0)  != NULLHANDLE);

        #ifdef DEBUG
        case IDM_OPENDEBUG:
            return (_wpViewObject (somSelf, hwndFrame, OPEN_DEBUG, 0)    != NULLHANDLE);
        #endif

       default:
            return WPDCF77_parent_WPClock_wpMenuItemSelected (somSelf, hwndFrame, ulMenuId);
        }
    }

/*******************************************************************\
    _wpModifyPopupMenu: modify system menu: insert entries
\*******************************************************************/
SOM_Scope BOOL SOMLINK wpDCF77_wpModifyPopupMenu (WPDCF77 *somSelf,
                                                  HWND hwndMenu,
                                                  HWND hwndCnr,
                                                  ULONG iPosition)
    {
    WPDCF77Data *somThis = WPDCF77GetData (somSelf);
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpModifyPopupMenu");

    DebugULx (D_MENU, "wpModifyPopupMenu", "Input", hwndMenu);

    _wpInsertPopupMenuItems (somSelf, hwndMenu, iPosition, hmod,
                             IDM_OPENVIEW, WPMENUID_OPEN);

    /* The statu panel as well as the panel for the graph has */
    /* only to be displayed, if a driver is installed         */
    if (isAnySource ())
        {
        _wpInsertPopupMenuItems (somSelf, hwndMenu, iPosition, hmod,
                                 IDM_OPENSTAT, WPMENUID_OPEN);
        if (ulGraphView != OPEN_ANTADJ)
            {
            _wpInsertPopupMenuItems (somSelf, hwndMenu, iPosition, hmod,
                                     IDM_OPENGRPH, WPMENUID_OPEN);
            }
        if (ulGraphView != OPEN_GRAPH &&                                // activate "Adjust Antenna" only, if:
            (isHopf603x () && !isHopf6038 () ||                         //   Hopf 6036
            ((isUSBDevice () || isExtModule ()) &&                      //   DCF77 driver with high res driver
            DataDCF.usTimerMode == TIMER_MODE_HR)))
            {
            _wpInsertPopupMenuItems (somSelf, hwndMenu, iPosition, hmod,
                                     IDM_OPENANT, WPMENUID_OPEN);
            }
        if ((_dtAlarm.usMode & AM_REMINDER) &&
            (_timerResources.tidAlarmThread != NULLHANDLE))
            {
            _wpInsertPopupMenuItems (somSelf, hwndMenu, iPosition, hmod,
                                     IDM_REMINDER, WPMENUID_PRIMARY);
            WinCheckMenuItem (hwndMenu, IDM_REMIND, IsAlarmActive (somThis));
            }
        }

    _wpInsertPopupMenuItems (somSelf, hwndMenu, iPosition, hmod,
                             IDM_MAINMENU, WPMENUID_PRIMARY);

    return (WPDCF77_parent_WPClock_wpModifyPopupMenu (somSelf,
                                                             hwndMenu,
                                                             hwndCnr,
                                                             iPosition));
    }

/*******************************************************************\
    _wpFilterPopupMenu: Modify system menu: remove entries
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77_wpFilterPopupMenu (WPDCF77 *somSelf,
                                                   ULONG ulFlags,
                                                   HWND hwndCnr,
                                                   BOOL fMultiSelect)
    {
    ULONG flag;

    /* WPDCF77Data *somThis = WPDCF77GetData(somSelf); */
    WPDCF77MethodDebug("WPDCF77", "wpDCF77_wpFilterPopupMenu");

    DebugULx (D_MENU, "wpFilterPopupMenu", "Flag input", ulFlags);

    flag = WPDCF77_parent_WPClock_wpFilterPopupMenu (somSelf,
                                                     ulFlags,
                                                     hwndCnr,
                                                     fMultiSelect) & ~CTXT_PALETTE;
    DebugULx (D_MENU, "wpFilterPopupMenu", "Flag output", flag);
    return flag;
    }

/*******************************************************************\
    _wpOpen: Open an new View
\*******************************************************************/
SOM_Scope HWND SOMLINK wpDCF77_wpOpen (WPDCF77 *somSelf,
                                       HWND hwndCnr,
                                       ULONG ulView,
                                       ULONG param)
    {
    WPDCF77Data *somThis = WPDCF77GetData (somSelf);
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpOpen");

    switch (ulView)
        {
        case OPEN_ANALOG:
            if (!_wpSwitchTo (somSelf, OPEN_ANALOG))
                {
                HWND hwnd;

                if (_ulOpenView == OPEN_DIGITAL)
                    {
                    DebugE (D_WND, "_wpOpen", "Close digital view");
                    _wpCloseADView (somSelf);
                    DebugE (D_WND, "_wpOpen", "digital view closed");
                    }
                _ulOpenView = OPEN_ANALOG;
                DebugE (D_WND, "_wpOpen", "Open: analog");
                _ulPresence &= ~PRESENCE_DISP_DIGITAL;
                _ulPresence |=  PRESENCE_DISP_ANALOG;
                hwnd = ClkInit (somSelf);
                DebugE (D_WND, "_wpOpen", "Opened: analog");
                return hwnd;
                }
            break;

        case OPEN_DIGITAL:
            if (!_wpSwitchTo (somSelf, OPEN_DIGITAL))
                {
                if (_ulOpenView == OPEN_ANALOG)
                    {
                    DebugE (D_WND, "_wpOpen", "Close analog view");
                    _wpCloseADView (somSelf);
                    }
                _ulOpenView = OPEN_DIGITAL;
                DebugE (D_WND, "_wpOpen", "Open: digital");
                _ulPresence &= ~PRESENCE_DISP_ANALOG;
                _ulPresence |=  PRESENCE_DISP_DIGITAL;
                ClkInit (somSelf);
                DebugE (D_WND, "_wpOpen", "Opened: digital");
                }
            break;

        case OPEN_STATUS:
            if (!_wpSwitchTo (somSelf, OPEN_STATUS))
                {
                WinLoadDlg (HWND_DESKTOP, HWND_DESKTOP,
                    (PFNWP)StatusDlgProc, hmod, IDD_DCF77_STATUS, (PVOID)somSelf);
                }
            break;

        case OPEN_GRAPH:
            DebugE (D_WND, "_wpOpen", "OPEN_GRAPH started");
            ulGraphView = OPEN_GRAPH;
            if (somSelfGraphView == NULL)
                somSelfGraphView = somSelf;
            if (!_wpSwitchTo (somSelfGraphView, OPEN_GRAPH))
                {
                DebugE (D_WND, "_wpOpen","Open: graph");
                ClkGraph (somSelfGraphView);
                DebugE (D_WND, "_wpOpen", "Opened: graph");
                }
            break;

        case OPEN_ANTADJ:
            DebugE (D_WND, "_wpOpen", "OPEN_ANTADJ started");
            ulGraphView = OPEN_ANTADJ;
            if (somSelfGraphView == NULL)
                somSelfGraphView = somSelf;
            if (tidGraphThread == 0)
                {
                ClkStartThread (somSelfGraphView);
                DebugE (D_WND, "_wpOpen","thAdj6036/thAdjExtModule-thread started");
                }
            if (!_wpSwitchTo (somSelfGraphView, OPEN_ANTADJ))
                {
                ClkGraph (somSelfGraphView);
                DebugE (D_WND, "_wpOpen", "Opened: AntAdj");
                }
            break;

        case OPEN_ABOUT:
            if (!_wpSwitchTo (somSelf, OPEN_ABOUT))
                {
                WinLoadDlg (HWND_DESKTOP, HWND_DESKTOP,
                    (PFNWP)AboutDlgProc, hmod, IDD_ABOUTBOX, (PVOID)somSelf);
                }
            break;

        case OPEN_REMIND:
            AlarmStart (somThis, toggle);
            break;

        #ifdef DEBUG
        case OPEN_DEBUG:
            {
            ULONG ulResult;

            SOMOutCharRoutine = myReplacementForSOMOutChar;

            ulResult = WinDlgBox (HWND_DESKTOP, HWND_DESKTOP,
                (PFNWP)DbgDlgProc, hmod, IDD_DEBUG, NULL);

            SOM_TraceLevel  = (ulResult >> SHFT_TRACE)  & 3;
            SOM_WarnLevel   = (ulResult >> SHFT_WARN)   & 3;
            SOM_AssertLevel = (ulResult >> SHFT_ASSERT) & 3;
            }
            break;
        #endif

        default:
            return WPDCF77_parent_WPClock_wpOpen (somSelf, hwndCnr, ulView, param);
        }

    return NULLHANDLE;
    }

/*******************************************************************\
    _wpRefreshClockView: Repaint current view Analog/Digital 
                         of the clock
\*******************************************************************/
SOM_Scope void SOMLINK wpDCF77_wpRefreshClockView (WPDCF77 *somSelf)
    {
    PUSEITEM pUseItem = NULL;
    ULONG    ulActView = 0;
    ULONG    ulNewView;

    WPDCF77Data *somThis = WPDCF77GetData (somSelf);
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpRefreshClockView");

    do
        {
        pUseItem = _wpFindUseItem (somSelf, USAGE_OPENVIEW, pUseItem);
        if (pUseItem == NULL)
            break;
        DebugULx (D_WND, "_wpRefreshClockView", "Pointer",  (ULONG)(pUseItem->pNext));

        /* Determine current view out of VIEWITEM structure         */
        /* If this view doesn't correspond to the requested view in */
        /* _ulPresence a new view has to be painted (_wpViewObject) */
        ulActView = ((PVIEWITEM)(pUseItem+1))->view;
        if (ulActView == OPEN_DIGITAL || ulActView == OPEN_ANALOG)
            break;              // First view found is sufficient
        else
            ulActView = 0;      // set 0 for later comparison
        } while (pUseItem->pNext != NULL);

    ulNewView = _ulPresence & PRESENCE_DISP_ANALOG ? OPEN_ANALOG : OPEN_DIGITAL;
    if (ulNewView == ulActView)
        {
        ClkRefresh (somThis);
        DebugE (D_WND, "_wpRefreshClockView", "Same View: ClkRefresh called");
        }
    else if (ulActView != 0)
        {
        _wpViewObject (somSelf, NULLHANDLE, ulNewView, 0);
        DebugE (D_WND, "_wpRefreshClockView", "New View: _wpViewObject called");
        }

    return;
    }

/*******************************************************************\
    _wpRestoreState: Load instance data
\*******************************************************************/
SOM_Scope BOOL SOMLINK wpDCF77_wpRestoreState (WPDCF77 *somSelf,
                                               ULONG ulReserved)
    {
    BOOL  bRes;
    ULONG ulSize;

    WPDCF77Data *somThis = WPDCF77GetData (somSelf);
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpRestoreState");

    bRes  = _wpRestoreLong (somSelf, CLASSNAME, IDKEY_PRESENCE,            &_ulPresence     );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_BACKGND,     (PULONG)&_clrBackgnd     );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_FACE,        (PULONG)&_clrFace        );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_TICK,        (PULONG)&_clrTick        );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_HHAND,       (PULONG)&_clrHHand       );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_MHAND,       (PULONG)&_clrMHand       );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_DATE,        (PULONG)&_clrDateOnAnalog);
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_TRANSPARENT, (PULONG)&_clrTransparent );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_DATETXT,     (PULONG)&_clrDateText    );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_TIMETXT,     (PULONG)&_clrTimeText    );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_CX,          (PULONG)&_lcxClock       );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_CY,          (PULONG)&_lcyClock       );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_X,           (PULONG)&_lxPos          );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_Y,           (PULONG)&_lyPos          );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_IX,          (PULONG)&_lxIconPos      );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_IY,          (PULONG)&_lyIconPos      );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_GRAPHCX,     (PULONG)&_lcxGraph       );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_GRAPHCY,     (PULONG)&_lcyGraph       );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_GRAPHX,      (PULONG)&_lxGraphPos     );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_GRAPHY,      (PULONG)&_lyGraphPos     );
    bRes &= _wpRestoreLong (somSelf, CLASSNAME, IDKEY_LOFFSET,     (PULONG)&_lLOffset       );
    ulSize = sizeof (ALARMTIME);
    bRes &= _wpRestoreData (somSelf, CLASSNAME, IDKEY_ALARM,    (PBYTE)&_dtAlarm,   &ulSize);
    ulSize = sizeof (FATTRS);
    bRes &= _wpRestoreData (somSelf, CLASSNAME, IDKEY_FATTRSD,  (PBYTE)&_fAttrD,    &ulSize);
    ulSize = sizeof (FATTRS);
    bRes &= _wpRestoreData (somSelf, CLASSNAME, IDKEY_FATTRST,  (PBYTE)&_fAttrT,    &ulSize);
    ulSize = FACESIZE;
    bRes &= _wpRestoreString (somSelf, CLASSNAME, IDKEY_FAMILYD,     _szFontFamilyD,    &ulSize);
    ulSize = FACESIZE;
    bRes &= _wpRestoreString (somSelf, CLASSNAME, IDKEY_FAMILYT,     _szFontFamilyT,    &ulSize);
    ulSize = CCHMAXALARMMSG;
    bRes &= _wpRestoreString (somSelf, CLASSNAME, IDKEY_ALARMTXT,    _szAlarmMsg,       &ulSize);
    ulSize = CCHMAXPATH;
    bRes &= _wpRestoreString (somSelf, CLASSNAME, IDKEY_ALARMMMFILE, _szAlarmSoundFile, &ulSize);
    ulSize = CCHMAXPATH;
    bRes &= _wpRestoreString (somSelf, CLASSNAME, IDKEY_ALARMPROG,   _szAlarmProg,      &ulSize);
    ulSize = CCHMAXPARM;
    bRes &= _wpRestoreString (somSelf, CLASSNAME, IDKEY_ALARMPARM,   _szAlarmParm,      &ulSize);
    ulSize = CCHMAXPATHCOMP;
    bRes &= _wpRestoreString (somSelf, CLASSNAME, IDKEY_ALARMDIR,    _szAlarmDir,       &ulSize);
    ulSize = CCHMAXTZONE;
    bRes &= _wpRestoreString (somSelf, CLASSNAME, IDKEY_TIMEZONE,    _szTimezone,       &ulSize);
    ulSize = CCHMAXPATH;
    bRes &= _wpRestoreString (somSelf, CLASSNAME, IDKEY_BMP_HHAND,   _szPathHHandBmp,   &ulSize);
    ulSize = CCHMAXPATH;
    bRes &= _wpRestoreString (somSelf, CLASSNAME, IDKEY_BMP_MHAND,   _szPathMHandBmp,   &ulSize);
    ulSize = CCHMAXPATH;
    bRes &= _wpRestoreString (somSelf, CLASSNAME, IDKEY_BMP_FACE,    _szPathFaceBmp,    &ulSize);

    /* If _dtAlarm is set to AM_REMINDER, the reminder alarm will be deactivated */
    if (_dtAlarm.usMode & AM_REMINDER)
        _dtAlarm.bIsAlarmActive = FALSE;

    bRes &= WPDCF77_parent_WPClock_wpRestoreState (somSelf, ulReserved);

    return bRes;
    }

/*******************************************************************\
    _wpSaveState: Save instance data
\*******************************************************************/
SOM_Scope BOOL SOMLINK wpDCF77_wpSaveState (WPDCF77 *somSelf)
    {
    BOOL bRes;

    WPDCF77Data *somThis = WPDCF77GetData (somSelf);
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpSaveState");

    bRes  = _wpSaveLong (somSelf, CLASSNAME, IDKEY_PRESENCE,    _ulPresence      );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_BACKGND,     _clrBackgnd      );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_FACE,        _clrFace         );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_TICK,        _clrTick         );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_HHAND,       _clrHHand        );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_MHAND,       _clrMHand        );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_DATE,        _clrDateOnAnalog );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_TRANSPARENT, _clrTransparent  );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_DATETXT,     _clrDateText     );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_TIMETXT,     _clrTimeText     );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_CX,          _lcxClock        );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_CY,          _lcyClock        );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_X,           _lxPos           );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_Y,           _lyPos           );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_IX,          _lxIconPos       );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_IY,          _lyIconPos       );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_GRAPHCX,     _lcxGraph        );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_GRAPHCY,     _lcyGraph        );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_GRAPHX,      _lxGraphPos      );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_GRAPHY,      _lyGraphPos      );
    bRes &= _wpSaveLong (somSelf, CLASSNAME, IDKEY_LOFFSET,     _lLOffset        );
    bRes &= _wpSaveData (somSelf, CLASSNAME, IDKEY_FATTRSD,     (PBYTE)&_fAttrD,  sizeof (FATTRS));
    bRes &= _wpSaveData (somSelf, CLASSNAME, IDKEY_FATTRST,     (PBYTE)&_fAttrT,  sizeof (FATTRS));
    bRes &= _wpSaveData (somSelf, CLASSNAME, IDKEY_ALARM,       (PBYTE)&_dtAlarm, sizeof (ALARMTIME));
    bRes &= _wpSaveString (somSelf, CLASSNAME, IDKEY_FAMILYD,     _szFontFamilyD   );
    bRes &= _wpSaveString (somSelf, CLASSNAME, IDKEY_FAMILYT,     _szFontFamilyT   );
    bRes &= _wpSaveString (somSelf, CLASSNAME, IDKEY_ALARMTXT,    _szAlarmMsg      );
    bRes &= _wpSaveString (somSelf, CLASSNAME, IDKEY_ALARMMMFILE, _szAlarmSoundFile);
    bRes &= _wpSaveString (somSelf, CLASSNAME, IDKEY_ALARMPROG,   _szAlarmProg     );
    bRes &= _wpSaveString (somSelf, CLASSNAME, IDKEY_ALARMPARM,   _szAlarmParm     );
    bRes &= _wpSaveString (somSelf, CLASSNAME, IDKEY_ALARMDIR,    _szAlarmDir      );
    bRes &= _wpSaveString (somSelf, CLASSNAME, IDKEY_TIMEZONE,    _szTimezone      );
    bRes &= _wpSaveString (somSelf, CLASSNAME, IDKEY_BMP_HHAND,   _szPathHHandBmp  );
    bRes &= _wpSaveString (somSelf, CLASSNAME, IDKEY_BMP_MHAND,   _szPathMHandBmp  );
    bRes &= _wpSaveString (somSelf, CLASSNAME, IDKEY_BMP_FACE,    _szPathFaceBmp   );
    bRes &= WPDCF77_parent_WPClock_wpSaveState (somSelf);

    DebugULd (D_INI, "_wpSaveState", "_lxPos", _lxPos);
    DebugULd (D_INI, "_wpSaveState", "_lyPos", _lyPos);

    return bRes;
    }

/*******************************************************************\
    _wpQueryDefaultView: Determine default view
\*******************************************************************/
SOM_Scope ULONG   SOMLINK wpDCF77_wpQueryDefaultView (WPDCF77 *somSelf)
    {
    WPDCF77Data *somThis = WPDCF77GetData (somSelf);
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpQueryDefaultView");

    return _ulPresence & PRESENCE_DISP_ANALOG ? OPEN_ANALOG : OPEN_DIGITAL;
    }

/*******************************************************************\
    _wpClosedADView: Method is comparable to _wpClose,
                     but only OPEN_ANALOG and OPEN_DIGITAL
                     views will be closed.
\*******************************************************************/
SOM_Scope void SOMLINK wpDCF77_wpCloseADView (WPDCF77 *somSelf)
    {
    PUSEITEM pUseItem = NULL;

    /* WPDCF77Data *somThis = WPDCF77GetData (somSelf); */
    WPDCF77MethodDebug ("WPDCF77", "wpDCF77_wpCloseADView");

    do
        {
        pUseItem = _wpFindUseItem (somSelf, USAGE_OPENVIEW, pUseItem);
        if (pUseItem == NULL)
            break;
        DebugULx (D_WND, "_wpCloseADView", "Pointer",  (ULONG)(pUseItem->pNext));

        /* Determine current view out of VIEWITEM struktur                   */
        /* If this view doesn't correspond to the requested view in          */
        /* _ulPresence a new view has to be painted (_wpViewObject)          */
        /* wpDeleteFromObjUseList will be called within the window procedure */
        switch (((PVIEWITEM)(pUseItem+1))->view)
            {
            case OPEN_DIGITAL:
                DebugE (D_WND, "_wpCloseADView", "OPEN_DIGITAL recognized");
            case OPEN_ANALOG:
                DebugULx (D_WND, "_wpCloseADView", "hwnd", (HWND)(((PVIEWITEM)(pUseItem+1))->handle));
                WinSendMsg ((HWND)(((PVIEWITEM)(pUseItem+1))->handle), WM_CLOSE, MPVOID, MPVOID);
                DebugE (D_WND, "_wpCloseADView", "View closed");
                break;
            }
        } while (pUseItem->pNext != NULL);

    DebugE (D_WND, "_wpCloseADView", "exit");
    return;
    }

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta
/*******************************************************************\
    _clsQueryModuleHandle: determine hmod
\*******************************************************************/
SOM_Scope HMODULE SOMLINK wpDCF77M_clsQueryModuleHandle (M_WPDCF77 *somSelf)
    {
    /* M_WPDCF77Data *somThis = M_WPDCF77GetData (somSelf); */
    M_WPDCF77MethodDebug ("M_WPDCF77", "wpDCF77M_clsQueryModuleHandle");

    if (hmod == NULLHANDLE)
        {
        zString zsPathName;

        /* Retrieve registered pathname of our module */
        /* (DLL) and query the module handle.         */
        zsPathName =
        _somLocateClassFile (SOMClassMgrObject, SOM_IdFromString (CLASSNAME),
                             WPDCF77_MajorVersion, WPDCF77_MinorVersion);

        if (DosQueryModuleHandle (zsPathName, &hmod))
            {
            DebugE (D_DIAG, "_clsQueryModuleHandle", "Failed to load module");
            hmod = NULLHANDLE;
            }
        }

    return hmod;
    }

/*******************************************************************\
    _wpclsInitData: Initialize class data (hab, hmod, ...)
                    Start timer thread
                    Register window classes
\*******************************************************************/
SOM_Scope void SOMLINK wpDCF77M_wpclsInitData (M_WPDCF77 *somSelf)
    {
    PCHAR    psz;
    ULONG    ul;
    ULONG    flType;
    BOOL     bRC;

    /* M_WPDCF77Data *somThis = M_WPDCF77GetData (somSelf); */
    M_WPDCF77MethodDebug ("M_WPDCF77", "wpDCF77M_wpclsInitData");
    M_WPDCF77_parent_M_WPClock_wpclsInitData (somSelf);

    hab = WinQueryAnchorBlock (HWND_DESKTOP);

    _clsQueryModuleHandle (somSelf);

    /* Start thread for 1s timer */
    _beginthread (th1sTimer, NULL, STACKLEN, NULL);
    DebugE (D_IO, "_wpclsInitData", "Thread started");

    /* Read class data from INI file                  */
    /* flag set in flType on read error in class data */
    ul = sizeof (DCF77_DATA);
    flType  = PrfQueryProfileData (HINI_USERPROFILE, APP_DCF, KEY_SETTINGS, &DataDCF,        &ul) ? 0 : SAVESET_INIDATA;
    ul = sizeof (DCF77_OFFSET);
    flType |= PrfQueryProfileData (HINI_USERPROFILE, APP_DCF, KEY_OFFSET,   &OffsDCF,        &ul) ? 0 : SAVESET_INIOFFSET;
    ul = sizeof (ULONG);
    flType |= PrfQueryProfileData (HINI_USERPROFILE, APP_DCF, KEY_INTERVAL, &ulSrvrInterval, &ul) ? 0 : SAVESET_INIINTERVAL;
    ul = sizeof (BOOL);
    flType |= PrfQueryProfileData (HINI_USERPROFILE, APP_DCF, KEY_SENDTIME, &bSendSrvrTime,  &ul) ? 0 : SAVESET_INIINTERVAL;
    ul = sizeof (BOOL);
    flType |= PrfQueryProfileData (HINI_USERPROFILE, APP_DCF, KEY_AUDIOMODE, &bClsIs1PerHour,  &ul) ? 0 : SAVESET_AUDIODATA;
    ul = sizeof (HOBJECT);
    flType |= PrfQueryProfileData (HINI_USERPROFILE, APP_DCF, KEY_AUDIOOBJECT, &hClsRingingObject, &ul) ? 0 : SAVESET_AUDIODATA;
    flType |= PrfQueryProfileString (HINI_USERPROFILE, APP_DCF, KEY_AUDIOFILE, NULL, szClsGongFile, CCHMAXPATH) ? 0 : SAVESET_AUDIODATA;

    ul = CCHMAXTZONE+CCHMAXPATH;
    psz = allocZeroMem (ul);
    flType |= PrfQueryProfileData (HINI_USERPROFILE, APP_DCF, KEY_TIMEZONE, psz,             &ul) ? 0 : SAVESET_INITIMEZONE;
    if (!(flType & SAVESET_INITIMEZONE))
        {
        strncpy (szLocName, psz,                               CCHMAXTZONE);
        strncpy (szLocFile, (PCHAR)memchr (psz, '\0', ul) + 1, CCHMAXPATH);
        }
    else
        {
        szLocName[0] = '\0';
        szLocFile[0] = '\0';
        }
    DebugE (D_IO, "_wpclsInitData, szLocName", szLocName);
    DebugE (D_IO, "_wpclsInitData, szLocFile", szLocFile);
    freeMem ((PPVOID)&psz);

    /* If class data for audio could not be read, they will be set to default values */
    if (flType & SAVESET_AUDIODATA)
        {
        szClsGongFile[0]  = '\0';
        bClsIs1PerHour    = FALSE;
        hClsRingingObject = NULLHANDLE;
        }

    DebugULx (D_IO, "_wpclsInitData", "flType", flType);

    /* Open/create shared memory for communication with LAN::Time Server/Client processes */
    if (DosGetNamedSharedMem ((PPVOID)&pShMem, SHMEMNAME, PAG_READ | PAG_WRITE))
        {
        if (DosAllocSharedMem ((PPVOID)&pShMem, SHMEMNAME, sizeof (SHMEM),
                               PAG_COMMIT | PAG_WRITE | PAG_READ))
            pShMem = NULL;                              // Fehler: Anlegen des Shared-Memory nicht mglich
        else
            memset (pShMem, '\0', sizeof (SHMEM));
        }
    if (pShMem)
        pShMem->flProgs |= PROG_CLOCK;

    /* Open interface to DCF driver */
    if (DosOpen (DEVICENAME, &hDrvr, &ul, 0, FILE_NORMAL,
                 OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                 OPEN_SHARE_DENYREADWRITE | OPEN_ACCESS_READWRITE,
                 NULL))
        {
        hDrvr = -1;
        DebugE (D_IO, "_wpclsInitData", "No IOCTL-driver found");
        }

    if (isAnySource ())
        {
        DebugE (D_IO, "_wpclsInitData", "driver or LAN::Time client opened");
        memset (&StatDCF, '\0', sizeof (DCF77_STATUS));
        GetDCFStatus ();
        if (!(StatDCF.cVerMajor | StatDCF.cVerMinor))
            {
            DebugE (D_IO | D_DIAG, "_wpclsInitData", "wrong data in DCF77_STATUS-Package");
            if (hDrvr != -1)
                {
                DosClose (hDrvr);
                hDrvr = -1;
                }
            }
        else
            {
            /* If class data could be read successfully, they will be read from driver */
            /* 1. DCF77_DATA structure */
            if (flType & SAVESET_INIDATA)
                {
                bRC = Query_DCFData (&DataDCF);
                DebugULd (D_IO, "_wpclsInitData", "DCF77_QUERYDATA, bRC",             bRC);
                DebugULx (D_IO, "_wpclsInitData", "DCF77_QUERYDATA, bSupply",         DataDCF.bSupply);
                DebugULx (D_IO, "_wpclsInitData", "DCF77_QUERYDATA, bSignal",         DataDCF.bSignal);
                DebugULx (D_IO, "_wpclsInitData", "DCF77_QUERYDATA, bPort",           DataDCF.bPort);
                DebugULd (D_IO, "_wpclsInitData", "DCF77_QUERYDATA, bcRepeat",        DataDCF.bcRepeat);
                DebugULx (D_IO, "_wpclsInitData", "DCF77_QUERYDATA, usIOAddr",        DataDCF.usIOAddr);
                DebugULd (D_IO, "_wpclsInitData", "DCF77_QUERYDATA, usQueryInterval", DataDCF.usSetInterval);
                DebugULd (D_IO, "_wpclsInitData", "DCF77_QUERYDATA, usThreshold",     DataDCF.usThreshold);
                DebugULd (D_IO, "_wpclsInitData", "DCF77_QUERYDATA, usTicklen",       DataDCF.usTicklen);
                DebugULd (D_IO, "_wpclsInitData", "DCF77_QUERYDATA, usTimerMode",     DataDCF.usTimerMode);
                if (!bRC)
                    memset (&DataDCF, '\0', sizeof (DCF77_DATA));
                }
            else
                {
                flType |= SAVESET_DRVRDATA;

                /* Initialize daylight saving time, if GPS hardware detected */
                DebugE (D_IO, "_wpclsInitData", "initialize GPS");
                InitGPSDriver ();
                }

            /* 2. DCF77_OFFSET structure */
            if (flType & SAVESET_INIOFFSET)
                {
                bRC = Query_DCFOffset (&OffsDCF);
                DebugULd (D_IO, "_wpclsInitData", "DCF77_QUERYOFFQUERY, bRC",     bRC);
                DebugULd (D_IO, "_wpclsInitData", "DCF77_QUERYOFFQUERY, flUTC",   OffsDCF.flUTC);
                DebugULd (D_IO, "_wpclsInitData", "DCF77_QUERYOFFQUERY, sOffset", OffsDCF.sOffset);
                if (!bRC)
                    memset (&OffsDCF, '\0', sizeof (DCF77_OFFSET));
                }
            else
                flType |= SAVESET_DRVROFFSET;

            /* 3. Set interval for LAN::Time to default, if error occurred */
            if (flType & SAVESET_INIINTERVAL)
                {
                ulSrvrInterval = INTERVAL_DEFAULT;
                bSendSrvrTime  = SENDTIME_DEFAULT;
                }
            }
        }

    /* Write class data into driver and INI file */
    _clsSaveSetData (somSelf, flType);

    /* Register Window class for marker box */
    WinRegisterClass (hab, CLASS_MARKER, (PFNWP)InfoWndProc, 0, sizeof (ULONG));

    return;
    }

/*******************************************************************\
    _wpclsQueryIconData: Determine Icon
\*******************************************************************/
SOM_Scope ULONG SOMLINK wpDCF77M_wpclsQueryIconData (M_WPDCF77 *somSelf,
                                                     PICONINFO pIconInfo)
    {
    /* M_WPDCF77Data *somThis = M_WPDCF77GetData (somSelf); */
    M_WPDCF77MethodDebug ("M_WPDCF77", "wpDCF77M_wpclsQueryIconData");

    if (pIconInfo != NULL)
        {
        pIconInfo->cb      = sizeof (ICONINFO);
        pIconInfo->fFormat = ICON_RESOURCE;
        pIconInfo->hmod    = _clsQueryModuleHandle (somSelf);
        pIconInfo->resid   = ID_ICON;
        }

    return sizeof (ICONINFO);
    }

/*******************************************************************\
    _wpclsQueryTitle: Determine default title of the class
\*******************************************************************/
SOM_Scope PSZ SOMLINK wpDCF77M_wpclsQueryTitle (M_WPDCF77 *somSelf)
    {
    /* M_WPDCF77Data *somThis = M_WPDCF77GetData (somSelf); */
    M_WPDCF77MethodDebug ("M_WPDCF77", "wpDCF77M_wpclsQueryTitle");

    return szDefaultTitle;
    }

/*******************************************************************\
    _clsSaveSetData: Hand over class data to driver and save in
                     INI file respectively
\*******************************************************************/
SOM_Scope void SOMLINK wpDCF77M_clsSaveSetData (M_WPDCF77 *somSelf,
               ULONG flType)
    {
    BOOL   bRC;
    PCHAR  psz;
    ULONG  ulLen, ulc;

    /* M_WPDCF77Data *somThis = M_WPDCF77GetData (somSelf); */
    M_WPDCF77MethodDebug ("M_WPDCF77", "wpDCF77M_clsSaveSetData");

    if (flType & SAVESET_DRVRDATA)
        {
        bRC = Set_DCFData (&DataDCF);
        DebugULd (D_IO, "_clsSaveSetData", "DCF77_SETDATA, bRC",           bRC);
        DebugULx (D_IO, "_clsSaveSetData", "DCF77_SETDATA, bSupply",       DataDCF.bSupply);
        DebugULx (D_IO, "_clsSaveSetData", "DCF77_SETDATA, bSignal",       DataDCF.bSignal);
        DebugULx (D_IO, "_clsSaveSetData", "DCF77_SETDATA, bPort",         DataDCF.bPort);
        DebugULd (D_IO, "_clsSaveSetData", "DCF77_SETDATA, bcRepeat",      DataDCF.bcRepeat);
        DebugULx (D_IO, "_clsSaveSetData", "DCF77_SETDATA, usIOAddr",      DataDCF.usIOAddr);
        DebugULd (D_IO, "_clsSaveSetData", "DCF77_SETDATA, usSetInterval", DataDCF.usSetInterval);
        DebugULd (D_IO, "_clsSaveSetData", "DCF77_SETDATA, usThreshold",   DataDCF.usThreshold);
        DebugULd (D_IO, "_clsSaveSetData", "DCF77_SETDATA, usTicklen",     DataDCF.usTicklen);
        DebugULd (D_IO, "_clsSaveSetData", "DCF77_SETDATA, usTimerMode",   DataDCF.usTimerMode);
        }

    if (flType & SAVESET_INIDATA)
        {
        /* Write data only, if a driver is available */
        if (hDrvr != -1 || pShMem && pShMem->flProgs & PROG_DRIVER)
            {
            PrfWriteProfileData (HINI_USERPROFILE, APP_DCF, KEY_SETTINGS, &DataDCF, sizeof (DCF77_DATA));
            DebugE (D_IO, "_clsSaveSetData", "Classdata DCF77_DATA saved");
            }
        }

    if (flType & SAVESET_DRVROFFSET)
        {
        bRC = Set_DCFOffset (&OffsDCF);
        DebugULd (D_IO, "_clsSaveSetData", "DCF77_SETOFFSET, bRC",     bRC);
        DebugULd (D_IO, "_clsSaveSetData", "DCF77_SETOFFSET, flUTC",   OffsDCF.flUTC);
        DebugULd (D_IO, "_clsSaveSetData", "DCF77_SETOFFSET, sOffset", OffsDCF.sOffset);
        }

    if (flType & SAVESET_INIOFFSET)
        {
        PrfWriteProfileData (HINI_USERPROFILE, APP_DCF, KEY_OFFSET, &OffsDCF, sizeof (DCF77_OFFSET));
        DebugE (D_IO, "_clsSaveSetData", "Classdata DCF77_OFFSET saved");
        }

    if (flType & SAVESET_SHMEMINTERVAL && pShMem)
        {
        HEV hevServer = 0;

        pShMem->dcf77Data.ulInterval    = ulSrvrInterval;
        pShMem->dcf77Data.bSendSrvrTime = bSendSrvrTime;

        /* Notify changes in server process via semaphore */
        if (DosOpenEventSem (SEMNAME, &hevServer) == 0)
            {
            DosPostEventSem (hevServer);
            DosCloseEventSem (hevServer);
            }

        DebugULd (D_IO, "_clsSaveSetData", "SHMEM.ulInterval", ulSrvrInterval);
        DebugULd (D_IO, "_clsSaveSetData", "SHMEM.bSendSrvrTime", bSendSrvrTime);
        }

    if (flType & SAVESET_INIINTERVAL)
        {
        PrfWriteProfileData (HINI_USERPROFILE, APP_DCF, KEY_INTERVAL, &ulSrvrInterval, sizeof (ULONG));
        PrfWriteProfileData (HINI_USERPROFILE, APP_DCF, KEY_SENDTIME, &bSendSrvrTime,  sizeof (ULONG));
        DebugE (D_IO, "_clsSaveSetData", "Classdata ulSrvrInterval saved");
        }

    if (flType & SAVESET_INITIMEZONE)
        {
        psz = allocZeroMem (CCHMAXTZONE+CCHMAXPATH);

        ulLen = strlen (szLocName);
        ulc   = strlen (szLocFile);
        memcpy (psz,         szLocName, min (ulLen, CCHMAXTZONE-1));
        memcpy (psz+ulLen+1, szLocFile, min (ulc,   CCHMAXPATH-1));
        ulLen += ulc;

        PrfWriteProfileData (HINI_USERPROFILE, APP_DCF, KEY_TIMEZONE, psz, ulLen+2);
        DebugULx (D_IO, "_clsSaveSetData", "Classdata TIMEZONE saved, length", ulLen);
        freeMem ((PPVOID)&psz);
        }

    if (flType & SAVESET_AUDIODATA)
        {
        DebugE (D_IO, "_clsSaveSetData => save and set Audio data; string: ", szClsGongFile);

        PrfWriteProfileString (HINI_USERPROFILE, APP_DCF, KEY_AUDIOFILE,   szClsGongFile);
        PrfWriteProfileData   (HINI_USERPROFILE, APP_DCF, KEY_AUDIOMODE,   &bClsIs1PerHour,    sizeof (BOOL));
        PrfWriteProfileData   (HINI_USERPROFILE, APP_DCF, KEY_AUDIOOBJECT, &hClsRingingObject, sizeof (HOBJECT));
        }

    return;
    }

/*******************************************************************\
    _wpclsQueryDefaultHelp: Specify default help panel of the class
\*******************************************************************/
SOM_Scope BOOL SOMLINK wpDCF77M_wpclsQueryDefaultHelp (M_WPDCF77 *somSelf,
                                                       PULONG pHelpPanelId,
                                                       PSZ pszHelpLibrary)
    {
    /* M_WPDCF77Data *somThis = M_WPDCF77GetData (somSelf); */
    M_WPDCF77MethodDebug ("M_WPDCF77", "wpDCF77M_wpclsQueryDefaultHelp");

    strcpy (pszHelpLibrary, HELPFILENAME);
    *pHelpPanelId = PANEL_MAIN;

    return TRUE;
    }
