.*
:userdoc.
:title. Unit Converter 0.96
.nameit symbol=greename text=':hp2.:color fc=darkgreen bc=default.Unit Converter:color fc=default bc=default.:ehp2.'
.nameit symbol=updateme text=':hp2.when you add new group/unit/constant or correct errors in existing, send me the file CONVERT.NEW, so I can include changes in next release. Thanks in advance.:ehp2.'

:docprof toc=123.

.*
.* Panel definition : Introduction
.*
:h1 id=100  res=100 x=0% y=0% width=100% height=100%  group=1.Introduction
:i1 id=100.Introduction
:p.
&greename. is a PM calculator and utility which enables "on-the-fly" unit conversions.
:p.
Features&colon.
:ul compact.
:li.add new groups, change basic units for groups, delete groups you don't need
:li.add new units in selected group, change unit's conversion factor, offset and prefixes, delete units you don't need
:li.input value, conversion factor and offset can be number, expression or function
:li.usage of program's built-in, user defined, Rexx built-in and external functions
:li.remember last selected group and units
:li.hot keys
:eul.
:nt.&updateme.:ent.
.br
&greename. has Language support for English, Croatian, French, German, Spanish and Swedish.
If you want to add your Language support :link refid=author reftype=fn. visit my site:elink.
and download Translation tool (translat.zip).
:p.
:hp5.See also&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=110.Installation
:elink.
:li.
:link reftype=hd res=200.Using Unit Converter
:elink.
:li.
:link reftype=hd res=300.Groups and units
:elink.
:li.
:link reftype=hd res=400.Settings
:elink.
:li.
:link reftype=hd res=600.SI units
:elink.
:li.
:link reftype=hd res=700.Prefixes
:elink.
:li.
:link reftype=hd res=750.Translation tool
:elink.
:esl.

.*
.* Panel definition : Installation
.*
:h2 id=110  res=110 x=0% y=0% width=100% height=100%  group=1.Installation
:i2 refid=100.Installation
:p.
:hp2.Files in this archive&colon.:ehp2.
:dl compact tsize=20.
:dt.ConvInst.cmd
:dd.install/uninstall script - :hp8.required!:ehp8.
:dt.Convert.exe
:dd.program - :hp8.required!:ehp8.
:dt.Convert.ico
:dd.Icon for program
:dt.CONVERT.DAT
:dd.database - :hp8.required!:ehp8.
:dt.Conbmp32.dll
:dd.bitmaps - :hp8.required!:ehp8.
:dt.ENGLISH.INI
:dd.English Language support - :hp8.required!:ehp8.
:dt.English.inf
:dd.English manual
:dt.CROATIAN.INI
:dd.Croatian Language support
:dt.FRENCH.INI
:dd.French Language support
:dt.French.inf
:dd.French manual
:dt.GERMAN.INI
:dd.German Language support
:dt.SPANISH.INI
:dd.Spanish Language support
:dt.SWEDISH.INI
:dd.Swedish Language support
:dt.Swedish.inf
:dd.Swedish manual
:dt.helpfile.zip
:dd.Manual (source files)
:dt.FastIni.dll
:dd.if you already have library FastIni.dll in LIBPATH directory, you can delete this file.
:edl.
:p.
Copy all files to separate directory, run script ConvInst.cmd with parameter I (:hp2.ConvInst.cmd I:ehp2.) and follow instructions.
:nt.
DO NOT MOVE Conbmp32.dll to LIBPATH directory, or English.inf to BOOKSHELF directory  - they must be in &greename. directory.
:p.
DO NOT USE database (CONVERT.DAT) from previous versions of &greename. - data format is different in this version.
:ent.
To uninstall &greename., run script ConvInst.cmd again with parameter U (:hp2.ConvInst.cmd U:ehp2.). Program object for &greename. will be destroyed.
Then you can delete files in &greename. directory.
:p.

.*
.* Panel definition : Using Unit Converter
.*
:h1 id=200  res=200 x=0% y=0% width=100% height=100%  group=1.Using Unit Converter
:i1 id=200.Using Unit Converter
:p.
When you start &greename., in upper part of main window is :link reftype=hd res=201.Button bar:elink.
and three lists below&colon.
:dl compact tsize=20.
:dt.:hp2.1 Groups:ehp2.
:dd.Groups of units (Area, Length, Mass,...). When you select group, in second and third list are displayed units in this group.
:dt.:hp2.2 Source units:ehp2.
:dd.Source units (convert from ...). Select source unit and type value (number, constant, expression).
:dt.:hp2.3 Target units:ehp2.
:dd.Target units (convert to ...). Select target unit to convert units and display conversion result.
:edl.
:p.
When you select new group, in source and target list is selected base unit for this group and value of source unit is set to 1.
:p.
Below lists are two entry fields&colon.
:ul compact.
:li.value field (left) - here you write value of source unit (single number or expression)
:li.result field (right) - here is displayed calculation/conversion result
:eul.
.br
 and calculation/conversion buttons&colon.
.br
:artwork name='clipaste.bmp' runin.:hp9.Paste:ehp9. - copy Clipboard contents to input (vaule) field (:hp9.Alt-P:ehp9.).
.br
:artwork name='clear.bmp' runin.:hp9.Clear:ehp9. - delete expression in input (vaule) field, enter default value (1) and convert it to target unit (:hp9.Alt-D:ehp9.).
.br
:artwork name='convert.bmp' runin.:hp9.Convert:ehp9. - evaluate expression in input (vaule) field and display result of calculation/conversion in result field (:hp9.Enter:ehp9.).
.br
:artwork name='convall.bmp' runin.:hp9.Convert one to all:ehp9.- :link reftype=hd res=203.convert selected source unit to all target units:elink..
.br
:artwork name='convall2.bmp' runin.:hp9.Convert all to all:ehp9. - :link reftype=hd res=203.convert all source units to all target units:elink..
.br
:artwork name='swap.bmp' runin.:hp9.Swap:ehp9. - select target unit as source unit and vice versa.
.br
:artwork name='clipcopy.bmp' runin.:hp9.Copy:ehp9. - copy conversion result to Clipboard (:hp9.Alt-C:ehp9.).
:p.
You can use &greename. as calculator or converter&colon.
:ol.
:li.
To use &greename. as calculator, select same unit in source and target list,
type :link reftype=hd res=220.expression:elink. in value (left) field and press :hp9.Enter:ehp9. key or :hp9.Convert:ehp9. button.
&greename. will ignore conversion factor and offset for selected units and evaluate expression in value field.
The calculator follows standard :link reftype=hd res=220.evaluation rules:elink..
In result (right) field will be displayed result of calculation.
:li.
To use &greename. as converter, select different unit in source or target list.
&greename. will evaluate expression in value (left) field, multiply it with conversion factor for source unit,
divide with conversion factor for target unit, add offset for source unit and substract offset for target unit.
In result (right) field will be displayed result of conversion.
:eol.
:nt.
You can also perform common actions (selections in the lists, conversion, ...) without mouse, using :link reftype=hd res=202.Hot keys:elink..
.br
When you select another source or target unit, conversion result is automatically updated and you don't need to press :hp9.Enter:ehp9. key or :hp9.Convert:ehp9. button.
:ent.
:p.
:hp5.See also&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=201.Button bar
:elink.
:li.
:link reftype=hd res=202.Hot keys
:elink.
:li.
:link reftype=hd res=203.Multiple conversions
:elink.
:li.
:link reftype=hd res=220.Expressions and evaluation rules
:elink.
:li.
:link reftype=hd res=230.Functions
:elink.
:li.
:link reftype=hd res=280.Constants
:elink.
:li.
:link reftype=hd res=290.Examples
:elink.
:li.
:link reftype=hd res=300.Groups and units
:elink.
:li.
:link reftype=hd res=380.Characters
:elink.
:li.
:link reftype=hd res=400.Settings
:elink.
:esl.

.*
.* Panel definition : Button bar
.*
:h2 id=201  res=201 x=0% y=0% width=100% height=100%  group=2.Button bar
:i2 refid=200.Button bar
:p.
:artwork name='chars.bmp' runin.:hp9.Characters:ehp9. - convert representation of ONE character to another format. See :link reftype=hd res=380.Characters:elink.
:p.
:artwork name='func.bmp' runin.:hp9.Functions:ehp9. - edit :link reftype=hd res=232.user defined functions:elink. in &greename.
.br
:artwork name='constant.bmp' runin.:hp9.Constants:ehp9. - edit :link reftype=hd res=280.constants:elink. in &greename.
.br
:artwork name='set.bmp' runin.:hp9.Settings:ehp9. - change :link reftype=hd res=400.settings:elink. for &greename.
.br
:artwork name='help.bmp' runin.:hp9.Help:ehp9. - help for &greename. (:hp9.F1:ehp9.).
.br
:artwork name='exit.bmp' runin.:hp9.Exit:ehp9. - leave &greename. (:hp9.Alt-X:ehp9.).
:p.

.*
.* Panel definition : Hot keys
.*
:h2 id=202  res=202 x=0% y=0% width=100% height=100%  group=2.Hot keys
:i2 refid=200.Hot keys
:p.
You can also perform common actions (selections in the lists, conversion, ...) without mouse, using hot keys&colon.
:dl tsize=10.
:dt.:hp7.Key:ehp7.
:dd.:hp7.Action:ehp7.
:dt.:hp2.Alt-0:ehp2.
:dd.Select groups list (font color will change to :hp4.blue:ehp4.)
:dt.:hp2.Alt-1:ehp2.
:dd.Select source units list (font color will change to :hp4.blue:ehp4.)
:dt.:hp2.Alt-2:ehp2.
:dd.Select target units list (font color will change to :hp4.blue:ehp4.)
:dt.:hp2.Alt-I:ehp2.
:dd.Select input (value) field
:dt.:hp2.Alt-C:ehp2.
:dd.Copy conversion result to Clipboard
:dt.:hp2.Alt-P:ehp2.
:dd.Paste conversion result from Clipboard to input (value) field and convert it to target unit
:dt.:hp2.Alt-D:ehp2.
:dd.Delete expression in input (vaule) field, enter default value (1) and convert it to target unit
:dt.:hp2.Alt-X:ehp2.
:dd.Exit &greename.
:edl.

.*
.* Panel definition : Multiple conversions
.*
:h2 id=203  res=203 x=0% y=0% width=100% height=100%  group=2.Multiple conversions
:i2 refid=200.Multiple conversions
:artwork name='convall.bmp' runin.:hp2.Convert selected source unit to all target units:ehp2.
(value of selected source unit is converted to all target units in selected group and displayed in the list).
:p.
:artwork name='convall2.bmp' runin.:hp2.Convert all source units to all target units:ehp2.
(value of all source units is converted to all target units in selected group and displayed in the list).
:p.
Units and conversion result is displayed in form defined in settings (units names or symbols and numeric form).
If symbols for some of units are unknown, * character will be displayed.
Don't use symbols to display conversion result, or enter symbols for all units in the group.
:nt.
when you convert all source units to all target units, units names are truncated to 11 characters,
and if conversion result is longer than 11 characters, it is displayed in the exponential form.
When you save conversion result to HTML file, full units names and conversion results are written to file.
:ent.
:p.
:artwork name='convtext.bmp' runin.:hp9.Save to text:ehp9. - save conversion result to text file 'Convert.txt'.
.br
:artwork name='convhtml.bmp' runin.:hp9.Save to HTML:ehp9. - save conversion result to HTML file 'Convert.htm'.
Enabled only if you convert all source units to all target units.
.br
:artwork name='help.bmp' runin.:hp9.Help:ehp9. - help for multiple conversions.
.br
:artwork name='close.bmp' runin.:hp9.Close:ehp9. - return to main window.
:p.

.*
.* Panel definition : Expressions and evaluation rules
.*
:h1 id=220  res=220 x=0% y=0% width=100% height=100%  group=1.Expressions and evaluation rules
:i1 id=220.Expressions and evaluation rules
:p.
An expression consists of one or more numbers, :link reftype=hd res=280.constants:elink.,
 operators (see below) and calls to :link reftype=hd res=230.functions:elink..
:p.
You can use following operators in expressions&colon.
:dl compact tsize=15.
:dt.Addition
:dd.The operator for addition is the plus sign :hp9.+:ehp9..
:dt.Subtraction
:dd.The operator for subtraction is the minus sign :hp9.-:ehp9..
:dt.Multiplication
:dd.The operator for multiplication is the asterisk :hp9.*:ehp9..
.br
To raise a number to a power, the operator is two asterisks :hp9.**:ehp9..
:dt.Division
:dd.For a simple division, the operator is a single slash :hp9./:ehp9..
.br
To divide for the purpose of getting only the remainder, the operator is two slashes :hp9.//:ehp9..
.br
To divide, and return only the whole number portion of an answer and no remainder, the operator is the percent sign :hp9.%:ehp9..
:edl.
:p.
The rules of algebra apply to mathematical expressions.
Expressions are normally evaluated from left to right in following order of precedence for math operations&colon.
:ol compact.
:li.Raise to a power
:li.Multiplication and Division
:li.Addition and Subtraction
:eol.
:nt.
if you use parentheses in an expression, then what is in the parentheses is evaluated first.
You can use as many sets of parentheses as you want, even in expressions where they are not really necessary to force desired precedence.
:ent.
:p.
You can use any combination of numbers, constants and functions in expression, but remember that result of expression must be numeric value.
If result is not numeric, &greename. will return :hp8.Error!:ehp8. result.
:p.
:hp2.Tip&colon.:ehp2.
if calculation/conversion was successful, result is stored in variable :hp2.z:ehp2.
and it can be used in next calculation/conversion.
:p.
:hp5.See also&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=230.Functions
:elink.
:li.
:link reftype=hd res=280.Constants
:elink.
:li.
:link reftype=hd res=290.Examples
:elink.
:li.
:link reftype=hd res=300.Groups and units
:elink.
:li.
:link reftype=hd res=400.Settings
:elink.
:esl.

.*
.* Panel definition : Functions
.*
:h1 id=230  res=230 x=0% y=0% width=100% height=100%  group=1.Functions
:i1 id=230.Functions
:p.
You can include calls to :link reftype=hd res=231.Unit Converter built-in functions:elink., :link reftype=hd res=232.User defined functions:elink.,
Rexx built-in functions and :link reftype=hd res=233.External functions:elink. in an expression using the notation&colon.
:p.
      :hp2.FUNCTION:ehp2.(:hp1.expression:ehp1.)
:p.
:p.
:hp2.Unit Converter built-in functions:ehp2.
:dl compact tsize=10.
:dt.B2O
:dd.binary to octal
:dt.O2B
:dd.octal to binary
:dt.!
:dd.factorial
:dt.SQRT
:dd.Square root
:dt.LN
:dd.natural logarithm
:dt.SIN
:dd.sine
:dt.COS
:dd.cosine
:dt.TAN
:dd.tangent
:edl.
:p.
:p.
:hp2.REXX built-in functions:ehp2.
:p.
Rexx provides a rich set of built-in functions.A dictionary of built-in functions is in the
:link reftype=launch object='View.exe' data='Rexx.inf Functions'.Procedures Language 2/REXX Reference:elink.
:p.
:p.
:hp2.User defined functions:ehp2.
:p.
You can write your own Rexx functions (up to 9) to use with &greename.
:p.
:p.
:hp2.External functions:ehp2.
:p.
You can call functions that are external to &greename. and Rexx. An external function must return data to &greename..

:warning.
if you set numeric display to 'Country specific' , and comma is used as thousand or decimal separator,
don't use functions which accept parameters separated with comma, like LEFT(string,n) or WORD(string,n),
or &greename. will return :hp8.Error!:ehp8. as result.
.br
If you need to use those functions, change numeric display to 'Default' or 'SI recommended' in :link reftype=hd res=400.Settings:elink..
:ewarning.
:p.
:hp5.See also&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=231.Unit Converter built-in functions
:elink.
:li.
:link reftype=hd res=232.User defined functions
:elink.
:li.
:link reftype=hd res=233.External functions
:elink.
:li.
:link reftype=hd res=220.Expressions and evaluation rules
:elink.
:li.
:link reftype=hd res=280.Constants
:elink.
:li.
:link reftype=hd res=290.Examples
:elink.
:li.
:link reftype=hd res=400.Settings
:elink.
:esl.

.*
.* Panel definition : Unit Converter built-in functions
.*
:h2 id=231  res=231 x=0% y=0% width=100% height=100%  group=2.Unit Converter built-in functions
:i2 refid=230.Unit Converter built-in functions
:p.
:hp2.B2O:ehp2. (binary to octal) - convert string of binary digits (0 or 1) to octal value.
:dl compact tsize=15.
:dt.:hp1.Syntax:ehp1.
:dd.B2O(binary_string) - any string between 0 and 11111111.
:dt.:hp1.Result:ehp1.
:dd.number between 0 and 377.
:dt.:hp1.Example:ehp1.
:dd.B2O(10101010) returns 252.
:edl.
:p.
:hp2.O2B:ehp2. (octal to binary)  - convert octal number to string of binary digits (0 or 1).
:dl compact tsize=15.
:dt.:hp1.Syntax:ehp1.
:dd.O2B(octal_number) - any number between 0 and 377.
:dt.:hp1.Result:ehp1.
:dd.string of binary digits between 0 and 11111111.
:dt.:hp1.Example:ehp1.
:dd.O2B(123) returns 001010011.
:edl.
:p.
:hp2.!:ehp2. (factorial)  - factorial of number.
:dl compact tsize=15.
:dt.:hp1.Syntax:ehp1.
:dd.!(number) - any positive whole number
:dt.:hp1.Result:ehp1.
:dd.number.
:dt.:hp1.Example:ehp1.
:dd.!(10) returns 3628800.
:edl.
:p.
:hp2.SQRT:ehp2. (square root)  - square root of number.
:dl compact tsize=15.
:dt.:hp1.Syntax:ehp1.
:dd.SQRT(number) - any positive number
:dt.:hp1.Result:ehp1.
:dd.number.
:dt.:hp1.Example:ehp1.
:dd.SQRT(2) returns 1.4142135624.
:edl.
:p.
:hp2.LN:ehp2. (natural logarithm)  - natural logarithm of number.
:dl compact tsize=15.
:dt.:hp1.Syntax:ehp1.
:dd.LN(number) - any positive number
:dt.:hp1.Result:ehp1.
:dd.number.
:dt.:hp1.Example:ehp1.
:dd.LN(2) returns 0.6931471484.
:edl.
:p.
:hp2.SIN:ehp2. (sine)  - sine of number.
:dl compact tsize=15.
:dt.:hp1.Syntax:ehp1.
:dd.SIN(number) - angle in radians
:dt.:hp1.Result:ehp1.
:dd.number.
:dt.:hp1.Example:ehp1.
:dd.SIN(1) returns 0.8414709848.
:edl.
:p.
:hp2.COS:ehp2. (cosine)  - cosine of number.
:dl compact tsize=15.
:dt.:hp1.Syntax:ehp1.
:dd.COS(number) - angle in radians
:dt.:hp1.Result:ehp1.
:dd.number.
:dt.:hp1.Example:ehp1.
:dd.COS(1) returns 0.5403023062.
:edl.
:p.
:hp2.TAN:ehp2. (tangent)  - tangent of number.
:dl compact tsize=15.
:dt.:hp1.Syntax:ehp1.
:dd.TAN(number) - angle in radians
:dt.:hp1.Result:ehp1.
:dd.number.
:dt.:hp1.Example:ehp1.
:dd.TAN(1) returns 1.5574077247.
:edl.
:p.

.*
.* Panel definition : User defined functions
.*
:h2 id=232  res=232 x=0% y=0% width=100% height=100%  group=2.User defined functions
:i2 refid=230.User defined functions
You can write your own Rexx functions (up to 9) to use with &greename. To do this, click on
:artwork name='func.bmp' runin.button to open new window.
:p.
There are 9 buttons with functions names (FN1 to FN9). Defined functions are in :hp4.blue:ehp4. and empty functions (not defined) are in :hp8.red:ehp8..
Click on button to display defined function, or to write new function (if it is empty). Color of button will change to yellow. Now you can edit function.
:nt.
there are already 2 example functions&colon. FN8 (factorial) and FN9 (used space of current drive in bytes).
.br
You can use them in &greename., edit or delete them.
:ent.
:p.
:hp2.IMPORTANT!:ehp2. When writing your function, follow those rules&colon.
:ul.
:li.every function must return data to &greename.. You can call other functions (built-in, Rexx, external, other user defined) from your functions.
:li.name of input variable (parameter passed to function) must be :hp9.fnin:ehp9.. Input variable is optional (see example function FN9).
.br
DO NOT use :link reftype=launch object='View.exe' data='Rexx.inf PARSE'.PARSE ARG:elink. command to retrieve parameter passed to function.
:li.name of output variable (result of function) must be :hp9.fnout:ehp9.. Output variable is required (function must return value).
.br
DO NOT use :link reftype=launch object='View.exe' data='Rexx.inf RETURN'.RETURN:elink. command to return value to &greename..
:li.DO NOT use commands/functions defined to write output to display, like SAY or CHAROUT,
or commands/functions defined to work only in windowed or full-screen application, like the RexxUtil function SysTextScreenRead.
:eul.
:p.
:artwork name='check.bmp' runin.:hp9.Check syntax:ehp9. - check syntax for function.
Type input value (variable :hp9.fnin:ehp9.) and press this button. Expressions will be evaluated, and final result of function (variable :hp9.fnout:ehp9.) will be displayed.
If some of expressions can not be evaluated, &greename. will return :hp8.Error!:ehp8..
.br
:artwork name='import.bmp' runin.:hp9.Import:ehp9. - import function (Rexx script).
If you have function written in Rexx and want to use it in &greename., you don't need to write it again - press this button and select Rexx script (*.cmd) in FileOpen dialog.
You'll have to do some changes (remove PARSE ARG, RETURN, SAY,... commands) - see rules above.
.br
:artwork name='delete.bmp' runin.:hp9.Delete:ehp9. - delete selected function.
If you want to delete function, check if it is called in another function or another function will return error or unexpected result.
.br
:artwork name='save.bmp' runin.:hp9.Save:ehp9. - save selected function.
After you checked function's syntax, press this button to save function.
.br
Then you can call this function in &greename. like any other function&colon. :hp2.FNx:ehp2.(:hp1.expression:ehp1.),
where x is number between 1 and 9 (FN1 to FN9), and expression is :hp9.fnin:ehp9. variable.
.br
:artwork name='help.bmp' runin.:hp9.Help:ehp9. - help about functions.
.br
:artwork name='close.bmp' runin.:hp9.Close:ehp9. - return to program without saving changes.
:p.

.*
.* Panel definition : External functions
.*
:h2 id=233  res=233 x=0% y=0% width=100% height=100%  group=2.External functions
:i2 refid=230.External functions
:p.
You can call functions that are external to &greename. and Rexx. An external function must return data to &greename..
Before you start to use external functions in &greename., you must register them.
For example, to register all the math functions in IBM EWS RxMathFn.dll,
you need to execute the following function calls in REXX:
:sl compact.
:li.rc = RxFuncAdd("MathLoadFuncs","RxMathFn","MathLoadFuncs")
:li.rc = MathLoadFuncs()
:esl.
:p.
The first statement registers the MathLoadFuncs function in RxMathFn,
and the second statement calls the MathLoadFuncs function to load in the rest of the functions.
:nt.
You don't need to register
:link reftype=launch object='View.exe' data='Rexx.inf Rexx Utility Functions'.Rexx Utility Functions (RexxUtil.dll):elink..
If they are not registered, &greename. will register them.
:ent.

.*
.* Panel definition : Constants
.*
:h1 id=280  res=280 x=0% y=0% width=100% height=100%  group=1.Constants
:i1 id=280.Constants
:p.
Constants are numbers often used in calculation/conversion. You can add your own constants to &greename..
Two constants are built-in and can not be changed&colon.
:dl compact tsize=5.
:dt.:hp2.e:ehp2.
:dd.the base for the natural logarithm system. Value is 2.718281828459045
:dt.:hp2.pi:ehp2.
:dd.the quotient of a circles perimeter and its diameter. Value is 3.141592653589793
:edl.
:p.
Constant can be ONLY number, without expressions, functions or other constants within it.
:p.
To edit constant, change it's symbol (then it will be saved as new constant), name and/or value.
:warning.
You can assign any symbol to constant except :hp8.e pi x y z:ehp8.. They are reserved by &greename..
:ewarning.
:artwork name='clipaste.bmp' runin.:hp9.Paste:ehp9. - use conversion result as value of selected constant.
.br
:artwork name='save.bmp' runin.:hp9.Save:ehp9. - save selected constant.
&greename. will save constant only if symbol is different than reserved symbols, and if value of constant is number.
.br
:artwork name='help.bmp' runin.:hp9.Help:ehp9. - help about constants.
.br
:artwork name='close.bmp' runin.:hp9.Close:ehp9. - return to main window without saving changes.
:p.
:hp5.See also&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=220.Expressions and evaluation rules
:elink.
:li.
:link reftype=hd res=230.Functions
:elink.
:li.
:link reftype=hd res=290.Examples
:elink.
:esl.

.*
.* Panel definition : Examples
.*
:h1 id=290  res=290 x=0% y=0% width=100% height=100%  group=1.Examples
:i1 id=290.Examples
:p.
:hp2.Expression without parentheses:ehp2.
:ol compact.
:li.Type :hp9.2+3*4+5**4-2:ehp9. in value field and press :hp9.Convert:ehp9. button or :hp9.Enter:ehp9. key.
:li.Result will be :hp9.637:ehp9.
:eol.
:p.
:hp2.Expression with parentheses:ehp2.
:ol compact.
:li.Type :hp9.(2+3)*4+5**(4-2):ehp9. in value field and press :hp9.Convert:ehp9. button or :hp9.Enter:ehp9. key.
:li.Result will be :hp9.45:ehp9.
:eol.
:p.
:hp2.Using result of previous calculation/conversion:ehp2. - calculate sine of 45 degrees&colon.
:ol compact.
:li.Select group 'Angle'. Degree will be selected as source and target unit.
:li.Type :hp9.45:ehp9. in value field.
:li.Select radian in target units.
:li.Result will be :hp9.0.785398:ehp9..
(this conversion is needed because SIN() function returns sine of angle in radians and we have to convert degrees to radians first)
:li.Type :hp9.SIN(z):ehp9. in value field.
:li.Select degree in target units.
:li.Result will be :hp9.0.707107:ehp9.
:eol.
:p.
:hp2.Using Rexx built-in functions:ehp2. - calculate time since midnight and convert to other units&colon.
:ol compact.
:li.Select group 'Time'. Second will be selected as source and target unit.
:li.Select minute in source units and leave seconds in target units.
:li.Type :hp9.TIME('M'):ehp9. and press :hp9.Convert:ehp9. button or :hp9.Enter:ehp9. key.
:li.Result will be :hp9.79200:ehp9. (time since mindnight in seconds).
:li.When you select hour in target units, result will be :hp9.22:ehp9., and when you select minute in target units result will be :hp9.1320:ehp9..
:eol.
:p.
:hp2.Using external functions:ehp2. - calculate size of current drive and convert to other units&colon.
:ol compact.
:li.Select group 'Data'. Bit will be selected as source and target unit.
:li.Select byte as source and target unit.
:li.Type :hp9.WORD(SysDriveInfo(LEFT(DIRECTORY(),2)),3):ehp9. and press :hp9.Convert:ehp9. button or :hp9.Enter:ehp9. key.
:li.Result will be :hp9.540345344:ehp9. Here are several function, each using result of previous one&colon.
:ol compact.
:li.:hp9.DIRECTORY():ehp9. is Rexx built-in function and returns the current directory&colon. :hp9.D&colon.\Util\Units095:ehp9.
:li.:hp9.LEFT('D&colon.\Util\Units095',2):ehp9. is Rexx built-in function and returns 2 leftmost characters of string D&colon.\Util\Units095&colon. :hp9.D&colon.:ehp9.
:li.:hp9.SysDriveInfo('D&colon.'):ehp9. is Rexx utility function and returns string in following form&colon. :hp9.D&colon. 235165514 540345344 OS2:ehp9. (drive free total label)
:li.:hp9.WORD('D&colon. 235165514 540345344 OS2',3):ehp9. is Rexx built-in function and returns 3rd blank delimited word in string&colon. :hp9.540345344:ehp9.
:eol.
:li.When you select megabyte in target units, result will be :hp9.540.345:ehp9., and when you select mebibyte result will be :hp9.515.313:ehp9..
:eol.
:nt.
result of expression must be a number, or &greename. will return :hp8.Error!:ehp8. as result,
but result of function inside expression (used by other function) may be string, like in DIRECTORY(), LEFT() and SysDriveInfo(),
because result of expression is result of WORD() function.
:ent.
:warning.
if you set numeric display to 'Country specific' , and comma is used as thousand or decimal separator,
don't use functions which accept parameters separated with comma, like LEFT(string,n) or WORD(string,n),
or &greename. will return :hp8.Error!:ehp8. as result.
.br
If you need to use some of them, change numeric display to 'Default' or 'SI recommended' in :link reftype=hd res=400.Settings:elink..
:ewarning.

.*
.* Panel definition : Groups and units
.*
:h1 id=300  res=300 x=0% y=0% width=100% height=100%  group=1.Groups and units
:i1 id=300.Groups and units
:p.
In &greename. database are many units ready for conversion.
.br
It is easy to add new group or unit, or change existing one - select group or unit and press :artwork name='edit.bmp' runin.:hp9.edit:ehp9. button.
.br
If you are sure that you don't need some groups or units, you can :artwork name='delete.bmp' runin. remove them from database.
:nt.
you can use group '#test' to write new groups, set their conversion factors, offsets and test result.
:ent.
:p.
:hp5.See also&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=310.Groups
:elink.
:li.
:link reftype=hd res=320.Units
:elink.
:li.
:link reftype=hd res=380.Characters
:elink.
:li.
:link reftype=hd res=600.SI units
:elink.
:esl.

.*
.* Panel definition : Groups
.*
:h2 id=310  res=310 x=0% y=0% width=100% height=100%  group=2.Groups
:i2 refid=300.Groups
:nt.
:hp8.You can not change or delete groups 'Shoe' and 'Temperature'.:ehp8.
See :link reftype=hd res=380.Characters:elink. and :link reftype=hd res=360.Shoe sizes:elink..
:ent.
:ul compact.
:li.group's name (if you change name, group will be saved as new)
:li.group's basic unit.
:eul.
:p.
:artwork name='save.bmp' runin.:hp9.Save:ehp9. - save selected group. If this is new group,
&greename. will also add default unit for this group. You should later select this unit and check it's properties.
.br
:artwork name='help.bmp' runin.:hp9.Help:ehp9. - help about groups.
.br
:artwork name='close.bmp' runin.:hp9.Close:ehp9. - to return to program without saving changes.
:nt.&updateme.:ent.

.*
.* Panel definition : Units
.*
:h2 id=320  res=320 x=0% y=0% width=100% height=100%  group=2.Units
:i2 refid=300.Units
:nt.
:hp8.You can not change or delete units in groups 'Shoe' and 'Temperature'.:ehp8.
See :link reftype=hd res=380.Characters:elink. and :link reftype=hd res=360.Shoe sizes:elink..
:ent.
:ul compact.
:li.unit's name (if you change name, unit will be saved as new).
:li.unit's symbol (type :hp9.*:ehp9. if symbol is unknown)
:li.unit's conversion factor (multiply group's basic unit with this number - default is :hp9.x:ehp9. - see note below)&colon. result of expression must be a number.
:li.offset for conversion factor (add this number to conversion factor - default is :hp9.0:ehp9.)&colon. result of expression must be a number.
:li.prefixes to use with unit. If some of prefixes can be used with this unit, check selected prefix.
.br
You can not edit unit which is combination of prefix and base unit (for example&colon. kilometre, milimetre, ... in group 'Length').
Select base unit (metre in this example), and check prefixes to use with this unit. New units will be added to the list, and unchecked will be removed.
:eul.
:nt.
default symbol for conversion factor is :hp9.x:ehp9., meaning&colon. multiply value of source unit with this symbol.
For example&colon. if conversion factor for selected unit is :hp9.x*0.3048:ehp9. (conversion factor for foot in group 'Length' and value is :hp9.2:ehp9.,
when you select foot as source and metre as target unit, conversion result will be :hp9.0.6096:ehp9. (2*0.3048=0.6096).
.br
If :hp9.x:ehp9. is missing, result will allways be only conversion factor.
:p.
After you change unit's conversion factor and/or offset, type test value and press :hp9.Check syntax:ehp9. button to test conversion.
:ent.
:artwork name='check.bmp' runin.:hp9.Check syntax:ehp9. - check syntax for unit's conversion factor and offset.
Type value (default is 1) and press this button. You can see 'step-by-step' how expressions are evaluated, and final result of conversion for selected unit.
If some of expressions can not be evaluated, &greename. will return :hp8.Error!:ehp8..
:p.
:artwork name='save.bmp' runin.:hp9.Save:ehp9. - save selected unit.
.br
:artwork name='help.bmp' runin.:hp9.Help:ehp9. - help about units.
.br
:artwork name='close.bmp' runin.:hp9.Close:ehp9. - return to program without saving changes.
:nt.&updateme.:ent.
:p.

.*
.* Panel definition : Shoe sizes
.*
:h2 id=360 res=360 x=0% y=0% width=100% height=100%  group=2.Shoe sizes
:i2 refid=360.Shoe sizes
:p.
There is no specific international standard for shoe sizes.
European half sizes don't really exist (they are shown to make the table accurate).
:p.
When you select 'Shoe' in &greename., folowing sizes are valid for Europe (EU), Japan (JP), United Kingdom (UK) and United States (US)&colon.
:table cols='22 22 22 22' rules=both frame=box.
:row.
:c.
Infants
:c.
Children
:c.
Men
:c.
Women
:row.
:c.
EU    JP    US    UK
:c.
EU    JP    US    UK
:c.
EU    JP    US    UK
:c.
EU    JP    US    UK
:row.
:c.
:lines.
17     7     2     1.5
18     7.5   2.5   2
18.5   8     3     2.5
19     8.5   3.5   3
19.5   9     4     3.5
20     9.5   4.5   4
21    10     5     4.5
21.5  10.5   5.5   5
22    11     6     5.5
22.5  11.5   6.5   6
23.5  12     7     6.5
24    12.5   7.5   7
25    13     8     7.5
:c.
:lines.
25.5  13.5   8.5   8
26    14     9     8.5
26.5  14.5   9.5   9
27    15    10     9.5
27.5  15.5  10.5  10
28    16    11    10.5
28.5  16.5  11.5  11
29.5  17    12    11.5
30    17.5  12.5  12
31    18    13    12.5
31.5  18.5  13.5  13
32    19     1    13.5
33    19.5   1.5   1
33.5  20     2     1.5
34    20.5   2.5   2
35    21     3     2
35.5  21.5   3.5   2.5
36    22     4     3
36.5  22.5   4.5   3.5
37.5  23     5     4
38    23.5   5.5   4.5
38.5  24     6     5
39    24.5   6.5   5.5
:c.
:lines.
38.5  24     6     5
39    24.5   6.5   5.5
40    25     7     6
40.5  25.5   7.5   6.5
41    26     8     7
42    26.5   8.5   7.5
42.5  27     9     8
43    27.5   9.5   8.5
44    28    10     9
44.5  28.5  10.5   9.5
45    29    11    10
45.5  29.5  11.5  10.5
46    30    12    11
47    31    12.5  12
48    32    13    13
49    33    13.5  14
50    34    14    15
51    35    14.5  16
52    36    15    17
:c.
:lines.
35    22     5     4
35.5  22.5   5.5   4.5
36    23     6     5
36.5  23.5   6.5   5.5
37.5  24     7     6
38    24.5   7.5   6.5
38.5  25     8     6.5
39    25.5   8.5   7
40    26     9     7.5
40.5  26.5   9.5   8
41    27    10     8.5
42    28    11     9.5
42.5  29    12    10.5
:etable.

.*
.* Panel definition : Characters
.*
:h1 id=380 res=380 x=0% y=0% width=100% height=100%  group=1.Characters
:i1 id=380.Characters
:p.
In group 'Characters' you can convert representation of ONE character to another format&colon.
:dl compact tsize=10.
:dt.:hp2.ASCII:ehp2.
:dd.ASCII (American National Standard Code for Information Interchange) - valid entry is any character.
:dt.:hp2.BIN:ehp2.
:dd.Binary - valid entry is string composed of characters&colon. :hp9.01:ehp9. between 0 and 11111111.
:dt.:hp2.DEC:ehp2.
:dd.Decimal - valid entry is string composed of characters&colon. :hp9.0123456789:ehp9. between 0 and 255.
:dt.:hp2.HEX:ehp2.
:dd.Hexadecimal - valid entry is string composed of characters&colon. :hp9.0123456789AaBbCcDdEeFf:ehp9. between 00 and FF.
:dt.:hp2.OCT:ehp2.
:dd.Octal - valid entry is string composed of characters&colon. :hp9.01234567:ehp9. between 0 and 377.
:dt.:hp2.EBCDIC:ehp2.
:dd.EBCDIC (Extended Binary Coded Decimal Interchange Code) representation of one character (read only).
:edl.
:p.
To convert representation of character to another format, type value of character and representation in all formats will change.
:p.
To copy selected representation of character to Clipboard, press :hp9.Copy:ehp9. button or :hp9.Enter:ehp9. key.
Small blue arrow shows selected representation of character.
:nt.
when you type value of control code character (between 0 and 31 decimal), abbreviation and name of this character will be displayed.
:ent.

:artwork name='clipcopy.bmp' runin.:hp9.Copy:ehp9. - copy selected representation of character to clipboard.
.br
:artwork name='help.bmp' runin.:hp9.Help:ehp9. - help about characters.
.br
:artwork name='close.bmp' runin.:hp9.Close:ehp9. - return to program.
:p.

.*
.* Panel definition : Settings
.*
:h1 id=400  res=400 x=0% y=0% width=100% height=100%  group=1.Settings
:i1 id=400.Settings
:p.
:hp2.General&colon.:ehp2.
:ol.
:li.Precision to which arithmetic operations are evaluated - from 9 to 50. Default is 15.
:li.Decimal part of the result - from 0 (whole number) to 32. Default is 3.
:li.Display result in form of exponential notation - the power of 10 is always a multiple of 3. Default is NO.
:li.Use symbols to display conversion result. Default is NO.
:li.Group numbers - divide numbers into groups of 3.
:ol compact.
:li.No separator - use period as decimal separator and don't separate numbers. This is default.
:li.SI recommended - use period as decimal separator and use space to separate numbers (as thousand separator).
:li.Country specific - use Country specific decimal and thousand separator
:eol.
:li.Size of &greename. window - width between 480 and screen width, height between 360 and screen height. Default is 480 (width) and 360 (height).
:li.Display hints in 2 lines - select if you can not see whole description text in the bottom line of &greename. Default is NO.
:li.Remember last conversion - remember last selected group and units and select them on next start. Default is NO.
:li.Save position of &greename. on exit. Default is YES.
:eol.
:p.
:hp2.Interface&colon.:ehp2.
:ol.
:li.:artwork name='colorpal.bmp' runin.:hp9.Open Color Palette:ehp9. and drag &amp. drop selected color.  Default background color for &greename. is white.
:li.:artwork name='fontpal.bmp' runin. :hp9.Open Font Palette:ehp9. and drag &amp. drop selected font.  Default font for &greename. is 9.WarpSans.
:li.Language to use with &greename.. Default is English.
:eol.
:nt.
you can also select different font and background color for &greename.'s controls (lists and entry fields) - drag &amp. drop desired font or color on selected control.
You can not change font color (it is set to black), so don't use black or very dark background colors.
:ent.
:p.
:artwork name='setsave.bmp' runin.Save changes
.br
:artwork name='default.bmp' runin.Load default settings
.br
:artwork name='help.bmp' runin.Help for settings
.br
:artwork name='close.bmp' runin.Return to program without saving changes.
:p.

.*
.* Panel definition : SI units
.*
:h1 id=600  res=600 x=0% y=0% width=100% height=100%  group=1.SI units
:i1 id=600.SI units
:p.
The modern metric system (SI) is the system of units and measures, with following principles&colon.
:ol compact.
:li.the system should consist of measuring units based on unvariable quantities in nature,
:li.all units other than the base units should be derived from these base units,
:li.multiples and submultiples of the units should be decimal (see :link reftype=hd res=700.Prefixes:elink..)
:eol.
:nt.
At this time, only three countries - Burma, Liberia, and the US - have not adopted the metric system as their official system of weights and measures.
The US is the only industrialized nation that does not mainly use the metric system in its commercial and standards activities.
:ent.
:p.
The units are classified into Base units, Supplementary units and Derived units&colon.
:dl compact tsize=40.
:dt.:hp2.The Base units of the SI:ehp2.
:dt.:hp5.Physical quantity:ehp5.
:dd.:hp5.Unit [symbol]:ehp5.
:dt.length
:dd.metre  [m]
:dt.time
:dd.second [s]
:dt.mass
:dd.kilogram [kg]
:dt.electric current
:dd.ampere [A]
:dt.thermodynamic temperature
:dd.kelvin [K]
:dt.luminous intensity
:dd.candela [cd]
:dt.amount of substance
:dd.mole [mol]
.br
:dt.:hp2.The Supplementary units of the SI:ehp2.
:dt.:hp5.Physical quantity:ehp5.
:dd.:hp5.Unit [symbol]:ehp5.
:dt.plane angle
:dd.radian [rad]
:dt.solid angle
:dd.steradian [sr]
.br
:dt.:hp2.The Derived units of the SI:ehp2.
:dt.:hp5.Physical quantity:ehp5.
:dd.:hp5.Unit [symbol]:ehp5.
:dt.frequency
:dd.hertz [Hz]
:dt.force, weight
:dd.newton [N]
:dt.work, energy, quantity of heat
:dd.joule [J]
:dt.pressure, stress
:dd.pascal [Pa]
:dt.power
:dd.watt [W]
:dt.electric charge
:dd.coulomb [C]
:dt.electric potential difference
:dd.volt [V]
:dt.electric capacitance
:dd.farad [F]
:dt.electric resistance, reactance
:dd.ohm [Omega]
:dt.electric conductance
:dd.siemens [S]
:dt.magnetic flux
:dd.weber [Wb]
:dt.magnetic induction
:dd.tesla [T]
:dt.inductance
:dd.henry [H]
:dt.luminous flux
:dd.lumen [lm]
:dt.illuminance
:dd.lux [lx]
:dt.absorbed dose
:dd.gray [Gy]
:dt.activity
:dd.becquerel [Bq]
:dt.dose equivalent
:dd.sievert [Sv]
:dt.area
:dd.square metre [m&sup2.]
:dt.volume
:dd.cubic metre [m3]
:dt.speed, velocity
:dd.metre per second [m/s]
:dt.acceleration
:dd.metre per second squared [m/s&sup2.]
:dt.angular velocity
:dd.radian per second [rad/s]
:dt.angular acceleration
:dd.radian per second squared [rad/s&sup2.]
:dt.density
:dd.kilogram per cubic metre [kg/m3]
:dt.moment of force
:dd.newton metre [N.m]
:dt.electric field strength
:dd.volt per metre [V/m]
:dt.permeability
:dd.henry per metre [H/m]
:dt.permittivity
:dd.farad per metre [F/m]
:dt.specific heat capacity
:dd.joule per kilogram kelvin [J/(kg.K)]
:dt.luminance
:dd.candela per square metre [cd/m&sup2.]
.br
:dt.:hp2.Units that may be used with the SI:ehp2.
:dt.:hp5.Physical quantity:ehp5.
:dd.:hp5.Unit [symbol]:ehp5.
:dt.time
:dd.minute [min]
.br
hour [h]
.br
day [d]
:dt.plane angle
:dd.degree [&deg.]
:dt.mass
:dd.metric tonne [t]
:dt.volume
:dd.litre [l or L]
:dt.energy
:dd.electron volt [eV]
:dt.speed
:dd.kilometre per hour [km/h]
:dt.area
:dd.hectare [ha]
:dt.rotational frequency
:dd.revolution per minute  [r/min]
:edl.

.*
.* Panel definition : Prefixes
.*
:h1 id=700  res=700 x=0% y=0% width=100% height=100%  group=1.Prefixes
:i1 id=700.Prefixes
:p.
20 SI prefixes are used to form decimal multiples and submultiples of :link reftype=hd res=600.SI units:elink..
Nearly all of the SI prefixes are multiples or sub-multiples of 1000.
However, these are inconvenient for many purposes and so hecto, deca, deci and centi are also used.

:table cols='25 25' rules=both frame=box.
:row.
:c.
Symbol  Prefix   Factor
:c.
Symbol  Prefix   Factor
:row.
:c.
:lines.
da      deca     10&and.1
h       hecto    10&and.2
k       kilo     10&and.3
M       mega     10&and.6
G       giga     10&and.9
T       tera     10&and.12
P       peta     10&and.15
E       exa      10&and.18
Z       zetta    10&and.21
Y       yotta    10&and.24
:elines.
:c.
:lines.
d       deci     10&and.-1
c       centi    10&and.-2
m       mili     10&and.-3
       micro    10&and.-6
n       nano     10&and.-9
p       pico     10&and.-12
f       femto    10&and.-15
a       atto     10&and.-18
z       zepto    10&and.-21
y       yocto    10&and.-24
:elines.
:etable.

In computing, using the metric prefixes specify powers of 2.
For example, a kilobit is usually 2&and.10 = 1024 bits instead of 1000 bits.
This leads to considerable confusion, and in 1998 the International Electrotechnical Commission approved new prefixes for the powers of 2&colon.

:table cols='51' rules=both frame=box.
:row.
:c.
Symbol  Prefix   Factor                     Value
:row.
:c.
:lines.
Ki      kibi     2&and.10                       1 024
Mi      mebi     2&and.20                   1 048 576
Gi      gibi     2&and.30               1 073 741 824
Ti      tebi     2&and.40           1 099 511 627 776
Pi      pebi     2&and.50       1 125 899 906 842 624
Ei      exbi     2&and.60   1 152 921 504 606 846 976
:elines.
:etable.

The metric prefixes should be used in computing just as they are used in other fields&colon.
.br
1 gigabyte (GB) should mean exactly 1 000 000 000 bytes, and 1 gibibyte (GiB) should mean exactly 1 073 741 824 bytes.

.*
.* Panel definition for:Translation tool
.*
:h1 id=750 res=750 x=left y=bottom width=100% height=100% group=2.Translation tool
:i1 id=750.
Translation tool
:p.
Language support for &greename. (buttons text, messages, frames text ...) is stored in Language INI files (ENGLISH.INI, CROATIAN.INI,etc.)
and source of help file (this file - English.inf) is file English.ipf.
.br
If you want to add your Language support :link refid=author reftype=fn. visit my site:elink.
and download Translation tool (translat.zip).
:p.
:hp2.
To create new Language INI file&colon.
:ehp2.
:ol compact.
:li.
Select source language (one of languages in the list).
:li.
Press :hp9.New language!:ehp9. button, to create new language file. SOURCE LANGUAGE will be copied to new language file.
:li.
Enter language name, comment, your name and email adress (REQUIRED!). Then press :hp9.OK - start translation:ehp9. button.
:li.
Sections (pages in Notebook) are: Menu, Hint, Message, Button, Frame and Help. Overwrite text with your text.
:li.
When finished, select your language in program and try it.
:eol.
:p.
:hp2.
To change existing Language INI file&colon.
:ehp2.
:ol compact.
:li.
Select your language (as source language and your language).
:li.
Change comment, your name and email adress if you want, then press :hp9.OK - start translation:ehp9. button.
:li.
Sections (pages in Notebook) are: Menu, Hint, Message, Button, Frame and Help. Overwrite existing text with your text - press :hp9.Write changes:ehp9. button after EVERY CHANGE.
:li.
When finished, select your language in &greename. and check changes.
:eol.
:p.
:hp2.
Important!
:ehp2.
:p.
Press :hp9.Write changes:ehp9. button after EVERY CHANGE to save changes. If you don't press this button and go to next item, changes WILL BE LOST!
:p.
When you create new Language INI file, program will write new Key to file CONVERT.INI, Application Language, where&colon.
.br
- Key name is name of new language
.br
- Key value is "English.inf" - it is default help file for &greename..
:p.
In section (Page) Help are stored titles of topics in English.inf and they are used as parameter when you press :hp9.Help:ehp9. button in &greename..
You should translate this section only if you want to
:link reftype=hd res=751.
translate source help file (English.ipf).
:elink.
Then items in Help section should be identical as translated titles in new IPF/INF file.
:nt.
After you added new Language support to &greename., I would appreciate if you send me new INI file,
so I can include this file in next version of &greename..
:ent.

.*
.* Panel definition for:Translate help file
.*
:h1 id=751 res=751 x=left y=bottom width=100% height=100% group=2.Translate help file
:i1 id=751.
Translate help file
:p.
:hp2.
To translate help file you need IPF compiler.
:ehp2.
:p.
If you want to translate English.ipf to your language, after you finished translation,
 make changes in Application "Language" in file CONVERT.INI.
:parml compact tsize=5.
:pt.
For example&colon.
:pd.
when you translated ENGLISH to MYLANG (where MYLANG is your Language), MYLANG.INI file is created.
When you translated English.ipf to Mylang.ipf and compile Mylang.ipf, Mylang.inf file is created.
.br
Edit in CONVERT.INI&colon.
.br
change in Application Language, Key MYLANG, Value English.inf to Mylang.inf.
:eparml.
:p.
Be sure you also translated Help section in MYLANG.INI.
In section (Page) Help are stored titles of topics help and they are used as parameter when you press :hp9.Help:ehp9. button in &greename..
Translate this section only when you translated source help file (English.ipf).
:nt.
After you translated help file, I would appreciate if you send me new IPF/INF file,
so I can include this file in next version of &greename..
:ent.

.*
.* Panel definition : Copyright and contact
.*
:h1 id=900 res=900  x=0% y=0% width=100% height=100%  group=1.Copyright and contact
:i1 id=900.Copyright and contact
:dl compact tsize=15.
:dthd.:hp2.Author:ehp2.
:ddhd.Goran Ivankovic
:dt.:hp2.Address:ehp2.
:dd.Ulica Josipa Poduje 8
:dt.
:dd.HR-52100 Pula
:dt.
:dd.Croatia
:dt.:hp2.email:ehp2.
:dd.:link reftype=launch object='netscape.exe' data='mailto:duga1@pu.hinet.hr?subject=Unit Converter 0.96'.duga1@pu.hinet.hr:elink.
:dt.:hp2.Home page:ehp2.
:dd.:link reftype=launch object='Netscape.exe' data='http://redrival.com/os2util/'.http&colon.//redrival.com/os2util/:elink.
:edl.
:p.
&greename. is free software but it is :hp2.not:ehp2. public domain.
The author retains all copyright to the application and all files within it.
:p.
You may use &greename. yourself and you may distribute it to others
so long as all files are left unchanged. You may not distribute &greename.
in any way which leads to your making a profit from it. This means that you can
only charge enough to cover the costs of media, postage etc. involved in distribution.
Also you may not use it as an incentive to buy something else. If you are in any
doubt you should contact the author.
:p.
The author's permission must be obtained before &greename. is included
on a magazine disc and P.D. libraries. You should, as a matter of courtesy,
inform the author when you are planning to distribute the application and
send one copy of magazine disc to the author.
:p.
The author makes no representations about the accuracy or suitability of
this material for any purpose. It is provided "as is", without any
express or implied warranties. The author will assume no liability for
damages either from the direct use of this product or as a consequence of
the use of this product.
:parml tsize=5.
:pt.:hp2.Thanks to all users for ideas, comments, corrections, suggestions and bug reports.:ehp2.
:pt.:hp7.Special thanks to&colon.:ehp7.
:dl compact tsize=25.
:dt.Klaus Staedtler
:dd.translated Unit Converter to German, created bitmaps, idea, support and nice icons
:dt.Bjrn Sderstrm
:dd.translated Unit Converter to Swedish
:dt.Guillaume Gay
:dd.translated Unit Converter to French
:dt.Javier Arias Fern&aa.ndez
:dd.translated Unit Converter to Spanish
:dt.Brian Crook
:dd.tested Unit Converter
:dt.Steven Levine
:dd.tested Unit Converter
:dt.Przemysaw Paweczyk
:dd.tested Unit Converter
:edl.
:eparml.
:ul compact.
:li.OS/2 is a Trademark of International Business Machines Corporation
:li.DrDialog is Copyright of International Bussines Machines Corporation
:li.FastIni.dll is Copyright of Dennis Bareis - OS/2 Developer in Australia
:eul.

.*
.*FootnotesHere

:fn id=author.
:dl compact tsize=15.
:dthd.:hp2.Author:ehp2.
:ddhd.Goran Ivankovic
:dt.:hp2.Address:ehp2.
:dd.Ulica Josipa Poduje 8
:dt.
:dd.HR-52100 Pula
:dt.
:dd.Croatia
:dt.:hp2.email:ehp2.
:dd.:link reftype=launch object='Netscape.exe' data='mailto:duga1@pu.hinet.hr?subject=Unit Converter 0.96'.duga1@pu.hinet.hr:elink.
:dt.:hp2.Home page:ehp2.
:dd.:link reftype=launch object='Netscape.exe' data='http://redrival.com/os2util/'.http&colon.//redrival.com/os2util/:elink.
:edl.
:efn.

:euserdoc.
