/* OS/2-REXX-Program clc.CMD, 05.12.1996   */
   "@ echo off"
   /* These high accuracy at this place is necessary     */
   /* to inspect some partial strings for formal errors. */
   numeric digits 100
   ND=20
   parse arg str
   str=strip(str)

   if (length(str)= 0) then
   do
     "view.exe clc.inf"
     SIGNAL ende
   end
   ww=word(str, 1)
   l1=length(ww)
   lk=Pos(",", ww)
   p1=wordpos(" , ", str)

   if l1 <> lk then
   do
     if p1 = 0 then
     do
       Call kommav
       SIGNAL ende
     end
   end

   parse value str with ND ',' t1 op12 t2 op23

   if length(ND) = 0 then ND = 20
   numeric digits ND

   if length(op23) <> 0 then
   do
     Call anz1 op23
     SIGNAL ende
   end

   if length(t1) = 0 | length(op12) = 0 | length(t2) = 0 then
   do
     Call unvoll
     SIGNAL ende
   end

   if op12='**' & Datatype(t2, N) <> 1 then
   do
     Call expNoRexx t2
     SIGNAL ende
   end

   if op12="**" & Datatype(t2, W) <> 1  then
   do
     Call expNoInt t2
     SIGNAL ende
   end

   select
     when op12='+'  then do;  Signal we; end
     when op12='-'  then do;  Signal we; end
     when op12='*'  then do;  Signal we; end
     when op12='/'  then do;  Signal we; end
     when op12=':'       then do; op12 = '/';  Signal we; end
     when op12='divint'  then do; op12 = '%';  Signal we; end
     when op12='divrest' then do; op12 = "//"; Signal we; end
     when op12='**' then do;  Signal we; end
     otherwise
     do
       Call falschop op12
       SIGNAL ende
     end
   end

we:
   if datatype(t1, N) <> 1 then
   do
     Call anzt1 t1
     SIGNAL ende
   end

   if datatype(t2, N) <> 1 then
   do
     Call anzt2 t2
     SIGNAL ende
   end

   select
     when op12="+"  then do; z=t1+t2;  signal wew; end
     when op12="-"  then do; z=t1-t2;  signal wew; end
     when op12="*"  then do; z=t1*t2;  signal wew; end
     when op12="/"  then do; z=t1/t2;  signal wew; end
     when op12="%"  then do; z=t1%t2;  signal wew; end
     when op12="//" then do; z=t1//t2; signal wew; end
     otherwise NOP
   end

   if op12="**" then
   do
     if t2 < 1.0E9 then
     do
       z=t1**t2
       signal wew
     end
     else
       Call expZuGross t2
       SIGNAL ende
     end
   end

wew:
   str=t1||" "||op12||" "||t2

   say
   Call CsrAttrib "High";   Call Color "white"
   Call Charout,"The programm internal calculates with an accuracy of  "
   Call Color "yellow"
   Call Charout,ND
   Call Color "white"
   Call Charout,"  decimal digits.";say; say
   Call Color "yellow"
   Call Charout,str; say; say
   Call Color "white"
   Call Charout," = "
   Call Color "green"
   Call Charout,z; say
   Call CsrAttrib "Normal"

ende:
EXIT

anzt1:
  say
  parse arg t1
  Call CsrAttrib "High";   Call Color "white"
  Call Charout,"          "
  Call Charout,t1
  Call Color "yellow"
  Call Charout," is not a valid REXX-number !"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

anzt2:
  say
  Call CsrAttrib "High";   Call Color "white"
  Call Charout,"          "
  Call Charout,t2
  Call Color "yellow"
  Call Charout," is not a valid REXX-number !"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

anz1:
  say
  parse arg op23
  Call CsrAttrib "High";   Call Color "Yellow"
  Call Charout,"The character (or the string)  "
  Call Color "white"
  Call Charout,op23; say
  Call Color "yellow"
  Call Charout,"at the end of the command line string is superflous !"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

falschop:
  say
  parse arg op12
  Call CsrAttrib "High";   Call Color "Yellow"
  Call Charout,"The character (or the string)  "
  Call Color "white"
  Call Charout,op12; say
  Call Color "yellow"
  Call Charout,"is "
  Call Color "cyan"
  Call Charout,"no one"
  Call Color "yellow"
  Call Charout," of the mathematical operators"; say
  Call Color "white"
  Call Charout,"+"
  Call Color "yellow"
  Call Charout,", "
  Call Color "white"
  Call Charout,"-"
  Call Color "yellow"
  Call Charout,", "
  Call Color "white"
  Call Charout,"*"
  Call Color "yellow"
  Call Charout,", "
  Call Color "white"
  Call Charout,":"
  Call Color "yellow"
  Call Charout," (or "
  Call Color "white"
  Call Charout,"/"
  Call Color "yellow"
  Call Charout,"), "
  Call Color "white"
  Call Charout,"divint"
  Call Color "yellow"
  Call Charout," (internal: %) or "
  Call Color "white"
  Call Charout,"divrest "
  Call Color "yellow"
  Call Charout,"(internal: //) !"; say; say;
  Call Charout,"Look for this in the "
  Call Color "white"
  Call Charout,"clc.INF"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

unvoll:
  say
  Call CsrAttrib "High";   Call Color "yellow"
  Call Charout,"The command line string in not complete"; say
  Call Charout,"or you have forgotten some indispensable necessary blanks !"; say; say
  Call Charout,"Or is it possible that by mistake you have typed"; say
  Call Charout,"the internal operator  "
  Call Color "white"
  Call Charout,"%"
  Call Color "yellow"
  Call Charout,"   instead of the external operator  "
  Call Color "white"
  Call Charout,"divint"
  Call Color "yellow"
  Call Charout,"  or";say
  Call Charout,"the internal operator  "
  Call Color "white"
  Call Charout,"//"
  Call Color "yellow"
  Call Charout,"  instead of the external operator  "
  Call Color "white"
  Call Charout,"divrest"
  Call Color "yellow"
  Call Charout,"  ?"; say;say
  Call Charout,"Look for this in the "
  Call Color "white"
  Call Charout,"clc.INF"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

kommav:
  say
  Call CsrAttrib "High";   Call Color "yellow"
  Call Charout,"The command line string"; say
  Call Charout,"must include at least  "
  Call Color "green"
  Call Charout,"1"
  Call Color "yellow"
  Call Charout,"  blank after the string  "
  Call Color "cyan"
  Call Charout,"clc"
  Call Color "yellow"
  Call Charout,"."; say
  Call Charout,"After that, before typing the actual arithmetical problem, you must type"; say
  Call Charout,"either";say
  Call Charout,"        a "
  Call Color "white"
  Call Charout,"single comma"
  Call Color "yellow"
  Call Charout," with at least  "
  Call Color "green"
  Call Charout,"1"
  Call Color "yellow"
  Call Charout,"  blank after it"; say
  Call Charout,"or";say
  Call Charout,"        a "
  Call Color "white"
  Call Charout,"whole number > 1"
  Call Color "yellow"
  Call Charout,", followed by"; say
  Call Charout,"        a "
  Call Color "white"
  Call Charout,"single comma"
  Call Color "yellow"
  Call Charout," with at least  "
  Call Color "green"
  Call Charout,"1"
  Call Color "yellow"
  Call Charout,"  blank after it."; say; say
  Call Charout,"Look for this in the "
  Call Color "white"
  Call Charout,"clc.INF"
  Call Color "yellow"
  Call Charout,"."
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

expNoInt:
  say
  parse arg t2
  Call CsrAttrib "High";   Call Color "yellow"
  Call Charout,"The exponent "
  Call Color "white"
  Call Charout,t2
  Call Color "yellow"
  Call Charout," is not a whole number !"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

expNoRexx:
  say
  parse arg t2
  Call CsrAttrib "High";   Call Color "yellow"
  Call Charout,"The exponent "
  Call Color "white"
  Call Charout,t2
  Call Color "yellow"
  Call Charout," is not a valid  REXX-number !"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

expZuGross:
  say
  parse arg t2
  Call CsrAttrib "High";   Call Color "yellow"
  Call Charout,"The exponent "
  Call Color "white"
  Call Charout,t2
  Call Color "yellow"
  Call Charout," must be smaller than "
  Call Color "white"
  Call Charout,"1.0E+9"
  Call Color "yellow"
  Call Charout," !"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return


Color: Procedure /* Call Color <ForeGround>,<BackGround> */
arg F,B
Colors = "BLACK RED GREEN YELLOW BLUE MAGENTA CYAN WHITE"
return CHAROUT(,D2C(27)"["WORDPOS(F,COLORS)+29";"WORDPOS(B,COLORS)+39";m")

CsrAttrib: Procedure  /* call CsrAttrib <Attrib> */
Arg A
attr = "NORMAL HIGH LOW ITALIC UNDERLINE BLINK RAPID REVERSE"
return CHAROUT(,D2C(27)"["WORDPOS(A,ATTR) - 1";m")

EndAll:
Call Color "White","Black"
CALL CsrAttrib "Normal"

