/*
 * Decompiled with CFR 0.152.
 */
package au.com.imagingassociates.lib.gui;

import au.com.imagingassociates.lib.gui.AbstractTrackableJFrame;
import au.com.imagingassociates.lib.gui.FramePlacer;
import au.com.imagingassociates.lib.gui.FrameSizer;
import au.com.imagingassociates.lib.gui.FrameTrackerJMenu;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HtmlJFrame
extends AbstractTrackableJFrame
implements HyperlinkListener {
    public final int widthN;
    public final int widthD;
    public final int heightN;
    public final int heightD;
    public final JEditorPane editorPane;
    public final URL defaultResource;
    public final URL styleSheetResource;

    public HtmlJFrame() {
        super(null, false, null, null);
        this.widthN = 0;
        this.widthD = 0;
        this.heightN = 0;
        this.heightD = 0;
        this.editorPane = null;
        this.defaultResource = null;
        this.styleSheetResource = null;
    }

    public HtmlJFrame(FrameTrackerJMenu frameTrackerJMenu, boolean bl, String string, String string2, URL uRL, URL uRL2, int n2, int n3, int n4, int n5) {
        super(frameTrackerJMenu, bl, string, string2);
        Serializable serializable;
        this.defaultResource = uRL;
        this.styleSheetResource = uRL2;
        this.widthN = n2;
        this.widthD = n3;
        this.heightN = n4;
        this.heightD = n5;
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        this.editorPane.setFont(new Font("SansSerif", 0, 20));
        this.editorPane.addHyperlinkListener(this);
        if (this.styleSheetResource != null) {
            serializable = new StyleSheet();
            ((StyleSheet)serializable).importStyleSheet(this.styleSheetResource);
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.editorPane.getEditorKitForContentType("text/html");
            hTMLEditorKit.setStyleSheet((StyleSheet)serializable);
            this.editorPane.setEditorKit(hTMLEditorKit);
        }
        serializable = new JScrollPane(this.editorPane);
        ((JScrollPane)serializable).setVerticalScrollBarPolicy(22);
        ((JScrollPane)serializable).setHorizontalScrollBarPolicy(32);
        this.getContentPane().add((Component)serializable);
    }

    public void showWithDefaults() {
        try {
            this.editorPane.setPage(this.defaultResource);
        }
        catch (IOException iOException) {
            this.editorPane.setContentType("text/html");
            this.editorPane.setText("<html><body><center><p>Unable to load HTML Page.</p>" + iOException.toString() + "</center></body></html>");
            iOException.printStackTrace();
        }
        FrameSizer.setSize(this, this.widthN, this.widthD, this.heightN, this.heightD);
        FramePlacer.toMidUpperFrontCenter(this, true);
    }

    public void setPage(URL uRL) throws IOException {
        this.editorPane.setPage(uRL);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                URL uRL = hyperlinkEvent.getURL();
                this.editorPane.setPage(uRL);
                return;
            }
            catch (Exception exception) {
                this.editorPane.setText(exception.toString());
                exception.printStackTrace();
            }
        }
    }
}

