/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketException;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHPdu;
import mindbright.ssh.SSHPduOutputStream;
import mindbright.ssh.SSHPduQueue;
import mindbright.ssh.SSHSocketImpl;
import mindbright.ssh.SSHTunnel;

public final class SSHSocketTunnel
extends SSHTunnel {
    Object lock = new Object();
    boolean inputClosePending = false;
    boolean inputExplicitClosed = false;
    boolean outputClosed = false;
    boolean terminated = false;
    boolean openFail = false;
    protected SSHPdu rest;
    protected SSHSocketIS in;
    protected SSHSocketOS out;
    protected InetAddress localAddress;
    protected SSHSocketImpl impl;

    public SSHSocketTunnel(SSHChannelController sSHChannelController, SSHSocketImpl sSHSocketImpl) throws IOException {
        super(null, sSHChannelController.newChannelId(), -4, sSHChannelController);
        this.txQueue = new SSHPduQueue();
        this.in = new SSHSocketIS(this);
        this.out = new SSHSocketOS(this);
        this.impl = sSHSocketImpl;
    }

    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public void openFailure() {
        this.openFail = true;
        this.start();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        SSHPdu sSHPdu = null;
        SSHSocketTunnel sSHSocketTunnel = this;
        synchronized (sSHSocketTunnel) {
            if (this.inputExplicitClosed) {
                throw new SocketException("Socket closed");
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.rest != null) {
                sSHPdu = this.rest;
                this.rest = null;
            } else {
                sSHPdu = this.inputClosePending && this.txQueue.isEmpty() ? null : this.txQueue.getFirst();
            }
            if (sSHPdu == null) {
                int n4 = -1;
                return n4;
            }
            int n5 = sSHPdu.rawSize();
            if (n2 < n5) {
                this.rest = sSHPdu;
                n3 = n2;
            } else {
                n3 = n5;
            }
            System.arraycopy(sSHPdu.rawData(), sSHPdu.rawOffset(), byArray, n, n3);
            if (this.rest != null) {
                this.rest.rawAdjustSize(n5 - n2);
            }
        }
        return n3;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        SSHSocketTunnel sSHSocketTunnel = this;
        synchronized (sSHSocketTunnel) {
            if (this.outputClosed) {
                throw new IOException("Resource temporarily unavailable");
            }
        }
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(23, this.controller.sndCipher);
        sSHPduOutputStream = (SSHPduOutputStream)this.prepare(sSHPduOutputStream);
        sSHPduOutputStream.writeInt(n2);
        sSHPduOutputStream.write(byArray, n, n2);
        this.controller.transmit(sSHPduOutputStream);
    }

    public void connect(String string, int n) throws IOException {
        this.setRemoteDesc(string + ":" + n);
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(29, this.controller.sndCipher);
        this.controller.addTunnel(this);
        sSHPduOutputStream.writeInt(this.channelId);
        sSHPduOutputStream.writeString(string);
        sSHPduOutputStream.writeInt(n);
        sSHPduOutputStream.writeString(this.localAddress.getHostAddress());
        this.controller.transmit(sSHPduOutputStream);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.openFail) {
            throw new ConnectException("Connection Refused");
        }
    }

    public void close() throws IOException {
        this.closein(true);
        this.closeout();
    }

    public synchronized void closeout() {
        this.outputClosed = true;
        this.sendInputEOF();
    }

    public void closein(boolean bl) {
        this.txQueue.release();
        SSHSocketTunnel sSHSocketTunnel = this;
        synchronized (sSHSocketTunnel) {
            this.inputClosePending = true;
            this.inputExplicitClosed = bl;
            this.sendOutputClosed();
        }
    }

    public int available() throws IOException {
        if (this.rest != null) {
            return this.rest.rawSize();
        }
        return 0;
    }

    protected void setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
    }

    public synchronized void checkTermination() {
        if (this.sentInputEOF && this.sentOutputClosed && this.receivedInputEOF && this.receivedOutputClosed) {
            this.terminated = true;
            this.controller.delTunnel(this.channelId);
            this.impl.factory.closePseudoUser(this.controller.sshAsClient(), this.impl);
        }
    }

    public synchronized boolean terminated() {
        return this.terminated;
    }

    public void receiveOutputClosed() {
        super.receiveOutputClosed();
        this.closeout();
    }

    public void receiveInputEOF() {
        this.receivedInputEOF = true;
        this.closein(false);
        this.closeout();
        this.checkTermination();
    }

    public static final class SSHSocketOS
    extends OutputStream {
        protected SSHSocketTunnel tunnel;

        protected SSHSocketOS(SSHSocketTunnel sSHSocketTunnel) {
            this.tunnel = sSHSocketTunnel;
        }

        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            this.tunnel.write(byArray, 0, 1);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.tunnel.write(byArray, n, n2);
        }

        public void close() throws IOException {
            this.tunnel.closeout();
        }
    }

    public static final class SSHSocketIS
    extends InputStream {
        protected SSHSocketTunnel tunnel;

        protected SSHSocketIS(SSHSocketTunnel sSHSocketTunnel) {
            this.tunnel = sSHSocketTunnel;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == -1) {
                return -1;
            }
            return byArray[0];
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.tunnel.read(byArray, n, n2);
        }

        public void close() throws IOException {
            this.tunnel.closein(true);
        }
    }
}

