/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import mindbright.ssh.SSH;
import mindbright.ssh.SSHChannelListener;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public abstract class SSHChannel
implements Runnable {
    protected int channelId;
    protected SSHChannelListener listener;
    private Thread thread;

    public SSHChannel(int n) {
        try {
            PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
            PrivilegeManager.enablePrivilege("UniversalThreadAccess");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            // empty catch block
        }
        this.thread = new Thread(SSH.getThreadGroup(), this, SSH.createThreadName());
        this.channelId = n;
        this.listener = null;
    }

    public void setSSHChannelListener(SSHChannelListener sSHChannelListener) {
        this.listener = sSHChannelListener;
    }

    public int getId() {
        return this.channelId;
    }

    public abstract void serviceLoop() throws Exception;

    public void close() {
    }

    public void run() {
        try {
            PrivilegeManager.enablePrivilege("TerminalEmulator");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            // empty catch block
        }
        try {
            this.serviceLoop();
        }
        catch (Exception exception) {
            if (SSH.DEBUGMORE) {
                System.out.println("--- channel exit (exception is not an error):");
                exception.printStackTrace();
                System.out.println("---");
            }
            this.close();
            if (this.listener != null) {
                this.listener.close(this);
            }
        }
        catch (ThreadDeath threadDeath) {
            SSH.logExtra("Channel killed " + this.channelId);
            throw threadDeath;
        }
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        this.thread.stop();
    }

    public void join(long l) throws InterruptedException {
        this.thread.join(l);
    }

    public boolean isAlive() {
        return this.thread.isAlive();
    }
}

