/*
 * Decompiled with CFR 0.152.
 */
package mindbright.application;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.ConnectException;
import mindbright.ssh.SSH;
import mindbright.vnc.DesCipher;
import mindbright.vnc.authenticationPanel;
import mindbright.vnc.clipboardFrame;
import mindbright.vnc.optionsFrame;
import mindbright.vnc.rfbProto;
import mindbright.vnc.vncCanvas;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public class MindVNC
extends Applet
implements Runnable {
    boolean inAnApplet = true;
    boolean separateFrame;
    Container cont;
    Frame f;
    String[] mainArgs;
    String sshHost;
    int sshPort;
    String vncHost;
    int vncPort;
    String sshUser;
    String sshPasswd;
    ScrollPane sp;
    vncCanvas vc;
    public rfbProto rfb;
    Thread rfbThread;
    GridBagLayout gridbag;
    Panel buttonPanel;
    Button disconnectButton;
    Button optionsButton;
    Button clipboardButton;
    Button ctrlAltDelButton;
    authenticationPanel authenticator;
    public optionsFrame options;
    public clipboardFrame clipboard;
    public boolean gotFocus = false;

    public static void main(String[] stringArray) {
        MindVNC mindVNC = new MindVNC();
        mindVNC.mainArgs = stringArray;
        mindVNC.inAnApplet = false;
        mindVNC.f = new Frame("MindVNC v0.1");
        mindVNC.f.add("Center", mindVNC);
        mindVNC.init();
        mindVNC.start();
    }

    public void init() {
        this.readParameters();
        if (this.inAnApplet && this.separateFrame) {
            this.f = new Frame("MindVNC v0.1");
            this.cont = this.f;
        } else {
            this.cont = this;
        }
        if (this.f != null) {
            this.f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MindVNC.this.f.dispose();
                    MindVNC.this.rfbThread.stop();
                    if (!MindVNC.this.inAnApplet) {
                        System.exit(1);
                    }
                }
            });
        }
        this.options = new optionsFrame(this);
        this.clipboard = new clipboardFrame(this);
        this.authenticator = new authenticationPanel();
        try {
            PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
            PrivilegeManager.enablePrivilege("UniversalThreadAccess");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            // empty catch block
        }
        this.rfbThread = new Thread(SSH.getThreadGroup(), this);
        this.rfbThread.start();
    }

    public void update(Graphics graphics) {
    }

    public void run() {
        this.gridbag = new GridBagLayout();
        this.cont.setLayout(this.gridbag);
        this.buttonPanel = new Panel();
        this.buttonPanel.setLayout(new FlowLayout(0, 0, 0));
        this.disconnectButton = new Button("Disconnect");
        this.buttonPanel.add(this.disconnectButton);
        this.optionsButton = new Button("Options");
        this.buttonPanel.add(this.optionsButton);
        this.clipboardButton = new Button("Clipboard");
        this.buttonPanel.add(this.clipboardButton);
        this.ctrlAltDelButton = new Button("Send Ctrl-Alt-Del");
        this.buttonPanel.add(this.ctrlAltDelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.gridbag.setConstraints(this.buttonPanel, gridBagConstraints);
        this.cont.add(this.buttonPanel);
        this.disconnectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MindVNC.this.buttonPressed(0);
            }
        });
        this.optionsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MindVNC.this.buttonPressed(1);
            }
        });
        this.clipboardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MindVNC.this.buttonPressed(2);
            }
        });
        this.ctrlAltDelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MindVNC.this.buttonPressed(3);
            }
        });
        while (true) {
            this.disconnectButton.disable();
            this.clipboardButton.disable();
            this.ctrlAltDelButton.disable();
            try {
                this.connectAndAuthenticate();
                this.rfb.doProtocolInitialisation(this.options.encodings, this.options.nEncodings);
                this.vc = new vncCanvas(this);
                this.sp = new ScrollPane(0);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                this.gridbag.setConstraints(this.sp, gridBagConstraints);
                this.cont.add(this.sp);
                if (this.f != null) {
                    int n = this.sp.getVScrollbarWidth();
                    int n2 = this.sp.getHScrollbarHeight();
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    Insets insets = this.f.getInsets();
                    dimension.width -= insets.left + insets.right + n;
                    dimension.height -= insets.top + insets.bottom + n2;
                    int n3 = dimension.width > this.rfb.framebufferWidth + 4 ? this.rfb.framebufferWidth + 4 : dimension.width;
                    int n4 = dimension.height > this.rfb.framebufferHeight + 4 ? this.rfb.framebufferHeight + 4 : dimension.height;
                    this.sp.setSize(new Dimension(n3, n4));
                } else {
                    this.sp.setSize(this.getSize());
                }
                this.sp.add(this.vc);
                if (this.f != null) {
                    this.f.setTitle(this.rfb.desktopName);
                    this.f.pack();
                } else {
                    this.validate();
                }
                this.disconnectButton.enable();
                this.clipboardButton.enable();
                this.ctrlAltDelButton.enable();
                this.vc.processNormalProtocol();
                this.cont.remove(this.sp);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.fatalError(exception.toString());
                continue;
            }
            break;
        }
    }

    void connectAndAuthenticate() throws IOException {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 50;
        this.gridbag.setConstraints(this.authenticator, gridBagConstraints);
        this.cont.add(this.authenticator);
        this.validate();
        if (this.f != null) {
            this.f.pack();
            this.f.show();
        }
        boolean bl = false;
        while (!bl) {
            authenticationPanel authenticationPanel2 = this.authenticator;
            synchronized (authenticationPanel2) {
                try {
                    this.authenticator.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.sshUser = this.authenticator.sshUser.getText();
            this.sshPasswd = this.authenticator.sshPassword.getText();
            this.vncHost = this.authenticator.vncHost.getText();
            this.vncPort = 5900;
            int n = this.vncHost.indexOf(58);
            if (n != -1) {
                try {
                    this.vncPort += Integer.parseInt(this.vncHost.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    this.authenticator.retry("VNC host-string format error");
                    continue;
                }
                this.vncHost = this.vncHost.substring(0, n);
            }
            try {
                this.rfb = new rfbProto(this.sshHost, this.sshPort, this.sshUser, this.sshPasswd, this.vncHost, this.vncPort, this);
            }
            catch (ConnectException connectException) {
                System.out.println("Connect...");
                this.authenticator.retry("VNC host, connection refused");
                continue;
            }
            catch (IOException iOException) {
                System.out.println("IO...");
                this.authenticator.retry("SSH error: " + iOException.getMessage());
                continue;
            }
            if (this.rfb.connectAndAuthenticate(this.authenticator)) break;
        }
        this.cont.remove(this.authenticator);
    }

    int getInt(byte[] byArray, int n) {
        int n2 = (byArray[n + 0] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        return n2;
    }

    void putInt(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >>> 24);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 3] = (byte)n2;
    }

    public void setCutText(String string) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.rfb.close();
                this.rfb = null;
                break;
            }
            case 1: {
                if (this.options.isVisible()) {
                    this.options.hide();
                    break;
                }
                this.options.show();
                break;
            }
            case 2: {
                if (this.clipboard.isVisible()) {
                    this.clipboard.hide();
                    break;
                }
                this.clipboard.show();
                break;
            }
            case 3: {
                this.rfb.sendCtrlAltDel();
            }
        }
    }

    public boolean gotFocus(Event event, Object object) {
        this.gotFocus = true;
        return true;
    }

    public boolean lostFocus(Event event, Object object) {
        this.gotFocus = false;
        return true;
    }

    void encryptBytes(byte[] byArray, String string) {
        byte[] byArray2 = new byte[8];
        string.getBytes(0, string.length(), byArray2, 0);
        int n = string.length();
        while (n < 8) {
            byArray2[n] = 0;
            ++n;
        }
        DesCipher desCipher = new DesCipher(byArray2);
        desCipher.encrypt(byArray, 0, byArray, 0);
        desCipher.encrypt(byArray, 8, byArray, 8);
    }

    public void readParameters() {
        String string;
        this.sshHost = this.readParameter("sshhost", !this.inAnApplet);
        if (this.sshHost == null) {
            this.sshHost = this.getCodeBase().getHost();
            if (this.sshHost.equals("")) {
                this.fatalError("Not able to determine sshhost");
            }
        }
        this.sshPort = (string = this.readParameter("sshport", false)) != null ? Integer.parseInt(string) : 22;
        try {
            this.separateFrame = new Boolean(this.getParameter("sepframe"));
        }
        catch (Exception exception) {
            this.separateFrame = true;
        }
    }

    public String readParameter(String string, boolean bl) {
        if (this.inAnApplet) {
            String string2 = this.getParameter(string);
            if (string2 == null && bl) {
                this.fatalError(string + " parameter not specified");
            }
            return string2;
        }
        int n = 0;
        while (n < this.mainArgs.length) {
            if (this.mainArgs[n].equalsIgnoreCase(string)) {
                try {
                    return this.mainArgs[n + 1];
                }
                catch (Exception exception) {
                    if (bl) {
                        this.fatalError(string + " parameter not specified");
                    }
                    return null;
                }
            }
            n += 2;
        }
        if (bl) {
            this.fatalError(string + " parameter not specified");
        }
        return null;
    }

    public void fatalError(String string) {
        System.out.println(string);
        if (this.inAnApplet) {
            this.cont.removeAll();
            Label label = new Label(string);
            this.setLayout(new FlowLayout(0, 30, 30));
            this.cont.add(label);
            this.validate();
            Thread.currentThread().stop();
        } else {
            System.exit(1);
        }
    }
}

