/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHMiscDialogs;
import mindbright.ssh.SSHPropertyHandler;
import mindbright.util.AWTConvenience;

public final class SSHTunnelDialog {
    private static Dialog basicTunnelsDialog = null;
    private static List tunnelList;
    private static TextField remoteHost;
    private static TextField remotePort;
    private static TextField localPort;
    private static Choice protoChoice;
    private static final String[] protos;
    static final int[] servs;
    private static SSHPropertyHandler propsHandler;
    private static Frame parent;
    private static SSHClient client;

    public static void show(String string, SSHClient sSHClient, SSHPropertyHandler sSHPropertyHandler, Frame frame) {
        propsHandler = sSHPropertyHandler;
        parent = frame;
        client = sSHClient;
        if (basicTunnelsDialog == null) {
            basicTunnelsDialog = new Dialog(parent, string, true);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            basicTunnelsDialog.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(4, 4, 0, 4);
            Label label = new Label("Current local tunnels:");
            gridBagConstraints.gridwidth = 2;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            basicTunnelsDialog.add(label);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.gridy = 1;
            tunnelList = new List(8);
            gridBagLayout.setConstraints(tunnelList, gridBagConstraints);
            basicTunnelsDialog.add(tunnelList);
            tunnelList.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = tunnelList.getSelectedIndex();
                    if (n != -1) {
                        SSHClient.LocalForward localForward = (SSHClient.LocalForward)client.localForwards.elementAt(n);
                        localPort.setText(String.valueOf(localForward.localPort));
                        remotePort.setText(String.valueOf(localForward.remotePort));
                        remoteHost.setText(localForward.remoteHost);
                        n = 1;
                        while (n < servs.length) {
                            if (localForward.remotePort == servs[n]) {
                                protoChoice.select(protos[n]);
                                break;
                            }
                            ++n;
                        }
                        if (n == servs.length) {
                            protoChoice.select("general");
                        }
                    }
                }
            });
            gridBagConstraints.fill = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            label = new Label("Local port:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            basicTunnelsDialog.add(label);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            localPort = new TextField("", 5);
            gridBagLayout.setConstraints(localPort, gridBagConstraints);
            basicTunnelsDialog.add(localPort);
            label = new Label("Protocol:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            gridBagConstraints.fill = 0;
            basicTunnelsDialog.add(label);
            protoChoice = new Choice();
            int n = 0;
            while (n < protos.length) {
                protoChoice.add(protos[n]);
                ++n;
            }
            protoChoice.select("general");
            gridBagLayout.setConstraints(protoChoice, gridBagConstraints);
            basicTunnelsDialog.add(protoChoice);
            protoChoice.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    String string = (String)itemEvent.getItem();
                    int n = 0;
                    while (n < protos.length) {
                        if (string.equals(protos[n])) break;
                        ++n;
                    }
                    if (n > 0) {
                        remotePort.setText(String.valueOf(servs[n]));
                    }
                }
            });
            gridBagConstraints.gridy = 3;
            label = new Label("Remote host:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            basicTunnelsDialog.add(label);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 3;
            remoteHost = new TextField("", 16);
            gridBagLayout.setConstraints(remoteHost, gridBagConstraints);
            basicTunnelsDialog.add(remoteHost);
            gridBagConstraints.gridy = 4;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            label = new Label("Remote port:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            basicTunnelsDialog.add(label);
            remotePort = new TextField("", 5);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.9;
            gridBagLayout.setConstraints(remotePort, gridBagConstraints);
            basicTunnelsDialog.add(remotePort);
            Button button = new Button("Add");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = remoteHost.getText();
                    String string2 = "general";
                    int n = -1;
                    int n2 = -1;
                    try {
                        n = Integer.valueOf(localPort.getText());
                        n2 = Integer.valueOf(remotePort.getText());
                        if (n < 1 || n > 65535) {
                            n = -1;
                            throw new NumberFormatException();
                        }
                        if (n2 < 1 || n2 > 65535) {
                            n2 = -1;
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (n == -1) {
                            localPort.setText("");
                            localPort.requestFocus();
                        } else {
                            remotePort.setText("");
                            remotePort.requestFocus();
                        }
                        return;
                    }
                    if (protoChoice.getSelectedItem().equals("ftp")) {
                        string2 = "ftp";
                    }
                    try {
                        propsHandler.setProperty("local" + client.localForwards.size(), "/" + string2 + "/" + n + ":" + string + ":" + n2);
                        if (client.isOpened()) {
                            SSHMiscDialogs.alert("Tunnel Notice", "Tunnel is now open and operational", parent);
                        }
                    }
                    catch (Throwable throwable) {
                        SSHMiscDialogs.alert("Tunnel Notice", "Could not open tunnel: " + throwable.getMessage(), parent);
                    }
                    SSHTunnelDialog.updateTunnelList();
                }
            });
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.1;
            gridBagLayout.setConstraints(button, gridBagConstraints);
            basicTunnelsDialog.add(button);
            button = new Button("Delete");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = tunnelList.getSelectedIndex();
                    if (n != -1) {
                        propsHandler.removeLocalTunnelAt(n, true);
                    }
                    SSHTunnelDialog.updateTunnelList();
                }
            });
            gridBagLayout.setConstraints(button, gridBagConstraints);
            basicTunnelsDialog.add(button);
            button = new Button("Close Dialog");
            button.addActionListener(new AWTConvenience.CloseAction(basicTunnelsDialog));
            gridBagConstraints.gridy = 5;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.ipady = 2;
            gridBagConstraints.ipadx = 2;
            gridBagLayout.setConstraints(button, gridBagConstraints);
            basicTunnelsDialog.add(button);
            basicTunnelsDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(basicTunnelsDialog);
            basicTunnelsDialog.setResizable(true);
            basicTunnelsDialog.pack();
        }
        SSHTunnelDialog.updateTunnelList();
        basicTunnelsDialog.setTitle(string);
        AWTConvenience.placeDialog(basicTunnelsDialog);
        localPort.requestFocus();
        ((Component)basicTunnelsDialog).setVisible(true);
    }

    private static void updateTunnelList() {
        tunnelList.removeAll();
        int n = 0;
        while (n < SSHTunnelDialog.client.localForwards.size()) {
            SSHClient.LocalForward localForward = (SSHClient.LocalForward)SSHTunnelDialog.client.localForwards.elementAt(n);
            String string = localForward.plugin.equals("general") ? "" : " (plugin: " + localForward.plugin + ")";
            tunnelList.add("local: " + localForward.localPort + " -> remote: " + localForward.remoteHost + "/" + localForward.remotePort + string);
            ++n;
        }
    }

    static {
        protos = new String[]{"general", "ftp", "telnet", "smtp", "http", "pop2", "pop3", "nntp", "imap"};
        servs = new int[]{0, 21, 23, 25, 80, 109, 110, 119, 143};
    }
}

