/*
 * Decompiled with CFR 0.152.
 */
package mindbright.application;

import java.applet.Applet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHPropertyHandler;
import mindbright.ssh.SSHTunnelingClient;

public class MindTunnelCli
extends Applet
implements Runnable {
    static Properties paramSSHProps = new Properties();
    String[] cmdLineArgs;
    String sshHomeDir = null;
    String propsFile = null;
    String commandLine = null;
    String redirURL = null;
    String redirTarget = null;
    boolean listMode = false;
    boolean haveTunnelDialog = false;
    boolean haveSCPDialog = false;
    boolean haveProxyDialog = false;
    boolean weAreAnApplet = false;

    public static void main(String[] stringArray) {
        MindTunnelCli mindTunnelCli = new MindTunnelCli();
        mindTunnelCli.cmdLineArgs = stringArray;
        try {
            mindTunnelCli.getApplicationParams();
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
            System.exit(1);
        }
        try {
            mindTunnelCli.run();
        }
        catch (Exception exception) {
            System.out.println("Error, please mail below stack-trace to mats@mindbright.se");
            exception.printStackTrace();
        }
    }

    public void init() {
        this.getAppletParams();
        new Thread(SSH.getThreadGroup(), this).start();
    }

    public void run() {
        try {
            SSHPropertyHandler sSHPropertyHandler = new SSHPropertyHandler(paramSSHProps);
            if (this.propsFile != null) {
                try {
                    sSHPropertyHandler = SSHPropertyHandler.fromFile(this.propsFile, "");
                }
                catch (SSHClient.AuthFailException authFailException) {
                    throw new Exception("Sorry, can only use passwordless settings files for now");
                }
                sSHPropertyHandler.mergeProperties(paramSSHProps);
            }
            SSHTunnelingClient sSHTunnelingClient = new SSHTunnelingClient(sSHPropertyHandler, this);
            sSHTunnelingClient.getPropertyHandler().setSSHHomeDir(this.sshHomeDir);
            sSHTunnelingClient.verbose = SSH.DEBUG;
            sSHTunnelingClient.listMode = this.listMode;
            sSHTunnelingClient.haveTunnelDialog = this.haveTunnelDialog;
            sSHTunnelingClient.haveSCPDialog = this.haveSCPDialog;
            sSHTunnelingClient.haveProxyDialog = this.haveProxyDialog;
            try {
                Thread thread = new Thread(SSH.getThreadGroup(), sSHTunnelingClient);
                thread.start();
                thread.join();
                if (!this.weAreAnApplet) {
                    System.exit(0);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void online() {
        if (this.weAreAnApplet) {
            if (this.redirURL != null) {
                try {
                    this.getAppletContext().showDocument(new URL(this.redirURL), this.redirTarget);
                }
                catch (MalformedURLException malformedURLException) {
                    this.getAppletContext().showStatus("MindTunnel Client, malformed URL: " + this.redirURL);
                }
            }
        } else if (this.commandLine != null) {
            try {
                Runtime.getRuntime().exec(this.commandLine);
            }
            catch (Exception exception) {
                System.out.println("Error running external program: " + this.commandLine);
                System.out.println("Error is: " + exception);
            }
        }
    }

    public void getApplicationParams() throws Exception {
        int n;
        int n2;
        try {
            n2 = 0;
            while (n2 < this.cmdLineArgs.length) {
                String string = this.cmdLineArgs[n2];
                if (string.startsWith("--")) {
                    switch (string.charAt(2)) {
                        case 'h': {
                            this.sshHomeDir = this.cmdLineArgs[++n2];
                            break;
                        }
                        case 'l': {
                            this.listMode = true;
                            break;
                        }
                        case 'f': {
                            this.propsFile = this.cmdLineArgs[++n2];
                            break;
                        }
                        case 's': {
                            this.haveSCPDialog = true;
                            break;
                        }
                        case 't': {
                            this.haveTunnelDialog = true;
                            break;
                        }
                        case 'v': {
                            System.out.println("verbose mode selected...");
                            SSH.DEBUG = true;
                            break;
                        }
                        case 'y': {
                            this.haveProxyDialog = true;
                            break;
                        }
                        case 'V': {
                            System.out.println("MindTerm v1.2.1SCP3");
                            System.out.println("SSH protocol version 1.5");
                            System.exit(0);
                            break;
                        }
                        case 'D': {
                            SSH.DEBUG = true;
                            SSH.DEBUGMORE = true;
                            break;
                        }
                        case '?': {
                            this.printHelp();
                            System.exit(0);
                        }
                        default: {
                            throw new Exception("unknown parameter '" + string + "'");
                        }
                    }
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.printHelp();
            throw exception;
        }
        n2 = n = n2;
        while (n2 < this.cmdLineArgs.length) {
            String string = this.cmdLineArgs[n2];
            if (string.charAt(0) != '-' || n2 + 1 == this.cmdLineArgs.length) break;
            string = string.substring(1);
            String string2 = this.cmdLineArgs[n2 + 1];
            if (SSHPropertyHandler.isProperty(string)) {
                ((Hashtable)paramSSHProps).put(string, string2);
            } else {
                System.out.println("Unknown property '" + string + "'");
            }
            n2 += 2;
        }
        if (n2 < this.cmdLineArgs.length) {
            this.commandLine = "";
            while (n2 < this.cmdLineArgs.length) {
                this.commandLine = this.commandLine + this.cmdLineArgs[n2] + " ";
                ++n2;
            }
            this.commandLine = this.commandLine.trim();
        }
    }

    public void getAppletParams() {
        String string;
        this.weAreAnApplet = true;
        try {
            SSH.DEBUG = new Boolean(this.getParameter("verbose"));
        }
        catch (Exception exception) {
            SSH.DEBUG = false;
        }
        try {
            this.haveTunnelDialog = new Boolean(this.getParameter("edittunnels"));
        }
        catch (Exception exception) {
            this.haveTunnelDialog = false;
        }
        try {
            this.haveSCPDialog = new Boolean(this.getParameter("filetransfer"));
        }
        catch (Exception exception) {
            this.haveSCPDialog = false;
        }
        try {
            this.haveProxyDialog = new Boolean(this.getParameter("configproxy"));
        }
        catch (Exception exception) {
            this.haveProxyDialog = false;
        }
        try {
            this.listMode = new Boolean(this.getParameter("listmode"));
        }
        catch (Exception exception) {
            this.listMode = false;
        }
        try {
            SSH.DEBUG = SSH.DEBUGMORE = new Boolean(this.getParameter("debug")).booleanValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sshHomeDir = this.getParameter("sshhome");
        this.propsFile = this.getParameter("propsfile");
        this.redirURL = this.getParameter("redirurl");
        this.redirTarget = this.getParameter("redirtarget");
        int n = 0;
        while (n < SSHPropertyHandler.defaultPropDesc.length) {
            String string2 = SSHPropertyHandler.defaultPropDesc[n][0];
            string = this.getParameter(string2);
            if (string != null) {
                ((Hashtable)paramSSHProps).put(string2, string);
            }
            ++n;
        }
        n = 0;
        while ((string = this.getParameter("local" + n)) != null) {
            ((Hashtable)paramSSHProps).put("local" + n, string);
            ++n;
        }
        n = 0;
        while ((string = this.getParameter("remote" + n)) != null) {
            ((Hashtable)paramSSHProps).put("remote" + n, string);
            ++n;
        }
    }

    void printHelp() {
        System.out.println("usage: MindTunnelCli [options] [properties] [command]");
        System.out.println("Options:");
        System.out.println("  --f <file> Use settings from the given file.");
        System.out.println("  --h dir    Name of the MindTerm home-dir (default: ~/mindterm/).");
        System.out.println("  --l        Enables list mode (i.e. lists available settings to choose from).");
        System.out.println("  --s        Enables file transfer dialog. (i.e. scp functionality).");
        System.out.println("  --t        Enables tunnel dialog (i.e. ability to edit tunnels).");
        System.out.println("  --v        Verbose; display verbose messages.");
        System.out.println("  --y        Enables proxy configure dialog (i.e. proxy settings).");
        System.out.println("  --D        Debug; display extra debug info.");
        System.out.println("  --V        Version; display version number only.");
        System.out.println("  --?        Help; display this help.");
    }
}

