/*
 * Decompiled with CFR 0.152.
 */
package com.vyx.jburner;

import com.vyx.io.CfgFile;
import java.io.File;
import java.util.Properties;

public final class Config {
    public final String OPT_ISO_MODE = "iso.mode";
    public final String OPT_BUF_SIZE_M = "buffer.size.M";
    public final String OPT_BUF_SIZE_SEC = "buffer.size";
    public final String OPT_SRC_DRIVER = "src.driver";
    public final String OPT_SRC_DEVICE = "src.device";
    public final String OPT_SRC_DRIVE = "src.drive";
    public final String OPT_BURNER_DRIVER = "burner.driver";
    public final String OPT_BURNER_DEVICE = "burner.device";
    public final String OPT_BURNER_DRIVE = "burner.drive";
    public final String OPT_WORK_DIR = "target.image.dir";
    public String cdrwDevice = null;
    public String cdrwDriver = null;
    public String cdrwDrive = null;
    public String cdromDevice = null;
    public String cdromDriver = null;
    public String cdromDrive = null;
    public String imageDir = ".";
    public String isoMode = "CD_ROM";
    public int bufSize = 64;
    public String[] aISOModes = new String[]{"CD_ROM", "CD_DA", "CD_ROM_XA"};
    public CfgFile cfgFile = new CfgFile();
    public boolean eject = true;
    public boolean lock = false;
    public boolean overburn = false;
    public boolean simulate = false;
    public int paranoia = 0;
    public boolean rawRead = true;
    public boolean clearMode = true;
    public File workDir = null;
    public File bootImg = null;
    public int speed = 4;
    public String mkiso = null;
    public String label = "CDROM";
    public String appID = "jBurner";
    public String publ = "C00l ziz0p";
    public String prep = "C00l ziz0p";
    public String sysID = "OS/2";
    public String copyr = "Copyleft";
    public File dataFile = null;
    public File dataTOCFile = null;
    public boolean srcCDRW = false;
    public boolean srcTAO = false;
    public boolean detectAtStartup = false;
    public boolean onTheFly = false;

    private String chkDL(String string) {
        if (string == null) {
            return null;
        }
        char c = string.toUpperCase().charAt(0);
        if (c < 'A' || c > 'Z') {
            return null;
        }
        return c + ":";
    }

    public final void load() {
        this.cfgFile.loadAppConfig("jburner");
        Properties properties = this.cfgFile.getConfig();
        this.cdrwDevice = properties.getProperty("burner.device");
        this.cdrwDriver = properties.getProperty("burner.driver");
        this.cdrwDrive = this.chkDL(properties.getProperty("burner.drive"));
        this.cdromDevice = properties.getProperty("src.device");
        this.cdromDriver = properties.getProperty("src.driver");
        this.cdromDrive = this.chkDL(properties.getProperty("src.drive"));
        this.isoMode = properties.getProperty("iso.mode");
        this.bufSize = 0;
        String string = properties.getProperty("buffer.size");
        if (string != null) {
            try {
                this.bufSize = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.bufSize = 0;
            }
        }
        if (this.bufSize == 0 && (string = properties.getProperty("buffer.size.M")) != null) {
            try {
                this.recalcBufSize(Integer.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.bufSize = 0;
            }
        }
        this.lock = this.cdrwDrive != null;
        this.workDir = new File(properties.getProperty("target.image.dir", "."));
        if (!this.workDir.isDirectory()) {
            this.workDir = new File(".");
        }
        this.mkiso = properties.getProperty("mkisofs");
        if (this.mkiso != null && !new File(this.mkiso).exists()) {
            this.mkiso = null;
        }
        if (this.mkiso != null) {
            this.label = properties.getProperty("label", "CDROM");
            this.appID = properties.getProperty("app", "jBurner");
            this.publ = properties.getProperty("publisher", "Darth Vader");
            this.prep = properties.getProperty("preparer", "Darth Vader");
            this.sysID = properties.getProperty("system", "OS/2");
            this.copyr = properties.getProperty("copyright", "Copyleft");
        }
        this.detectAtStartup = properties.getProperty("try.detect.media.at.startup", "false").toLowerCase().equals("true");
    }

    public final void recalcBufSize(int n) {
        this.bufSize = n * 1024 / 150;
    }
}

