/* rexx */
parse arg use_version

rc = 0

select
   when use_version = 'latest' then do
      base_name='freenet-latest'
      get_file='freenet-latest.jar'
   end /* do */
   when use_version = 'experimental' then do
      base_name='freenet-experimental'
      get_file='freenet-exp-latest.jar'
   end /* do */
   otherwise do
      /* Use the default version - get latest if none exist */
      base_name='freenet'
      get_file='freenet-latest.jar'
   end /* do */
end  /* select */

jar_file=base_name||'.jar'

classpath=jar_file';freenet-ext.jar'
javaexe='@c:\java141\jre\bin\java.exe -cp 'classpath' -Duser.home='value('HOME',,'OS2ENVIRONMENT')

if stream(jar_file, 'c', 'query exists') = '' then do
   say 'Getting 'jar_file'. Please wait.. This may take a few minutes.'
   '@wget -q http://freenetproject.org/snapshots/'get_file' -O 'jar_file
   if rc <> 0 then say 'Could not fetch 'get_file'.'
end /* do */

if stream('freenet-ext.jar', 'c', 'query exists') = '' & rc = 0 then do
   say 'Getting freenet-ext.jar. Please wait.. This should not take long.'
   '@wget -q http://freenetproject.org/snapshots/freenet-ext.jar -O freenet-ext.jar'
   if rc <> 0 then say 'Could not fetch freenet-ext.jar'
end /* do */

if stream('seednodes.ref', 'c', 'query exists') = '' & rc = 0 then do
   say 'Getting seednodes.ref. Please wait.. Last "Please Wait". I promise.'
   '@wget -q http://freenetproject.org/snapshots/seednodes.ref -O seednodes.ref'
   if rc <> 0 then say 'Could not get seednodes.ref..'
end /* do */

if stream('freenet.conf', 'c', 'query exists') = '' & rc = 0 then do
   say 'Running configuration.. Wait for the prompt, and just hit enter a few times,'
   say 'if this stuff bores you.'
   javaexe' freenet.node.Main --config'
end /* do */

html_doc=base_name||'.html'
if stream(html_doc, 'c', 'query exists') = '' & rc = 0 then do
   say 'Generating HTML manual ('html_doc')'
   javaexe' freenet.node.Main --manual > 'html_doc
end

node_ref='NodeReference.text'
if stream(node_ref, 'c', 'query exists') = '' & rc = 0 then do
   say 'Exporting node reference to 'node_ref'.'
   javaexe' freenet.node.Main --export 'node_ref
end

if rc = 0 then do
   say 'Starting Fred.. Wait a while for it to start properly, then point your browser'
   say 'to http://localhost:8888/'
   /* -server ? */
   javaexe' -XdisableMMFjars freenet.node.Main'
end /* do */

