/*
 * Decompiled with CFR 0.152.
 */
package FontViewer.windows.dialogs;

import FontViewer.components.AAToggleButton;
import FontViewer.windows.dialogs.TextAreaDialog;
import com.jgoodies.plaf.BorderStyle;
import com.jgoodies.plaf.HeaderStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public class ListView
extends JDialog {
    private final int SYSTEM = 0;
    private final int FILE = 1;
    private int rows;
    private int columns;
    private int fontSize;
    private int fontNum;
    private int drawToNum;
    private String sampleText = "Sample Text";
    private Vector selectedFonts;
    private Object[] list;
    JFrame parent;
    private JMenuItem changeSampleTextMenuItem;
    private JMenuItem closeViewMenuItem;
    private JLabel fontSizeLabel;
    private JTextField fontSizeTextField;
    private JLabel fontsPerPageLabel;
    private JTextField fontsPerPageTextField;
    private JMenuItem goToFontMenuItem;
    private JMenu hiddenMenu;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPanel listPanel;
    private JScrollPane listScrollPane;
    private JMenuBar menuBar;
    private JLabel navInfoLabel;
    private JPanel navigationPanel;
    private JButton nextButton;
    private JMenuItem nextMenuItem;
    private JMenu optionsMenu;
    private JPanel optionsPanel;
    private JButton prevButton;
    private JMenuItem prevMenuItem;
    private JMenuItem quitMenuItem;
    private JMenuItem saveFavsMenuItem;
    private JMenuItem viewFavsMenuItem;

    public ListView(JFrame parent, int rows, int columns, Object[] o) {
        super(parent);
        this.parent = parent;
        this.setModal(true);
        this.rows = rows;
        this.columns = columns;
        this.list = o;
        this.fontSize = 20;
        this.fontNum = 0;
        this.drawToNum = this.fontNum + rows;
        this.selectedFonts = new Vector();
        this.initComponents();
        this.menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        this.menuBar.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
        this.drawFonts();
        this.fontSizeTextField.setText("" + this.fontSize);
        this.fontsPerPageTextField.setText("" + rows);
        this.navInfoLabel.setText("Font " + (this.fontNum + 1) + "~" + this.drawToNum + " of " + this.list.length);
        this.pack();
        this.hiddenMenu.setVisible(false);
        this.hiddenMenu.setEnabled(false);
        this.setLocation((GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width - this.getSize().width) / 2, (GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height - this.getSize().height) / 2);
    }

    private void drawFonts() {
        boolean objectType = false;
        Font f = null;
        WeakReference<Font> wrf = null;
        WeakReference<AAToggleButton> wrb = null;
        this.listPanel.removeAll();
        this.listPanel.repaint();
        for (int i = this.fontNum; i < this.drawToNum; ++i) {
            AAToggleButton tb;
            if (this.list[i] instanceof String) {
                f = new Font(this.list[i].toString(), 0, this.fontSize);
                wrf = new WeakReference<Font>(f);
                objectType = false;
            } else if (this.list[i] instanceof File) {
                try {
                    f = Font.createFont(0, new FileInputStream((File)this.list[i]));
                    wrf = new WeakReference<Font>(f);
                    objectType = true;
                }
                catch (Exception e) {
                    f = null;
                }
            }
            if (f != null) {
                tb = new AAToggleButton(this.sampleText);
                wrb = new WeakReference<AAToggleButton>(tb);
                ((AAToggleButton)wrb.get()).setBackground(Color.WHITE);
                ((AAToggleButton)wrb.get()).setFont(f.deriveFont(0, this.fontSize));
                if (objectType) {
                    ((AAToggleButton)wrb.get()).setToolTipText(((Font)wrf.get()).getName() + " (" + ((File)this.list[i]).getName() + ")");
                } else {
                    ((AAToggleButton)wrb.get()).setToolTipText(((Font)wrf.get()).getName());
                }
                if (this.selectedFonts.contains(((AAToggleButton)wrb.get()).getToolTipText())) {
                    ((AAToggleButton)wrb.get()).setSelected(true);
                }
                ((AAToggleButton)wrb.get()).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        JToggleButton source = (JToggleButton)evt.getSource();
                        if (source.isSelected()) {
                            ListView.this.selectedFonts.add(source.getToolTipText());
                        } else {
                            ListView.this.selectedFonts.remove(source.getToolTipText());
                        }
                        ListView.this.menuBar.requestFocus();
                    }
                });
            } else {
                tb = new AAToggleButton("Font could not be loaded.");
            }
            this.listPanel.add((AAToggleButton)wrb.get());
        }
    }

    private void updateFontSize() {
        this.fontSizeTextField.setText("" + this.fontSize);
        this.drawFonts();
    }

    private void updateRows() {
        this.fontsPerPageTextField.setText("" + this.rows);
        this.drawFonts();
    }

    private void updateNavInfo() {
        this.drawToNum = this.fontNum + this.rows < this.list.length ? this.fontNum + this.rows : this.list.length;
        this.navInfoLabel.setText("Font " + (this.fontNum + 1) + "~" + this.drawToNum + " of " + this.list.length);
        this.navInfoLabel.setToolTipText(this.navInfoLabel.getText());
        this.drawFonts();
    }

    private void showNextPage() {
        if (this.fontNum + this.rows < this.list.length) {
            this.fontNum += this.rows;
            this.updateNavInfo();
        }
    }

    private void showPrevPage() {
        if (this.fontNum != 0) {
            this.fontNum = this.fontNum - this.rows >= 0 ? (this.fontNum -= this.rows) : 0;
            this.updateNavInfo();
        }
    }

    public void pack() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle bounds = env.getMaximumWindowBounds();
        super.pack();
        int w = this.getWidth();
        int h = this.getHeight();
        boolean changed = false;
        if (w > bounds.width) {
            w = bounds.width;
            changed = true;
            this.setLocation(0, (int)this.getLocation().getY());
        }
        if (h > bounds.height) {
            h = bounds.height;
            changed = true;
            this.setLocation((int)this.getLocation().getX(), 0);
        }
        if (changed) {
            this.setSize(w, h);
        }
        Point p = this.getLocation();
        int px = p.x;
        int py = p.y;
        boolean moved = false;
        if (px + w > bounds.width) {
            px = (bounds.width - w) / 2;
            moved = true;
        }
        if (py + h > bounds.height) {
            py = (bounds.height - h) / 2;
            moved = true;
        }
        if (moved) {
            this.setLocation(px, py);
        }
    }

    private void saveFavToFile(File f) {
        if (this.selectedFonts.size() == 0) {
            new JOptionPane();
            JOptionPane.showMessageDialog(this, "There are no favourite fonts to save.", "Error!", 0);
        } else {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                Collections.sort(this.selectedFonts);
                for (int i = 0; i < this.selectedFonts.size(); ++i) {
                    bw.write(this.selectedFonts.get(i).toString());
                    bw.newLine();
                }
                bw.close();
            }
            catch (IOException ioe) {
                new JOptionPane();
                JOptionPane.showMessageDialog(this, "Cannot write to file.", "Error!", 0);
            }
        }
    }

    private StringBuffer getSortedFavs() {
        Collections.sort(this.selectedFonts);
        StringBuffer favs = new StringBuffer(this.selectedFonts.size() * 15);
        for (int i = 0; i < this.selectedFonts.size(); ++i) {
            favs.append(this.selectedFonts.get(i) + "\n");
        }
        return favs;
    }

    private void initComponents() {
        this.optionsPanel = new JPanel();
        this.fontsPerPageLabel = new JLabel();
        this.fontsPerPageTextField = new JTextField();
        this.fontSizeLabel = new JLabel();
        this.fontSizeTextField = new JTextField();
        this.listScrollPane = new JScrollPane();
        this.listPanel = new JPanel();
        this.navigationPanel = new JPanel();
        this.prevButton = new JButton();
        this.navInfoLabel = new JLabel();
        this.nextButton = new JButton();
        this.menuBar = new JMenuBar();
        this.optionsMenu = new JMenu();
        this.goToFontMenuItem = new JMenuItem();
        this.changeSampleTextMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.viewFavsMenuItem = new JMenuItem();
        this.saveFavsMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.closeViewMenuItem = new JMenuItem();
        this.hiddenMenu = new JMenu();
        this.prevMenuItem = new JMenuItem();
        this.nextMenuItem = new JMenuItem();
        this.quitMenuItem = new JMenuItem();
        this.getContentPane().setLayout(new BorderLayout(2, 2));
        this.setDefaultCloseOperation(2);
        this.setTitle("List View");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ListView.this.exitForm(evt);
            }
        });
        this.optionsPanel.setLayout(new GridLayout(1, 0));
        this.optionsPanel.setPreferredSize(new Dimension(10, 20));
        this.fontsPerPageLabel.setHorizontalAlignment(0);
        this.fontsPerPageLabel.setText("Fonts/Page");
        this.fontsPerPageLabel.setToolTipText("Fonts to show per page");
        this.optionsPanel.add(this.fontsPerPageLabel);
        this.fontsPerPageTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ListView.this.fontsPerPageTextFieldKeyPressed(evt);
            }
        });
        this.optionsPanel.add(this.fontsPerPageTextField);
        this.fontSizeLabel.setHorizontalAlignment(0);
        this.fontSizeLabel.setText("Font Size");
        this.fontSizeLabel.setToolTipText("Font display size");
        this.optionsPanel.add(this.fontSizeLabel);
        this.fontSizeTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ListView.this.fontSizeTextFieldKeyPressed(evt);
            }
        });
        this.optionsPanel.add(this.fontSizeTextField);
        this.getContentPane().add((Component)this.optionsPanel, "North");
        this.listScrollPane.setMinimumSize(new Dimension(300, 22));
        this.listScrollPane.setPreferredSize(null);
        this.listPanel.setLayout(new GridLayout(1, 1));
        this.listPanel.setMinimumSize(new Dimension(300, 0));
        this.listPanel.setLayout(new GridLayout(this.rows, this.columns, 2, 0));
        this.listScrollPane.setViewportView(this.listPanel);
        this.getContentPane().add((Component)this.listScrollPane, "Center");
        this.navigationPanel.setLayout(new FlowLayout(1, 5, 0));
        this.navigationPanel.setPreferredSize(new Dimension(250, 20));
        this.prevButton.setText("<");
        this.prevButton.setToolTipText("Previous page");
        this.prevButton.setPreferredSize(new Dimension(41, 20));
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListView.this.prevButtonActionPerformed(evt);
            }
        });
        this.navigationPanel.add(this.prevButton);
        this.navInfoLabel.setHorizontalAlignment(0);
        this.navInfoLabel.setText("Font 0~0 of 0");
        this.navInfoLabel.setPreferredSize(new Dimension(150, 20));
        this.navigationPanel.add(this.navInfoLabel);
        this.nextButton.setText(">");
        this.nextButton.setToolTipText("Next page");
        this.nextButton.setPreferredSize(new Dimension(41, 20));
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListView.this.nextButtonActionPerformed(evt);
            }
        });
        this.navigationPanel.add(this.nextButton);
        this.getContentPane().add((Component)this.navigationPanel, "South");
        this.optionsMenu.setMnemonic('o');
        this.optionsMenu.setText("Options");
        this.goToFontMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.goToFontMenuItem.setText("Go To Font #");
        this.goToFontMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListView.this.goToFontMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.goToFontMenuItem);
        this.changeSampleTextMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.changeSampleTextMenuItem.setText("Change Sample Text");
        this.changeSampleTextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListView.this.changeSampleTextMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.changeSampleTextMenuItem);
        this.optionsMenu.add(this.jSeparator1);
        this.viewFavsMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.viewFavsMenuItem.setMnemonic('v');
        this.viewFavsMenuItem.setText("View Favourites");
        this.viewFavsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListView.this.viewFavsMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.viewFavsMenuItem);
        this.saveFavsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveFavsMenuItem.setMnemonic('s');
        this.saveFavsMenuItem.setText("Save Favourites");
        this.saveFavsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListView.this.saveFavsMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.saveFavsMenuItem);
        this.optionsMenu.add(this.jSeparator2);
        this.closeViewMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 2));
        this.closeViewMenuItem.setMnemonic('c');
        this.closeViewMenuItem.setText("Close View");
        this.closeViewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListView.this.closeViewMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.closeViewMenuItem);
        this.menuBar.add(this.optionsMenu);
        this.hiddenMenu.setText("hidden menu");
        this.prevMenuItem.setAccelerator(KeyStroke.getKeyStroke(33, 0));
        this.prevMenuItem.setText("Previous");
        this.prevMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListView.this.prevMenuItemActionPerformed(evt);
            }
        });
        this.hiddenMenu.add(this.prevMenuItem);
        this.nextMenuItem.setAccelerator(KeyStroke.getKeyStroke(34, 0));
        this.nextMenuItem.setText("Next");
        this.nextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListView.this.nextMenuItemActionPerformed(evt);
            }
        });
        this.hiddenMenu.add(this.nextMenuItem);
        this.quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.quitMenuItem.setText("Item");
        this.quitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListView.this.quitMenuItemActionPerformed(evt);
            }
        });
        this.hiddenMenu.add(this.quitMenuItem);
        this.menuBar.add(this.hiddenMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void goToFontMenuItemActionPerformed(ActionEvent evt) {
        block5: {
            new JOptionPane();
            String fontNumString = JOptionPane.showInputDialog(this, "Enter font number to go to", "Go To Font #", 3);
            if (fontNumString != null) {
                try {
                    int fn = Integer.parseInt(fontNumString);
                    if (fn > 0 && fn <= this.list.length) {
                        if (this.fontNum != fn - 1) {
                            this.fontNum = fn - 1;
                            this.updateNavInfo();
                        }
                        break block5;
                    }
                    throw new NumberFormatException();
                }
                catch (NumberFormatException nfe) {
                    new JOptionPane();
                    JOptionPane.showMessageDialog(this, "Invalid font number, please enter a number between 1 and " + this.list.length, "Error!", 0);
                }
            }
        }
    }

    private void quitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void closeViewMenuItemActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void nextMenuItemActionPerformed(ActionEvent evt) {
        this.showNextPage();
    }

    private void prevMenuItemActionPerformed(ActionEvent evt) {
        this.showPrevPage();
    }

    private void viewFavsMenuItemActionPerformed(ActionEvent evt) {
        new TextAreaDialog(this.parent, "Favourite Fonts", this.getSortedFavs().toString()).show();
    }

    private void saveFavsMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(new File(""));
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null) {
            File f = fc.getSelectedFile();
            if (f.exists()) {
                new JOptionPane();
                if (JOptionPane.showConfirmDialog(this, "The file " + f.getName() + " already exists, do you\nwant to overwrite?", "Warning!", 0, 2) == 0) {
                    this.saveFavToFile(f);
                }
            } else {
                this.saveFavToFile(f);
            }
        }
    }

    private void changeSampleTextMenuItemActionPerformed(ActionEvent evt) {
        new JOptionPane();
        String t = JOptionPane.showInputDialog(this, "Set sample text as:", "Change Sample Text", 3);
        if (t != null) {
            this.sampleText = t;
            this.drawFonts();
            this.pack();
        }
    }

    private void fontSizeTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                int tfs = Integer.parseInt(this.fontSizeTextField.getText());
                if (tfs <= 0) {
                    this.fontSizeTextField.setText("" + this.fontSize);
                    throw new NumberFormatException();
                }
                this.fontSize = tfs;
                this.drawFonts();
                this.pack();
            }
            catch (NumberFormatException nfe) {
                new JOptionPane();
                JOptionPane.showMessageDialog(this, "Invalid font size.", "Error!", 0);
            }
        }
    }

    private void fontsPerPageTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                int tmpRows = Integer.parseInt(this.fontsPerPageTextField.getText());
                if (tmpRows > 0) {
                    this.rows = tmpRows;
                    this.listPanel.setLayout(new GridLayout(this.rows, this.columns, 2, 0));
                    if (this.rows > this.list.length) {
                        this.fontNum = 0;
                    }
                } else {
                    this.fontsPerPageTextField.setText("" + this.rows);
                    throw new NumberFormatException();
                }
                this.updateNavInfo();
                this.pack();
            }
            catch (NumberFormatException nfe) {
                new JOptionPane();
                JOptionPane.showMessageDialog(this, "Invalid fonts per page number.", "Error!", 0);
            }
        }
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.showNextPage();
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        this.showPrevPage();
    }

    private void exitForm(WindowEvent evt) {
        this.dispose();
    }
}

