/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.scroll;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.StandardBorderPainter;
import org.pushingpixels.substance.internal.painter.SimplisticSoftBorderPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceScrollPaneBorder
implements Border,
UIResource {
    @Override
    public Insets getBorderInsets(Component c) {
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c));
        int ins = (int)borderStrokeWidth;
        return new Insets(ins, ins, ins, ins);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        boolean verticalVisible;
        if (!(c instanceof JScrollPane)) {
            return;
        }
        JScrollPane scrollPane = (JScrollPane)c;
        JScrollBar vertical = scrollPane.getVerticalScrollBar();
        JScrollBar horizontal = scrollPane.getHorizontalScrollBar();
        JViewport columnHeader = scrollPane.getColumnHeader();
        SimplisticSoftBorderPainter painter = new SimplisticSoftBorderPainter();
        SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(c, ColorSchemeAssociationKind.BORDER, c.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c));
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c)) / 2.0);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setStroke(new BasicStroke(borderStrokeWidth, 2, 0));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        x += borderDelta;
        y += borderDelta;
        width -= 2 * borderDelta;
        height -= 2 * borderDelta;
        boolean horizontalVisible = horizontal != null && horizontal.isVisible();
        boolean bl = verticalVisible = vertical != null && vertical.isVisible();
        if (scrollPane.getComponentOrientation().isLeftToRight()) {
            g2d.setColor(((StandardBorderPainter)painter).getTopBorderColor(scheme));
            if (verticalVisible && columnHeader == null) {
                g2d.drawLine(x, y, x + width - vertical.getWidth(), y);
            } else {
                g2d.drawLine(x, y, x + width, y);
            }
            g2d.setColor(((StandardBorderPainter)painter).getTopBorderColor(scheme));
            if (horizontalVisible) {
                g2d.drawLine(x, y, x, y + height - horizontal.getHeight());
            } else {
                g2d.drawLine(x, y, x, y + height);
            }
            g2d.setColor(((StandardBorderPainter)painter).getBottomBorderColor(scheme));
            if (!horizontalVisible) {
                if (verticalVisible) {
                    g2d.drawLine(x, y + height - 1, x + width - vertical.getWidth(), y + height - 1);
                } else {
                    g2d.drawLine(x, y + height - 1, x + width, y + height - 1);
                }
            }
            g2d.setColor(((StandardBorderPainter)painter).getBottomBorderColor(scheme));
            if (verticalVisible) {
                if (columnHeader != null) {
                    g2d.drawLine(x + width - 1, y, x + width - 1, y + columnHeader.getHeight());
                }
            } else if (horizontalVisible) {
                g2d.drawLine(x + width - 1, y, x + width - 1, y + height - horizontal.getHeight());
            } else {
                g2d.drawLine(x + width - 1, y, x + width - 1, y + height);
            }
        } else {
            g2d.setColor(((StandardBorderPainter)painter).getTopBorderColor(scheme));
            if (verticalVisible && columnHeader == null) {
                g2d.drawLine(x + vertical.getWidth(), y, x + width, y);
            } else {
                g2d.drawLine(x, y, x + width, y);
            }
            g2d.setColor(((StandardBorderPainter)painter).getBottomBorderColor(scheme));
            if (verticalVisible) {
                if (columnHeader != null) {
                    g2d.drawLine(x, y, x, y + columnHeader.getHeight());
                }
            } else if (horizontalVisible) {
                g2d.drawLine(x, y, x, y + height - horizontal.getHeight());
            } else {
                g2d.drawLine(x, y, x, y + height - 1);
            }
            g2d.setColor(((StandardBorderPainter)painter).getBottomBorderColor(scheme));
            if (!horizontalVisible) {
                if (verticalVisible) {
                    g2d.drawLine(x + vertical.getWidth(), y + height - 1, x + width, y + height - 1);
                } else {
                    g2d.drawLine(x, y + height - 1, x + width, y + height - 1);
                }
            }
            g2d.setColor(((StandardBorderPainter)painter).getTopBorderColor(scheme));
            if (horizontalVisible) {
                g2d.drawLine(x + width - 1, y, x + width - 1, y + height - horizontal.getHeight());
            } else {
                g2d.drawLine(x + width - 1, y, x + width - 1, y + height);
            }
        }
        g2d.dispose();
    }
}

