/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.comp;

import com.hbworks.dirpane.DirectoryPane;
import com.hbworks.dirpane.FileSystem;
import com.hbworks.dirpane.TreeDirectoryPane;
import com.hbworks.dirpane.TreeFileSystemModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class DirectoryHistoryComboBox
extends JComboBox {
    static final long serialVersionUID = 4312738667148042598L;
    public static final String DIRECTORYPANE_PROPERTY = "directoryPane";
    DirectoryPane pane;
    DirectoryHistoryComboBoxModel model;

    public DirectoryHistoryComboBox() {
        this((DirectoryPane)null);
    }

    public DirectoryHistoryComboBox(DirectoryPane pane) {
        this.setMaximumRowCount(5);
        this.setEditable(true);
        if (pane != null) {
            this.pane = pane;
            this.model = new DirectoryHistoryComboBoxModel();
            this.setModel(this.model);
            File curDir = pane.getCurrentDirectory();
            if (curDir != null) {
                this.model.addItem(curDir.getPath());
            }
            this.addActionListener(new ComboActionListener());
            pane.addPropertyChangeListener(new DirectoryChangedListener());
        }
    }

    public void setDirectoryPane(DirectoryPane newpane) {
        DirectoryPane newprop;
        if (newpane == null) {
            throw new IllegalArgumentException("Can not set a null DirectoryPane");
        }
        DirectoryPane oldprop = this.pane;
        this.pane = newprop = newpane;
        this.model = new DirectoryHistoryComboBoxModel();
        this.setModel(this.model);
        File curDir = this.pane.getCurrentDirectory();
        if (curDir != null) {
            this.model.addItem(curDir.getPath());
        }
        this.addActionListener(new ComboActionListener());
        this.pane.addPropertyChangeListener(new DirectoryChangedListener());
        this.firePropertyChange(DIRECTORYPANE_PROPERTY, oldprop, newprop);
    }

    public DirectoryPane getDirectoryPane() {
        return this.pane;
    }

    class DirectoryChangedListener
    implements PropertyChangeListener {
        DirectoryChangedListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            File f;
            String name = e.getPropertyName();
            if (name == "fileSystemChanged") {
                FileSystem system = (FileSystem)e.getNewValue();
                DirectoryHistoryComboBox.this.model = new DirectoryHistoryComboBoxModel();
                DirectoryHistoryComboBox.this.setModel(DirectoryHistoryComboBox.this.model);
                File curDir = system.getFileSystemRoot();
                if (curDir != null) {
                    DirectoryHistoryComboBox.this.model.addItem(curDir.getPath());
                }
            }
            if ((name == "directoryChanged" || name == "syncSlaveDirectory") && (f = (File)e.getNewValue()) != null && DirectoryHistoryComboBox.this.pane.getModel().belongsToFileSystem(f)) {
                if (DirectoryHistoryComboBox.this.pane instanceof TreeDirectoryPane && !((TreeFileSystemModel)DirectoryHistoryComboBox.this.pane.getModel()).isDescendantOfRoot(f)) {
                    return;
                }
                String path = f.getPath();
                DirectoryHistoryComboBox.this.model.addItem(path);
            }
        }
    }

    class ComboActionListener
    implements ActionListener {
        ComboActionListener() {
        }

        public void actionPerformed(ActionEvent ignored) {
            String dir = (String)DirectoryHistoryComboBox.this.model.getSelectedItem();
            DirectoryHistoryComboBox.this.pane.setCurrentDirectory(dir);
        }
    }

    class DirectoryHistoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Vector paths = new Vector();
        private String selection;

        public void addItem(String path) {
            boolean add = true;
            Enumeration en = this.paths.elements();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                if (!path.equalsIgnoreCase(s)) continue;
                add = false;
            }
            if (add) {
                this.paths.addElement(path);
            }
            this.setSelectedItem(path);
        }

        public void setSelectedItem(Object selection) {
            this.selection = (String)selection;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selection;
        }

        public int getSize() {
            return this.paths.size();
        }

        public Object getElementAt(int index) {
            return this.paths.elementAt(index);
        }
    }
}

