/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.util.Date;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.security.DSASignature;
import org.xbill.DNS.security.KEYConverter;
import org.xbill.DNS.utils.DataByteOutputStream;

public class SIG0Signer {
    private static final short VALIDITY = 300;
    private int algorithm;
    private PrivateKey privateKey;
    private Name name;
    private int footprint;

    public SIG0Signer(int algorithm, PrivateKey privateKey, Name name, int keyFootprint) {
        this.algorithm = (byte)algorithm;
        this.privateKey = privateKey;
        this.name = name;
        this.footprint = keyFootprint;
    }

    public SIG0Signer(int algorithm, PrivateKey privateKey, Name name, PublicKey publicKey) {
        this.algorithm = (byte)algorithm;
        this.privateKey = privateKey;
        this.name = name;
        KEYRecord keyRecord = KEYConverter.buildRecord((Name)name, (short)1, (int)0, (int)0, (int)255, (PublicKey)publicKey);
        this.footprint = keyRecord.getFootprint();
    }

    public void apply(Message m, byte[] old) throws IOException, SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        String algorithmName;
        int validity = 300;
        if (Options.check("sig0validity")) {
            String s = Options.value("sig0validity");
            try {
                validity = Short.parseShort(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        long now = System.currentTimeMillis();
        Date timeSigned = new Date(now);
        Date timeExpires = new Date(now + (long)(validity * 1000));
        if (this.algorithm == 3) {
            algorithmName = "SHA1withDSA";
        } else if (this.algorithm == 1) {
            algorithmName = "MD5withRSA";
        } else if (this.algorithm == 5) {
            algorithmName = "SHA1withRSA";
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm");
        }
        DataByteOutputStream out = new DataByteOutputStream();
        if (Options.check("bind9sig0")) {
            if (old != null) {
                out.write(old);
            }
            out.write(m.toWire());
        }
        out.writeShort(0);
        out.writeByte(this.algorithm);
        out.writeByte(0);
        out.writeInt(0);
        out.writeInt((int)(timeExpires.getTime() / 1000L));
        out.writeInt((int)(timeSigned.getTime() / 1000L));
        out.writeShort(this.footprint);
        this.name.toWireCanonical(out);
        if (!Options.check("bind9sig0")) {
            if (old != null) {
                out.write(old);
            }
            out.write(m.toWire());
        }
        byte[] outBytes = out.toByteArray();
        Signature signer = Signature.getInstance(algorithmName);
        signer.initSign(this.privateKey);
        signer.update(outBytes);
        byte[] signature = signer.sign();
        if (this.algorithm == 3) {
            DSAKey dsakey = (DSAKey)((Object)this.privateKey);
            signature = DSASignature.create((DSAParams)dsakey.getParams(), (byte[])signature);
        }
        SIGRecord r = new SIGRecord(new Name("."), 255, 0, 0, this.algorithm, 0, timeExpires, timeSigned, this.footprint, this.name, signature);
        m.addRecord(r, 3);
    }
}

