/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.Task;

import java.util.Vector;

public class WorkerThread
extends Thread {
    private Runnable task;
    private String name;
    private static int nactive = 0;
    private static Vector list = new Vector();
    private static int max = 10;
    private static long lifetime = 900000L;

    private WorkerThread() {
        this.setDaemon(true);
    }

    public static void assignThread(Runnable task, String name) {
        while (true) {
            try {
                WorkerThread t;
                WorkerThread workerThread = t = WorkerThread.getThread();
                synchronized (workerThread) {
                    t.task = task;
                    t.name = name;
                    if (!t.isAlive()) {
                        t.start();
                    } else {
                        t.notify();
                    }
                }
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                continue;
            }
            break;
        }
    }

    static WorkerThread getThread() {
        WorkerThread t;
        Vector vector = list;
        synchronized (vector) {
            if (list.size() > 0) {
                t = (WorkerThread)list.firstElement();
                list.removeElement(t);
            } else if (nactive >= max) {
                do {
                    try {
                        list.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } while (list.size() == 0);
                t = (WorkerThread)list.firstElement();
                list.removeElement(t);
            } else {
                t = new WorkerThread();
            }
            ++nactive;
        }
        return t;
    }

    public synchronized void run() {
        do {
            this.setName(this.name);
            try {
                this.task.run();
            }
            catch (Throwable t) {
                System.err.println(t);
            }
            this.setName("idle thread");
            Vector vector = list;
            synchronized (vector) {
                list.addElement(this);
                list.notify();
                --nactive;
            }
            this.task = null;
            try {
                this.wait(lifetime);
            }
            catch (InterruptedException interruptedException) {}
        } while (this.task != null);
        list.removeElement(this);
    }

    public static synchronized void setLifetime(long time) {
        lifetime = time;
    }

    public static synchronized void setMaxThreads(int maxThreads) {
        max = maxThreads;
    }
}

